'
'(C) 1990 Marquis Computing - All Rights Reserved. Proudly written in
'pure BASIC by Hank Marquis.
'
'Returns the size of an open file.
'

DEFINT A-Z

TYPE RegType
  AX AS INTEGER
  BX AS INTEGER
  CX AS INTEGER
  DX AS INTEGER
  BP AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
END TYPE

DECLARE SUB Interrupt (IntNum, InRegs AS RegType, OutRegs AS RegType)
DECLARE SUB SeekFile (FileHandle, OffSet&)
DECLARE SUB SetMAXError (ErrNum)

DECLARE FUNCTION SizeOf& (FileHandle)

FUNCTION SizeOf& (FileHandle)

   '
   'Returns the size of file with handle FileHandle. Use FileSize& for
   'closed files, but FileSize& is MUCH slower than this one for already
   'MAXBASIC opened files.
   '
   'NOTE : This call position DOS pointer to END of the file! Be sure
   '       to move it back to where it was (or where you want it)
   '       after calling it.
   '
   'NOTE : This is ONLY for files opened using the MAXBASIC FILEFUNC.BAS
   '       library. It won't work for files opened in BASIC or for
   '       closed files.
   '
   '
  
   '--- reset error handler
   SetMAXError 0                                'assume sucess
  
   '--- check for error
   IF FileHandle = 0 THEN
     SetMAXError &H2                            'file not found
     EXIT FUNCTION
   END IF
  
   '--- DOS type
   DIM Regs  AS RegType
  
   '--- seek to bottom of file & count how far that is (which is file size)
   Regs.AX = &H4202                             'file size
   Regs.BX = FileHandle                         'file
   Regs.CX = 0                                  'absolute offset from top
   Regs.DX = 0                                  'top
  
   Interrupt &H21, Regs, Regs                   'do it
  
   IF Regs.Flags AND 1 THEN                     'error
     SetMAXError Regs.AX                        'assign error
     EXIT FUNCTION
   END IF

   '--- assign function
   SizeOf& = (Regs.DX * 256) + Regs.AX

END FUNCTION

