; READSUBI - absolute disk read subroutine for interpretive BASIC
; CALL READSUBI(STACK$,DRIVE%,SECTOR%,BUF$)
; STACK$ - stack area
; DRIVE% = 0 if A:, 1 if B:, etc.
; SECTOR% - relative sector number (starting at 0)
; BUF$ - 512 byte buffer for sector's data
cseg   segment para public 'code'
public readsubi
readsubi proc far
    assume cs:cseg,ds:cseg,ss:cseg,es:nothing
    push bp
    mov bp,sp
    push es          ; save es
    mov si,[bp+12]   ; point to stack$ arg
    mov al,[si]      ; get length
    mov ah,0
    inc si
    add ax,[si]      ; add start addr
    dec ax           ; down by 1
    mov di,sp        ; hold in di
    mov sp,ax        ; new sp
    push di
    mov si,[bp+10]   ; drive no
    mov ax,[si]
    mov cx,1         ; read 1 sector
    mov si,[bp+8]    ; sector no
    mov dx,[si]
    mov si,[bp+6]    ; buffer
    add si,1
    mov bx,[si]
    mov es,bp        ; save bp
    int 25h          ; bios absolute read
    mov bp,es        ; restore bp
    jc p88           ; error
    mov ax,0         ; no error - clear ax
p88:popf
    mov ah,0         ; leave any error in al
    mov si,[bp+8]
    mov [si],ax      ; return error in sector arg
    pop di           ; restore original stack
    mov sp,di
    pop es           ; restore es
    pop bp
    ret 8
readsubi endp
cseg ends
    end
