10 REM readc - read file directory for compiled BASIC
20 DEFINT A-Z
30 GOSUB 70 ' initialize
40 IF DOS=0 THEN GOSUB 220 ' prior to DOS 2.00
50 IF DOS>=2 THEN GOSUB 1070 ' DOS 2.00 or later
60 END
70 REM *** initialize ***
80 CLS:PRINT "File directory":PRINT
90 RETCD=255 ' error return code
100 INTNO=0   ' interrupt number
110 AH=0:AL=0 ' registers
120 BH=0:BL=0
130 CH=0:CL=0
140 DH=0:DL=0
150 INTNO=33 ' check version of dos
160 AH=48
170 GOSUB 1400
180 DOS=AL
190 IF DOS=0 THEN PRINT "DOS is prior to version 2.00" ELSE PRINT "DOS version" AL "." AH
200 PRINT
210 RETURN
220 REM *** mainline for dos 1.xx ***
230 REM This program reads the diskette file directory using absolute
240 REM disk reads. The subroutine can be modified to perform an absolute
250 REM disk write, so you can modify the directory (e.g. change file
260 REM attributes). Be very careful when writing to the diskette file
270 REM directory or file allocation table as it is very easy to destroy
280 REM either or both of the above tables, resulting in loss of files.
290 F$=SPACE$(512)
300 INPUT "Drive (0=A, 1=B, etc.)";DRIVE
310 PRINT "Filename            Size  Date      Time      Attributes"
320 SECTOR=1 ' read file allocation table
330 GOSUB 570
340 DISKTYPE=ASC(F$)
350 IF DISKTYPE=254 THEN 380
360 IF DISKTYPE=255 THEN 430
370 PRINT "Unknown disk type":RETURN
380 REM *** single-sided disk ***
390 PRINT "Single-sided 8-sector disk"
400 SEC1=3:SEC2=6
410 GOSUB 500 ' read sectors 3 - 6
420 RETURN
430 REM *** double-sided disk ***
440 PRINT "Double-sided 8-sector disk"
450 SEC1=3:SEC2=7
460 GOSUB 500 ' read sectors 3 - 7
470 SEC1=320:SEC2=321
480 GOSUB 500 ' read sectors 320 - 321
490 RETURN
500 REM *** read sectors ***
510 FOR I=SEC1 TO SEC2
520 SECTOR=I
530 GOSUB 570
540 GOSUB 700
550 NEXT I
560 RETURN
570 REM *** call readsub ***
580 CALL READSUB(DRIVE,SECTOR,F$)
590 IF SECTOR<=1 THEN 690
600 PRINT "*** Disk error ***"
610 IF (SECTOR AND 128)=128 THEN PRINT "Attachment failed to respond"
620 IF (SECTOR AND 64)=64 THEN PRINT "Seek operation failed"
630 IF (SECTOR AND 32)=32 THEN PRINT "Controller failure"
640 IF (SECTOR AND 16)=16 THEN PRINT "Bad CRC on diskette read"
650 IF (SECTOR AND 8)=8 THEN PRINT "DMA overrun"
660 IF (SECTOR AND 4)=4 THEN PRINT "Sector not found"
670 IF (SECTOR AND 3)=3 THEN PRINT "Write-protected diskette"
680 IF (SECTOR AND 2)=2 THEN PRINT "Address mark not found"
690 RETURN
700 REM *** print dos 1.xx file info ***
710 FOR J=1 TO 16
720 FD$=MID$(F$,J*32-31,32)
730 IF LEFT$(FD$,1)=CHR$(229) THEN 780 ' deleted or never used
740 PRINT LEFT$(FD$,8) "." MID$(FD$,9,3) " "; ' file name
750 SIZ$=MID$(FD$,29,4)
760 ATTRIB=ASC(MID$(FD$,12,1))
770 GOSUB 800 ' print size, date, time & attribute
780 NEXT J
790 RETURN
800 REM *** print size, date, time, & attribute ***
810 SIZE1!=ASC(MID$(SIZ$,1,1))
820 SIZE2!=ASC(MID$(SIZ$,2,1))
830 SIZE3!=ASC(MID$(SIZ$,3,1))
840 SIZE4!=ASC(MID$(SIZ$,4,1))
850 FILSIZ!=SIZE1!+(SIZE2!*256)+65536!*(SIZE3!+(SIZE4!*256))
860 PRINT USING "###,###,###_ _ ";FILSIZ!;
870 DATE1=ASC(MID$(FD$,25,1))
880 DATE2=ASC(MID$(FD$,26,1))
890 YEAR=((DATE2 AND 254)/2)+80
900 MONTH=(DATE2 AND 1)*8+((DATE1 AND 224)/32)
910 DAY=(DATE1 AND 31)
920 PRINT USING "##_/##_/##_ _ ";MONTH,DAY,YEAR;
930 TIME1=ASC(MID$(FD$,23,1))
940 TIME2=ASC(MID$(FD$,24,1))
950 HOURS=(TIME2 AND 248)/8
960 MINUTES=(TIME2 AND 7)*8+((TIME1 AND 224)/32)
970 SECONDS=(TIME1 AND 31)*2
980 PRINT USING "##_:##_:##_ _ ";HOURS,MINUTES,SECONDS;
990 IF (ATTRIB AND 1)=1 THEN PRINT "Read-only ";
1000 IF (ATTRIB AND 2)=2 THEN PRINT "Hidden ";
1010 IF (ATTRIB AND 4)=4 THEN PRINT "System ";
1020 IF (ATTRIB AND 8)=8 THEN PRINT "Volume ";
1030 IF (ATTRIB AND 16)=16 THEN PRINT "Directory ";
1040 IF (ATTRIB AND 32)=32 THEN PRINT "Archive ";
1050 PRINT
1060 RETURN
1070 REM *** mainline for dos 2.00 and later ***
1080 INTNO=33
1090 DTA$=SPACE$(43)+""
1100 INPUT "Drive (A, B, C, or D)";DRIVE$
1110 PRINT "Filename           Size  Date      Time      Attributes"
1120 SEARCH$=DRIVE$+":*.*"+CHR$(0) ' search argument
1130 DEF SEG
1140 X!=VARPTR(DTA$) ' set data transfer area
1150 DH=PEEK(X!+3)
1160 DL=PEEK(X!+2)
1170 AH=26
1180 GOSUB 1400 ' set dta
1190 X!=VARPTR(SEARCH$)
1200 DH=PEEK(X!+3)
1210 DL=PEEK(X!+2)
1220 AH=78 ' find first file
1230 CL=&H37 ' search for all files
1240 GOSUB 1400 ' find first/next file
1250 IF AL=2 THEN PRINT "File not found":GOTO 1300 ' no more files
1260 IF AL=18 THEN PRINT "No more files":GOTO 1300 ' no more files
1270 GOSUB 1310
1280 AH=79 ' find next file
1290 GOTO 1240
1300 RETURN
1310 REM *** print file info ***
1320 FILNAM$=RIGHT$(DTA$,13)
1330 EPOS=INSTR(FILNAM$,CHR$(0))
1340 PRINT LEFT$(FILNAM$,EPOS-1) TAB(13); ' file name
1350 FD$=DTA$
1360 SIZ$=MID$(DTA$,27,4)
1370 ATTRIB=ASC(MID$(DTA$,22,1))
1380 GOSUB 800
1390 RETURN
1400 REM *** call dos/bios ***
1410 CALL DOSSUB(RETCD,INTNO,AH,AL,BH,BL,CH,CL,DH,DL)
1420 IF RETCD=255 THEN 1570
1430 BEEP
1440 IF RETCD=0 THEN PRINT "Attempt to write on write-protected diskette"
1450 IF RETCD=1 THEN PRINT "Unknown unit"
1460 IF RETCD=2 THEN PRINT "Drive not ready"
1470 IF RETCD=3 THEN PRINT "Unknown command"
1480 IF RETCD=4 THEN PRINT "Data error (CRC)"
1490 IF RETCD=5 THEN PRINT "Bad request structure length"
1500 IF RETCD=6 THEN PRINT "Seek error"
1510 IF RETCD=7 THEN PRINT "Unknown media type"
1520 IF RETCD=8 THEN PRINT "Sector not found"
1530 IF RETCD=9 THEN PRINT "Printer out of paper"
1540 IF RETCD=10 THEN PRINT "Write fault"
1550 IF RETCD=11 THEN PRINT "Read fault"
1560 IF RETCD=12 THEN PRINT "General failure"
1570 RETURN
HEN PRINT "Write fault"
1550 IF RETCD=11 THEN PRINT "Read fault"
1560 