; PEEKSUB - subroutine to read memory for Pascal programs
; PEEKSUB(DATASEG,LOCATION,PEEKVAL)
; DATASEG is the value of the data segment
; LOCATION is the memory location relative to the DS (0-66535)
; PEEKVAL is the integer value (0-255) returned
cseg segment para public 'code'
public peeksub
peeksub proc far
    assume cs:cseg,ds:nothing,ss:nothing,es:nothing
    push bp
    mov bp,sp
    push es	     ; save original es
    mov si,[bp+10]   ; point to dataseg
    mov ax,[si]      ; dataseg in ax
    mov es,ax	     ; fix extra segment
    mov di,[bp+8]    ; point to memory location
    mov di,[di]      ; location in di
    mov si,[bp+6]    ; point to return value
    mov al,es:[di]   ; peek
    mov ah,0
    mov [si],ax      ; return value
    pop es	     ; restore es
    pop bp
    ret 6
peeksub endp
cseg ends
    end
