; DOSSUBI - general dos subroutine interface for interpretive BASIC
; CALL DOSSUBI(STACK$,RETCD%,INTNO%,AH%,AL%,BH%,BL%,CH%,CL%,DH%,DL%)
; STACK$ is the stack area
; RETCD% is the error return code (0 if no error)
; INTNO% is the interrupt number (0 to 255)
; AH% is the argument corresponding to register AH
; AL% is the argument corresponding to register AL
; BH% is the argument corresponding to register BH
; BL% is the argument corresponding to register BL
; CH% is the argument corresponding to register CH
; CL% is the argument corresponding to register CL
; DH% is the argument corresponding to register DH
; DL% is the argument corresponding to register DL
cseg segment para public 'code'
public dossubi
dossubi proc far
    assume cs:cseg,ds:nothing,ss:nothing,es:nothing
    push bp
    mov bp,sp

p10:               ; use passed stack
    mov di,sp      ; save orig sp
    mov si,[bp+26] ; point to stack$ arg
    mov al,[si]    ; get length
    mov ah,0
    inc si
    add ax,[si]    ; add start addr
    dec ax         ; down by 1
    mov sp,ax      ; new sp
    push di        ; save orig sp on new stack

p20:               ; temporarily change fatal error vector
    mov ax,0
    mov ds,ax
    mov ax,[ds:90h]; get fatal error ip
    push ax        ; save ip
    mov ax,[ds:92h]; get fatal error cs
    push ax        ; save cs
    call p25       ; get ip
p25:
a25 equ this byte
    pop bx         ; ip in bx
    add bx,a50-a25
    mov ds:90h,bx  ; ip of vector
    push cs        ; set fatal error cs
    pop ax         ; set ds to cs
    mov ds:92h,ax  ; cs of vector
    mov ax,es
    mov ds,ax      ; restore ds

p30:               ; set registers for call
    mov si,[bp+20] ; point to ah argument
    mov ah,[si]
    mov si,[bp+18] ; point to al argument
    mov al,[si]
    mov si,[bp+16] ; point to bh argument
    mov bh,[si]
    mov si,[bp+14] ; point to bl argument
    mov bl,[si]
    mov si,[bp+12] ; point to ch argument
    mov ch,[si]
    mov si,[bp+10] ; point to cl argument
    mov cl,[si]
    mov si,[bp+8]  ; point to dh argument
    mov dh,[si]
    mov si,[bp+6]  ; point to dl argument
    mov dl,[si]

p40:               ; set up for call
    push ax
    push bx
    mov si,[bp+22] ; point to interrupt no
    mov al,[si]    ; interrupt in al
    call p45
p45:
a45 equ this byte
    pop bx         ; ip in bx
    add bx,a46-a45+1
    mov cs:[bx],al ; set interrupt
    pop bx
    pop ax
    push bp        ; save bp - bios bug
a46 equ this byte
    int 00h        ; overlaid by intno%
    jmp p60        ; skip err control

p50:               ; handle fatal error
a50 equ this byte
    sti            ; interrupts back on
    mov ax,di      ; get error code
    mov ah,0       ; error in al
    add sp,18      ; skip unneeded stack
    pop bp
    pop ds
    pop es
    add sp,6
    pop bp         ; restore bp - bios bug
    mov si,[bp+24]
    mov [si],ax    ; return error
    jmp p70        ; restore orig vector

p60:               ; return register values
    pop bp         ; restore bp - bios bug
    mov si,[bp+20] ; point to ah argument
    mov [si],ah
    mov si,[bp+18] ; point to al argument
    mov [si],al
    mov si,[bp+16] ; point to bh argument
    mov [si],bh
    mov si,[bp+14] ; point to bl argument
    mov [si],bl
    mov si,[bp+12] ; point to ch argument
    mov [si],ch
    mov si,[bp+10] ; point to cl argument
    mov [si],cl
    mov si,[bp+8]  ; point to dh argument
    mov [si],dh
    mov si,[bp+6]  ; point to dl argument
    mov [si],dl

p70:               ; reset fatal error vector
    mov ax,0
    mov ds,ax
    pop ax         ; re-set fatal error vector
    mov ds:92h,ax  ; restore original cs
    pop ax
    mov ds:90h,ax  ; restore original ip
    mov ax,es
    mov ds,ax      ; restore ds

p80:               ; return to caller
    pop di         ; get orig sp
    mov sp,di      ; back to orig stack
    pop bp         ; return to caller
    ret 22

dossubi endp
cseg ends
    end
