;Contents        : Sweep 1.1 - multi field zoom
;                  (see also Sweepnxt.sc)
;
;Source File     : Sweep.sc
;Written By      : Ken Schachat
;                  Matriya Software
;                  108 Belmont St
;                  Somerville, Ma 02143
;                  Phone (617) 572-4965 (Weekdays)
;                  CompuServ I.D. : 76666,3623
;
;Date            : 10/10/88
;Description     : Searches ALL fields in current table and locates FIRST
;                  occurence of value entered at prompt
;                  Will search ALL fields in table
;                  NOT case sensitive
;                  Works in all paradox 2.01 modes
;                  Supports wild cards
;Paradox Version : Paradox 2.0 or above
;
;Special Notes   : Suggested use:                                                             ;
; place the following lines in paradox init.sc:
; Setkey -94 PLAY "C:\\PARADOX2\\SWEEP"     ;Ctrl-F1 sweep all fields
; Setkey -95 PLAY "C:\\PARADOX2\\SWEEPNXT"  ;Ctrl-F2 sweep next all fields
; See PAL Users Guide Appendix B for alternate key assignments
;
; If there are any questions please contact the author at the address
; and phone number above.
; PLEASE distribute these two programs together:
; Sweep.sc
; Sweepnxt.sc
; Both are contained in Sweep.arc
;
; I welcome your comments, suggestions, bug reports etc. (see address
; above & Compuserv
;
;Comments: (also see Sweepnxt.sc)
;  I decided to write this as an enhancement and complement to the
;  Paradox 2.0 "Zoom".  The main goal with Sweep.sc is to extend the power
;  of Zoom to "sweep" all the fields in a table.  I think this provides an
;  extremely useful tool for Paradox users.
;  Sweep currently supports wild cards (..,@) only on alpha fields.  I'll
;  upload a new version that supports wild cards on the other field types
;  when I finish it.  I have left part of the script as a procedure for the
;  enchanced performance, but it will run fine as a normal script.
;  I have many enhancements planned for Sweep...
;---------------------------------------------------------------------------
Style Attribute 49
@24,0 ?? Format("W80,AC","Sweep  multi-field search ver 1.1 by Ken Schachat  Matriya Software")
Style

;see if there are any display tables open on the workspace ;

If Imagetype() <> "Display"
  Then Beep
    Message "Cursor must be in table image"
    Sleep 3000
    Return
Endif

; Check to make sure there is no menu displayed

If Menuchoice() <> "Error"
  Then
    Beep
    Message "Sweep can't run when Menu is active"
    Sleep 3000
    Return
Endif

; Fieldview behaves strangely at times
; so just don't deal with it
; paradox Ctrl-Z "Zoom" doesn't work with it either

If Isfieldview()
  Then
    Beep
    Message "Press Enter to leave FieldView"
    Sleep 3000
    Return
Endif

If not Isassigned(kgs_sweepval)
  Then kgs_sweepval = ""
Endif

formchk=""        ;initalize formview flag

;check if image is in form or table view

If Isformview()
  Then
    formchk = "Y"
    Formkey
Endif

fld=Field()       ;get current field
CtrlEnd           ;go to last field
lastfld = Field() ;get last field

Moveto Field fld  ;move back to current field

;Sometimes it's nice to be able to zoom in the record # column
;so I left this code in: just remove the comments if you want to
;use it.  This is as an "extra" so I went the easy way here with
;a menu macro.     If this is left out then Sweep starts in the
;first field.
;If Field() = "#"
;  Then
;    Sleep 500
;    Menu {Image} {GoTo} {Record}
;    Return
;Endif

;prompt for a value.

@0,0 ?? "Value:"+Spaces(70)
@1,0 ?? "Enter value or pattern to search for."
@0,8

;I put the previously searched value as a default but if you wish to
;disable this, eliminate the DEFAULT statement.

Cursor Normal      ;turn on cursor for input
Accept "A54" Picture "*@" Default Strval(kgs_sweepval) To kgs_sweepval
Cursor Off

;if user presses ESC then return to paradox

If retval = False
  Then
    If formchk = "Y"
      Then Formkey
    Endif
  Return
Endif

;move to first field in image

Moveto [#]
Right
Message "Searching "+Field()

;----------------------------------------------------------------------------;
;This For loop moves through all the fields, starting with the first field,  ;
;until the value is located.  Every time there is a move to the next field,  ;
;the fieldtype is checked.  An attempt is made to convert the value to the   ;
;current fieldtype. If this attempt fails it moves on to the next field.     ;
;If the types match, then a Locate is done on that field, placing the cursor ;
;on the record, highlighting the value if appropriate, and exiting the loop. ;
;If there is NO matching value found in that field then we move on to the    ;
;next field until all the fields have been searched.                         ;
;----------------------------------------------------------------------------;

;define proc
Proc sweep()
Cursor Off
i=1
For i From i To Nfields(Table())
  Cursor Off
  If Charwaiting()
    Then Quitloop
  Endif
  Message "Searching "+Field()

  Cursor Off
  ;------------------------------------------------------;
  ;Convert kgs_sweepval back to a string if necessary    ;
  ;------------------------------------------------------;
  If Substr(Type(kgs_sweepval),1,1) <> "A"
    Then kgs_sweepval = Strval(kgs_sweepval)
  Endif
  ;------------------------------------------------------------------;
  ;this switch/case is the section that does the data type checking, ;
  ;locating & conversion and is the most important part of the code  ;
  ;------------------------------------------------------------------;
  Switch
    Case Substr(Fieldtype(),1,1) = "A" : Locate Pattern kgs_sweepval
    Case (Fieldtype() = "N") Or (Fieldtype() = "S") :
      If Numval(kgs_sweepval) = "Error"
        Then
          retval = False
          If Field() <> lastfld
            Then Right Loop
          Endif
        Else
          kgs_sweepval = Numval(kgs_sweepval)
          Locate kgs_sweepval
      Endif
    Case Fieldtype() = "D" :
      If DATEVAL(kgs_sweepval) = "Error"
        Then
          retval = False
          If Field() <> lastfld
            Then Right Loop
          Endif
        Else
          kgs_sweepval = Dateval(kgs_sweepval)
          Locate kgs_sweepval
      Endif
    Case Fieldtype() = "$" :
      If Numval(kgs_sweepval) = "Error"
        Then
          retval = False
          If Field() <> lastfld
            Then Right Loop
          Endif
        Else
          kgs_sweepval = Numval(kgs_sweepval)
          Locate kgs_sweepval
      Endif
  EndSwitch
  Cursor Off
  ;---------------------------------------------------------------------;
  ;The following section is mostly here to imitate the reverse video    ;
  ;highlighting that Ctrl-Z does in Paradox when a record is located.   ;
  ;This section handles some of the stange things involved with the     ;
  ;way FieldView behaves and handles situations where a column has      ;
  ;been narrowed in the display image (form or table view) with the     ;
  ;Image menu choice.  If some of the code seems obscure, stepping      ;
  ;through it with the debugger will show what is going on.             ;
  ;---------------------------------------------------------------------;
  Switch
    Case retval = True :
      If formchk = "Y"       ;switch back to form view if necessary
        Then Formkey
      Endif
      Synccursor
      Fieldview
      rightcol = Col()
      Home
      Synccursor
      leftcol = Col()
      Enter
      Menu  ;this bit of weirdness is because fieldview leaves the value
      Esc   ;on the workplace "shifted": moving the cursor behind the scenes
            ;restores it to its normal postion in the field
      Synccursor
      If (leftcol = rightcol) OR Fieldtype() = "N"
        Then
          Style Reverse    ;if the display image was narrowed to the point
          ?? " "           ;of value truncation or if the field is numeric
          Sleep 100        ;it's not worth the trouble to do the reverse
          Style            ;highlighting on the entire value so just put
          Return           ;up a simple blip
        Else
          Cursor Off
          ;this is where the reverse video display stuff is done
          Style Reverse
          Switch
            ;too much hassle with N fields to bother
            ;with display stuff, just locate
            Case Fieldtype() = "N" :
            Case Fieldtype() = "$" :
              Synccursor
              @ Row(), (Col()-3)-Len([])
              ?? Fill(" ",Len([])+3)
              @ Row(), (Col()-3)-Len([])
              ?? []
            Otherwise:
              Synccursor
              @ Row(), Col()-Len([])
              ?? Fill(" ",Len([]))
              @ Row(), Col()-Len([])
              ?? []
          Endswitch
          Sleep 100
          Style
          Return
      Endif
    Case retval = False:
      If Field() = lastfld
        Then
          Moveto [#]            ;I'm doing this rather than a simple
          While Field() <> fld  ;"moveto field fld" because this will
            Right               ;restore the image exactly the way it was
          Endwhile              ;more often
          IF formchk = "Y"
            Then Formkey
          Endif
          Message "Match not found"
          Sleep 2000
          Style
          Return
        Else
          Right
      Endif
  EndSwitch
EndFor

Cursor Off
Endproc

;execute proc
sweep()