;Contents        : Sweepnxt 1.1 - multi field zoom next
;                  (see also Sweep.sc)
;
;Source File     : Sweepnxt.sc
;Written By      : Ken Schachat
;                  Matriya Software
;                  108 Belmont St
;                  Somerville, Ma 02143
;                  Phone (617) 572-4965 (Weekdays)
;                  CompuServ I.D. : 76666,3623
;---------------------------------------------------------------------------
;Description: Searches ALL fields in the table previosly searched by Sweep,
;             starting at the current cursor location and locates the
;             NEXT occurence of the value carried over from Sweep.
;Features:    Will search ALL fields in table beginning with current field
;             NOT case sensitive
;             works in all paradox 2.01 modes
;             supports wild cards
;---------------------------------------------------------------------------
;requirements: Paradox 2.0 or above
;---------------------------------------------------------------------------
;Suggested use:
;place the following lines in paradox init.sc
;SETKEY -94 PLAY "C:\\PARADOX2\\SWEEP"     ;Ctrl-F1 sweep all fields
;SETKEY -95 PLAY "C:\\PARADOX2\\SWEEPNXT"  ;Ctrl-F2 sweep next all fields
;See PAL Users Guide Appendix B for alternate key assignments
;---------------------------------------------------------------------------
;PLEASE distribute these two programs together:
; Sweep.sc
; Sweepnxt.sc
; Both are contained in Sweep.arc
;
; I welcome your comments, suggestions, bug reports etc. (see address
; above & Compuserv).
;---------------------------------------------------------------------------
;Comments (also see Sweep.sc):
;  This is designed to work with Sweep.sc. and basically works like Paradox
;  ZoomNext.  Like Sweep, it is not case sensitive.  It will continue
;  searching from the current location of the cursor and continue through
;  the last field in the current table image.  This script uses a global
;  variable  called kgs_sweepval that is carried over in memory from the
;  previous execution of Sweep.sc.  If this variable IS deleted from memory or
;  otherwise trashed before Sweepnxt is executed, then the message "No
;  Sweep value specified" will appear and Sweepnxt will work.
;  Part of this script is proceduralized for enhanced performance, but it will
;  run fine as script.
;---------------------------------------------------------------------------
Style Attribute 49
@24,0 ?? Format("W80,AC","SweepNext  multi-field search ver 1.1 by Ken Schachat  Matriya Software")
Style
Cursor Off

;see if there are any display tables open on the workspace
If ImageType() <> "Display"
    Then Beep
    Message "Cursor must be in table image"
    Sleep 3000
    Return
EndIf

;Check to make sure there is no menu displayed
If MenuChoice() <> "Error"
    Then
    Beep
    Message "Sweep can't run when Menu is active"
    Sleep 3000
    Return
EndIf

;Make sure variable carried over from Sweep.sc is available
If Not IsAssigned(kgs_sweepval)
    Then
      Message "No Sweep value specified"
      Sleep 3000
      Return
EndIf

; fieldview behaves strangely at times
; so just won't deal with it
; paradox ver2 ctrl-z "zoom" won't work with it either
If IsFieldView()
    Then
      Beep
      Message "Press Enter to leave FieldView"
      Sleep 3000
      Return
EndIf

formchk=""           ;initalize formview flag
first_fld_search=""  ;initalize first time field search flag

;check if image is in form or table view
If IsFormView()
    Then
    formchk = "Y"
    FormKey
EndIf

If Field() = "#"  ;no point searching for next occurence
    Then Right
EndIf


fld = Field()        ;get current field
last_recno = RecNo() ;get current recno()
CtrlEnd              ;go to last field
lastfld = Field()    ;get last field
MoveTo [#]           ;better visual results than moving directly
MoveTo Field fld     ;to field (in table view)

Message "Searching "+Field()

;----------------------------------------------------------------------------
;This is the main loop for continuing the sweep of the table.  It starts at
;current cursor location and goes until the last field of the current image
;is searched.  It's basically like Sweep but there is a SKIP to the next
;record if it's the same field.  If it's performing the first LOCATE
;in a field, it has to avoid the SKIP or the first record won't be included
;in the search
;----------------------------------------------------------------------------

;define proc
Proc sweepnext()
While (Field() <> "#")
  If CharWaiting()
      Then
      QuitLoop
  EndIf
  Cursor Off
  Message "Searching "+Field()
  ;------------------------------------------------------;
  ;Convert kgs_sweepval back to a string if necessary    ;
  ;------------------------------------------------------;
  If Substr(Type(kgs_sweepval),1,1) <> "A"
      Then kgs_sweepval = StrVal(kgs_sweepval)
  EndIf
  Cursor Off
  ;------------------------------------------------------------------;
  ;this switch/case is the section that does the data type checking, ;
  ;locating & conversion and is the most important part of the code  ;
  ;------------------------------------------------------------------;
  Switch
    Case AtLast() :   ;if you're at the end there's no point searching
      RetVal = False  ;anymore
    Case Substr(FieldType(),1,1) = "A" :
      If first_fld_search = "Y"
        Then
          Locate Next Pattern kgs_sweepval
          first_fld_search = "N"
        Else
          Skip                             ;skip to next record
          Locate Next Pattern kgs_sweepval ;then use locate pattern command
      EndIf                                ;for non-case sensitive search
    Case (FieldType() = "N") Or (FieldType() = "S") : ;convert search string
      If NumVal(kgs_sweepval) = "Error"  ;if it can't be converted
        Then RetVal = False
         If Field() <> lastfld
           Then
             Right            ;then move on to top of next field
             Home
             first_fld_search = "Y"
             Loop
         EndIf
      Else
        kgs_sweepval = NumVal(kgs_sweepval) ;if it can be converted here
        If first_fld_search = "Y"
          Then
            Locate Next kgs_sweepval        ;then locate
            first_fld_search = "N"
          Else
            Skip
            Locate Next kgs_sweepval
        EndIf
      EndIf
    Case FieldType() = "D" :               ;convert search string to date
      If DateVal(kgs_sweepval) = "Error"    ;if you can't convert it
        Then RetVal = False
        If Field() <> lastfld
          Then
            Right                        ;then move on to top of next field
            Home
            first_fld_search = "Y"
            Loop
        EndIf
      Else
        kgs_sweepval = DateVal(kgs_sweepval)
        If first_fld_search = "Y"
          Then
            Locate Next kgs_sweepval
            first_fld_search = "N"
          Else
            Skip
            Locate Next kgs_sweepval
        EndIf
      EndIf
    Case FieldType() = "$" :               ;same as above for currency field
      If NumVal(kgs_sweepval) = "Error"
        Then RetVal = False
        If Field() <> lastfld
          Then
            Right
            Home
            first_fld_search = "Y"
            Loop
        EndIf
      Else
        kgs_sweepval = NumVal(kgs_sweepval)
        If first_fld_search = "Y"
          Then
            Locate Next kgs_sweepval
            first_fld_search = "N"
          Else
            Skip
            Locate Next kgs_sweepval
        EndIf
      EndIf
  EndSwitch
  Cursor Off
  ;---------------------------------------------------------------------;
  ;The following section is mostly here to imitate the reverse video    ;
  ;highlighting that Ctrl-Z does in Paradox when a record is located.   ;
  ;This section handles some of the stange things involved with the     ;
  ;way FieldView behaves and handles situations where a column has      ;
  ;been narrowed in the display image (form or table view) with the     ;
  ;Image menu choice.  If some of the code seems obscure, stepping      ;
  ;through it with the debugger will show what is going on.             ;
  ;---------------------------------------------------------------------;
  Switch
    Case RetVal = True :
      If formchk = "Y"
        Then FormKey
      EndIf
      SyncCursor
      FieldView
      leftcol = Col()
      Home
      SyncCursor
      rightcol = Col()
      Enter
      Menu  ;this bit of weirdness is because fieldview leaves the value
      Esc   ;on the workplace "shifted" moving the cursor behind the scenes
      ;restores it
      SyncCursor
      If (leftcol = rightcol) Or FieldType() = "N"
        Then
          Style Reverse  ;if the display image was narrowed to the point
          ?? " "         ;of truncation or if the field is numeric
          Sleep 100      ;it's not worth the trouble to do the reverse
          Style          ;highlighting on the entire value so I just put
          Return         ;up a simple blip
        Else
          Cursor Off
          ;this is where the reverse video display stuff is done
          Style Reverse
          ;too much hassle with N fields to bother with display stuff, just locate
          Switch
            Case FieldType() = "N" :
            Case FieldType() = "$" :
              @ Row(), (Col()-3)-Len([])
              ?? Fill(" ",Len([])+3)
              @ Row(), (Col()-3)-Len([])
              ?? []
            OtherWise:
              @ Row(), Col()-Len([])
              ?? Fill(" ",Len([]))
              @ Row(), Col()-Len([])
              ?? []
          EndSwitch
          Sleep 300
          Style
          Return
      EndIf
    Case RetVal = False :
      If Field() = lastfld
        Then
          MoveTo [#]            ;I'm doing this rather than a simple
          While Field() <> fld  ;"moveto field fld" because this will
            Right               ;restore the image exactly the way it was
          EndWhile              ;more often
          MoveTo Record last_recno
          If formchk = "Y"
            Then FormKey
          EndIf
          Cursor Off
          Message "Match not found"
          Sleep 2000
          Style
          Return
        Else
          Right
          Home
          first_fld_search = "Y" ;set flag for first time search in next field
      EndIf
  Endswitch
EndWhile
EndProc

;execute proc
sweepnext()