; TKAdSpec
; Adds RSpec
; to RETK Specification Table
; Michael Clifford
; Copyright 1990, Computer Essentials, Inc.
; Atlanta, GA  Ph. 404-633-3046


PROC wfield()
   MOVETO RECORD currec.n
   MOVETO FIELD fieldname.a
     WAIT FIELD
       PROMPT pre.msg.a+prompt.msg.a,
              "Press Return (Enter) When Done " + FORMAT("W48,AR","RETK Specification Entry")
       MESSAGE pre.msg.a
     UNTIL "Enter"
ENDPROC

PROC  fieldprompt(fp.a)
 PRIVATE rp.a
 SWITCH
   CASE fp.a = "Description"    : rp.a =  "Description of Report"
   CASE fp.a = "R Category"     : rp.a =  "Category (See Help)  "
   CASE fp.a = "STable"         : rp.a =  "Source Table of Data "
   CASE fp.a = "DTable"         : rp.a =  "Table from Which Data Is Reported"
   CASE fp.a = "RSpec - STable" : rp.a =  "Table from Which Report Spec Originates"
   CASE fp.a = "RSpec - SDirec" : rp.a =  "Directory of Dummy Report Spec Table (Category #3)"
   CASE fp.a = "RSpec - S#"     : rp.a =  "Report Spec # (R, 1-14) from Source Table"
   CASE fp.a = "RSpec - D#"     : rp.a =  "Report Spec # (R, 1-14) in Destination Table"
   CASE fp.a = "UI Proc"        : rp.a =  "Procedure Name Which Requests Input from User"
   CASE fp.a = "Query Proc"     : rp.a =  "Procedure Name Which Generates Query"
   CASE fp.a = "Graph Proc"     : rp.a =  "Procedure Name Which Generates Graph, Xtab"
   CASE fp.a = "Setup Source"   : rp.a =  "Source that RETK Draws Setup Codes"
   CASE fp.a = "Setup String"   : rp.a =  "Setup String to Issue from This Report"
   CASE fp.a = "Setup Port"     : rp.a =  "Port (LPT1-3,COM1-2, Aux) to Issue This Report"
   OTHERWISE                    : rp.a = ""
  ENDSWITCH
  RETURN rp.a
ENDPROC


PROC rd(fieldname.a,reqstatus.a)
    ; required_desired proc
    ; entry must be filled in (for required) and should be
    ; filled in (for desired)
  PRIVATE blankfield.l,rat_sel.a,currec.n,prompt.msg.a,pre.msg.a,normal.entry.l
  prompt.msg.a = fieldprompt(fieldname.a)
  currec.n = [#]
  reqstatus.a = SUBSTR(UPPER(reqstatus.a),1,1)
  IF reqstatus.a = "R"
   THEN pre.msg.a = "REQUIRED! "
   ELSE pre.msg.a = "DESIRED!  "
  ENDIF
  normal.entry.l = TRUE
  WHILE true
    wfield()
    EXECUTE "blankfield.l = ISBLANK([" + fieldname.a + "])"
    IF blankfield.l = false THEN QUITLOOP ENDIF
    IF reqstatus.a = "R"
     THEN MESSAGE "Warning! Not Filled In" BEEP BEEP
         SHOWMENU
         "Correct" : "Correct Entry",
         "Abort"   : "Abort Entry for This Report"
         TO rat_sel.a
         IF rat_sel.a = "Correct"
           THEN LOOP
           ELSE DEL
                normal.entry.l = FALSE
                QUITLOOP
         ENDIF
    ELSE ; "D"
      IF IsBlank([]) AND MATCH(FieldType(),"A..")
       THEN [] = "NA"
      ENDIF
    ENDIF
    QUITLOOP
  ENDWHILE
  IF  normal.entry.l = FALSE
    THEN close_down("Report Assignment to RETK Terminated.")
  ENDIF
ENDPROC

PROC rspecadd()
  rd("Description","R")
  rd("R Category","R")
  [Setup Source] = "R"    ; actually in report
  [Setup String] = "NA"   ; no need to have code, issued from report
  [Setup Port]   = "LPT1"
  SWITCH
    CASE [R Category] = 1   :
      [DTable]         = "NA"
      [UI Proc]        = "NA"
      [RSpec - SDirec] = "NA"
      [Query Proc]     = "NA"
      rd("STable","R")
      [DTable] = [STable]
      [RSpec - STable] = [STable]
      rd("RSpec - S#","R")
      [RSpec - D#] = [RSpec - S#]
      rd("Graph Proc","D")


    CASE [R Category] = 2   :
      [STable]         = "NA" ; changed
      [DTable]         = "Answer"
      [RSpec - Stable] = "Answer"
      [RSpec - S#]     = "R"
      [RSpec - D#]     = "R"
      [RSpec - SDirec] = "NA"
      rd("Query Proc","R")
      rd("UI Proc","D") ; formerly "R" !!!
      rd("Graph Proc","D")

    CASE [R Category] = 3   :

      [STable]         = "NA" ; changed
      [DTable]         = "Answer"
      [RSpec - D#]     = "R"
      rd("RSpec - STable","R")
      rd("RSpec - S#","R")
      rd("RSpec - SDirec","D")
      rd("Query Proc","R")
      rd("UI Proc","D")
      rd("Graph Proc","D")

    CASE [R Category] = 4   :
      [DTable]         = "Answer"
      [RSpec - D#]     = "R"
      [RSpec - SDirec] = "NA"
      rd("STable","R")
      [RSpec - STable] = [STable]
      rd("RSpec - S#","R")
      rd("Query Proc","R")
      rd("UI Proc","D")
      rd("Graph Proc","D")

    CASE [R Category] = 5   :

      [Setup Source]    = "NA"  ; actually in report
      [STable]          = "NA"
      [DTable]          = "NA"
      [RSpec - STable]  = "NA"
      [RSpec - SDirec]  = "NA"
      [RSpec - S#]      = "NA"
      [RSpec - D#]      = "NA"
      [Query Proc]      = "NA"
      [Graph Proc]      = "NA"
      rd("UI Proc","R") ; the custom proc is the UI Proc
  ENDSWITCH
  IF [R Category] < 5
    THEN
      rd("Setup Source","D")
      IF [Setup Source] = "T"
       THEN rd("Setup String","R")
            rd("Setup Port","D")
      ENDIF
  ENDIF
ENDPROC

PROC close_down(close_msg.a)
     ; closes down operation if essential descriptor ommitted
  IF close_msg.a = ""
    THEN close_msg.a =
    "Essential Information Ommitted. RETK Generation Cancelled"
  ENDIF
  RESET
  RELEASE VARS ALL
  CLEAR
  QUIT close_msg.a
ENDPROC

RESET
CLEAR
SHOWTABLES
SDIR() "Enter Name of Report Driver Table "
TO rtd.a
IF NOT RETVAL OR rtd.a = "Esc"
  THEN  close_down("Report Assignment to RETK Terminated.")
ENDIF

CLEAR
MESSAGE "Working"
Edit rtd.a
PICKFORM "1"
IF [Description] = ""
THEN ; first time entry
     [Seq Num] = 100
     rspecadd()
ENDIF

WHILE true
  ECHO FAST ECHO OFF
  SHOWMENU
  "Add_Another" : "Add A Report Specification to Toolkit.",
  "Revise"       : "Revise This Report Assignment",
  "Quit"        : "Quit Routine"
  TO repeat.a
  SWITCH
    CASE repeat.a = "Add_Another" :
           IF [Description] = ""
           THEN ; first time entry
                new.seq.s = 100
           ELSE ; not first time entry
                ; establish sequence
                FORMKEY
                ImageRights ReadOnly
                WAIT TABLE
                 Prompt "Move to Reference Record Above or Below Which New RSpec Will Be Added",
                        "<F2> to Confirm, Esc to Abort"
                UNTIL "F2","Esc","Left"
                Formkey
                ImageRights

                SWITCH
                 CASE retval = "F2"  :
                      SHOWMENU
                       "Above" : "Place Above Current Record",
                       "Below" : "Place Below Current Record"
                       TO a.b.a

                     orig2.val.s = [Seq Num]
                     IF a.b.a = "Above"
                        THEN
                         IF ATFIRST()
                          THEN orig1.val.s = 0
                          ELSE
                           SKIP -1
                           orig1.val.s = [Seq Num]
                         ENDIF
                       ELSE ; below
                        IF ATLAST()
                          THEN orig1.val.s = orig2.val.s + 100
                          ELSE SKIP
                               orig1.val.s = [Seq Num]
                        ENDIF
                     ENDIF
                      new.seq.s = MIN(orig1.val.s,orig2.val.s) + ABS(orig1.val.s - orig2.val.s)
                      Ins
                      [Seq Num] = new.seq.s
                      rspecadd()
                 CASE retval = "Esc" : Loop
                 OTHERWISE           : Beep
                ENDSWITCH
           ENDIF


    CASE repeat.a = "Revise"      :
         currec.n = [#]
         Editlog Mark
         WAIT RECORD
         Prompt "Revise Entry. Press F2 to Confirm",
                "Esc to Restore Original"
         UNTIL "F2","Esc"
         MOVETO RECORD currec.n
         IF retval = "F2"
           THEN  rspecadd()
           ELSE Editlog Revert
         ENDIF
         Editlog Permanent
    OTHERWISE : QUITLOOP
  ENDSWITCH
ENDWHILE

Do_It!
close_down("Report Assignment to RETK Completed")
