unit PXBase;
interface
{$F+,O+,N+,E+}
uses Objects, PXEngine, Dos;


{********************** PARADOX Engine Object Shell **********************

  Copyright 1991, by Allen Bauer (75300, 1733)

  You may freely use this Paradox Shell providing the above copyright notice
  remains intact.

  Currently no support for file/record locking is provided and not all Engine
  functions are supported.

  One thing about this shell that should be mentioned.  In addition to the
  field name and type arrays that are required to create a Paradox table
  another type array is required.  This array is the same as the field type
  array passed to the Engine except another identifier is defined; "L"  This
  specifies that the shell should treat this field as a Longint.

  example:

  const
    NFields: 4;
    Fields: array[1..NFields] of NameString =
    ('Acct. Number',
     'Name',
     'Address',
     'State');

    Types: array[1..NFields] of NameString =
    ('N',
     'A15',
     'A15',
     'A2');

   PTypes: array[1..NFields] of NameString =
   ('L', <---this lets you treat the Account Number as a Longint
    'A15',
    'A15',
    'A2');

  The GetRecText abstract method is used for creating a record browser using
  TListViewer from Turbo Vision.  Override this method to return a string
  with the fields arranged in any manner you choose.

  This object is far from being complete at this time.  Any comments or sug-
  gestions are greatly appreciated.  I cannot garantee whether or not any rec-
  mendations would be implemented due to time constraints.  Feel free to make
  changes to suit your own needs.

}

type
  {**Change the PXEngine defines into TVision naming conventions**}
  PFieldArray = NamesArrayPtr;
  TFieldArray = NameArray;

  PPXBase = ^TPXBase;
  TPXBase = object(TObject)
    TblName: PString;
    TblHandle: TableHandle;
    RecHandle: RecordHandle;
    TableOpen: boolean;
    NFields: integer;
    Fields: PFieldArray;
    Types: PFieldArray;
    PasTypes: PFieldArray;
    constructor Init(NF: integer;
                     Flds, Typs, PTyps: PFieldArray;
                     ATblName: PathStr);
    constructor Load(var S: TStream);
    destructor Done; virtual;
    procedure Store(var S: TStream);
    procedure SetTableName(TN: PathStr); virtual;
    function PXError(Err: integer): word; virtual;
    function OpenTable: word; virtual;
    function CloseTable: word; virtual;
    function CreateTable: word; virtual;
    function AddKey(NFld, KeyType: integer): word; virtual;
    function RenameTable(NewName: PathStr): word; virtual;
    function CopyTable(DestName: PathStr): word; virtual;
    function DeleteTable: word; virtual;
    function IsOpen: boolean; virtual;
    function TblExist: boolean; virtual;
    function NumRecs: RecordNumber; virtual;
    function SearchKey(Flds, SrchMode: integer): word; virtual;
    function SearchFld(Fld: FieldHandle; SrchMode: integer): word; virtual;
    function NextRec: word; virtual;
    function PrevRec: word; virtual;
    function FirstRec: word; virtual;
    function LastRec: word; virtual;
    function UpdateRec: word; virtual;
    function DeleteRec: word; virtual;
    function GetRec: word; virtual;
    function GotoRec(Rec: RecordNumber): word; virtual;
    procedure GetField(FldHandle: FieldHandle; var Rec);
    procedure SetField(FldHandle: FieldHandle; var Rec);
    function InsertRec: word; virtual;
    function AppendRec: word; virtual;
    function GetRecText(Rec: RecordNumber; MaxLen: integer): string; virtual;
  end;

const
  RPXBase: TStreamRec = (ObjType: 22100;
                         VmtLink: Ofs(TypeOf(TPXBase)^);
                         Load: @TPXBase.Load;
                         Store: @TPXBase.Store);

  PXOpCanceled = $7FFF;

implementation
uses MsgBox, Views;

function SFLongInt(L: longint; Siz: integer): string;
var
  RStr : ^string;
begin
  asm
    mov  sp,bp
    push ss
    push word ptr [bp+0ch]
  end;
  str(L:Siz, RStr^);
end;

constructor TPXBase.Init(NF: integer;
                         Flds, Typs, PTyps: PFieldArray;
                         ATblName: PathStr);
begin
  TObject.Init;
  NFields := NF;
  getmem(Fields, NFields*sizeof(NameString));
  move(Flds^, Fields^, NFields*sizeof(NameString));
  getmem(Types, NFields*sizeof(NameString));
  move(Typs^, Types^, NFields*sizeof(NameString));
  getmem(PasTypes, NFields*sizeof(NameString));
  move(PTyps^, PasTypes^, NFields*sizeof(NameString));
  TblName := NewStr(ATblName);
end;

constructor TPXBase.Load(var S: TStream);
begin
  S.Read(NFields, sizeof(integer));
  getmem(Fields, NFields*sizeof(NameString));
  S.Read(Fields^, NFields*sizeof(NameString));
  getmem(Types, NFields*sizeof(NameString));
  S.Read(Types^, NFields*sizeof(NameString));
  getmem(PasTypes, NFields*sizeof(NameString));
  S.Read(PasTypes^, NFields*sizeof(NameString));
  TblName := S.ReadStr;
end;

destructor TPXBase.Done;
begin
  DisposeStr(TblName);
  freemem(Fields, NFields*sizeof(NameString));
  freemem(Types, NFields*sizeof(NameString));
  freemem(PasTypes, NFields*sizeof(NameString));
  TObject.Done;
end;

procedure TPXBase.Store(var S: TStream);
begin
  S.Write(NFields, sizeof(integer));
  S.Write(Fields^, NFields*sizeof(NameString));
  S.Write(Types^, NFields*sizeof(NameString));
  S.Write(PasTypes^, NFields*sizeof(NameString));
  S.WriteStr(TblName);
end;

procedure TPXBase.SetTableName(TN: PathStr);
begin
  if TblName <> nil then
    DisposeStr(TblName);
  TblName := NewStr(TN);
end;

function TPXBase.PXError(Err: integer): word;
var
  Params: array[0..1] of longint;
  ErrStr: string[80];
  RSlt: word;
begin
  PXError := Err;
  if Err > PXSuccess then
  begin
    ErrStr := PXErrMsg(Err);
    Params[0] := Err;
    Params[1] := longint(@ErrStr);
    case Err of
      PXERR_NOMORETMPNAMES,
      PXERR_TOOMANYPASSW,
      PXERR_TYPEMISMATCH,
      PXERR_OUTOFRANGE,
      PXERR_INVPARAMETER,
      PXERR_INVDATE,
      PXERR_INVFIELDHANDLE,
      PXERR_INVRECHANDLE,
      PXERR_INVTABLEHANDLE,
      PXERR_INVLOCKHANDLE,
      PXERR_INVDIRNAME,
      PXERR_INVFILENAME,
      PXERR_INVTABLENAME,
      PXERR_INVFIELDNAME,
      PXERR_INVLOCKCODE,
      PXERR_INVUNLOCK,
      PXERR_INVSORTORDER,
      PXERR_INVPASSW,
      PXERR_INVNETTYPE,
      PXERR_STRUCTDIFFER,
      PXERR_INVENGINESTATE,
      PXERR_TABLENOTFOUND,
      PXERR_TABLEOPEN,
      PXERR_TABLEINDEXED,
      PXERR_TABLENOTINDEXED,
      PXERR_TABLEWRITEPRO,
      PXERR_TABLEFULL,
      PXERR_TABLESQL,
      PXERR_INSUFRIGHTS,
      PXERR_XCORRUPTED,
      PXERR_XOUTOFDATE,
      PXERR_XSORTVERSION,
      PXERR_SXCORRUPTED,
      PXERR_SXOUTOFDATE,
      PXERR_SXNOTFOUND,
      PXERR_SXOPEN,
      PXERR_SXCANTUPDATE,
      PXERR_RECTOOBIG,
      PXERR_DIRNOACCESS,
      PXERR_DIRNOTPRIVATE,
      PXERR_DIRNOTFOUND,
      PXERR_NOTINITERR,
      PXERR_ALREADYINIT,
      PXERR_NOTLOGGEDIN,
      PXERR_NONETINIT,
      PXERR_NETMULTIPLE :
        begin
          MessageBox(^C'Fatal Error!'#13^C'#%d, %s ',
                      @Params, mfError+mfOKButton);
          Halt(Err);
        end;

      PXERR_RECDELETED,
      PXERR_RECLOCKED,
      PXERR_TABLEBUSY,
      PXERR_TABLELOCKED,
      PXERR_FILEBUSY,
      PXERR_FILELOCKED,
      PXERR_DIRBUSY,
      PXERR_DIRLOCKED:
        begin
          Rslt := MessageBox(^C'Lock Error!'#13^C'#%d, %s ',
                             @Params, mfError+mfOKCancel);
          if Rslt = cmCancel then
            PXError := PXOpCanceled;
        end;

      PXERR_DRIVENOTREADY,
      PXERR_DISKWRITEPRO,
      PXERR_GENERALFAILURE :
        begin
          Rslt := MessageBox(^C'Hardware Error!'#13^C'#%d, %s ',
                             @Params, mfError+mfOKCancel);
          if Rslt = cmCancel then
            PXError := PXOpCanceled;
        end;

      PXERR_OUTOFMEM,
      PXERR_OUTOFDISK,
      PXERR_OUTOFSTACK,
      PXERR_OUTOFSWAPBUF,
      PXERR_OUTOFFILEHANDLES,
      PXERR_OUTOFTABLEHANDLES,
      PXERR_OUTOFRECHANDLES,
      PXERR_OUTOFLOCKHANDLES:
        begin
          Rslt := MessageBox(^C'Space Error!'#13^C'#%d, %s ',
                             @Params, mfError+mfOKCancel);
          if Rslt = cmCancel then
            PXError := PXOpCanceled;
        end;

      PXERR_ENDOFTABLE,
      PXERR_STARTOFTABLE,
      PXERR_TABLEEMPTY,
      PXERR_RECNOTFOUND,
      PXERR_KEYVIOL: begin end;

    else
      begin
        MessageBox(^C'Error!'#13^C'#%d, %s ',
                    @Params, mfError+mfOKButton);
        Halt(Err);
      end;
    end;
  end;
end;

function TPXBase.OpenTable: word;
var
  RSlt: integer;
begin
  OpenTable := PXOpCanceled;
  repeat
    RSlt := PXError(PXTblOpen(TblName^, TblHandle, 0, true));
    if Rslt = PXOpCanceled then Exit;
  until Rslt = PXSuccess;
  repeat
    RSlt := PXError(PXRecBufOpen(TblHandle, RecHandle));
    if Rslt = PXOpCanceled then Exit;
  until Rslt = PXSuccess;
  OpenTable := Rslt;
  TableOpen := true;
end;

function TPXBase.CloseTable: word;
var
  RSlt: integer;
begin
  CloseTable := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecBufClose(RecHandle));
    if Rslt = PXOpCanceled then Exit;
  until Rslt = PXSuccess;
  repeat
    RSlt := PXError(PXTblClose(TblHandle));
    if RSlt = PXOpCanceled then Exit;
  until RSlt = PXSuccess;
  CloseTable := RSlt;
  TableOpen := false;
end;

function TPXBase.CreateTable: word;
var
  RSlt: integer;
begin
  CreateTable := PXOpCanceled;
  repeat
    RSlt := PXError(PXTblCreate(TblName^, NFields, Fields, Types));
    if RSlt =  PXOpCanceled then Exit;
  until RSlt = PXSuccess;
  CreateTable := RSlt;
  {CreateTable := OpenTable;}
end;

function TPXBase.AddKey(NFld, KeyType: integer): word;
var
  RSlt: integer;
  FldHandles: FieldHandleArray;
begin
  if KeyType = Primary then
    for RSlt := 1 to NFields do
      FldHandles[RSlt]  := RSlt
  else
  begin
    FldHandles[1] := NFld;
    NFld := 1;
  end;
  AddKey := PXOpCanceled;
  repeat
    RSlt := PXError(PXKeyAdd(TblName^, NFld, FldHandles, KeyType));
    if RSlt = PXOpCanceled then Exit;
  until RSlt = PXSuccess;
  AddKey := RSlt;
end;

function TPXBase.RenameTable(NewName: PathStr): word;
var
  RSlt: integer;
begin
  RenameTable := PXOpCanceled;
  if CloseTable <> PXSuccess then exit;
  repeat
    RSlt := PXError(PXTblRename(TblName^, NewName));
  until (RSlt = PXSuccess) or (RSlt = PXOpCanceled);
  if RSlt = PXSuccess then
  begin
    DisposeStr(TblName);
    TblName := NewStr(NewName);
  end;
  if OpenTable <> PXSuccess then exit;
  RenameTable := RSlt;
end;

function TPXBase.CopyTable(DestName: PathStr): word;
var
  RSlt: integer;
begin
  CopyTable := PXOpCanceled;
  if CloseTable <> PXSuccess then exit;
  repeat
    RSlt := PXError(PXTblCopy(TblName^, DestName));
  until (RSlt = PXSuccess) or (RSlt = PXOpCanceled);
  if RSlt = PXSuccess then
  begin
    DisposeStr(TblName);
    TblName := NewStr(DestName);
  end;
  if OpenTable <> PXSuccess then exit;
  CopyTable := RSlt;
end;

function TPXBase.DeleteTable: word;
var
  RSlt: integer;
begin
  DeleteTable := PXOpCanceled;
  if CloseTable <> PXSuccess then exit;
  repeat
    RSlt := PXError(PXTblDelete(TblName^));
  until (RSlt = PXSuccess) or (RSlt = PXOpCanceled);
  if RSlt <> PXSuccess then
  begin
    if OpenTable <> PXSuccess then exit;
  end;
  DeleteTable := RSlt;
end;

function TPXBase.IsOpen: boolean;
begin
  IsOpen := TableOpen;
end;

function TPXBase.TblExist: boolean;
var
  RSlt: integer;
  Exist: boolean;
begin
  TblExist := false;
  repeat
    RSlt := PXError(PXTblExist(TblName^, Exist));
    if RSlt = PXOpCanceled then exit;
  until RSlt = PXSuccess;
  TblExist := Exist;
end;

function TPXBase.NumRecs: RecordNumber;
var
  RSlt: integer;
  Num: RecordNumber;
begin
  NumRecs := 0;
  repeat
    Rslt := PXError(PXTblNRecs(TblHandle, Num));
    if RSlt = PXOpCanceled then exit;
  until RSlt = PXSuccess;
  NumRecs := Num;
end;

function TPXBase.SearchKey(Flds, SrchMode: integer): word;
var
  RSlt: integer;
begin
  SearchKey := PXOpCanceled;
  repeat
    RSlt := PXError(PXSrchKey(TblHandle, RecHandle, Flds, SrchMode));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (RSlt = PXErr_RecNotFound);
  SearchKey := RSlt;
end;

function TPXBase.SearchFld(Fld: FieldHandle; SrchMode: integer): word;
var
  RSlt: integer;
begin
  SearchFld := PXOpCanceled;
  repeat
    RSlt := PXError(PXSrchFld(TblHandle, RecHandle, Fld, SrchMode));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (RSlt = PXErr_RecNotFound);
  SearchFld := RSlt;
end;

function TPXBase.NextRec: word;
var
  RSlt: integer;
begin
  NextRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecNext(TblHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (RSlt = PXErr_EndOfTable) or (RSlt = PXErr_TableEmpty);
  NextRec := RSlt;
end;

function TPXBase.PrevRec: word;
var
  RSlt: integer;
begin
  PrevRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecPrev(TblHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (RSlt = PXErr_StartOfTable) or (RSlt = PXErr_TableEmpty);
  PrevRec := RSlt;
end;

function TPXBase.FirstRec: word;
var
  RSlt: integer;
begin
  FirstRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecFirst(TblHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (RSlt = PXErr_TableEmpty);
  FirstRec := RSlt;
end;

function TPXBase.LastRec: word;
var
  RSlt: integer;
begin
  LastRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecLast(TblHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (RSlt = PXErr_TableEmpty);
  LastRec := RSlt;
end;

function TPXBase.UpdateRec: word;
var
  RSlt: integer;
begin
  UpdateRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecUpdate(TblHandle, RecHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (Rslt = PXErr_KeyViol);
  UpdateRec := RSlt;
end;

function TPXBase.DeleteRec: word;
var
  RSlt: integer;
begin
  DeleteRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecDelete(TblHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess);
  DeleteRec := RSlt;
end;

function TPXBase.GetRec: word;
var
  RSlt: integer;
begin
  GetRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecGet(TblHandle, RecHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess);
  GetRec := RSlt;
end;

function TPXBase.GotoRec(Rec: RecordNumber): word;
var
  RSlt: integer;
begin
  GotoRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecGoto(TblHandle, Rec));
    if Rslt = PXOpCanceled then exit;
  until RSlt = PXSuccess;
  GotoRec := RSlt;
end;

procedure TPXBase.GetField(FldHandle: FieldHandle;var Rec);
var
  RSlt: integer;
  M, D, Y: integer;
  TheDate: TDate;
  DateStr: string[8];
begin
  case Upcase(PasTypes^[FldHandle][1]) of
    'A': RSlt := PXGetAlpha(RecHandle, FldHandle, string(Rec));
    'N', '$': RSlt := PXGetDoub(RecHandle, FldHandle, double(Rec));
    'D': begin
           RSlt := PXGetDate(RecHandle, FldHandle, TheDate);
           RSlt := PXDateDecode(TheDate, M, D, Y);
           Y := Y - 1900;
           DateStr := SFLongInt(M,2)+'/'+SFLongInt(D,2)+'/'+SFLongInt(Y,2);
           for M := 1 to length(DateStr) do
             if DateStr[M] = ' ' then DateStr[M] := '0';
           string(Rec) := DateStr;
         end;
    'S': RSlt := PXGetShort(RecHandle, FldHandle, integer(Rec));
    'L': RSlt := PXGetLong(RecHandle, FldHandle, Longint(Rec));
  end;
end;

procedure TPXBase.SetField(FldHandle: FieldHandle; var Rec);
var
  RSlt: integer;
  M, D, Y, Code: integer;
  TheDate: TDate;
  DateStr: string[8];
begin
  case Upcase(PasTypes^[FldHandle][1]) of
    'A': RSlt := PXPutAlpha(RecHandle, FldHandle, string(Rec));
    'N', '$': RSlt := PXPutDoub(RecHandle, FldHandle, double(Rec));
    'D': begin
           DateStr := string(Rec);
           val(copy(DateStr, 1, 2), M, Code);
           val(copy(DateStr, 4, 2), D, Code);
           val(Copy(DateStr, 7, 2), Y, Code);
           Y := Y + 1900;
           RSlt := PXDateEncode(M, D, Y, TheDate);
           RSlt := PXPutDate(RecHandle, FldHandle, TheDate);
         end;
    'S': RSlt := PXPutShort(RecHandle, FldHandle, integer(Rec));
    'L': RSlt := PXPutLong(RecHandle, FldHandle, Longint(Rec));
  end;
end;

function TPXBase.InsertRec: word;
var
  RSlt: integer;
begin
  InsertRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecInsert(TblHandle, RecHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (Rslt = PXErr_KeyViol);
  InsertRec := RSlt;
end;

function TPXBase.AppendRec: word;
var
  RSlt: integer;
begin
  AppendRec := PXOpCanceled;
  repeat
    RSlt := PXError(PXRecAppend(TblHandle, RecHandle));
    if RSlt = PXOpCanceled then exit;
  until (RSlt = PXSuccess) or (Rslt = PXErr_KeyViol);
  AppendRec := RSlt;
end;

function TPXBase.GetRecText(Rec: RecordNumber; MaxLen: integer): string;
begin
  Abstract;
end;

end.
