; DATES.SC - Adds date procedures DateToAlpha and
; ConvertDate to DMUtils library.

CREATELIB "DMUtils"

; ***********************************************
; ***********************************************
; DATES (Paradox 4.0) by K. Buchholz

; This procedure asks the user to enter a file name
; on which to perform the operations, then a
; Source Fieldname (containing the Date type of
; date) and a Target Fieldname (into which the 
; date converted to alphanumeric format will be
; placed). The Source Fieldname and the Target
; Fieldname variables must already be present in
; the table named above. The alphanumeric date is
; length 8 and months 1-9 are automatically padded
; with a leading zero (i.e., 01-09).

PROC DateToAlpha()

Filename = ""                                    
FilenameValue = ""                           
FileButtonValue = "No"
SourceFieldnameValue = ""
SourceButtonValue = "No"
TargetFieldnameValue = ""
TargetButtonValue = "No"

; Get Filename
SHOWDIALOG "Indicate Filename"
  @6,15 HEIGHT 10 WIDTH 50
  @2, 8 ?? "Enter filename:"                   
  ACCEPT @2, 25                                 
    WIDTH 15 "A50"                             
    TAG "Fname"                                  
    TO Filename                                   
  PUSHBUTTON @5, 9 WIDTH 10
    "OK"                                        
    OK                                           
    DEFAULT                               
    VALUE "Yes"                           
    TAG "Yes"                                
    TO FileButtonValue                 
  PUSHBUTTON @5, 29 WIDTH 10 
    "Cancel"                                    
    CANCEL                                  
    VALUE "No"                             
    TAG "No"                                  
    TO FileButtonValue                   
ENDDIALOG                              

; Get Source Fieldname
IF FileButtonValue = "Yes" AND
   Filename <> ""          THEN
  SHOWDIALOG "Indicate Source Field"
    @6,15 HEIGHT 10 WIDTH 50
    @2, 8 ?? "Enter fieldname:"                  
    ACCEPT @2, 25                                  
      WIDTH 15 "A50"                             
      TAG "Sname"                                   
      TO SourceFieldnameValue                      
    PUSHBUTTON @5, 9 WIDTH 10               
      "OK"                                          
      OK                                            
      DEFAULT                                 
      VALUE "Yes"                             
      TAG "SourceYes"                       
      TO SourceButtonValue               
    PUSHBUTTON @5, 29 WIDTH 10
      "Cancel"                                      
      CANCEL                                    
      VALUE "No"                               
      TAG "SourceNo"                          
      TO SourceButtonValue                 
  ENDDIALOG   
                             
  IF SourceButtonValue = "Yes"  AND
     SourceFieldnameValue <> "" THEN
     ; Get Target Fieldname
    SHOWDIALOG "Indicate Target Field"
      @6,15 HEIGHT 10 WIDTH 50
      @2, 8 ?? "Enter fieldname:"                
      ACCEPT @2, 25                                
        WIDTH 15 "A50"                           
        TAG "Tname"                                
        TO TargetFieldnameValue             
      PUSHBUTTON @5, 9 WIDTH 10      
        "OK"                                          
        OK                                            
        DEFAULT                                 
        VALUE "Yes"                             
        TAG "TargetYes"                       
        TO TargetButtonValue               
      PUSHBUTTON @5, 29 WIDTH 10
        "Cancel"                                      
        CANCEL                                    
        VALUE "No"                               
        TAG "TargetNo"                          
        TO TargetButtonValue                 
    ENDDIALOG                                
  ELSE
    QUIT
  ENDIF                                             
ELSE
  QUIT
ENDIF                                             

; Main Routine
IF Filename <> ""             AND
   SourceFieldnameValue <> "" AND
   TargetFieldnameValue <> "" THEN
  VIEW Filename                          
  EDIT Filename                           
  SCAN                                       
    EXECUTE "X$ = StrVal([" + SourceFieldnameValue + "])"
    IF LEN(X$) = 7 THEN
      X$ = "0" + X$
    ELSE
      X$ = X$
    ENDIF  
    EXECUTE "[" + TargetFieldnameValue + "] = X$"
  ENDSCAN                                       
ELSE
  QUIT
ENDIF        
ENDPROC
WRITELIB "DMUtils" DateToAlpha

; ***********************************************
; ***********************************************
; ConvertDate (Paradox 4.0) By K. Buchholz

; This procedure creates an alphanumeric field
; in the format of MM/DD/YY from three separate
; alphanumeric fields representing Month, Day and
; Year. IF the year is 4 digits (e.g. 1992), only
; the last 2 digits are taken. The user inputs the
; filename and field names for the Month, Day and
; Year fields, as well as the name of the alpha-
; numeric field to store the composed date in.

PROC ConvertDate()

Filename = ""                                     
FilenameValue = ""
MonthFieldnameValue = ""
DayFieldnameValue = ""
YearFieldnameValue = ""
CDateFieldnameValue = ""
FileButtonValue = "No"                      
MonthButtonValue = "No"
DayButtonValue = "No"
YearButtonValue = "No"
CDateButtonValue = "No"
X = True

; Get Filename
WHILE X
  SHOWDIALOG "Filename to Work On"
    @6,15 HEIGHT 10 WIDTH 50
    @2, 8 ?? "Enter filename:"                  
    ACCEPT @2, 25                                
      WIDTH 15 "A50"                            
      TAG "Fname"                                 
      TO Filename                                  
    PUSHBUTTON @5, 9 WIDTH 10
      "OK"                                         
      OK                                           
      DEFAULT                                
      VALUE "Yes"                            
      TAG "Yes"                                
      TO FileButtonValue                  
    PUSHBUTTON @5, 29 WIDTH 10
      "Cancel"                                     
      CANCEL                                   
      VALUE "No"                              
      TAG "No"                                   
      TO FileButtonValue                    
  ENDDIALOG                                      
  DiskFileName = Filename + ".db"
  FileThere = IsFile(DiskFileName)
  IF FileButtonValue = "Yes" THEN
    IF FileThere = True THEN
      X = False
    ELSE
      X = True
      BEEP BEEP BEEP
    ENDIF
  ELSE
    QUIT
  ENDIF
ENDWHILE

; Get Month Fieldname
IF FileButtonValue = "Yes" AND
   Filename <> ""          THEN 
  SHOWDIALOG "Indicate Month Field"
    @6,15 HEIGHT 10 WIDTH 50
    @2, 8 ?? "Enter Fieldname:"                
    ACCEPT @2, 25                                 
      WIDTH 15 "A50"                             
      TAG "Mname"                                 
      TO MonthFieldnameValue              
    PUSHBUTTON @5, 9 WIDTH 10       
      "OK"                                        
      OK                                          
      DEFAULT                               
      VALUE "Yes"                           
      TAG "MonthYes"                     
      TO MonthButtonValue             
    PUSHBUTTON @5, 29 WIDTH 10
      "Cancel"                                     
      CANCEL                                   
      VALUE "No"                              
      TAG "MonthNo"                         
      TO MonthButtonValue                
  ENDDIALOG                               

  ; Get Day Fieldname
  IF MonthButtonValue = "Yes"  AND
     MonthFieldnameValue <> "" THEN
    SHOWDIALOG "Indicate Day Fieldname"
      @6,15 HEIGHT 10 WIDTH 50
      @2, 8 ?? "Enter Fieldname:"                 
      ACCEPT @2, 25                                  
        WIDTH 15 "A50"                              
        TAG "Dname"                                  
        TO DayFieldnameValue                   
      PUSHBUTTON @5, 9 WIDTH 10 
        "OK"                                         
        OK                                            
        DEFAULT                                
        VALUE "Yes"                            
        TAG "DayYes"                           
        TO DayButtonValue                  
      PUSHBUTTON @5, 29 WIDTH 10
        "Cancel"                                     
        CANCEL                                      
        VALUE "No"                                 
        TAG "DayNo"                               
        TO DayButtonValue                      
    ENDDIALOG                                  

    ; Get Year Fieldname
    IF DayButtonValue = "Yes"  AND
       DayFieldnameValue <> "" THEN 
      SHOWDIALOG "Indicate Year Fieldname"
        @6,15 HEIGHT 10 WIDTH 50
        @2, 8 ?? "Enter Fieldname:"                 
        ACCEPT @2, 25                                  
          WIDTH 15 "A50"                              
          TAG "Yname"                                  
          TO YearFieldnameValue                  
        PUSHBUTTON @5, 9 WIDTH 10     
          "OK"                                         
          OK                                           
          DEFAULT                                
          VALUE "Yes"                            
          TAG "YearYes"                         
          TO YearButtonValue                
        PUSHBUTTON @5, 29 WIDTH 10
          "Cancel"                                     
          CANCEL                                   
          VALUE "No"                              
          TAG "YearNo"                            
          TO YearButtonValue                  
      ENDDIALOG                               

      ; Get Calculated Date Fieldname
      IF YearButtonValue = "Yes"  AND
         YearFieldnameValue <> "" THEN
        SHOWDIALOG "Indicate alphanumeric field"
          @6,15 HEIGHT 10 WIDTH 50
          @2, 8 ?? "Enter Fieldname:"               
          ACCEPT @2, 25                                
            WIDTH 15 "A50"                            
            TAG "CDname"                              
            TO CDateFieldnameValue              
          PUSHBUTTON @5, 9 WIDTH 10
            "OK"                                        
            OK                                           
            DEFAULT                               
            VALUE "Yes"                           
            TAG "CDateYes"                      
            TO CDateButtonValue             
          PUSHBUTTON @5, 29 WIDTH 10 
            "Cancel"                                      
            CANCEL                                    
            VALUE "No"                               
            TAG "CDateNo"                          
            TO CDateButtonValue                 
        ENDDIALOG                                
      ELSE
        QUIT
      ENDIF                                       
    ELSE
      QUIT
    ENDIF                                       
  ELSE
    QUIT
  ENDIF                                       
ELSE
  QUIT
ENDIF                                       

; Main Routine
IF Filename <> ""            AND
   MonthFieldnameValue <> "" AND
   DayFieldnameValue <> ""   AND
   YearFieldnameValue <> ""  AND
   CDateFieldnameValue <> "" THEN
  VIEW Filename                                    
  EDIT Filename                                     
  SCAN                                                 
    EXECUTE "D = [" + DayFieldnameValue + "]"        
    EXECUTE "M = [" + MonthFieldnameValue + "]"    
    EXECUTE "Y = [" + YearFieldnameValue + "]"       
    IF M = "MM" OR
       M = "M " OR
       M = " M" OR
       M = "mm" OR
       M = "m " OR
       M = " m" THEN 
      Mo = "MM"
    ELSE
      IF LEN(M) = 1 THEN                      
        Mo = "0" + M                             
      ELSE
        IF LEN(m) = 2 THEN
          Mo = M                             
        ELSE
          Mo = "??"                    
        ENDIF
      ENDIF        
    ENDIF
    IF D = "MM" OR
       D = "M " OR
       D = " M" OR
       D = "mm" OR
       D = "m " OR
       D = " m" THEN 
      Da = "MM"
    ELSE
      IF len(D) = 1 THEN                    
        Da = "0" + D                            
      ELSE
        IF len(D) = 2 THEN            
          Da = D                            
        ELSE Da = "??"                  
        ENDIF
      ENDIF
    ENDIF
    IF Y = "MM" OR
       Y = "M " OR
       Y = " M" OR
       Y = "mm" OR
       Y = "m " OR
       Y = " m" THEN 
      Yr = "MM"
    ELSE
      IF len(Y) = 4 THEN                     
        Yr = SUBSTR(Y,3,2)                
      ELSE
        IF len(Y) = 2 THEN             
          Yr = Y                             
        ELSE Yr = "??"                   
        ENDIF
      ENDIF
    ENDIF
    AlphaDate = Mo + "/" + Da + "/" + Yr                    
    EXECUTE "[" + CDateFieldnameValue + "] = AlphaDate"
  ENDSCAN                                                   
ELSE
  QUIT
ENDIF                                                         

ENDPROC
WRITELIB "DMUtils" ConvertDate
; DATES.SC - Adds date procedures DateToAlpha and
; ConvertDate to DMUtils library.

CREATELIB "DMUtils"

; ***********************************************
; ***********************************************
; DATES (Paradox 4.0) by K. Buchholz

; This procedure asks the user to enter a file name
; on which to perform the operations, then a
; Source Fieldname (containing the Date type of
; date) and a Target Fieldname (into which the 
; date converted to alphanumeric format will be
; placed). The Source Fieldname and the Target
; Fieldname variables must already be present in
; the table named above. The alphanumeric date is
; length 8 and months 1-9 are automatically padded
; with a leading zero (i.e., 01-09).

PROC DateToAlpha()

Filename = ""                                    
FilenameValue = ""                           
FileButtonValue = "No"
SourceFieldnameValue = ""
SourceButtonValue = "No"
TargetFieldnameValue = ""
TargetButtonValue = "No"

; Get Filename
SHOWDIALOG "Indicate Filename"
  @6,15 HEIGHT 10 WIDTH 50
  @2, 8 ?? "Enter filename:"                   
  ACCEPT @2, 25                                 
    WIDTH 15 "A50"                             
    TAG "Fname"                                  
    TO Filename                                   
  PUSHBUTTON @5, 9 WIDTH 10
    "OK"                                        
    OK                                           
    DEFAULT                               
    VALUE "Yes"                           
    TAG "Yes"                                
    TO FileButtonValue                 
  PUSHBUTTON @5, 29 WIDTH 10 
    "Cancel"                                    
    CANCEL                                  
    VALUE "No"                             
    TAG "No"                                  
    TO FileButtonValue                   
ENDDIALOG                              

; Get Source Fieldname
IF FileButtonValue = "Yes" AND
   Filename <> ""          THEN
  SHOWDIALOG "Indicate Source Field"
    @6,15 HEIGHT 10 WIDTH 50
    @2, 8 ?? "Enter fieldname:"                  
    ACCEPT @2, 25                                  
      WIDTH 15 "A50"                             
      TAG "Sname"                                   
      TO SourceFieldnameValue                      
    PUSHBUTTON @5, 9 WIDTH 10               
      "OK"                                          
      OK                                            
      DEFAULT                                 
      VALUE "Yes"                             
      TAG "SourceYes"                       
      TO SourceButtonValue               
    PUSHBUTTON @5, 29 WIDTH 10
      "Cancel"                                      
      CANCEL                                    
      VALUE "No"                               
      TAG "SourceNo"                          
      TO SourceButtonValue                 
  ENDDIALOG   
                             
  IF SourceButtonValue = "Yes"  AND
     SourceFieldnameValue <> "" THEN
     ; Get Target Fieldname
    SHOWDIALOG "Indicate Target Field"
      @6,15 HEIGHT 10 WIDTH 50
      @2, 8 ?? "Enter fieldname:"                
      ACCEPT @2, 25                                
        WIDTH 15 "A50"                           
        TAG "Tname"                                
        TO TargetFieldnameValue             
      PUSHBUTTON @5, 9 WIDTH 10      
        "OK"                                          
        OK                                            
        DEFAULT                                 
        VALUE "Yes"                             
        TAG "TargetYes"                       
        TO TargetButtonValue               
      PUSHBUTTON @5, 29 WIDTH 10
        "Cancel"                                      
        CANCEL                                    
        VALUE "No"                               
        TAG "TargetNo"                          
        TO TargetButtonValue                 
    ENDDIALOG                                
  ELSE
    QUIT
  ENDIF                                             
ELSE
  QUIT
ENDIF                                             

; Main Routine
IF Filename <> ""             AND
   SourceFieldnameValue <> "" AND
   TargetFieldnameValue <> "" THEN
  VIEW Filename                          
  EDIT Filename                           
  SCAN                                       
    EXECUTE "X$ = StrVal([" + SourceFieldnameValue + "])"
    IF LEN(X$) = 7 THEN
      X$ = "0" + X$
    ELSE
      X$ = X$
    ENDIF  
    EXECUTE "[" + TargetFieldnameValue + "] = X$"
  ENDSCAN                                       
ELSE
  QUIT
ENDIF        
ENDPROC
WRITELIB "DMUtils" DateToAlpha

; ***********************************************
; ***********************************************
; ConvertDate (Paradox 4.0) By K. Buchholz

; This procedure creates an alphanumeric field
; in the format of MM/DD/YY from three separate
; alphanumeric fields representing Month, Day and
; Year. IF the year is 4 digits (e.g. 1992), only
; the last 2 digits are taken. The user inputs the
; filename and field names for the Month, Day and
; Year fields, as well as the name of the alpha-
; numeric field to store the composed date in.

PROC ConvertDate()

Filename = ""                                     
FilenameValue = ""
MonthFieldnameValue = ""
DayFieldnameValue = ""
YearFieldnameValue = ""
CDateFieldnameValue = ""
FileButtonValue = "No"                      
MonthButtonValue = "No"
DayButtonValue = "No"
YearButtonValue = "No"
CDateButtonValue = "No"
X = True

; Get Filename
WHILE X
  SHOWDIALOG "Filename to Work On"
    @6,15 HEIGHT 10 WIDTH 50
    @2, 8 ?? "Enter filename:"                  
    ACCEPT @2, 25                                
      WIDTH 15 "A50"                            
      TAG "Fname"                                 
      TO Filename                                  
    PUSHBUTTON @5, 9 WIDTH 10
      "OK"                                         
      OK                                           
      DEFAULT                                
      VALUE "Yes"                            
      TAG "Yes"                                
      TO FileButtonValue                  
    PUSHBUTTON @5, 29 WIDTH 10
      "Cancel"                                     
      CANCEL                                   
      VALUE "No"                              
      TAG "No"                                   
      TO FileButtonValue                    
  ENDDIALOG                                      
  DiskFileName = Filename + ".db"
  FileThere = IsFile(DiskFileName)
  IF FileButtonValue = "Yes" THEN
    IF FileThere = True THEN
      X = False
    ELSE
      X = True
      BEEP BEEP BEEP
    ENDIF
  ELSE
    QUIT
  ENDIF
ENDWHILE

; Get Month Fieldname
IF FileButtonValue = "Yes" AND
   Filename <> ""          THEN 
  SHOWDIALOG "Indicate Month Field"
    @6,15 HEIGHT 10 WIDTH 50
    @2, 8 ?? "Enter Fieldname:"                
    ACCEPT @2, 25                                 
      WIDTH 15 "A50"                             
      TAG "Mname"                                 
      TO MonthFieldnameValue              
    PUSHBUTTON @5, 9 WIDTH 10       
      "OK"                                        
      OK                                          
      DEFAULT                               
      VALUE "Yes"                           
      TAG "MonthYes"                     
      TO MonthButtonValue             
    PUSHBUTTON @5, 29 WIDTH 10
      "Cancel"                                     
      CANCEL                                   
      VALUE "No"                              
      TAG "MonthNo"                         
      TO MonthButtonValue                
  ENDDIALOG                               

  ; Get Day Fieldname
  IF MonthButtonValue = "Yes"  AND
     MonthFieldnameValue <> "" THEN
    SHOWDIALOG "Indicate Day Fieldname"
      @6,15 HEIGHT 10 WIDTH 50
      @2, 8 ?? "Enter Fieldname:"                 
      ACCEPT @2, 25                                  
        WIDTH 15 "A50"                              
        TAG "Dname"                                  
        TO DayFieldnameValue                   
      PUSHBUTTON @5, 9 WIDTH 10 
        "OK"                                         
        OK                                            
        DEFAULT                                
        VALUE "Yes"                            
        TAG "DayYes"                           
        TO DayButtonValue                  
      PUSHBUTTON @5, 29 WIDTH 10
        "Cancel"                                     
        CANCEL                                      
        VALUE "No"                                 
        TAG "DayNo"                               
        TO DayButtonValue                      
    ENDDIALOG                                  

    ; Get Year Fieldname
    IF DayButtonValue = "Yes"  AND
       DayFieldnameValue <> "" THEN 
      SHOWDIALOG "Indicate Year Fieldname"
        @6,15 HEIGHT 10 WIDTH 50
        @2, 8 ?? "Enter Fieldname:"                 
        ACCEPT @2, 25                                  
          WIDTH 15 "A50"                              
          TAG "Yname"                                  
          TO YearFieldnameValue                  
        PUSHBUTTON @5, 9 WIDTH 10     
          "OK"                                         
          OK                                           
          DEFAULT                                
          VALUE "Yes"                            
          TAG "YearYes"                         
          TO YearButtonValue                
        PUSHBUTTON @5, 29 WIDTH 10
          "Cancel"                                     
          CANCEL                                   
          VALUE "No"                              
          TAG "YearNo"                            
          TO YearButtonValue                  
      ENDDIALOG                               

      ; Get Calculated Date Fieldname
      IF YearButtonValue = "Yes"  AND
         YearFieldnameValue <> "" THEN
        SHOWDIALOG "Indicate alphanumeric field"
          @6,15 HEIGHT 10 WIDTH 50
          @2, 8 ?? "Enter Fieldname:"               
          ACCEPT @2, 25                                
            WIDTH 15 "A50"                            
            TAG "CDname"                              
            TO CDateFieldnameValue              
          PUSHBUTTON @5, 9 WIDTH 10
            "OK"                                        
            OK                                           
            DEFAULT                               
            VALUE "Yes"                           
            TAG "CDateYes"                      
            TO CDateButtonValue             
          PUSHBUTTON @5, 29 WIDTH 10 
            "Cancel"                                      
            CANCEL                                    
            VALUE "No"                               
            TAG "CDateNo"                          
            TO CDateButtonValue                 
        ENDDIALOG                                
      ELSE
        QUIT
      ENDIF                                       
    ELSE
      QUIT
    ENDIF                                       
  ELSE
    QUIT
  ENDIF                                       
ELSE
  QUIT
ENDIF                                       

; Main Routine
IF Filename <> ""            AND
   MonthFieldnameValue <> "" AND
   DayFieldnameValue <> ""   AND
   YearFieldnameValue <> ""  AND
   CDateFieldnameValue <> "" THEN
  VIEW Filename                                    
  EDIT Filename                                     
  SCAN                                                 
    EXECUTE "D = [" + DayFieldnameValue + "]"        
    EXECUTE "M = [" + MonthFieldnameValue + "]"    
    EXECUTE "Y = [" + YearFieldnameValue + "]"       
    IF M = "MM" OR
       M = "M " OR
       M = " M" OR
       M = "mm" OR
       M = "m " OR
       M = " m" THEN 
      Mo = "MM"
    ELSE
      IF LEN(M) = 1 THEN                      
        Mo = "0" + M                             
      ELSE
        IF LEN(m) = 2 THEN
          Mo = M                             
        ELSE
          Mo = "??"                    
        ENDIF
      ENDIF        
    ENDIF
    IF D = "MM" OR
       D = "M " OR
       D = " M" OR
       D = "mm" OR
       D = "m " OR
       D = " m" THEN 
      Da = "MM"
    ELSE
      IF len(D) = 1 THEN                    
        Da = "0" + D                            
      ELSE
        IF len(D) = 2 THEN            
          Da = D                            
        ELSE Da = "??"                  
        ENDIF
      ENDIF
    ENDIF
    IF Y = "MM" OR
       Y = "M " OR
       Y = " M" OR
       Y = "mm" OR
       Y = "m " OR
       Y = " m" THEN 
      Yr = "MM"
    ELSE
      IF len(Y) = 4 THEN                     
        Yr = SUBSTR(Y,3,2)                
      ELSE
        IF len(Y) = 2 THEN             
          Yr = Y                             
        ELSE Yr = "??"                   
        ENDIF
      ENDIF
    ENDIF
    AlphaDate = Mo + "/" + Da + "/" + Yr                    
    EXECUTE "[" + CDateFieldnameValue + "] = AlphaDate"
  ENDSCAN                                                   
ELSE
  QUIT
ENDIF                                                         

ENDPROC
WRITELIB "DMUtils" ConvertDate

