;This file is copyright (c) 1992, Informant Communications Group and the 
;article author. The material here may be used in an application provided 
;that this copyright/disclaimer information is kept in the original source 
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assumes no responsibility 
;for the use or misuse of the material contained within.  
; 
;Contents        : Source file PDMEN.SC 
;Author          : David Berg - CompuMethods Company
;                               Huntington Beach, CA
;Informant Issue : August 1992
;Description     : Pull-Down menus and event handling demo
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;-----------------------------------------------------------------------------

Proc WaitProc(Trigger_a,Event_y,Cycle_n)
  If Trigger_a = "EVENT" Then
    Switch
    Case Event_Y["TYPE"] = "KEY":
      Switch
      Case Event_Y["KEYCODE"] = ASC("F2"):
        If NImages() = 0 Then
          DoMenuItem("EXIT")
        Else Beep
          Message "Close tables before exiting"
        EndIf
      Case Event_Y["KEYCODE"] = ASC("F7"):
        FormKey
        Return 1 ; No More Processing
      Case Event_Y["KEYCODE"] = ASC("F8"):
        If NImages() > 0 Then
          DoMenuItem("CLOSE")
        Else Beep
          Message "Nothing to Close"
        EndIf
      Otherwise:  Beep  ; Bad Key
        Return 1 ; No More Processing
      EndSwitch
    Case Event_Y["TYPE"] = "MESSAGE":
      If Event_Y["MESSAGE"] = "MENUSELECT" Then
        DoMenuItem(Event_Y["MenuTag"])
        If NImages()=0 Then Return 2 ; Exit Wait
        EndIf
      EndIf
    EndSwitch
  EndIf
  Return 0 ; Normal Processing
EndProc

Proc DoMenuItem(tag_a)
  Private Table_a
  Switch
    Case tag_a = "View All":
      View "Client"                 ; Build Workspace
      View "Prospect"
      View "Orders"
      MenuDisable "View Client"     ; Disable Menu Items
      MenuDisable "View Prospect"
      MenuDisable "View Orders"
      MenuDisable "View All"        ; Disable ALL
      MenuDisable "View-Menu"       ; Disable the Menu
    Case Match(tag_a,"View ..",table_a)
      View Table_a
      MenuDisable table_a           ; Disable Re-Viewing it
      MenuDisable "View All"        ; Disable ALL
    Case tag_a = "Close":
      MenuEnable "View "+Table()    ; Re-Enable Viewing it
      MenuEnable "View-Menu"        ; View Menu Enabled?
      ClearImage                    ; Get rid of it
    Case tag_a = "Exit":
      Working = False               ; Terminate
  EndSwitch
EndProc

ShowPulldown
  "View":"Select a Table to View": "View-Menu" SUBMENU
    "All":  "View All Tables":       "View All",
    SEPARATOR,
    "Client":  "View Client Table":  "View Client",
    "Prospect":"View Prospect Table":"View Prospect",
    "Orders":  "View Orders Table":  "View Oders"
    ENDSUBMENU,
  "Close":"Close current table":"Close-Menu" SUBMENU
    "Yes":"Really Close":"Close",
    "No": "Forget it"   :"",
    ENDSUBMENU,
  "Exit":"Exit system":"Exit-Menu" SUBMENU
    "Yes":"Really Exit":"Exit",
    "No": "Forget it"   :"",
    ENDSUBMENU
ENDMENU

Working = True
While Working
  If NImages() = 0 Then   ; No Images - Force Menu!
    MENUDISABLE "Close-Menu"  ; Invalid Menu
    MENUENABLE  "Exit-Menu"  ; Now a Valid Menu
    GETMENUSELECTION TO tag_a
    DoMenuItem(tag_a)
  Else
    MENUDISABLE "Exit-Menu"  ; Invalid Menu
    MENUENABLE  "Close-Menu"  ; Now a Valid Menu
    Wait Workspace Proc WaitProc
      Key "F2","F7","F8","DOS","DOSBIG"
      Message "CLOSE","MENUSELECT"
    EndWait
  EndIf
EndWhile

ClearPullDown

