If (Not IsFile("Example.Lib")) Then
   CreateLib "Example"
EndIf
;---------------------------------------------------------------------

Proc CoEditTable(SourceTbl, Frm)

  CoEdit SourceTbl                               ;CoEdit the table.

  PickForm Frm

  Prmpt1 = "[F2] - Complete CoEdit, "            ;Prompt the user.
         + "[Esc] - Cancel CoEdit"

  While (TRUE)
        Wait Table                               ;Allow user to work
             Prompt Prmpt1                       ;on the table until
             Until  "F2", "Esc", "F3", "F4",     ;one of our keys is
                    "F20"                        ;pressed.

        Switch                                   ;find out which key
                                                 ;was pressed.

          Case RetVal = "F2":                    ;[F2] Do_It!
               Do_It!
               ClearAll
               Clear
               QuitLoop

;     =================================================================

          Case RetVal = "Esc":                   ;[Esc]
                                                 ;Confirm before cancel.
               ShowMenu "No": "Do not cancel the CoEdit session.",
                        "Yes": "Cancel the CoEdit session."
                     To Ans
               If (Ans = "Yes") Then             ;If confirmed, Cancel.
                  Message "Cancelling CoEdit"
                  Sleep 300
                  UnDo
                  Do_It!
                  ClearAll
                  Clear
                  QuitLoop
               EndIf

;     =================================================================

          Case RetVal = "F3":                    ;[F3] UpImage.
               If (IsMultiForm() and IsFormView()) Then
                  UpImage
               Else
                  Beep
               EndIf

;     =================================================================

          Case RetVal = "F4":                    ;[F4] DownImage.
               If (IsMultiForm() and IsFormView()) Then
                  DownImage
               Else
                  Beep
               EndIf

;     =================================================================

          Case RetVal = "F20":                   ;[Shift][F10]
               ReadLib "Palpable" P_SaveInFo,    ;Load the Save
                                  P_RestoreInFo  ;and Restore Procs.
               P_SaveInFo()                      ;Save the workspace.

               ;At this point we will perform the special routines.
               ;For an example, I will to a VIEW on a table called
               ;Palpable.

               View "Palpable"
               PickForm "F"
               Prmpt1 = "Press [F2] when finished viewing"
               Wait Table
                    Prompt Prmpt1
                    Until "F2"
               ClearAll
               Clear

               P_RestoreInFo()                   ;Restore the workspace.
               Prmpt1 = "[F2] - Complete CoEdit, "
                      + "[Esc] - Cancel CoEdit"
               Release Procs P_SaveInFo, P_RestoreInFo

        Endswitch
  EndWhile

EndProc

WriteLib "Example" CoEditTable
Release Procs CoEditTable

