PROC Pack()
;      AUTHOR:  Brian McKinley
;        DATE:  1/26/93
;
; The purpose of this program is to compress each table in the current
; directory and its subdirectories which has over 33% unused space.  Since
; calculating the unused space (Pack Ratio) cannot be done in PAL, I have
; written a C++ program to assist us.  Compressing the table we will leave 
; to Paradox's restructure capabilities.

   ; Clear all table buffers.  Pack is not network aware.
   Message "Working"
   RESET
   SETDIR DIRECTORY()
   ; Lock the Pack table.  This can be done (and needs to be done here)
   ; because Pack does not lock the table before creating it.  As you will
   ; see it does not care if a lock has been placed either.
   LOCK "PACK" FL
   IF RETVAL THEN
      ; Run the pack program to create the pack table.  This table will
      ; contain the full path (minus the drive letter) of every table in 
      ; the current directory and its subdirectories.
      RUN NOREFRESH gDirBin + "PACK"
      MENU {Ask} SELECT "PACK"
      CHECKPLUS
      [PACK RATIO] = "NOT 0, < 67" ; More than 33% unused space.  0 occurs 
                                   ; when there is 1 block with no records.
      Do_it!
      
      IF NOT ISEMPTY("ANSWER") THEN
         SCAN
            Message "Compressing " + [TABLE PATH] 
            {Modify} {Restructure}
            SELECT [TABLE PATH]
            DO_IT!
            ClearImage
            MOVETO "ANSWER"
         ENDSCAN
      ELSE
         Message "Tables are already compressed"  
      ENDIF
      
      UNLOCK "PACK" FL
   ELSE
      Message "Error: Unable to lock PACK.DB"
   ENDIF
   
ENDPROC
