; msgprocs.sc
; A collection of dialog boxes for displaying common messages,
; reminiscent of PFW style.
; Written by Ann Lynnworth, submitted to compuserve 7/27/94
; Permission is granted to copy and improve this code.


PROC BOX.SHADOW( TOP.ROW, FIRST.COL, NUM.ROWS, NUM.COLS )
; TOP.ROW   --> top row coordinate
; FIRST.COL --> first column coordinate
; NUM.ROWS  --> number of rows in box
; NUM.COLS  --> number of columns in box
; retval    --> N/A

  Private tb_cs

  tb_cs = 48

  If Monitor() = "Color" Then
    PAINTCANVAS FILL CHR( 220 ) ATTRIBUTE tb_cs TOP.ROW,FIRST.COL + NUM.COLS,  ;
U
                              TOP.ROW,FIRST.COL + NUM.COLS
  Endif
  PAINTCANVAS FILL CHR( 219 ) ATTRIBUTE tb_cs TOP.ROW+1,FIRST.COL + NUM.COLS, ;
U
                            TOP.ROW + NUM.ROWS-1,FIRST.COL + NUM.COLS
  PAINTCANVAS FILL CHR( 223 ) ATTRIBUTE tb_cs TOP.ROW+NUM.ROWS, FIRST.COL+1,
;s
                            TOP.ROW + NUM.ROWS,FIRST.COL + NUM.COLS
ENDPROC
Writelib Applib BOX.SHADOW
Release Procs BOX.SHADOW

PROC msgGo( S )
; Extended PAL
; Displays large message without stopping
; retval --> N/A

;= Derived from the message commands in Paradox for Windows,
;= msgGo and msgStop provide messages to the user.
;=
;= This one provides a message in a blue box and does not pause.
;=

  Private theColor

  theColor = 31  ; white on blue

  Frame Double From 4,6 to 10, 73
  @7,7 ?? Format( "W66,AC", S )
  PaintCanvas Attribute theColor 4,6,10,73

  BOX.SHADOW( 4, 6, 7, (73-6)+1 )

ENDPROC
Writelib AppLib msgGo
Release Procs msgGo

PROC msgInfo( S )
; Extended PAL
; DBox with blue FYI message
; S --> text string to display to the user
; retval --> N/A

;= Derived from the message commands in Paradox for Windows,
;= ~msgGo~, msgInfo and ~msgStop~ provide messages to the user.
;=
;= This one provides a gentle FYI message in a light blue box.
;= It does pause for the user to press Enter.
;=
;= See also: ~msgProgrammerError~

  Private ButtonValue, paintPAL.originalPalette, paintPAL.colorDeviations

  ; PaintPAL_Generated_Code_Begin(474442034)

  ; PaintPAL_Color_Setup_Begin
  GETCOLORS TO PaintPAL.OriginalPalette
  DYNARRAY PaintPAL.ColorDeviations[]
  PaintPAL.ColorDeviations[1031] =  48  ;Border Inactive
  PaintPAL.ColorDeviations[1032] =  49  ;Border Active
  PaintPAL.ColorDeviations[1033] =  58  ;Border Dragging/Icons
  PaintPAL.ColorDeviations[1036] =  63  ;Background Text
  PaintPAL.ColorDeviations[1037] =  48  ;Label Inactive
  PaintPAL.ColorDeviations[1038] =  63  ;Label Selected
  PaintPAL.ColorDeviations[1039] =  62  ;Label Shortcut
  PaintPAL.ColorDeviations[1040] =  27  ;Pushbutton Normal
  PaintPAL.ColorDeviations[1041] =  27  ;Pushbutton Default
  PaintPAL.ColorDeviations[1042] =  31  ;Pushbutton Selected
  PaintPAL.ColorDeviations[1044] =  30  ;Pushbutton Shortcut
  PaintPAL.ColorDeviations[1045] =  48  ;Pushbutton Shadow
  SETCOLORS FROM PaintPAL.ColorDeviations
  ; PaintPAL_Color_Setup_End

  ShowDialog "For Your Information"  ;
E:\CLIENTS\DATA\HBIPDOX\ADDRESS\DLG\MSGINFO.DLG
     @9,15 Height 13 Width 62

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 63 1,2,7,45
     @1,2
     ?? S
     PaintCanvas Attribute 63 1,2,7,45
     ; PaintPAL_Static_Text_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 49 9,2,10,48
     @9,2
     ?? "This application will resume as soon as you"
     @10,2
     ?? "press Enter."
     PaintCanvas Attribute 49 9,2,10,48
     ; PaintPAL_Static_Text_End

     PushButton @9,49 Width 10
        "~O~k"
        Ok
        Default
        Value ""
        Tag ""
        To ButtonValue
  EndDialog

  ; PaintPAL_Color_Cleanup_Begin
  SETCOLORS FROM PaintPAL.OriginalPalette
  ; PaintPAL_Color_Cleanup_End

  ; PaintPAL_Generated_Code_End(474442034)

ENDPROC
Writelib AppLib msgInfo
Release Procs msgInfo

PROC msgProgrammerError( PROBLEM.MSG )
; Extended PAL
; DBox with purple message; please report
; PROBLEM.MSG --> text to display to the user
; retval --> N/A

  Private ButtonValue, paintPAL.originalPalette, paintPAL.colorDeviations

  ; PaintPAL_Generated_Code_Begin(474194314)

  ; PaintPAL_Color_Setup_Begin
  GETCOLORS TO PaintPAL.OriginalPalette
  DYNARRAY PaintPAL.ColorDeviations[]
  PaintPAL.ColorDeviations[1031] =  80  ;Border Inactive
  PaintPAL.ColorDeviations[1032] =  81  ;Border Active
  PaintPAL.ColorDeviations[1033] =  90  ;Border Dragging/Icons
  PaintPAL.ColorDeviations[1036] =  95  ;Background Text
  PaintPAL.ColorDeviations[1037] =  80  ;Label Inactive
  PaintPAL.ColorDeviations[1038] =  95  ;Label Selected
  PaintPAL.ColorDeviations[1039] =  94  ;Label Shortcut
  PaintPAL.ColorDeviations[1040] =  27  ;Pushbutton Normal
  PaintPAL.ColorDeviations[1041] =  27  ;Pushbutton Default
  PaintPAL.ColorDeviations[1042] =  31  ;Pushbutton Selected
  PaintPAL.ColorDeviations[1044] =  30  ;Pushbutton Shortcut
  PaintPAL.ColorDeviations[1045] =  80  ;Pushbutton Shadow
  SETCOLORS FROM PaintPAL.ColorDeviations
  ; PaintPAL_Color_Setup_End

  ShowDialog "Programmer Error"  ; E:\RIS\DLG\PROGERR.DLG
     @9,15 Height 13 Width 62

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 95 1,2,7,45
     @1,2
     ?? problem.msg
     PaintCanvas Attribute 95 1,2,7,45
     ; PaintPAL_Static_Text_End

     ; PaintPAL_Static_Text_Begin
     PaintCanvas Fill " " Attribute 87 9,2,10,48
     @9,2
     ?? "If you want to have this problem fixed, you"
     @10,2
     ?? "must report it to your Paradox Support Person."
     PaintCanvas Attribute 87 9,2,10,48
     ; PaintPAL_Static_Text_End

     PushButton @9,49 Width 10
        "~O~k"
        Ok
        Default
        Value ""
        Tag ""
        To ButtonValue
  EndDialog

  ; PaintPAL_Color_Cleanup_Begin
  SETCOLORS FROM PaintPAL.OriginalPalette
  ; PaintPAL_Color_Cleanup_End

  ; PaintPAL_Generated_Code_End(474194314)
ENDPROC
Writelib AppLib msgProgrammerError
Release Procs msgProgrammerError

PROC msgStop( S )
; Extended PAL
; Dialog box with large red message
; retval --> N/A

  Private ButtonValue, oldColors, newColors, theColor, buttonTextColor,
          shadowColor

;= Derived from the message commands in Paradox for Windows,
;= msgGo and msgStop provide messages to the user.
;=
;= msgStop displays a message in a red dialog box, and the user must
;= press Enter or click the OK button before the program will resume
;= processing.
;=

  getColors to oldColors
  theColor = 79          ; white on red
  shadowColor = 64       ; black on red
  buttonTextColor = 116  ; red on light grey

  DynArray newColors[]
  newColors[1032] = theColor
  newColors[1042] = buttonTextColor
  newColors[1045] = shadowColor

  setColors from newColors

  ; PaintPAL_Generated_Code_Begin(446472632)

  SHOWDIALOG ""
     @3,2 HEIGHT 8 WIDTH 76

     ; PaintPAL_Static_Text_Begin
     PAINTCANVAS FILL " " ATTRIBUTE 112 1,1,1,46
     @1,1
     ?? IIF( Len(S) < 72, Format( "W72,AC", S ), S )
     PAINTCANVAS ATTRIBUTE 112 1,1,1,46
     ; PaintPAL_Static_Text_End

     PAINTCANVAS ATTRIBUTE 79 0,0,5,73

     PUSHBUTTON @4,32 WIDTH 10
        "Ok"
        OK
        DEFAULT
        VALUE ""
        TAG ""
        TO ButtonValue
  ENDDIALOG

  ; PaintPAL_Generated_Code_End(446472632)

  setColors from oldColors

ENDPROC
Writelib AppLib msgStop
Release Procs msgStop
