;This file is copyright (c) 1991, 1992 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure ParseHeader(),
;                            MemoTrim()

;Source File     : MATCH.SC
;Author          : Richard C Haven
;                  Borland International
;
;Informant Issue : November 1992
;
;Description     : Using MATCH for stripping CompuServe mail
;
;
; Paradox Informant
; 10519 E. Stockton Blvd.
; Suite 142
; Elk Grove, CA  95624-9743
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740

PROC ParseHeader(header.dy)
    PRIVATE  line,counter,part1,part2,char,prevposition.dy
;   ENTRY    Pointed at first line of header
;   EXIT     Pointed after header
;   RETURNS  TRUE if legal header

EDITOR INFO TO prevposition.dy		;;	get starting position
counter = 0

		;;	we expect to get all these data elements
WHILE ((NOT IsAssigned(header.dy["TONAME"]))   OR
       (NOT IsAssigned(header.dy["TOID"]))     OR
       (NOT IsAssigned(header.dy["FROMNAME"])) OR
       (NOT IsAssigned(header.dy["FROMID"]))   OR
       (NOT IsAssigned(header.dy["SUBJECT"]))  OR
       (NOT IsAssigned(header.dy["DATE"]))     OR
       (NOT IsAssigned(header.dy["TIME"]))     OR
       (NOT IsAssigned(header.dy["MESSAGE_ID"]))  OR
       (NOT IsAssigned(header.dy["SECTION"]))    )    AND
        (counter < 7)
    line = GetCursorLine()		;;	this function will extract the next
line
    counter = counter + 1
    SWITCH
					;;	look for this pattern	"#: 12345 S12/Frog
United"
	CASE MATCH(line,"#: .. S../..",header.dy["MESSAGE_ID"],retval,
							header.dy["SECTION"]):
		header.dy["MESSAGE_ID"] = FORMAT("W6,AR",header.dy["MESSAGE_ID"])

	CASE MATCH(line,"    ..  ..",header.dy["DATE"],header.dy["TIME"]):
		IF DATEVAL(header.dy["DATE"]) <> "Error" THEN
			header.dy["DATE"] = DATEVAL(header.dy["DATE"])
		ELSE
			header.dy["DATE"] = BLANKDATE()
		ENDIF

;;				here we are looking for text like:
;;					Sb: 12345-Frogs or Sb: #12345-Frogs or Sb:
#12345 Frogs
	CASE MATCH(line,"Sb: ..-..",header.dy["REFERENCE"],
						header.dy["SUBJECT"]) OR
		MATCH(line,"Sb: .. ..",header.dy["REFERENCE"],
						header.dy["SUBJECT"]):
;;					strip leading "#" in subject if present
		retval =
MATCH(header.dy["REFERENCE"],"#..",header.dy["REFERENCE"])
		retval = NUMVAL(header.dy["REFERENCE"])
;;				does the reference refer to a reasonable message id?
		IF (retval = "Error") OR (retval <> INT(retval)) OR
				(IsAssigned(header.dy["MESSAGE_ID"]) AND
				(NUMVAL(header.dy["MESSAGE_ID"]) <> "Error") AND
				(NUMVAL(header.dy["MESSAGE_ID"]) <= retval)) THEN
;;					if it isn't a reference, format it back the way
it was
			header.dy["REFERENCE"] = header.dy["REFERENCE"] + "-" +
                                               TRIM(header.dy["SUBJECT"])
			header.dy["SUBJECT"] = ""
		ELSE			;;	it does look like a reasonable message id
			header.dy["REFERENCE"] =
FORMAT("AR,W6",header.dy["REFERENCE"])
			header.dy["SUBJECT"] = TRIM(header.dy["SUBJECT"])
;;					strip leading "#" in ["SUBJECT"] if present
			retval =
MATCH(header.dy["SUBJECT"],"#..",header.dy["SUBJECT"])
		ENDIF

;;				here we are looking for text like:
;;					Sb: Frogs
;;				if there was a dash or space in the subject, the
previous CASE would have
;;				caught it
	CASE MATCH(line,"Sb: ..",header.dy["REFERENCE"]):
;;					strip leading "#" in subject if present
		retval =
MATCH(header.dy["REFERENCE"],"#..",header.dy["REFERENCE"])
		retval = NUMVAL(header.dy["REFERENCE"])
		IF (retval = "Error") OR (retval <> INT(retval)) OR
					(IsAssigned(header.dy["MESSAGE_ID"]) AND
			(NUMVAL(header.dy["MESSAGE_ID"]) <> "Error") AND
			(NUMVAL(header.dy["MESSAGE_ID"]) <= retval)) THEN

			header.dy["REFERENCE"] = TRIM(header.dy["REFERENCE"])
		ELSE
			header.dy["REFERENCE"] =
FORMAT("AR,W6",header.dy["REFERENCE"])
		ENDIF
		header.dy["SUBJECT"] = ""

;;				here we are looking for text like:
;;					Fm: Fred 77777,1111
	CASE MATCH(line,"Fm: ..,..",part1,part2) AND (NUMVAL(part2) <> "Error"):
;;				part 1 = "Fred 77777"
		header.dy["FROMID"] = "," + part2
;;					we make sure each character is numeric
;;					working from the end backwards
		WHILE MATCH(part1,"..@",part1,char) AND
						(SEARCH(char,"0123456789") > 0)
			header.dy["FROMID"] = char + header.dy["FROMID"]
		ENDWHILE
;;				char is likely to be the space delimiting the name
from the id
		header.dy["FROMNAME"] = Trim(part1 + char)  ;; assumes char
assigned

;;				we know that there is no comma in this line or the
previous CASE would
;;				have caught it, or if there was a comma, the text
after it was not numeric
	CASE MATCH(line,"Fm: ..",header.dy["FROMNAME"]):
		header.dy["FROMID"]   = ""
		header.dy["FROMNAME"] = Trim(header.dy["FROMNAME"])

;;				the "To:" line could have a trailing "(X)"
	CASE (MATCH(line,"To: ..,.. (X)",part1,part2) OR
			MATCH(line,"To: ..,..",part1,part2))          AND
			(NUMVAL(part2) <> "Error"):
		header.dy["TOID"] = "," + part2
		WHILE MATCH(part1,"..@",part1,char) AND
						(SEARCH(char,"0123456789") > 0)
			header.dy["TOID"] = char + header.dy["TOID"]
		ENDWHILE
		header.dy["TONAME"] = Trim(part1 + char)

	CASE MATCH(line,"To: ..",header.dy["TONAME"]):
		header.dy["TOID"]   = ""
		header.dy["TONAME"] = Trim(header.dy["TONAME"])
	ENDSWITCH
	MoveNextLine()
ENDWHILE

RETURN (counter < 7)      ;;;   did we get all the info or read too many
lines?

ENDPROC

PROC MemoTrim(txt)
    PRIVATE  length,pointer

    length = LEN(txt)
    FOR pointer FROM length TO 0 STEP -1	;;	if it's all whitespace, return
NULL
;;		we are trimming whitespace characters from the back
         IF SEARCH(SUBSTR(txt,pointer,1)," \n\t") = 0 THEN
              txt = SUBSTR(txt,1,pointer)
              QUITLOOP
         ENDIF
    ENDFOR

    length = LEN(txt)
    FOR pointer FROM 2 TO length STEP 1		;;	there must be at least
one character
							;;	or we'll skip this part
;;		we are trimming whitespace characters from the front
         IF SEARCH(SUBSTR(txt,pointer,1)," \n\t") = 0 THEN
              txt = SUBSTR(txt,pointer,length)
              QUITLOOP
         ENDIF
    ENDFOR

    RETURN txt
ENDPROC
MATCH("Sweet Agony")Copyright , 1992 Richard C Haven

Printed Page 1 of 5


