;-------------  GET THE NUMBER SCRIPT -----------------------
;
;
;
PROC CLOSED GETNUM(NUMBER)
; GETNUM IS A PROCESS THAT CALCULATES AN 8 DIGIT NUMBER
; TO BE USED AS A COUNTER IN THE KEY FILED OF A TABLE. IT
; HAS PROVEN TO BE MORE EFFECTIVE THAN A SIMPLE DIGIT ADDER.
; IT HAS BEEN USED AS A PRIMARY TRACKING NUMBER FOR MULTI TABLE
; FORMS AND IS EXCEPTIONAL IN DATA RETRIEVAL MODES WHEN USED AS
; A MASTER JOB TRACKING NUMBER. IT REDUCES COLLISIONS IN A 
; MULTI USER ENVIRONMENT BECAUSE IT KEEPS 2 USERS FROM PROCESSING
; LAST RECORD NUMBERS AT THE SAME TIME WHEN GETTING A NEW RECORD.
;
;
; THE FUNCTION IS AS AN ALPHANUMERIC 8 PLACE IDENTITY
;
;   X            XXX               XXXX
; YEAR    DAY OF THE YEAR    OPERATION NUMBER
; 
; THIS SCRIPT REQUIRES A TABLE BE PRESENT CALLED "NUMBERS"
; "NUMBERS" HAS ONE FIELD CALLED "ACTIVE_NUMBER"
; [NUMBERS->ACTIVE_NUMBER] MUST HAVE BEEN PREFILLED WITH A MINIMUM OF
; 5 DUMMY PARMS
;
; GETNUM(NUMBER) BRINGS THE CURRENT NUMBER [TABLE->NUMBER] OR "" 
; INTO THE PROCESS AND EVALUATES THE HEADER CHARS AGAINST 
; THE LAST ENTRY IN "NUMBERS". IF THEY MATCH IT ADDS A VALUE OF ONE
; TO THE NUMBER AND ADDS THIE RECORD TO THE "NUMBERS" TABLE. IT THEN
; DELETES THE FIRSTY RECORD IN "NUMBERS" TO MINIMIZE THE TABLE SIZE.
;
; THIS COULD EASILY BE MODIFIED FOR SERIAL NUMBER APPS AS WELL

IF NOT (ISTABLE("NUMBERS")) THEN
    MESSAGE " THE SYSTEM IS IN ERROR ... PLEASE CALL A SYSTEM TECH ... "
    EXIT
ENDIF

CLEAR
VIEW"NUMBERS" 
END
@ 12,20 ??          " PROCESSING THE CURRENT NUMBER ..... "
@ 13,20 ??          "             PLEASE WAIT             "
ARRAY VARIABLE[18]
IF SUBSTR(NUMBER,1,4)<>SUBSTR([NUMBERS->ACTIVE_NUMBER],1,4) THEN
VARIABLE[16] = "0000"
VARIABLE[1] = 31

; LEAP YEAR CHECK INTO YEAR 2000 
IF(YEAR(TODAY()) = 1992 OR YEAR(TODAY())=1996 OR YEAR(TODAY()) =2000)
  THEN
  VARIABLE[2] = 29 ELSE VARIABLE[2] = 28
  ENDIF

VARIABLE[3] = 31 VARIABLE[4] = 30 VARIABLE[5] = 31
VARIABLE[6] = 30 VARIABLE[7] = 31 VARIABLE[8] = 31
VARIABLE[9] = 30 VARIABLE[10] = 31 VARIABLE[11] = 30

VARIABLE[13] = SUBSTR(YEAR(TODAY()),4,1)
VARIABLE[14] = DAY(TODAY())
COUNT = 1
VARIABLE[15] = 0

WHILE COUNT < MONTH(TODAY())
   ;
   ; THIS LOOP ADDS UP THE DAYS FROM MONTHS THAT HAVE PASSED
   ;   
   VARIABLE[15] = VARIABLE[15] + VARIABLE[COUNT]
   COUNT = COUNT + 1
ENDWHILE

; WE MUST TAKE CARE OF MISSING ZEROS
VARIABLE[15] = (VARIABLE[15]+VARIABLE[14])
IF VARIABLE[15] < 10  THEN
    VARIABLE[15] = "00"+STRVAL(VARIABLE[15]) Else
IF (VARIABLE[15] < 100) THEN
    VARIABLE[15] = "0"+STRVAL(VARIABLE[15]) ENDIF ENDIF

VARIABLE[17] = STRVAL(VARIABLE[13])+STRVAL(VARIABLE[15])
ELSE
VARIABLE[17] = SUBSTR(NUMBER,1,4)
ENDIF

END 
; RE INITIALISE THE TABLE IN CASE ANOTHER USER HAS STEPPED IN

VARCOUNT = [NUMBERS->ACTIVE_NUMBER]

IF SUBSTR(VARCOUNT,1,4) = VARIABLE[17]
  THEN
   VARCOUNT = SUBSTR(VARCOUNT,5,4)
   VARCOUNT = NUMVAL(VARCOUNT)
   VARCOUNT = VARCOUNT + 1
   ;
   ; AGAIN TAKE CARE OF MISSING ZEROS
   ;
   IF VARCOUNT > 999 THEN VARCOUNT = STRVAL(VARCOUNT) ELSE
     IF VARCOUNT > 99  THEN VARCOUNT = "0"+STRVAL(VARCOUNT) ELSE
       IF VARCOUNT > 9 THEN VARCOUNT = "00"+STRVAL(VARCOUNT) ELSE
          VARCOUNT = "000"+STRVAL(VARCOUNT)
   ENDIF ENDIF ENDIF
   VARIABLE[17] = VARIABLE[17]+VARCOUNT
 ELSE
   VARIABLE[17] = VARIABLE[17]+VARIABLE[16]
ENDIF
COEDITKEY
@ 12,15 ??    " GETTING THE CURRENT NUMBER ..... SETTING UP ... "
@ 13,15 ??    "                PLEASE WAIT                      "
DOWN
; SET THE RECORD
[NUMBERS->ACTIVE_NUMBER] = VARIABLE[17]

HOME
DEL
; DO THE HOUSEKEEPING
DO_IT!
MOVETO"NUMBERS" CLEARIMAGE
RETVAL = VARIABLE[17]
RETURN RETVAL
ENDPROC
;
;
