; Script Dol_Prt.SC
; Purpose.....: Print the dollars and cents on checks.
;               While there are several programs out there that spell
;               out the dollars this one does not spell out the dollars.
;               It is usefull when you have limited space on the check
;               where spelling out the dollars does not work and the
;               procedure justs prints out 9,999.99.  This does not
;               provide much check protection.  This procedure will print
;               out the following: *********9,999 DOLLARS AND 99 CENTS
;
; Variables...: Sp   = Determines which format to use
;               Sp.n = Decimal position
;               Sl.n = Substring starting position - used to strip off
;                      blank spaces after being converted using the
;                      format function.  Allowances are made for commas
;                      depending on the string length.
;               Maxlen.n = maximum length of check characters
;               Dol.n = Whole dollar amount. ie: 677
;               Cent.n = Decimal amount. ie: 78
; Author......: Joe Gavlas    Compuserve  72740,2411
;
; Date........: 10/24/93  16:55:55
;
; Notes.......: Do not use a number greater than 99,999,999,999.99
; Disclaimer..: It is your responsibility to ensure that this prints
;               out the proper results.  I have attempted to debug it
;               and it seems to work properly but that is no guarantee.
;
; This program is donated to the Public Domain.
; Let me know if there is a more efficient way to code this.
;
;--------------------------------------------------------------------
; Proc DollarCents
;--------------------------------------------------------------------
; TO PRINT DOLLARS ON CHECKS IN THE FOLLOWING FORMAT - $677.78
; ***********677 DOLLARS AND 78 CENTS


  PROC dollarcents(dol.n,          ; Amount to be converted
    maxlen.n)                      ; Maximum length to be converted
    Private Sp,sp.n,sl.n,dol.n,cent.n

    sp.n = SEARCH(".",dol.n)

    IF sp.n = 0 THEN;"N" or "S" Passed rather than "$"
      sp = LEN(dol.n) + 3          ; if "N" with no decimals
      dol.n  = STRVAL(dol.n)
      cent.n = "00"
    ELSE
      sp = sp.n + 2                ; "$" or "N" with decimals passed
      cent.n = SUBSTR(STRVAL(dol.n),sp.n+1,2)
      dol.n  = SUBSTR(STRVAL(dol.n),1,sp.n-1)
    ENDIF

; For quick execution rearrange the case order depending on the distribution
; of dollars being printed.

    SWITCH

      CASE sp= 6:                              ;             999.99
        dol.n = FORMAT("W7,EC",NUMVAL(dol.n))
        sl.n = 5

      CASE sp= 5:                              ;              99.99
        dol.n = FORMAT("W6,EC",NUMVAL(dol.n))
        sl.n = 5

      CASE sp= 4:                              ;               9.99
        dol.n = FORMAT("W5,EC",NUMVAL(dol.n))
        sl.n = 5

      CASE sp= 7:                              ;           9,999.99
        dol.n = FORMAT("W8,EC",NUMVAL(dol.n))
        sl.n = 4

      CASE sp= 8:                              ;          99,999.99
        dol.n = FORMAT("W9,EC",NUMVAL(dol.n))
        sl.n = 4

      CASE sp= 9:                              ;         999,999.99
        dol.n = FORMAT("W10,EC",NUMVAL(dol.n))
        sl.n = 4

      CASE sp= 3:                              ;                .99
        dol.n = FORMAT("W4,EC",NUMVAL(dol.n))
        sl.n = 5

      CASE sp= 10:                             ;       9,999,999.99
        dol.n = FORMAT("W11,EC",NUMVAL(dol.n))
        sl.n = 3

      CASE sp= 11:                             ;      99,999,999.99
        dol.n = FORMAT("W12,EC",NUMVAL(dol.n))
        sl.n = 3

      CASE sp= 12:                             ;     999,999,999.99
        dol.n = FORMAT("W13,EC",NUMVAL(dol.n))
        sl.n = 3

      CASE sp= 13:                             ;   9,999,999,999.99
        dol.n = FORMAT("W14,EC",NUMVAL(dol.n))
        sl.n = 2

      CASE sp= 14:                             ;  99,999,999,999.99
        dol.n = FORMAT("W15,EC",NUMVAL(dol.n))
        sl.n = 2

      CASE sp= 15:                             ; 999,999,999,999.9_
        dol.n = FORMAT("W16,EC",NUMVAL(dol.n))
        sl.n = 2

    ENDSWITCH


    IF sp = 3 THEN;   No Dollars
      dol.n = " NO DOLLARS AND " + cent.n + " CENTS"
    ELSE
      dol.n = SUBSTR(dol.n,sl.n,LEN(dol.n)+1)+" DOLLARS AND " + cent.n + " CENTS"
    ENDIF


    dol.n = FILL("*",maxlen.n - LEN(dol.n)) + dol.n
    return dol.n

  ENDPROC

;--------------------------------------------------------------------


  RELEASE VARS ALL
  maxlen.n = 35
  cont.l = true
  CLEAR ClearAll

  WHILE cont.l
    @ 5,00 ? "ENTER A VALUE: "
    ACCEPT "n" TO dol.n1

    IF NOT RETVAL THEN; ESC pressed
      RETURN false
    ENDIF

    dol.n1 = dollarcents(dol.n1,maxlen.n)

    @ 10,5 clear eos
    @ 10,5 ?? dol.n1
    sleep 2000

    CLEAR
  ENDWHILE
