;*****************************************************************************
;Naam         : DOCGEN.SC
;Soort        : script
;Omschrijving : Genereren documentatie
;*****************************************************************************
;
; (c) Copyright 1993
;
;               Ton Reesink
;               Aronskelkweg 104
;               2555 GP  THE HAGUE
;               THE NETHERLANDS
;
; Permission is granted to any individual or institution
; to use, copy, or redistribute this program so long as
; this copyright notice is retained.
;
;*****************************************************************************
;Naam         : IDX_TABELDOC
;Omschrijving : Index tabellen
;
PROC CLOSED IDX_TABELDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE tabelnaam

  ;Log
  PRINT FILE lg "     IDX_TABELDOC      ",TIME(),"\n"

  ;Print openen
  HPG("SYSTEMDOCUMENTATION: INDEX TABLENAMES")
  PRINT FILE bn "     Table      Date changed\n"
  PRINT FILE bn "     _______________________\n\n"

  ;Afdrukken index tabellen
  FOREACH tabelnaam IN tabelnamen
    PRINT FILE bn "     ",FORMAT("W10,AL",tabelnaam)," ",FORMAT("AR,W12",tabelnamen[tabelnaam]),"\n"
  ENDFOREACH

ENDPROC
;*****************************************************************************
;Naam         : TABELDOC
;Omschrijving : Documentatie per tabel
;
PROC CLOSED TABELDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE teller,validaties,veldtype,veldnaam,tabelnaam,aantrecords,aantvelden

  ;Log
  PRINT FILE lg "     TABELDOC          ",TIME(),"\n"
  
  ;init variabelen
  ARRAY validaties[9]
  FOR teller FROM 1 TO 9
    validaties[teller]=""
  ENDFOR

  ; Documentatie per tabel
  FOREACH tabelnaam IN tabelnamen
    HPG("SYSTEMDOCUMENTATION TABLE: "+tabelnaam)
    IF ISENCRYPTED(tabelnaam) THEN
      PRINT FILE bn "     ","NO ACCESS. TABLE IS ENCRYPTED.","\n"     
    ELSE
      ;algemene info
      aantvelden  = NFIELDS(tabelnaam)
      aantrecords = NRECORDS(tabelnaam)
      PRINT FILE bn "     Number of field            : ",aantvelden,"\n"     
      PRINT FILE bn "     Number of keyfields        : ",NKEYFIELDS(tabelnaam),"\n"     
      PRINT FILE bn "     Number of records          : ",aantrecords,"\n"
      PRINT FILE bn "     Paradox version            : ",FILEVERSION(tabelnaam+".db"),"\n"
      PRINT FILE bn "\n\n"
      ;veldnamen en veldtypes
      PRINT FILE bn "     ","Nr Fieldname                 Fieldtype\n"
      PRINT FILE bn "     ","________________________________________________\n"
      {Tools} {Info} {Structure}
      SELECT tabelnaam 
      SCAN "Struct"
        PRINT FILE bn "     ",FORMAT("AR,W2",STRVAL([#]))," ",FORMAT("AL,W25",[Field Name])," ",FORMAT("AL,W5",[Field Type]),"\n"
      ENDSCAN
      DELETE "Struct"
      
      ;Validaties&pictures per veld van de tabel
      ;minimaal 1 record in de tabel (ivm requiredchecks)
      IF aantrecords = 0 THEN 
        PRINT FILE bn "\n\n","     NO FIELD INFORMATION. TABLE IS EMPTY.","\n"     
      ELSE  
        PRINT FILE bn "\n\n"
        PRINT FILE bn "     ","Fieldname                    Validity checks\n"
        PRINT FILE bn "     ","___________________________________________________________________________\n"
        EDIT tabelnaam
        FOR teller FROM 1 TO aantvelden
          PRINT FILE bn "\n"
          RIGHT
          MENU {ValCheck} {Define}
          ENTER
          veldtype = FIELDTYPE()
          veldnaam = FIELD()
          IF MATCH(veldtype, "M..") OR MATCH(veldtype, "B..") OR MATCH(veldtype, "U..") THEN
            ;enige toegestane validatie
            {Required}
            validaties[1]=MENUCHOICE()
            ;afdrukken inclusief veldnaam
            PRINT FILE bn "     ",FORMAT("W29,AL",veldnaam),"Required     : ",validaties[6],"\n"
          ELSE
            ;bepalen validaties
            {LowValue}
            validaties[1]=MENUCHOICE()
            ESC
            {HighValue}
            validaties[2]=MENUCHOICE()
            ESC
            {Default}
            validaties[3]=MENUCHOICE()
            ESC
            {TableLookup}
            validaties[4]=MENUCHOICE()
            ESC
            {Picture}
            validaties[5]=MENUCHOICE()
            ESC
            {Required}
            validaties[6]=MENUCHOICE()
            ESC
            {Auto}{Filled}
            validaties[7]=MENUCHOICE()
            ESC ESC
            {Auto}{Picture}
            validaties[8]=MENUCHOICE()
            ESC ESC
            {Auto}{Lookup}
            validaties[9]=MENUCHOICE()
            ;afdrukken, eerste regel inclusief veldnaam
            PRINT FILE bn "     ",FORMAT("W29,AL",veldnaam),"Required     : ",validaties[6],"\n"
            PRINT FILE bn "     ",SPACES(29),"Low value    : ",validaties[1],"\n"
            PRINT FILE bn "     ",SPACES(29),"High value   : ",validaties[2],"\n"
            PRINT FILE bn "     ",SPACES(29),"Default      : ",validaties[3],"\n"
            PRINT FILE bn "     ",SPACES(29),"Table lookup : ",validaties[4],"\n"
            PRINT FILE bn "     ",SPACES(29),"Picture      : ",validaties[5],"\n"
            PRINT FILE bn "     ",SPACES(29),"Auto         : "
            PRINT FILE bn "Filled=",validaties[7]," "
            PRINT FILE bn "Picture=",validaties[8]," "
            PRINT FILE bn "Lookup=",validaties[9],"\n"
          ENDIF
        ENDFOR
        CANCELEDIT
        CLEARIMAGE
      ENDIF
    ENDIF
  ENDFOREACH

ENDPROC
;*****************************************************************************
;Naam         : IDX_FAMILYDOC
;Omschrijving : Index familie's
;
PROC CLOSED IDX_FAMILYDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE tabelnaam

  ;Log
  PRINT FILE lg "     IDX_FAMILYDOC     ",TIME(),"\n"
  
  ;Print openen
  HPG("SYSTEMDOCUMENTATION: INDEX FAMILYNAMES")
  PRINT FILE bn "     Family     Date changed\n"
  PRINT FILE bn "     _______________________\n\n"

  ;Afdrukken index familienamen
  FOREACH tabelnaam IN tabelnamen
    PRINT FILE bn "     ",FORMAT("W10,AL",tabelnaam)," ",FORMAT("AR,W12",tabelnamen[tabelnaam]),"\n"
  ENDFOREACH

ENDPROC
;*****************************************************************************
;Naam         : FAMILYDOC
;Omschrijving : Documentatie per familie
;
PROC CLOSED FAMILYDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE tabelnaam

  ;Log
  PRINT FILE lg "     FAMILYDOC         ",TIME(),"\n"
  
  ;inhoud per familie
  FOREACH tabelnaam IN tabelnamen
    HPG("SYSTEMDOCUMENTATION FAMILY: "+tabelnaam)
    IF ISENCRYPTED(tabelnaam) THEN
      PRINT FILE bn "     ","NO ACCESS. TABLE IS ENCRYPTED.","\n"     
    ELSE
      PRINT FILE bn "     Familymember                                       Date changed\n"
      PRINT FILE bn "     _______________________________________________________________\n\n"
      {Tools} {Info} {Family} 
      SELECT tabelnaam 
      VIEW "Family"
      SCAN 
        PRINT FILE bn "     ",FORMAT("W50,AL",[Name])," ",FORMAT("AR,W12",[Date]),"\n"
      ENDSCAN
      DELETE "Family"
    ENDIF
  ENDFOREACH

ENDPROC
;*****************************************************************************
;Naam         : FAM_REPORTDOC
;Omschrijving : Documentatie per familie van de reports
;
PROC CLOSED FAM_REPORTDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE tabelnaam
  
  ;Log
  PRINT FILE lg "     FAM_REPORTDOC     ",TIME(),"\n"

  ;rapportage per familielid
  FOREACH tabelnaam IN tabelnamen
    IF ISENCRYPTED(tabelnaam) THEN
      HPG("SYSTEMDOCUMENTATION REPORTS OF FAMILY: "+tabelnaam)
      PRINT FILE bn "     ","NO ACCESS. TABLE IS ENCRYPTED.","\n"     
    ELSE
      {Tools} {Info} {Family} 
      SELECT tabelnaam 
      VIEW "Family"
      SCAN 
        IF SUBSTR([Name],1,8) = "Report R" THEN
          REPORTDOC(tabelnaam,SUBSTR([Name],8,3))         
        ENDIF
      ENDSCAN
      DELETE "Family"
    ENDIF
  ENDFOREACH

ENDPROC
;*****************************************************************************
;Naam         : REPORTDOC
;Omschrijving : Documentatie per report
;
PROC CLOSED REPORTDOC(tabelnaam,reportnaam)  
USEVARS tabelnamen,bn,lg
PRIVATE teller,reportnummer,reportoms,aantblz,breedte,hoogte,replayout

  ;Log
  PRINT FILE lg "     REPORTDOC         ",TIME(),"\n"

  ; bepalen reportnummer
  IF LEN(reportnaam) = 1 THEN
    reportnummer     = "R"
  ELSE
    reportnummer     = SUBSTR(reportnaam,2,2)
  ENDIF

  ;bepalen gegevens van report
  MENU {Report} {Change} 
  SELECT tabelnaam 
  SELECT reportnummer
  reportoms = MENUCHOICE()
  ENTER
  ENTER ; in report designer
  aantblz   = NPAGES()
  hoogte    = NROWS()
  breedte   = PAGEWIDTH()
  ;report layout
  ARRAY replayout[hoogte]
  FOR teller FROM 1 TO hoogte STEP 1
    replayout[teller] = CURSORLINE()
    DOWN
  ENDFOR
  MENU {Cancel} {Yes} ; verlaat report designer

  ;afdrukken algemene gegevens
  HPG("SYSTEMDOCUMENTATION REPORTS OF FAMILY "+tabelnaam+". REPORT "+reportnaam+" "+reportoms)
  PRINT FILE bn "     Table name                     : ",tabelnaam,"\n"
  PRINT FILE bn "     Report name                    : ",reportnaam,"\n"
  PRINT FILE bn "     Report number                  : ",reportnummer,"\n"
  PRINT FILE bn "     Report description             : ",reportoms,"\n"
  PRINT FILE bn "     Number of pages                : ",aantblz,"\n"
  PRINT FILE bn "     Numer of rows                  : ",hoogte,"\n"
  PRINT FILE bn "     Page width                     : ",breedte,"\n"
  IF ISMULTIREPORT(tabelnaam,reportnummer) THEN
    REPORTTABLES tabelnaam reportnummer embedlist
    PRINT FILE bn "     Linked lookup tables           : Yes (",ARRAYSIZE(embedlist),")\n"
    FOR teller FROM 1 TO ARRAYSIZE(embedlist) STEP 1
      PRINT FILE bn "            Lookup table            : ",embedlist[teller],"\n"
    ENDFOR
  ELSE
    PRINT FILE bn "     Linked lookup tables           : No\n"
  ENDIF
      
  ; afdrukken report layout
  PRINT FILE bn "\n\n"
  PRINT FILE bn "     _____________________________________________________________________________________________________________________\n\n"
  FOR teller FROM 1 TO hoogte STEP 1
    PRINT FILE bn "     ",FORMAT("W3,AR",teller)," ",replayout[teller],"\n"
  ENDFOR

ENDPROC
;*****************************************************************************
;Naam         : FAM_FORMDOC
;Omschrijving : Documentatie per familie van de forms
;
PROC CLOSED FAM_FORMDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE tabelnaam
  
  ;Log
  PRINT FILE lg "     FAM_FORMDOC       ",TIME(),"\n"

  ;rapportage per familielid
  FOREACH tabelnaam IN tabelnamen
    IF ISENCRYPTED(tabelnaam) THEN
      HPG("SYSTEMDOCUMENTATION FORMS OF FAMILY: "+tabelnaam)
      PRINT FILE bn "     ","NO ACCESS. TABLE IS ENCRYPTED.","\n"     
    ELSE
      {Tools} {Info} {Family} 
      SELECT tabelnaam 
      VIEW "Family"
      SCAN 
        IF SUBSTR([Name],1,6) = "Form F" THEN
          FORMDOC(tabelnaam,SUBSTR([Name],6,3))         
        ENDIF
      ENDSCAN
      DELETE "Family"
    ENDIF
  ENDFOREACH

ENDPROC
;*****************************************************************************
;Naam         : FORMDOC
;Omschrijving : Documentatie per form
;
PROC CLOSED FORMDOC(tabelnaam,formnaam)  
USEVARS tabelnamen,bn,lg
PRIVATE teller,formnummer,formoms,aantblz,formlayout
      
  ;Log
  PRINT FILE lg "     FORMDOC           ",TIME(),"\n"

  ; bepalen formnummer
  IF LEN(formnaam) = 1 THEN
    formnummer  = "F"
  ELSE
    formnummer  = SUBSTR(formnaam,2,2)
  ENDIF

  ;bepalen gegevens form
  MENU {Forms} {Change} 
  SELECT tabelnaam 
  SELECT formnummer
  formoms = MENUCHOICE() 
  ENTER
  ENTER ; in form designer
  aantblz   = NPAGES()
  ;form layout
  ARRAY formlayout[23]
  FOR teller FROM 1 TO 23 STEP 1
    formlayout[teller] = CURSORLINE()
    DOWN
  ENDFOR
  MENU {Cancel} {Yes} ; verlaat form designer
      
  ;afdrukken algemene gegevens
  HPG("SYSTEMDOCUMENTATION FORMS OF FAMILY "+tabelnaam+". FORM "+formnaam+" "+formoms)
  PRINT FILE bn "     Table name                     : ",tabelnaam,"\n"
  PRINT FILE bn "     Form name                      : ",formnaam,"\n"
  PRINT FILE bn "     Form number                    : ",formnummer,"\n"
  PRINT FILE bn "     Form description               : ",formoms,"\n"
  PRINT FILE bn "     Number of pages                : ",aantblz,"\n"
  IF ISMULTIFORM(tabelnaam,formnummer) THEN
    FORMTABLES tabelnaam formnummer embedlist
    PRINT FILE bn "     Embedded tables                : Yes (",ARRAYSIZE(embedlist),")\n"
    FOR teller FROM 1 TO ARRAYSIZE(embedlist) STEP 1
      PRINT FILE bn "              Embedded table        : ",embedlist[teller],"\n"
    ENDFOR
  ELSE
    PRINT FILE bn "     Embedded tables                : No\n"
  ENDIF

  ;afdrukken layout
  PRINT FILE bn "\n\n"
  PRINT FILE bn "     _____________________________________________________________________________________________________________________\n\n"
  FOR teller FROM 1 TO 23 STEP 1
    PRINT FILE bn "     ",FORMAT("W3,AR",teller)," ",formlayout[teller],"\n"
  ENDFOR

ENDPROC
;*****************************************************************************
;Naam         : IDX_SCRIPTDOC
;Omschrijving : Index scripts
;
PROC CLOSED IDX_SCRIPTDOC()  
USEVARS tabelnamen,bn,lg
  
  ;Log
  PRINT FILE lg "     IDX_SCRIPTDOC     ",TIME(),"\n"
  
  ;Print openen
  HPG("SYSTEMDOCUMENTATIE: INDEX SCRIPTNAMES")

  ; scriptnamen bepalen. komt in tabel List
  {Tools} {Info} {Inventory} {Scripts} {}
  
  ; kijken of er scripts zijn
  IF ISEMPTY("List") THEN
    PRINT FILE bn "     NO SCRIPTS FOUND\n\n"
    RETURN
  ENDIF

  ; index scriptnamen afdrukken
  PRINT FILE bn "     Script     Date changed\n"
  PRINT FILE bn "     _______________________\n\n"
  VIEW "List"
  SCAN
    PRINT FILE bn "     ",FORMAT("W10,AL",[Name]),"     ",FORMAT("AR,D9",[Date]),"\n"
  ENDSCAN
  DELETE "List"

ENDPROC
;*****************************************************************************
;Naam         : SCRIPTDOC
;Omschrijving : Documentatie per script
;
PROC CLOSED SCRIPTDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE teller,scrnamen,aantalscr,scrnaam,punt,scr,
        positie,regelnr,karakters,aantkar,blznr

  ;Log
  PRINT FILE lg "     SCRIPTDOC         ",TIME(),"\n"

  ; scriptnamen bepalen. komt in tabel List
  {Tools} {Info} {Inventory} {Scripts} {}
  
  ; kijken of er scr's zijn
  IF ISEMPTY("List") THEN
    HPG("SYSTEMDOCUMENTATION SCRIPT:")
    PRINT FILE bn "     NO SCRIPTS FOUND\n\n"
    RETURN
  ENDIF

  ;scrnamen opslaan in array
  aantalscr = NRECORDS("List")
  ARRAY scrnamen[aantalscr]  
  teller = 0
  SCAN "List"
    teller           = teller + 1
    scrnamen[teller] = [Name]
  ENDSCAN
  DELETE "List"

  FOR teller FROM 1 TO aantalscr STEP 1
    scrnaam = scrnamen[teller]
    FILEREAD scrnaam+".sc" TO scr
    positie     = 1
    regelnr     = 1
    blznr       = 1
    HPG("SYSTEMDOCUMENTATION SCRIPT: "+scrnaam+"          Page: "+STRVAL(blznr))
    PRINT FILE bn "     ",FORMAT("W6,AR",regelnr)," "
    WHILE positie < LEN(scr) 
      aantkar     = SEARCHFROM(CHR(10),scr,positie) - positie
      karakters   = SUBSTR(scr,positie,aantkar)
      PRINT FILE bn karakters
      regelnr     = regelnr + 1
      IF MOD(regelnr,50) = 0 THEN  
        blznr = blznr + 1
        HPG("SYSTEMDOCUMENTATION SCRIPT: "+scrnaam+"          Page: "+STRVAL(blznr))
      ENDIF
      PRINT FILE bn "\n","     ",FORMAT("W6,AR",regelnr)," "
      positie     = positie + aantkar + 1
    ENDWHILE      
  ENDFOR

ENDPROC
;*****************************************************************************
;Naam         : IDX_LIBDOC
;Omschrijving : Index librarys
;
PROC CLOSED IDX_LIBDOC()  
USEVARS tabelnamen,bn,lg
  
  ;Log
  PRINT FILE lg "     IDX_LIBDOC        ",TIME(),"\n"

  ;Print openen
  HPG("SYSTEMDOCUMENTATION: INDEX LIBRARYNAMES")

  ; libnamen bepalen. komt in tabel List
  {Tools} {Info} {Inventory} {Files} {*.lib}
  
  ; kijken of er lib's zijn
  IF ISEMPTY("List") THEN
    PRINT FILE bn "     NO LIBRARYS FOUND\n\n"
    RETURN             
  ENDIF
  
  
  ; index librarys
  PRINT FILE bn "     Library    Date changed\n"
  PRINT FILE bn "     _______________________\n\n"
  VIEW "List"
  SCAN
    PRINT FILE bn "     ",FORMAT("W10,AL",[Name]),"     ",FORMAT("AR,D9",[Date]),"\n"
  ENDSCAN
  DELETE "List"

ENDPROC
;*****************************************************************************
;Naam         : LIBDOC
;Omschrijving : Documentatie per library
;
PROC CLOSED LIBDOC()  
USEVARS tabelnamen,bn,lg
PRIVATE teller,libnamen,aantallib,libnaam,punt

  ;Log
  PRINT FILE lg "     LIBDOC            ",TIME(),"\n"
  
  ; libnamen bepalen. komt in tabel List
  {Tools} {Info} {Inventory} {Files} {*.lib}
  
  ; kijken of er lib's zijn
  IF ISEMPTY("List") THEN
    HPG("SYSTEMDOCUMENTATION LIBRARY:")
    PRINT FILE bn "     NO LIBRARYS FOUND\n\n"
    RETURN
  ENDIF

  ;libnamen opslaan in array
  aantallib = NRECORDS("List")
  ARRAY libnamen[aantallib]  
  teller = 0
  SCAN "List"
    teller           = teller + 1
    libnamen[teller] = [Name]
  ENDSCAN
  DELETE "List"

  FOR teller FROM 1 TO aantallib STEP 1
    punt    = SEARCH(".",libnamen[teller])
    libnaam = SUBSTR(libnamen[teller],1,punt-1)
    HPG("SYSTEMDOCUMENTATION LIBRARY: "+libnaam)
    IF FILEVERSION(libnamen[teller]) <> "4.0" THEN
      PRINT FILE bn "     NO INFORMATION AVAILABLE\n"
    ELSE
      PRINT FILE bn "     Procedure                         Size\n"
      PRINT FILE bn "     ______________________________________\n\n"
      INFOLIB(libnaam)
      VIEW "List"
      SCAN
        PRINT FILE bn "     ",FORMAT("W31,AL",[Procedure])," ",FORMAT("AR,W6",[Size]),"\n"
      ENDSCAN
      DELETE "List"
    ENDIF
  ENDFOR

ENDPROC
;*****************************************************************************
;Naam         : HPG
;Omschrijving : Harde pagina
;
PROC HPG(tekst)  
  ; kop afdrukken
  PRINT FILE bn "\n"
  PRINT FILE bn "     ",FORMAT("W12,AL,D9",TODAY()),FORMAT("W93,AC",tekst),FORMAT("W12,AR",TIME()),"\n"
  PRINT FILE bn "     _____________________________________________________________________________________________________________________\n\n"

  ;grapje op het scherm om te laten zien dat programma loopt
  ?? CHR(1)

ENDPROC
;*****************************************************************************
;Naam         : KIESDIR
;Omschrijving : Kiezen van een directory
;
PROC CLOSED KIESDIR()  
USEVARS tabelnamen,bn,lg
PRIVATE dirlist,keuze,dirlista,dirkeuze,commando,treelist,teller,positie,
        aantkar,karakters

  ;init variabelen
  DYNARRAY dirlista[]

  ;bepalen directorynamen in file
  MESSAGE "Determinating directory names"
  commando = "DIR \\ /ad /on /b /s /-p > docgen.tre"
  RUN NOREFRESH commando 
  
  ;omzetten naar dynarray
  FILEREAD "docgen.tre" TO treelist
  teller        = 1
  positie       = 1
  WHILE positie < LEN(treelist) 
    aantkar     = SEARCHFROM(CHR(10),treelist,positie) - positie
    karakters   = SUBSTR(treelist,positie,aantkar)
    IF SEARCH(".",karakters) = 0 THEN
      dirlista[karakters] = karakters
    ENDIF
    positie     = positie + aantkar + 1
    teller      = teller + 1
  ENDWHILE      

  ;opruimen tijdelijke file
  commando = "DEL docgen.tre"
  RUN NOREFRESH commando 
  MESSAGE ""

  ;keuzes bepalen
  SHOWDIALOG " S E L E C T   D I R E C T O R Y "
  @ 2,5 HEIGHT 20 WIDTH 70
     
     PICKDYNARRAY
       @1,1
       HEIGHT 14
       WIDTH  66
       dirlista
       TAG "Dirkeuze"
       TO  dirkeuze
     
     PUSHBUTTON @16,1 WIDTH 10
       "~O~K"
       OK      
       DEFAULT
       VALUE "Accoord"
       TAG   "Accoord"
       TO    keuze
     
     PUSHBUTTON @16,55 WIDTH 12
       "~C~ancel"
       CANCEL
       VALUE "Opheffen"
       TAG   "Opheffen"
       TO    keuze
    ENDDIALOG

    IF Retval THEN
      SETDIR dirkeuze
    ENDIF

ENDPROC
;*****************************************************************************
;Naam         : HOOFDMENU
;Omschrijving : Menu en aansturing
;
PROC CLOSED HOOFDMENU()
USEVARS tabelnamen,bn,lg
PRIVATE tabelnaam,idx_tabdoc,tabdoc,idx_famdoc,famdoc,
        reportdoc,formdoc,idx_scriptdoc,scriptdoc,idx_libdoc,libdoc,
        starttijd,eindtijd,doorlooptijd

  ;**bepalen tabelnamen**
  
  ; init variabelen
  bn             = "DOCGEN.UIT"
  lg             = "DOCGEN.LOG"

  ; bepalen tabelnamen
  ; index van het array = tabelnaam
  ; waarde van het array is mutatiedatum
  DYNARRAY tabelnamen[]
  {Tools} {Info} {Inventory} {Tables} {}
  VIEW "List"
  SCAN
    tabelnaam     = UPPER(SUBSTR([Name],1,8))
    IF tabelnaam <> "ANSWER"   AND
       tabelnaam <> "CHANGED"  AND
       tabelnaam <> "CROSSTAB" AND
       tabelnaam <> "DELETED"  AND
       tabelnaam <> "ENTRY"    AND
       tabelnaam <> "FAMILY"   AND
       tabelnaam <> "INSERTED" AND
       tabelnaam <> "KEYVIOL"  AND
       tabelnaam <> "PASSWORD" AND
       tabelnaam <> "PROBLEMS" AND
       tabelnaam <> "STRUCT"   AND
       tabelnaam <> "LIST"     THEN
      tabelnamen[tabelnaam]  = STRVAL([Date])
    ENDIF
  ENDSCAN
  DELETE "List"  

  ;**menu en aansturing**

  ;menu
  WHILE (TRUE)
  
    ;scherm leeg
    CLEAR
    MESSAGE ""

    ;init variabelen
    idx_tabdoc    = False
    tabdoc        = False
    idx_famdoc    = False
    famdoc        = False
    reportdoc     = False
    formdoc       = False
    idx_scriptdoc = False
    scriptdoc     = False
    idx_libdoc    = False
    libdoc        = False

    ;keuzes bepalen
    SHOWDIALOG " G E N E R A T E    D O C U M E N T A T I O N "
    @ 2,5 HEIGHT 20 WIDTH 70
     @ 1,1  ?? "Directory"
     @ 1,31 ?? DIRECTORY()
     @ 2,1  ?? "Filename"
     @ 2,31 ?? bn
     @ 4,1  ?? "TABLES"  
     @ 6,1  ?? "FAMILIES"
     @ 8,1  ?? "REPORTS & FORMS"
     @10,1  ?? "SCRIPTS"
     @12,1  ?? "LIBRARYS"
     CHECKBOXES @4,30 HEIGHT 10 WIDTH 30
       TAG "Check"
       "Index tables"                 TO idx_tabdoc,
       "Table documentation"          TO tabdoc,
       "Index families"               TO idx_famdoc,
       "Familie documentation"        TO famdoc,
       "Report documentation"         TO reportdoc,
       "Form documentation"           TO formdoc,
       "Index scripts"                TO idx_scriptdoc,
       "Script documentation"         TO scriptdoc,
       "Index librarys"               TO idx_libdoc,
       "Library documentation"        TO libdoc
     PUSHBUTTON @16,1 WIDTH 10
       "~O~K"
       OK      
       DEFAULT
       VALUE "Accoord"
       TAG   "Accoord"
       TO    keuze
     PUSHBUTTON @16,30 WIDTH 12
       "~D~irectory"
       OK
       VALUE "Directory"
       TAG   "Directory"
       TO    keuze
     PUSHBUTTON @16,55 WIDTH 12
       "~C~ancel"
       CANCEL
       VALUE "Opheffen"
       TAG   "Opheffen"
       TO    keuze
    ENDDIALOG
  
    IF retval THEN
      SWITCH
         CASE keuze = "Accoord":
           
           ;starttijd loggen
           starttijd = TICKS()
           
           ;verwijderen oude bestanden           
           IF ISFILE(bn) THEN
             RUN NOREFRESH "DEL "+bn
           ENDIF  
           IF ISFILE(lg) THEN
             RUN NOREFRESH "DEL "+lg
           ENDIF  
           
           ;log openen
           PRINT FILE lg "     ",FORMAT("W12,AL,D9",TODAY()),FORMAT("W93,AC","L O G G I N G"),FORMAT("W12,AR",TIME()),"\n"
           PRINT FILE lg "     _____________________________________________________________________________________________________________________\n\n"

           ;muis en cursor uit
           MOUSE HIDE
           CURSOR OFF
           
           ;boodschap op het scherm
           MESSAGE "Busy generating documentation."
           
           ;aanmaken documentatie
           IF DYNARRAYSIZE(tabelnamen) > 0 THEN
             IF idx_tabdoc THEN IDX_TABELDOC() ENDIF
             IF tabdoc THEN TABELDOC() ENDIF
             IF idx_famdoc THEN IDX_FAMILYDOC() ENDIF
             IF famdoc THEN FAMILYDOC() ENDIF
             IF reportdoc THEN FAM_REPORTDOC() ENDIF
             IF formdoc THEN FAM_FORMDOC() ENDIF
           ENDIF 
           IF idx_scriptdoc THEN IDX_SCRIPTDOC() ENDIF
           IF scriptdoc THEN SCRIPTDOC() ENDIF
           IF idx_libdoc THEN IDX_LIBDOC() ENDIF
           IF libdoc THEN LIBDOC() ENDIF
           
           ;muis en cursor aan
           MOUSE SHOW
           CURSOR NORMAL

           ;doorlooptijd bepalen
           eindtijd     = TICKS()
           doorlooptijd = (eindtijd - starttijd) / 1000
           
           ;log afsluiten
           PRINT FILE lg "\n\n     Elapsed time is ",STRVAL(doorlooptijd)," seconds\n\n"
           
           ;bestanden inzien  
           IF ISFILE(bn) THEN
             RUN "README "+bn
           ENDIF
           RUN "README "+lg
         
         CASE keuze = "Directory":
           KIESDIR()           
           RETURN true ;opnieuw bepalen tabelnamen forceren

         CASE keuze = "Cancel":
           RETURN false

       ENDSWITCH
     ELSE
       RETURN false
     ENDIF
  ENDWHILE
ENDPROC
;*****************************************************************************
; MAIN PROCEDURE
;
; init proc
CLEARALL
CLEAR

;veiligstellen directory
bewaar = DIRECTORY()

;hoofdmenu
WHILE (HOOFDMENU())
ENDWHILE

;terugzetten directory
SETDIR bewaar

; afsluiten proc
RESET
RELEASE PROCS ALL
RELEASE VARS ALL
CLEARALL

