; DIRKEY.SC
;
; E. Scott Jones
; November 11, 1992
;
; This script allows you to quickly change working directories in Paradox
; without having to go thru all the menu machinations.
; I set it up in INIT.SC as SETKEY "F3" PLAY "C:\\PDOX\\DIRKEY"
;
; This is my VERY FIRST PAL Script, so if you have any suggestions or
; see areas where my code is kludgy or error-prone or just plain dumb,
; please leave me a message (public message is fine, btw) so I'll learn
; from my mistakes.  CServe ID 75500,2370.

PROC DirChange()

        PRIVATE old_dir, new_dir, dirwin

        old_dir = DIRECTORY()
        new_dir = ""

        ECHO NORMAL
        SHOWDIALOG "Directory Change" @ 5,10 HEIGHT 8 WIDTH 60
        @ 2,3 ?? "Enter new directory: "

        ACCEPT @ 2,24 WIDTH 30 "A50" TAG "" TO new_dir

        PUSHBUTTON @ 4,27 WIDTH 10
        "OK"
        OK
        DEFAULT
        VALUE "Say yes"
        TAG "OKTag"
        TO ButtonValue

        PUSHBUTTON @ 4, 42 WIDTH 10
        "Cancel"
        CANCEL
        VALUE "Say no"
        TAG "CancelTag"
        TO ButtonValue

        ENDDIALOG

        ECHO OFF
        IF new_dir = ""
                THEN new_dir = old_dir
        ENDIF
        IF DIREXISTS(new_dir) = 1
                THEN SETDIR new_dir
                msg = "Working directory is now " + DIRECTORY()
        ELSE
                SETDIR old_dir
                BEEP
                msg = "Directory <" + UPPER(new_dir) + "> doesn't exist!!"
        ENDIF

        ECHO NORMAL
ENDPROC

DirChange()

RETURN msg

; EOF() DIRKEY.SC
