;This file is copyright (c) 1990, 1991 Informant Communications Group and the
;article author. The material here may be used in an application provided
;that this copyright/disclaimer information is kept in the original source
;file. The material presented here is provided "as is" and with no guarantee.
;Informant Communications Group/Paradox Informant assume no responsibility
;for the use or misuse of the material contained within.
;
;Contents        : procedure Dlg_Box.u, TrueLen.n,CharCount.n
;Source File     : DIALOG.SC
;Author          : Jacob Colman
;                  BAKI Computing, Inc.
;                  1511 East 22 Street
;                  Brooklyn, NY  11210
;                  Phone: (718) 692-3367
;Informant Issue : November 1991
;Description     : A utility that creates dialog boxes that are displayed
;                  on the PAL Canvas. Provides an alternative method to 
;                  "message" the user and get user input to simple questions.
;
; Paradox Informant
; 8525 Elk Grove Blvd.
; Suite 126
; Elk Grove, CA  95624-1777
; Phone: (916) 686-6610
; Fax  : (916) 686-8497
; BBS  : (916) 686-4740
;

CREATELIB "Dialog"

; Dlg_Box.u() displays a centered dialog box and waits
; for the user to enter a specified key before continuing.

; Input    msg_text.a  The text to be displayed. Lines
;                      are terminated by "|" and text
;                      surrounded with "^" will be
;                      highlighted.
;          ans.a       A Character string containing list
;                      of valid keystrokes. A "~" allows
;                      any key to terminate input.

PROC Dlg_Box.u (msg_text.a,ans.a)
   PRIVATE i, x,
           numlines.n,             ; number of display lines
           brk_pos.n,              ; position of line break char
           blanks.a,               ; string of 80 spaces
           atext.a,                ; array of text strings
           linelength.n,           ; length of longest text line
           splashcolr.n,           ; outer splash box color
           bordercolr.n,           ; interior border color
           textcolr.n,             ; text color
           rvrscolr.n,             ; highlight color
           boxheight.n,            ; height of Dialog Box
           boxwidth.n,             ; width of Dialog Box
           trow.n,brow.n,          ; top/bottom row coordinates
           lcol.n,rcol.n,          ; left/right columns coords
           txt.a                   ; display text

   CANVAS OFF                      ; Initialization
   CURSOR OFF

   blanks.a = FILL (" ", 80)

   splashcolr.n = 78               ; yellow on red
   bordercolr.n = 78
   textcolr.n   = 78
   rvrscolr.n   = 15               ; white on black
   shdwcolr.n   = 8                ; dark grey on black

   numlines.n = CharCount.n (msg_text.a, "|")
   ARRAY atext.a[numlines.n]

   ; Extract the individual lines and determine length
   ; of longest line

   i = 0
   linelength.n = 0

   brk_pos.n = SEARCH("|",msg_text.a)

   WHILE (brk_pos.n > 0 AND numlines.n < 19)
      i = i + 1
      atext.a[i]   = SUBSTR (msg_text.a, 1, brk_pos.n-1)
      linelength.n = MAX (linelength.n,TrueLen.n(atext.a[i]))
      msg_text.a   = SUBSTR (msg_text.a, brk_pos.n + 1,LEN(msg_text.a))
      brk_pos.n    = SEARCH("|",msg_text.a)
   ENDWHILE

   boxheight.n = numlines.n + 3    ; Calculate all necessary dimensions
   boxwidth.n  = linelength.n + 7
   trow.n = 12 - INT(boxheight.n / 2)
   brow.n = trow.n + boxheight.n
   lcol.n = 40 - INT(boxwidth.n / 2)
   rcol.n = lcol.n + boxwidth.n

   PAINTCANVAS FILL " "            ; Paint the Dialog Box
     ATTRIBUTE splashcolr.n
     trow.n, lcol.n, brow.n, rcol.n
   PAINTCANVAS FILL ""
     ATTRIBUTE bordercolr.n
     trow.n+1, lcol.n+3, trow.n+1, rcol.n-3
   PAINTCANVAS FILL ""
     ATTRIBUTE bordercolr.n
     brow.n-1, lcol.n+3, brow.n-1, rcol.n-3
   PAINTCANVAS FILL ""
     ATTRIBUTE bordercolr.n
     trow.n+2, lcol.n+2, brow.n-2, lcol.n+2
   PAINTCANVAS FILL ""
     ATTRIBUTE bordercolr.n
     trow.n+2, rcol.n-2, brow.n-2, rcol.n-2

   STYLE ATTRIBUTE bordercolr.n
   @ trow.n+1,lcol.n+2 ?? ""
   @ trow.n+1,rcol.n-2 ?? ""
   @ brow.n-1,lcol.n+2 ?? ""
   @ brow.n-1,rcol.n-2 ?? ""

   PAINTCANVAS
     ATTRIBUTE shdwcolr.n
     brow.n+1, lcol.n+2, brow.n+1, rcol.n
   PAINTCANVAS
     ATTRIBUTE shdwcolr.n
     trow.n+1, rcol.n+1, brow.n+1, rcol.n+2

   ; The following code section paints the text onto
   ; the screen

   STYLE ATTRIBUTE textcolr.n

   ; Limit to 19 display lines
   IF numlines.n > 19
      THEN numlines.n = 19
   ENDIF
   FOR i FROM 1 TO numlines.n      ; For each line of text . . .

     @ trow.n+1+i,lcol.n+4         ;  Blank fill to the left for centering
     ?? SUBSTR(blanks.a,1,((linelength.n-
               TrueLen.n(atext.a[i])) / 2))

     WHILE (True)                  ; While the line has not been completely
                                   ;  displayed . . .
       x = SEARCH("^",atext.a[i])  ; Search for embedded carets indicating
                                   ;  highlighting
       IF (x <>> 0)
         ; If there are embedded carets, portions of the
         ;  line must be highlighted. The following code
         ;  section parses the line and paints the text,
         ;  switching attributes as needed.
         THEN txt.a = SUBSTR(atext.a[i],1,x-1)    ; text up to ^
              STYLE ATTRIBUTE textcolr.n          ; normal attribute
              @ trow.n+1+i,COL() ?? txt.a         ; paint it

              ; remove text prior to ^

              atext.a[i] = SUBSTR(atext.a[i],x+1,LEN(atext.a[i]))

              x = SEARCH("^",atext.a[i])          ; find closing ^
              txt.a = SUBSTR(atext.a[i],1,x-1)    ; text between ^
              STYLE ATTRIBUTE rvrscolr.n          ; highlight attribute
              @ trow.n+1+i,COL() ?? txt.a         ; paint it

              ; remove text between ^
              atext.a[i] = SUBSTR(atext.a[i],x+1,LEN(atext.a[i]))

         ; At this point there is only text with no embedded
         ; carets. We simply paint the line, exit the loop,
         ; and get the next line.

         ELSE STYLE ATTRIBUTE textcolr.n          ; normal attribute
              @ trow.n+1+i,COL() ?? atext.a[i]    ; paint it
              QUITLOOP                            ; end of this line
       ENDIF

     ENDWHILE

   ENDFOR

   CANVAS ON                        ; display the completed Dialog box
                                    ;  - wait for valid input character
   WHILE (True)
     x = GETCHAR()                  ; get the keypress
     SWITCH
       CASE (ans.a = "~"):
         x = ABS(x)                 ; allow for a negative keycode
         QUITLOOP                   ; exit - any char is ok
       CASE ((x > 0) AND (SEARCH(CHR(x),ans.a) <> 0)):
         QUITLOOP                   ; exit - matching character
       OTHERWISE:
         BEEP                       ; invalid char
     ENDSWITCH
   ENDWHILE

   CURSOR NORMAL

   RETURN (CHR(x))

ENDPROC

; TrueLen.n() calculates the true length of the line.
; That is, the length of the line minus any embedded
; control characters.

PROC TrueLen.n (txt.a)
   PRIVATE procname

   RETURN (LEN(txt.a) - CharCount.n(txt.a,"^"))

ENDPROC

; CharCount() counts the frequency with which a specified
; character appears within a given string.

PROC CharCount.n (txt.a, char.a)   ; Input: txt.a  the string to be searched
   PRIVATE x,y,i                   ;        char.a the character for which to
                                   ;        search
   i = 0
   y = 0

   x = SEARCH(char.a, txt.a)
   WHILE (x > 0)
     i = i + 1
     y = y + x
     x = SEARCH(char.a,SUBSTR(txt.a,y+1,LEN(txt.a)))
   ENDWHILE

   RETURN i

ENDPROC

WRITELIB "Dialog" Dlg_Box.u,TrueLen.n,CharCount.n
