#ifndef PALUSER_HPP
#define PALUSER_HPP

#ifndef NO_TYPES
#define bool            int
#define i16             short
#define u16    unsigned short
#define i32             long
#define u32    unsigned long
#endif


#ifndef EXPPLUS
#define EXPPLUS   _loadds _export pascal     // C++ autoexports
#endif

#ifndef _EXPORT 
#define _EXPORT _export
#endif

class _EXPORT   palDatum;
class _EXPORT   palAnyType;

class _EXPORT   palTime;
class _EXPORT   palDateTime;
class _EXPORT   palDate;

class _EXPORT   palLogical;
class _EXPORT   palInteger;
class _EXPORT   palLongInt;
class _EXPORT   palNumber;
class _EXPORT   palMoney;

class _EXPORT   palAnnn;

class _EXPORT   palReference;
class _EXPORT   palArray;
class _EXPORT   palDynArray;
class _EXPORT   palRecord;


//
//  OPAL Language mapping of internal data types
//

#define AnyType  palDatum    *

#define Time     palTime     *
#define DateTime palDateTime *
#define Date     palDate	  *

#define Logical  palLogical  *
#define SmallInt palInteger  *
#define LongInt  palLongInt  *
#define Number   palNumber	  *
#define Money    palMoney	  *

#define String   palAnnn	  *

#define UIObject palDatum  	*

#define Array    palArray		*
#define DynArray palDynArray	*
#define Record   palRecord		*



//
// Structures used for setting and retrieve Date, Time, and
// DateType data types.
//

typedef struct pxTime
{
	unsigned short    hour;
	unsigned short    minute;
	unsigned short    secs;
	unsigned short    millisecs;
}  pxTime;

typedef struct pxDate
{
	unsigned short    year;
	unsigned short    month;
	unsigned short    day;
}  pxDate;

typedef struct pxDateTime
{
	pxDate  date;
	pxTime  time;
}  pxDateTime;


//
//  Testing for isAssigned and isBlank. 
//

bool EXPPLUS pxIsAssigned(AnyType data);
bool EXPPLUS pxIsBlank(AnyType data);

//
// Retrieving the OPAL value and placing the result in the supplied
// pointer. A conversion is tried if the types do not match. For
// example if you call pxGetValue(AnyType sm, int * pSm) and the
// ObjectPal data type is really a String. We will assume that
// string really is something like "3" and try to do a convertion.
// The returned boolean indicates the success or failure of the
// operation. The location pointer to by pSm (or other respective pointer)
// is not modified if a failure occured (ie FALSE is returned).
//

bool EXPPLUS pxGetValue(AnyType sm , int * pSm);
bool EXPPLUS pxGetValue(AnyType li , long * pLi);
bool EXPPLUS pxGetValue(AnyType nu , long double * pNu);
bool EXPPLUS pxGetValue(AnyType str, char * pStr, int size);
bool EXPPLUS pxGetValue(AnyType dat, pxDate * pDat);
bool EXPPLUS pxGetValue(AnyType tim, pxTime * pTim);
bool EXPPLUS pxGetValue(AnyType tim, pxDateTime * pdt);
bool EXPPLUS pxGetCurrency(AnyType nu, long double * pNu);

//
// Get the Data from the Array or Record given the index.
// Indexes START AT 0 (ie 0 based) not 1 based as in ObjectPAL.
// Index zero of a record is the first item in the record, index 2
// is the second and so on. The item that is return is a direct pointer
// to the data (NULL is error occurred). You can use pxSetValue or
// pxGetValue to retreive or set the value.
//

AnyType EXPPLUS pxGetData(Array    ar , unsigned long int index);
AnyType EXPPLUS pxGetData(Record   rec, unsigned long int index);


//
// Get the Data from the DynArray or Record given the name of
// the DynArray key or Record field.
//

AnyType EXPPLUS pxGetData(Record   rec, const char * name);
AnyType EXPPLUS pxGetData(DynArray da , const char * name);
bool    EXPPLUS pxSetData(DynArray da , const char * name, palDatum & data);

//
// Get the number of items of the various items (for a String
//	the number of items is the number of characters.
//

long int   EXPPLUS pxGetCount(String str);
long int   EXPPLUS pxGetCount(Array  ar);
long int   EXPPLUS pxGetCount(Record rec);

long int   EXPPLUS pxGetSize(AnyType data);


//
//  Set the value of the ObjectPal data. Do any necessary conversion.
//  Returns TRUE is successful, FALSE otherwise.
//
bool       EXPPLUS pxSetValue(AnyType    sm , int i);
bool       EXPPLUS pxSetValue(AnyType    li , long l);
bool       EXPPLUS pxSetValue(AnyType    nu , long double ld);
bool       EXPPLUS pxSetValue(AnyType    str, const char * s);
bool       EXPPLUS pxSetValue(AnyType    dat, pxDate * pDate);
bool       EXPPLUS pxSetValue(AnyType    tim, pxTime * pTime);
bool       EXPPLUS pxSetValue(AnyType    tim, pxDateTime * pDT);
bool       EXPPLUS pxSetCurrency(AnyType cu , long double money);


//
//   The following routines allow you to have Object do something
//   while you are in your C code. The idea is not to send the
//   predeclared action (or menu ids) but send your own which
//   you trap on. This allows the C routine to have ObjectPAL
//   do things on its behave. Use global Records, DynArrays, or
//   arrays to communicate info.
//
//   Issues a MENU!! event to the object. 
//    (Actually it was supposed to issue an Action Event
//     but since these functions are not supposed to be here
//     they are not QAed and therefore this bug slipped by.
//     kind of handy any way. You can still do the stuff you 
//     could have with the action.)
//
//     pxAction(u16 action) issuses the action to self.
//     pxAction(UIObject obj, u16 action) issuses the action
//        to the specified UIObject. This is really the UIObject
//        it is not the name of the object. 
//     The return value is (eventInfo.errorCode() = NOERR) in other words,
//     TRUE if no error, FALSE otherwise.
//       
//

bool       EXPPLUS pxAction(u16 action);
bool       EXPPLUS pxAction(UIObject obj, u16 action);

//
//   Posts an action event (a real Action event) to the object. 
//     pxAction(u16 action) issuses the action to self.
//     pxAction(UIObject obj, u16 action) issuses the action
//        to the specified UIObject. This is really the UIObject
//        it is not the name of the object. 
//     The return value is (eventInfo.errorCode() = NOERR) in other words,
//     TRUE if no error, FALSE otherwise.
//       
//

void       EXPPLUS pxPostAction(u16 action);
void       EXPPLUS pxPostAction(UIObject obj, u16 action);

#endif

							
