#include <windows.h>
#include "paluser.hpp"



//
// Example of setting the value of a number.
//

extern "C" void EXPPLUS setNum(AnyType nm)
{
	pxSetValue(nm, (long double) 3.12);
}

//
// Example of setting the value of a string.
//
extern "C" void EXPPLUS setString(AnyType str)
{
	pxSetValue(str, "NewValue");
}

//
// Example of setting the value of a date.
//
extern "C" void EXPPLUS setDate(AnyType da)
{
	pxDate date;

	date.day   = 15;
	date.month = 1;
	date.year  = 1993;

	pxSetValue(da, &date);

}

//
// Example of setting/retreiving the value of a record element.
//
extern "C" void EXPPLUS getRecordInfo(Record rec)
{
	AnyType pd;
	long double x;

	if (rec)
		{
		//
		// Given the record pointer, fectch the Pal datum
		// for the particular field.
		//

		pd = pxGetData(rec, "Item1");

		if (pd)
			{
			//
			// Convert the PalDatum to a C++ type.
			pxGetValue(pd, &x);

			//
			// Change the value. It will also change in rec.
		   //
			pxSetValue(pd, (long double) 3.12);
			}
		}
}


//
// Example of setting/retreiving the value of an array element.
//
extern "C" void EXPPLUS getArrayInfo(Array ar)
{
	AnyType pd;
	long double x;

	if (ar)
		{
		//
		// Given the array pointer, fectch the Pal datum
		// for the particular field. (Indexes start at 0 NOT 1).
		//

		pd = pxGetData(ar, 0);

		if (pd)
			{
			//
			// Convert the PalDatum to a C++ type.
			pxGetValue(pd, &x);

			//
			// Change the value. It will also change in ar.
		   //
			pxSetValue(pd, (long double) 3.12);
			}
		}
}

//
// Example of setting/retreiving the value of a dynArray element.
//
extern "C" void EXPPLUS getDynArrayInfo(DynArray ar)
{
	AnyType pd;
	long double x;

	if (ar)
		{
		pd = pxGetData(ar, "Fred");

		if (pd)
			{
			//
			// Convert the PalDatum to a C++ type.
			pxGetValue(pd, &x);

			//
			// Change the value. It will also change in ar.
		   //
			pxSetValue(pd, (long double) 3.12);
			}
		}
}




//
// Calling back to ObjectPal via an action
//
extern "C" void EXPPLUS uiCallBack(UIObject ui)
{
	pxAction(ui, 1);
}

//
// Posting an action back to ObjectPal via an action
//
extern "C" void EXPPLUS uiPostBack(UIObject ui)
{
	pxPostAction(ui, 2);
}
