{$A+}
{$B-}  {Evaluate Entire Logical Expression (BOOLEAN)}
{$D-}  {Generate Debugging Information}
{$F+}  {Generate addressing for Far Calls in every case}
{$I-}  {Generate code for I/O Checking}
{$L-}  {Generate local symbol information for debugging}
{$N+}  {Generates code for 80X87 - see $E - DEFINED IN OPDEFINE.INC}
{$R-}  {Generates code for range checking}
{$S-}  {Generate code to check for stack overflows}
{$V-}  {Activates string type checking for strings, etc.}

{-> OPDEFINE.INC <-}
{$DEFINE UseMouse}
{$DEFINE UseScrollBars}
{$DEFINE UseHotSpots}
{$DEFINE UseShadows}
{$DEFINE UseAdjustableWindows}
{$DEFINE FourByteDates}
{$DEFINE UseDates}
{$DEFINE PickListFields}
{.$DEFINE FastDispose}
{$DEFINE ThwartSideKick}
{$DEFINE UseStreams}
{$DEFINE SupportXMS}                        {!!.02}

{$IFOPT N+}
  {$E+}{Uses Run-Time Library To Emulate 80X87 if actual chip not present}
{$ELSE}
  {$E-}
{$ENDIF}

{.$DEFINE TSR}
{.$DEFINE OVERLAY}
{.$DEFINE NETWORK}

{$IFDEF OVERLAY}
  {$O+}  {Generate code for overlay}
{$ENDIF}

PROGRAM CombineTwoTables;

  USES
    PXENGINE,
    PRINTER,
    OPDos,
    DOS,
    OpString,
    OpCrt,
    OpRoot,
    OpCmd,
    OpFrame,
    OpPick,
    OpDir,
    OpColor,
    {$IFDEF UseMouse}
       OpMouse,
    {$ENDIF}
    OpWindow;


  TYPE
    TableType           = (Master, Update, TMaster, TUpdate, Combined);

    FieldRecPtr         = ^FieldRec;

    FieldRec            = RECORD
                            PDXFieldName   : NameString;
                            PDXFieldType   : NameString;
                            PDXFieldKeySeq : WORD;
                            PDXFieldHandle : ARRAY[Master..Combined] OF FieldHandle;
                            NextField,
                            PrevField      : FieldRecPtr;
                          END;

    TableRecPtr         = ^TableRec;

    TableRec            = RECORD
                            PDXTableType   : TableType;
                            PDXTableName   : PathStr;
                            PDXTableHandle : TableHandle;
                            PDXRecHandle   : RecordHandle;
                            PDXHiField,
                            PDXNoFields,
                            MatchedFields  : INTEGER;
                            FieldList      : FieldRecPtr;
                          END;

  CONST
    prColorSet : ColorSet = (
      TextColor       : YellowOnBlue;       TextMono        : LtGrayOnBlack;
      CtrlColor       : YellowOnBlue;       CtrlMono        : WhiteOnBlack;
      FrameColor      : CyanOnBlue;         FrameMono       : LtGrayOnBlack;
      HeaderColor     : WhiteOnCyan;        HeaderMono      : BlackOnLtGray;
      ShadowColor     : DkGrayOnBlack;      ShadowMono      : WhiteOnBlack;
      HighlightColor  : WhiteOnRed;         HighlightMono   : BlackOnLtGray;
      PromptColor     : BlackOnCyan;        PromptMono      : LtGrayOnBlack;
      SelPromptColor  : BlackOnCyan;        SelPromptMono   : LtGrayOnBlack;
      ProPromptColor  : BlackOnCyan;        ProPromptMono   : LtGrayOnBlack;
      FieldColor      : YellowOnBlue;       FieldMono       : LtGrayOnBlack;
      SelFieldColor   : BlueOnCyan;         SelFieldMono    : WhiteOnBlack;
      ProFieldColor   : LtGrayOnBlue;       ProFieldMono    : LtGrayOnBlack;
      ScrollBarColor  : CyanOnBlue;         ScrollBarMono   : LtGrayOnBlack;
      SliderColor     : CyanOnBlue;         SliderMono      : WhiteOnBlack;
      HotSpotColor    : BlackOnCyan;        HotSpotMono     : BlackOnLtGray;
      BlockColor      : YellowOnCyan;       BlockMono       : WhiteOnBlack;
      MarkerColor     : WhiteOnMagenta;     MarkerMono      : BlackOnLtGray;
      DelimColor      : BlueOnCyan;         DelimMono       : WhiteOnBlack;
      SelDelimColor   : BlueOnCyan;         SelDelimMono    : WhiteOnBlack;
      ProDelimColor   : BlueOnCyan;         ProDelimMono    : WhiteOnBlack;
      SelItemColor    : YellowOnCyan;       SelItemMono     : BlackOnLtGray;
      ProItemColor    : LtGrayOnBlue;       ProItemMono     : LtGrayOnBlack;
      HighItemColor   : WhiteOnBlue;        HighItemMono    : WhiteOnBlack;
      AltItemColor    : WhiteOnBlue;        AltItemMono     : WhiteOnBlack;
      AltSelItemColor : WhiteOnCyan;        AltSelItemMono  : BlackOnLtGray;
      FlexAHelpColor  : WhiteOnBlue;        FlexAHelpMono   : WhiteOnBlack;
      FlexBHelpColor  : WhiteOnBlue;        FlexBHelpMono   : WhiteOnBlack;
      FlexCHelpColor  : LtCyanOnBlue;       FlexCHelpMono   : BlackOnLtGray;
      UnselXrefColor  : YellowOnBlue;       UnselXrefMono   : LtBlueOnBlack;
      SelXrefColor    : WhiteOnMagenta;     SelXrefMono     : BlackOnLtGray;
      MouseColor      : WhiteOnRed;         MouseMono       : BlackOnLtGray
    );

    BooleanArray        : ARRAY[FALSE..TRUE] OF CHAR = ('F', 'T');

  VAR
    prTables            : ARRAY[Master..Combined] OF TableRec;
    prField             : FieldRec;
    prResult            : INTEGER;
    ucChar              : CHAR;
    ucStatus,
    ucWindow            : WindowPtr;

{-----------------------------------------------------------------------------}
    FUNCTION prError(PDXReturnCode : INTEGER) : BOOLEAN;
      BEGIN
        IF PDXReturnCode <> PXSuccess THEN
          BEGIN
            ucStatus^.wFastWrite(Pad('',78), 23, 1, $34);
            ucStatus^.wFastText('COMBINE: '+PXErrMsg(PDXReturnCode), 23, 2);
          END;
        prError := PDXReturnCode <> PXSuccess;
      END;

{-----------------------------------------------------------------------------}
    FUNCTION FileRequester(       lcMask         : NameStr;
                                  lcHeader       : STRING)
                                                 : PathStr;
      VAR
        CSDirectory   : DirList;
        LocalOK,
        Finished      : Boolean;
        LocalStr      : STRING;

      BEGIN
        FileRequester := '';
        LocalOK := FALSE;
        if not CSDirectory.InitCustom(15, 5, 65, ScreenHeight-5,                 {Window coordinates}
                              prColorSet,               {ColorSet}
                              DefWindowOptions or wBordered, {Window options}
                              MaxAvail,                      {Heap space for files}
                              PickVertical,                  {Pick orientation}
                             SingleFile)                    {Command handler}
        then
          BEGIN
            WriteLn('Failed to Init DirList,  Status = ', InitStatus);
            Halt;
          END;
        {Set desired DirList features}
        WITH CSDirectory DO
          BEGIN
            SetPosLimits(1, 1, ScreenWidth, ScreenHeight-1);
            SetPadSize(1, 1);
            diOptionsOn(diDirsUpcase+diSetFirstFile+diShowDrives);
            SkipDrives(['A','B']);
            SetDriveDelim('[->','<-]');
            wFrame.AddHeader(lcHeader, heTL);
            wFrame.AddShadow(shBR, shSeeThru);
            AddMaskHeader(True, 1, 30, heBL);
            SetSortOrder(SortDirName);
            SetAllFormat('<dir>', 'NNN-dd-yyyy', 'hh:mm');
            SetMask(lcMask, AnyFile);

            {$IFDEF UseMouse}
             IF MouseInstalled THEN
               BEGIN
                 PickCommands.cpOptionsOn(cpEnableMouse);
                 wFrame.AddScrollBar(frRR,0,MaxLongInt, prColorSet);
               END;
            {$ENDIF}
          END;

        {Pick a file}
        Finished := False;
        REPEAT
          CSDirectory.Process;
          CASE CSDirectory.GetLastCommand of
            ccSelect : BEGIN
                         FileRequester := CSDirectory.GetSelectedPath;
                         LocalOK := TRUE;
                         Finished := TRUE;
                       END;
            ccError  : BEGIN{!!.01}
                         FastWrite('Error '+Long2Str(CSDirectory.GetLastError),
                                                     ScreenHeight, 1, TextAttr);
                         Finished := True;
                       END;
            ccQuit   : Finished := True;
          END;
        UNTIL Finished;
        CSDirectory.Done;
      END;

{-----------------------------------------------------------------------------}
  FUNCTION prFieldList(  VAR lcTable             : TableRec;
                             lcNameString        : STRING;
                             lcNewField          : BOOLEAN)
                                                 : FieldRecPtr;
    VAR
      lcField           : FieldRecPtr;

    BEGIN
      lcField := prTables[Master].FieldList;
      IF lcField <> NIL THEN
        WHILE (StUpCase(lcField^.PDXFieldName) <> StUpCase(lcNameString)) AND
              (lcField <> prTables[Master].FieldList^.PrevField) DO
          lcField := lcField^.NextField;
      IF (lcField <> NIL) AND
         (StUpCase(lcField^.PDXFieldName) = StUpCase(lcNameString)) THEN
        BEGIN
          IF lcNewField THEN
            lcField := NIL;
        END
      ELSE
        BEGIN
          NEW(lcField);
          FILLCHAR(lcField^, SIZEOF(lcField^), 0);
          IF prTables[Master].FieldList = NIL THEN
            BEGIN
              lcField^.NextField := lcField;
              lcField^.PrevField := lcField;
              prTables[Master].FieldList := lcField;
            END;
          prTables[Master].FieldList^.PrevField^.NextField := lcField;
          lcField^.NextField := prTables[Master].FieldList;
          lcField^.PrevField := prTables[Master].FieldList^.PrevField;
          prTables[Master].FieldList^.PrevField := lcField;
          lcField^.PDXFieldName := lcNameString;
          lcTable.FieldList := prTables[Master].FieldList;
        END;

      prFieldList := lcField;
    END;

{-----------------------------------------------------------------------------}
  FUNCTION PDXMatchedFields(  VAR lcPDXTable1,
                                  lcPDXTable2    : TableRec)
                                                 : BOOLEAN;
    VAR
      lcField           : FieldRecPtr;

    BEGIN
      lcPDXTable1.MatchedFields := 0;
      lcPDXTable2.MatchedFields := 0;
      lcField := lcPDXTable1.FieldList;
      REPEAT
        {WRITELN(LST, 'Matched-> ',
                     lcField^.PDXFieldName, ', ',
                     lcField^.PDXFieldHandle[lcPDXTable1.PDXTableType], ', ',
                     lcField^.PDXFieldHandle[lcPDXTable2.PDXTableType]);}
        IF (lcField^.PDXFieldHandle[lcPDXTable1.PDXTableType] > 0) AND
           (lcField^.PDXFieldHandle[lcPDXTable2.PDXTableType] > 0) THEN
          BEGIN
            {WRITELN(LST, 'Matched-> ', lcField^.PDXFieldName);}
            lcPDXTable1.MatchedFields := lcPDXTable1.MatchedFields + 1;
          END;
        lcField := lcField^.NextField;
      UNTIL lcField = lcPDXTable1.FieldList;
      {WRITELN(LST, #12);}
      lcPDXTable2.MatchedFields := lcPDXTable1.MatchedFields;
    END;

{-----------------------------------------------------------------------------}
  FUNCTION ReadPDXFields(     VAR lcPDXTable     : TableRec)
                                                 : BOOLEAN;
    VAR
      lcOK              : BOOLEAN;
      lcIter            : WORD;
      lcField           : FieldRecPtr;
      lcFieldName       : NameString;
      lcFieldType       : NameString;

    BEGIN
      lcOK := FALSE;
      IF NOT prError(PXRecNFlds(lcPDXTable.PDXTableHandle,lcPDXTable.PDXNoFields)) THEN
        BEGIN
          {WRITELN(LST, lcPDXTable.PDXTableName);}
          FOR lcIter := 1 TO lcPDXTable.PDXNoFields DO
            BEGIN
              lcOK := (prError(PXFldName(lcPDXTable.PDXTableHandle, lcIter, lcFieldName)) = FALSE) AND
                      (prError(PXFldType(lcPDXTable.PDXTableHandle, lcIter, lcFieldType)) = FALSE);
              IF lcOK THEN
                BEGIN
                  lcField := prFieldList(lcPDXTable, lcFieldName, TRUE);
                  IF lcField = NIL THEN
                    BEGIN
                      lcField := prFieldList(lcPDXTable, lcFieldName, FALSE);
                      IF (lcField^.PDXFieldType[1] = lcFieldType[1]) THEN
                        BEGIN
                          lcField^.PDXFieldHandle[lcPDXTable.PDXTableType] := lcIter;
                        END
                      ELSE
                        BEGIN
                          ucStatus^.wFastWrite(Pad('',78), 23, 1, $34);
                          ucStatus^.wFastText('COMBINE: Fatal Field Type Incompatibility ['+Trim(lcFieldName)+']',
                                               23, 2);
                          lcOK := FALSE;
                        END;
                    END
                  ELSE
                    BEGIN
                      lcField^.PDXFieldHandle[lcPDXTable.PDXTableType] := lcIter;
                      lcField^.PDXFieldName := lcFieldName;
                      lcField^.PDXFieldType := lcFieldType;
                    END;
                  {WRITELN(LST, lcIter:3, ', ', lcField^.PDXFieldName:25, '->', lcField^.PDXFieldType);}
                END;
            END;
          {WRITELN(LST, #12);}
        END;
      ReadPDXFields := lcOK;
    END;

{-----------------------------------------------------------------------------}
  PROCEDURE FieldPLStr(      Item            : WORD;
                             Mode            : pkMode;
                         VAR IType           : pkItemType;
                         VAR IString         : STRING;
                             PickPtr         : PickListPtr);
    VAR
      lcField         : FieldRecPtr;
      lcFieldCount    : WORD;

    BEGIN
      lcField := prTables[Master].FieldList;
      lcFieldCount := 0;
      REPEAT
        IF (lcField^.PDXFieldHandle[Master] <> 0) AND
           (lcField^.PDXFieldHandle[Update] <> 0) THEN
          BEGIN
            lcFieldCount := lcFieldCount + 1;
            IF Item = lcFieldCount THEN
              IString := lcField^.PDXFieldName;
          END;
        lcField := lcField^.NextField;
      UNTIL lcField = prTables[Master].FieldList;
    END;

{-----------------------------------------------------------------------------}
  PROCEDURE PickPDXMatchFields;

      VAR
        lcOK              : BOOLEAN;
        lcField           : FieldRecPtr;
        lcFieldPL         : PickList;
        lcFieldName       : NameString;
        lcSelectCount     : WORD;

      BEGIN
        IF PDXMatchedFields(prTables[Master],
                            prTables[Update]) THEN;
        lcOK := lcFieldPL.InitCustom(30,5,50,10,
                                     prColorSet,
                                     DefWindowOptions OR wBordered,
                                     20,
                                     prTables[Master].MatchedFields,
                                     FieldPLStr,
                                     PickVertical,
                                     SingleChoice);
        IF lcOK THEN
          BEGIN
            NEW(ucWindow, InitCustom(2, 2, 25, ScreenHeight-3,
                                     prColorSet,
                                     wBordered+wClear+wSaveContents+wResizeable));
            IF (ucWindow <> NIL) THEN
              BEGIN
                ucWindow^.wFrame.AddHeader(' Selected Fields ',heTC);
                ucWindow^.wFrame.AddShadow(shBR, shSeeThru);
                ucWindow^.Draw;
                lcFieldPL.SetSearchMode(PickCharSearch);
                WITH lcFieldPL.wFrame DO
                  BEGIN
                    AddShadow(shBR, shOverWrite);
                    AddHeader(' Select Fields ', heTC);
                    AddHeader(' <ESC> = DONE ', heBC);
                  END;
                lcSelectCount := 0;
                REPEAT
                  lcFieldPL.Process;
                  IF lcFieldPL.GetLastCommand = ccSelect THEN
                    BEGIN
                      lcSelectCount := lcSelectCount + 1;
                      lcFieldName := lcFieldPL.GetLastChoiceString;
                      lcFieldPL.Erase;
                      lcField := prTables[Master].FieldList;
                      REPEAT
                        IF (StUpCase(lcFieldName) = StUpCase(lcField^.PDXFieldName)) AND
                           (lcField^.PDXFieldKeySeq = 0) THEN
                          BEGIN
                            lcField^.PDXFieldKeySeq := lcSelectCount;
                            prTables[Master].PDXHiField := lcSelectCount;
                            ucWindow^.wFastText(lcFieldName, lcSelectCount, 2);
                          END;
                        lcField := lcField^.NextField;
                      UNTIL lcField = prTables[Master].FieldList;
                    END
                  ELSE
                    lcFieldPL.Erase;
                UNTIL lcFieldPL.GetLastCommand <> ccSelect;
                ucWindow^.Erase;
                DISPOSE(ucWindow, Done);
              END;
            lcFieldPL.Done;
          END;
      END;

{-----------------------------------------------------------------------------}
  FUNCTION PDXGetPut(    VAR lcGetTable,
                             lcPutTable          : TableRec;
                         VAR lcField             : FieldRecPtr)
                                                 : BOOLEAN;
    VAR
      lcDate            : TDate;
      lcAlpha           : STRING;
      lcDouble          : DOUBLE;
      lcShort           : INTEGER;
      lcLong            : LONGINT;
      lcOK              : BOOLEAN;

    BEGIN
      lcOK := FALSE;
      IF lcField <> NIL THEN
        CASE lcField^.PDXFieldType[1] OF
          'A' : BEGIN
                  lcOK := (prError(PXGetAlpha(lcGetTable.PDXRecHandle,
                                              lcField^.PDXFieldHandle[lcGetTable.PDXTableType],
                                              lcAlpha)) = FALSE) AND
                          (prError(PXPutAlpha(lcPutTable.PDXRecHandle,
                                              lcField^.PDXFieldHandle[lcPutTable.PDXTableType],
                                              lcAlpha)) = FALSE);
                END;
          'D' : BEGIN
                  lcOK := (prError(PXGetDate(lcGetTable.PDXRecHandle,
                                             lcField^.PDXFieldHandle[lcGetTable.PDXTableType],
                                             lcDate)) = FALSE) AND
                          (prError(PXPutDate(lcPutTable.PDXRecHandle,
                                             lcField^.PDXFieldHandle[lcPutTable.PDXTableType],
                                             lcDate)) = FALSE);
                END;
          'N',
          'S' : BEGIN
                  lcOK := (prError(PXGetLong(lcGetTable.PDXRecHandle,
                                             lcField^.PDXFieldHandle[lcGetTable.PDXTableType],
                                             lcLong)) = FALSE) AND
                          (prError(PXPutLong(lcPutTable.PDXRecHandle,
                                             lcField^.PDXFieldHandle[lcPutTable.PDXTableType],
                                             lcLong)) = FALSE);
                END;
          '$' : BEGIN
                  lcOK := (prError(PXGetDoub(lcGetTable.PDXRecHandle,
                                             lcField^.PDXFieldHandle[lcGetTable.PDXTableType],
                                             lcDouble)) = FALSE) AND
                          (prError(PXPutDoub(lcPutTable.PDXRecHandle,
                                             lcField^.PDXFieldHandle[lcPutTable.PDXTableType],
                                             lcDouble)) = FALSE);
                END;
        END;
      PDXGetPut := lcOK;
    END;

{-----------------------------------------------------------------------------}
  FUNCTION ReorganizePDXSourceTables(VAR lcMasterTable,
                                         lcUpdateTable,
                                         lcMasterTempTable,
                                         lcUpdateTempTable : TableRec)
                                                           : BOOLEAN;
    VAR
      lcEOF,
      lcOK              : BOOLEAN;
      lcField           : FieldRecPtr;
      lcMstrFldNdx,
      lcUpFldNdx,
      lcSort            : WORD;
      lcRecordNo        : LONGINT;
      lcMasterNames,
      lcMasterTypes,
      lcUpdateNames,
      lcUpdateTypes     : NamesArrayPtr;
      lcFieldHandles    : FieldHandleArray;

    BEGIN
      NEW(lcMasterNames);
      NEW(lcMasterTypes);
      NEW(lcUpdateNames);
      NEW(lcUpdateTypes);
      lcMasterTempTable.PDXTableName := 'TEMP1';
      lcUpdateTempTable.PDXTableName := 'TEMP2';

      lcMstrFldNdx := 0;
      lcUpFldNdx := 0;
      lcSort  := 0;
      WHILE lcSort < lcMasterTable.PDXHiField DO
        BEGIN
          lcSort := lcSort + 1;
          lcField := lcMasterTable.FieldList;
          REPEAT
            IF lcField^.PDXFieldKeySeq = lcSort THEN
              BEGIN
                lcMstrFldNdx                 := lcMstrFldNdx + 1;
                lcUpFldNdx                   := lcUpFldNdx + 1;
                lcMasterNames^[lcMstrFldNdx] := lcField^.PDXFieldName;
                lcMasterTypes^[lcMstrFldNdx] := lcField^.PDXFieldType;
                lcUpdateNames^[lcUpFldNdx]   := lcField^.PDXFieldName;
                lcUpdateTypes^[lcUpFldNdx]   := lcField^.PDXFieldType;
                lcField^.PDXFieldHandle[lcMasterTempTable.PDXTableType] := lcMstrFldNdx;
                lcField^.PDXFieldHandle[lcUpdateTempTable.PDXTableType] := lcUpFldNdx;
              END;
            lcField := lcField^.NextField;
          UNTIL lcField = lcMasterTable.FieldList;
        END;

      lcField := lcMasterTable.FieldList;
      REPEAT
        IF lcField^.PDXFieldKeySeq = 0 THEN
          BEGIN
            IF lcField^.PDXFieldHandle[lcMasterTable.PDXTableType] > 0 THEN
              BEGIN
                lcMstrFldNdx := lcMstrFldNdx + 1;
                lcMasterNames^[lcMstrFldNdx] := lcField^.PDXFieldName;
                lcMasterTypes^[lcMstrFldNdx] := lcField^.PDXFieldType;
                lcField^.PDXFieldHandle[lcMasterTempTable.PDXTableType] := lcMstrFldNdx;
              END;
            IF lcField^.PDXFieldHandle[lcUpdateTable.PDXTableType] > 0 THEN
              BEGIN
                lcUpFldNdx := lcUpFldNdx + 1;
                lcUpdateNames^[lcUpFldNdx] := lcField^.PDXFieldName;
                lcUpdateTypes^[lcUpFldNdx] := lcField^.PDXFieldType;
                lcField^.PDXFieldHandle[lcUpdateTempTable.PDXTableType] := lcUpFldNdx;
              END;
          END;
        lcField := lcField^.NextField;
      UNTIL lcField = lcMasterTable.FieldList;

      lcUpFldNdx := lcUpFldNdx + 1;
      lcUpdateNames^[lcUpFldNdx] := 'PDXMatch';
      lcUpdateTypes^[lcUpFldNdx] := 'N';

      lcOK := NOT prError(PXTblCreate(lcMasterTempTable.PDXTableName, lcMstrFldNdx, lcMasterNames, lcMasterTypes)) AND
              NOT prError(PXKeyAdd(lcMasterTempTable.PDXTableName, lcMasterTable.PDXHiField, lcFieldHandles, Primary)) AND
              NOT prError(PXTblOpen(lcMasterTempTable.PDXTableName, lcMasterTempTable.PDXTableHandle, 0, FALSE)) AND
              NOT prError(PXRecBufOpen(lcMasterTempTable.PDXTableHandle, lcMasterTempTable.PDXRecHandle)) AND
              NOT prError(PXTblCreate(lcUpdateTempTable.PDXTableName, lcUpFldNdx, lcUpdateNames, lcUpdateTypes)) AND
              NOT prError(PXKeyAdd(lcUpdateTempTable.PDXTableName, lcMasterTable.PDXHiField, lcFieldHandles, Primary)) AND
              NOT prError(PXTblOpen(lcUpdateTempTable.PDXTableName, lcUpdateTempTable.PDXTableHandle, 0, FALSE)) AND
              NOT prError(PXRecNFlds(lcUpdateTempTable.PDXTableHandle, lcUpdateTempTable.PDXNoFields)) AND
              NOT prError(PXRecBufOpen(lcUpdateTempTable.PDXTableHandle, lcUpdateTempTable.PDXRecHandle));


      IF lcOK THEN
        BEGIN
          ucStatus^.wFastWrite(Pad('',78), 5, 1, $34);
          ucStatus^.wFastText('Reorganizing Master Table; Record #->', 5, 2);
          lcRecordNo := 0;
          REPEAT
            lcRecordNo := lcRecordNo + 1;
            ucStatus^.wFastText(Long2Str(lcRecordNo), 5, 45);
            lcOK := NOT prError(PXRecGet(lcMasterTable.PDXTableHandle, lcMasterTable.PDXRecHandle));
            IF lcOK THEN
              BEGIN
                lcField := lcMasterTable.FieldList;
                REPEAT
                  IF lcOK AND
                     (lcField^.PDXFieldHandle[lcMasterTable.PDXTableType] > 0) AND
                     (lcField^.PDXFieldHandle[lcMasterTempTable.PDXTableType] > 0) THEN
                    lcOK := PDXGetPut(lcMasterTable, lcMasterTempTable, lcField);
                  lcField := lcField^.NextField;
                UNTIL lcField = lcMasterTable.FieldList;
                IF lcOK THEN
                  BEGIN
                    lcOK := prError(PXRecAppend(lcMasterTempTable.PDXTableHandle, lcMasterTempTable.PDXRecHandle)) = FALSE;
                    lcEOF := prError(PXRecNext(lcMasterTable.PDXTableHandle));
                  END;
              END
            ELSE
              lcOK := FALSE;
          UNTIL lcEOF OR
                NOT lcOK;
          IF lcOK THEN
            BEGIN
              ucStatus^.wFastWrite(Pad('',78), 6, 1, $34);
              ucStatus^.wFastText('Reorganizing Update Table; Record #->', 6, 2);
              lcRecordNo := 0;
              REPEAT
                lcRecordNo := lcRecordNo + 1;
                ucStatus^.wFastText(Long2Str(lcRecordNo), 6, 45);
                lcOK := NOT prError(PXRecGet(lcUpdateTable.PDXTableHandle, lcUpdateTable.PDXRecHandle));
                IF lcOK THEN
                  BEGIN
                    lcField := lcMasterTable.FieldList;
                    REPEAT
                      IF lcOK AND
                         (lcField^.PDXFieldHandle[lcUpdateTable.PDXTableType] > 0) AND
                         (lcField^.PDXFieldHandle[lcUpdateTempTable.PDXTableType] > 0) THEN
                        lcOK := PDXGetPut(lcUpdateTable, lcUpdateTempTable, lcField);
                      lcField := lcField^.NextField
                    UNTIL lcField = lcMasterTable.FieldList;
                    IF lcOK THEN
                      BEGIN
                        lcOK := prError(PXRecAppend(lcUpdateTempTable.PDXTableHandle, lcUpdateTempTable.PDXRecHandle)) = FALSE;
                        lcEOF := prError(PXRecNext(lcUpdateTable.PDXTableHandle));
                      END;
                  END
                ELSE
                  lcOK := FALSE;
              UNTIL lcEOF OR
                    NOT lcOK;
            END;
        END;

      lcEOF := NOT prError(PXRecBufClose(lcMasterTable.PDXRecHandle)) AND
               NOT prError(PXTblClose(lcMasterTable.PDXTableHandle)) AND
               NOT prError(PXRecBufClose(lcUpdateTable.PDXRecHandle)) AND
               NOT prError(PXTblClose(lcUpdateTable.PDXTableHandle));

      {SHOULD DISPOSE OF OLD FIELDLIST BEFORE ASSIGNMENT}
      DISPOSE(lcMasterNames);
      DISPOSE(lcMasterTypes);
      DISPOSE(lcUpdateNames);
      DISPOSE(lcUpdateTypes);

      ReorganizePDXSourceTables := lcOK;
    END;

{-----------------------------------------------------------------------------}
  FUNCTION CreatePDXCombinedTable(VAR lcCombinedTable : TableRec)
                                                      : BOOLEAN;
    VAR
      lcNameArray,
      lcTypeArray       : NamesArrayPtr;
      lcFields,
      lcSort            : WORD;
      lcField           : FieldRecPtr;
      lcOK              : BOOLEAN;

    BEGIN
      NEW(lcNameArray);
      NEW(lcTypeArray);
      lcSort  := 0;
      lcFields := 0;

      WHILE lcSort < lcCombinedTable.PDXHiField DO
        BEGIN
          lcSort := lcSort + 1;
          lcField := lcCombinedTable.FieldList;
          REPEAT
            IF lcField^.PDXFieldKeySeq = lcSort THEN
              BEGIN
                lcFields := lcFields + 1;
                lcNameArray^[lcFields] := lcField^.PDXFieldName;
                lcTypeArray^[lcFields] := lcField^.PDXFieldType;
                lcField^.PDXFieldHandle[lcCombinedTable.PDXTableType] := lcFields;
              END;
            lcField := lcField^.NextField;
          UNTIL lcField = lcCombinedTable.FieldList;
        END;

      lcField := lcCombinedTable.FieldList;
      REPEAT
        IF lcField^.PDXFieldKeySeq = 0 THEN
          BEGIN
            IF lcField^.PDXFieldHandle[TMaster] > 0 THEN
              BEGIN
                lcFields := lcFields + 1;
                lcNameArray^[lcFields] := lcField^.PDXFieldName;
                lcTypeArray^[lcFields] := lcField^.PDXFieldType;
                lcField^.PDXFieldHandle[lcCombinedTable.PDXTableType] := lcFields;
              END
            ELSE
              IF lcField^.PDXFieldHandle[TUpdate] > 0 THEN
                BEGIN
                  lcFields := lcFields + 1;
                  lcNameArray^[lcFields] := lcField^.PDXFieldName;
                  lcTypeArray^[lcFields] := lcField^.PDXFieldType;
                  lcField^.PDXFieldHandle[lcCombinedTable.PDXTableType] := lcFields;
                END;
          END;
        lcField := lcField^.NextField;
      UNTIL lcField = lcCombinedTable.FieldList;

      lcOK := NOT prError(PXTblCreate(lcCombinedTable.PDXTableName,lcFields,lcNameArray,lcTypeArray));
      DISPOSE(lcNameArray);
      DISPOSE(lcTypeArray);
      CreatePDXCombinedTable := lcOK;
    END;

{-----------------------------------------------------------------------------}
  FUNCTION PDXIndexedLoad(    VAR lcMasterTable,
                                  lcUpdateTable,
                                  lcCombinedTable: TableRec)
                                                 : BOOLEAN;
    VAR
      lcTableType       : TableType;
      lcRecordNo        : RecordNumber;
      lcMatch,
      lcOK              : BOOLEAN;
      lcField           : FieldRecPtr;

    BEGIN
      {lcField := lcMasterTable.FieldList;
      REPEAT
        WRITE(LST, lcField^.PDXFieldName:20, ', ', lcField^.PDXFieldKeySeq:5, '->');
        FOR lcTableType := Master TO Combined DO
          WRITE(LST, lcField^.PDXFieldHandle[lcTableType]:5, ', ');
        WRITELN(LST);
        lcField := lcField^.NextField;
      UNTIL lcField = lcMasterTable.FieldList;
      WRITELN(LST, #12);}

      lcOK := TRUE;
      lcRecordNo := 0;
      ucStatus^.wFastWrite(Pad('',78), 7, 1, $34);
      ucStatus^.wFastText('Combining Tables; Record #->', 7, 2);
      IF NOT prError(PXRecFirst(lcMasterTable.PDXTableHandle)) THEN
        REPEAT
          lcOK := NOT prError(PXRecGet(lcMasterTable.PDXTableHandle, lcMasterTable.PDXRecHandle));

          IF lcOK THEN
            BEGIN
              lcRecordNo := lcRecordNo + 1;
              ucStatus^.wFastText(Long2Str(lcRecordNo), 7, 45);
              lcField := lcMasterTable.FieldList;
              REPEAT
                IF lcOK AND
                   (lcField^.PDXFieldKeySeq > 0) THEN
                  lcOK := PDXGetPut(lcMasterTable, lcUpdateTable, lcField);
                lcField := lcField^.NextField
              UNTIL lcField = lcMasterTable.FieldList;

              IF NOT prError(PXSrchKey(lcUpdateTable.PDXTableHandle,
                                       lcUpdateTable.PDXRecHandle,
                                       lcCombinedTable.PDXHiField,
                                       SearchFirst)) AND
                 NOT prError(PXRecGet( lcUpdateTable.PDXTableHandle,
                                       lcUpdateTable.PDXRecHandle)) AND
                 NOT prError(PXPutLong(lcUpdateTable.PDXRecHandle,
                                       lcUpdateTable.PDXNoFields,
                                       1)) AND
                 NOT prError(PXRecUpdate(lcUpdateTable.PDXTableHandle,
                                         lcUpdateTable.PDXRecHandle)) THEN
                BEGIN
                  lcField := lcMasterTable.FieldList;
                  REPEAT
                    IF lcOK THEN
                      BEGIN
                        IF (lcField^.PDXFieldHandle[lcUpdateTable.PDXTableType] > 0) THEN
                          lcOK := PDXGetPut(lcUpdateTable, lcCombinedTable, lcField)
                        ELSE
                          lcOK := PDXGetPut(lcMasterTable, lcCombinedTable, lcField);
                      END;
                    lcField := lcField^.NextField
                  UNTIL lcField = lcMasterTable.FieldList;
                END
              ELSE
                BEGIN
                  lcOK := NOT prError(PXRecBufEmpty(lcCombinedTable.PDXRecHandle));
                  lcField := lcMasterTable.FieldList;
                  REPEAT
                    IF lcOK AND
                       (lcField^.PDXFieldHandle[lcMasterTable.PDXTableType] > 0) THEN
                      lcOK := PDXGetPut(lcMasterTable, lcCombinedTable, lcField);
                    lcField := lcField^.NextField
                  UNTIL lcField = lcMasterTable.FieldList;
                END;

              IF lcOK THEN
                lcOK := (prError(PXRecAppend(lcCombinedTable.PDXTableHandle,
                                             lcCombinedTable.PDXRecHandle)) = FALSE) AND
                        (prError(PXRecNext(lcMasterTable.PDXTableHandle)) = FALSE);
            END;
        UNTIL NOT lcOK;

      IF NOT prError(PXRecFirst(lcUpdateTable.PDXTableHandle)) THEN
        REPEAT
          lcOK := NOT prError(PXPutBlank(lcUpdateTable.PDXRecHandle,
                                         lcUpdateTable.PDXNoFields)) AND
                  NOT prError(PXSrchFld( lcUpdateTable.PDXTableHandle,
                                         lcUpdateTable.PDXRecHandle,
                                         lcUpdateTable.PDXNoFields,
                                         SearchNext)) AND
                  NOT prError(PXRecGet(  lcUpdateTable.PDXTableHandle,
                                         lcUpdateTable.PDXRecHandle)) AND
                  NOT prError(PXRecBufEmpty(lcCombinedTable.PDXRecHandle));

          IF lcOK THEN
            BEGIN
              lcRecordNo := lcRecordNo + 1;
              ucStatus^.wFastText(Long2Str(lcRecordNo), 7, 45);
              lcField := lcMasterTable.FieldList;
              REPEAT
                IF lcOK AND
                   (lcField^.PDXFieldHandle[lcUpdateTable.PDXTableType] > 0) THEN
                  lcOK := PDXGetPut(lcUpdateTable, lcCombinedTable, lcField);
                lcField := lcField^.NextField
              UNTIL lcField = lcMasterTable.FieldList;

              IF lcOK THEN
                lcOK := (prError(PXRecAppend(lcCombinedTable.PDXTableHandle,
                                             lcCombinedTable.PDXRecHandle)) = FALSE);
            END;
        UNTIL NOT lcOK;
    END;

{-----------------------------------------------------------------------------}
  PROCEDURE CombineMain;
    VAR
      lcTableType       : TableType;
      lcOK              : BOOLEAN;
      EraseFile         : FILE;

    BEGIN
      FOR lcTableType := Master TO Combined DO
        BEGIN
          FILLCHAR(prTables[lcTableType], SIZEOF(TableRec), 0);
          prTables[lcTableType].PDXTableType := lcTableType;
        END;
      IF NOT prError(PXLoadOverlay(JustPathName(ParamStr(0))+'\'+JustName(ParamStr(0))+'.OVL')) AND
         NOT prError(PXSetDefaults(32, 5, 10, 3, 10, SortOrderASCII)) THEN
        BEGIN
          {$IFDEF NETWORK}
            IF NOT prError(PXNetInit, NetDir, NetType, NetUserName) THEN
          {$ELSE}
            IF NOT prError(PXInit) THEN
          {$ENDIF}
            BEGIN
              prTables[Master].PDXTableName := FileRequester('*.DB', 'Master Table');
              IF NOT prError(PXTblOpen(prTables[Master].PDXTableName, prTables[Master].PDXTableHandle, 0, FALSE)) AND
                 NOT prError(PXRecBufOpen(prTables[Master].PDXTableHandle, prTables[Master].PDXRecHandle)) AND
                 ReadPDXFields(prTables[Master]) THEN
                BEGIN
                  prTables[Update].PDXTableName := FileRequester('*.DB', 'Update Table');
                  IF NOT prError(PXTblOpen(prTables[Update].PDXTableName, prTables[Update].PDXTableHandle, 0, FALSE)) AND
                     NOT prError(PXRecBufOpen(prTables[Update].PDXTableHandle,
                                              prTables[Update].PDXRecHandle)) AND
                     ReadPDXFields(prTables[Update]) THEN
                   BEGIN
                     PickPDXMatchFields;
                     IF ReorganizePDXSourceTables(prTables[Master],  prTables[Update],
                                                  prTables[TMaster], prTables[TUpdate]) THEN;
                        BEGIN
                          prTables[Combined].PDXTableName := 'COMBINE';
                          prTables[TMaster].FieldList    := prTables[Master].FieldList;
                          prTables[TUpdate].FieldList    := prTables[Master].FieldList;
                          prTables[Combined].FieldList    := prTables[Master].FieldList;
                          prTables[Combined].PDXHiField   := prTables[Master].PDXHiField;
                          IF CreatePDXCombinedTable(   prTables[Combined]) AND
                             NOT prError(PXTblOpen(    prTables[Combined].PDXTableName,
                                                       prTables[Combined].PDXTableHandle,
                                                       0,
                                                       FALSE)) AND
                             NOT prError(PXRecBufOpen( prTables[Combined].PDXTableHandle,
                                                       prTables[Combined].PDXRecHandle)) THEN
                            BEGIN
                              lcOK := PDXIndexedLoad(prTables[TMaster], prTables[TUpdate], prTables[Combined]) AND
                                      NOT prError(PXRecBufClose(prTables[TMaster].PDXRecHandle)) AND
                                      NOT prError(PXTblClose(prTables[TMaster].PDXTableHandle)) AND
                                      NOT prError(PXRecBufClose(prTables[TUpdate].PDXRecHandle)) AND
                                      NOT prError(PXTblClose(prTables[TUpdate].PDXTableHandle)) AND
                                      NOT prError(PXRecBufClose(prTables[Combined].PDXRecHandle)) AND
                                      NOT prError(PXTblClose(prTables[Combined].PDXTableHandle)) AND
                                      NOT prError(PXTblDelete(prTables[TMaster].PDXTableName)) AND
                                      NOT prError(PXTblDelete(prTables[TUpdate].PDXTableName));
                              IF lcOK THEN
                                ucStatus^.wFastWrite(Pad('',78), 23, 1, $34);
                            END;
                        END;
                   END;
                END;
            END;

          IF prError(PXExit) THEN
            BEGIN
              WRITELN('ERROR... Halting Program');
              HALT(1);
            END;
        END;
    END;

  BEGIN
    NEW(ucStatus, InitCustom(2, 2, ScreenWidth-1, ScreenHeight-1,
                             prColorSet,
                             wBordered+wClear+wSaveContents+wResizeable));
    IF (ucStatus <> NIL) THEN
      BEGIN
        ucStatus^.wFrame.AddHeader(' Table Combination Status [V1.00] ',heTC);
        ucStatus^.Draw;
        CombineMain;
        ucStatus^.wFrame.AddHeader(' Press any key to EXIT ',heBC);
        ucStatus^.wFrame.DrawHeader(1);
        ucChar := READKEY;
        ucStatus^.Erase;
        DISPOSE(ucStatus, Done);
      END;
  END.
