;==============  CAPture FAMily members PRocedures  ==================
;
; The documentation of concepts for this program came in the file
; CAPFAM.DOC.  THIS script is a set of tools to aid the developer in
; organizing and re-using report files for various "answer" tables.
;
; Some of the code here may be "excessive," but it is designed so that
; you have maximum control by using building-block procedures, and
; so that the workspace is left in the same state on exit as entry.
; There is SOME error-trapping via a QUIT+Message.  You may add to or kill it.
; The 'higher' level procedures follow, and requre the given SysModes:
;    INITIALIZE - Main or CoEdit mode (the first time)
;    FIND.EXP   - Main, Edit or CoEdit; Only MAIN if Restructure Family needed
;    FIND.UPD   - Main, Edit or CoEdit
;    NEW        - Main, Edit or CoEdit
;
; --------------------------------------------------------------------
; (C) Adam Guberman, December 1993.      CIS 72310,2274
; ====================================================================

LIBNAME = "CAPFAM"
CreateLib LIBNAME
Clear
? "Creating procedure library "+LIBNAME


;-----------------------  INITIALIZE  ----------------------------------
;   The CAPFAM table is placed onto the workspace using whatever method is
; appropriate for the curent sysmode (View or CoEdit).  Note that in the
; entire file, I refer to the CAPFAMdb variable rather than the table
; directly.  In this  way, you can change the assignment below, or alter this
; procedure to take the tablename as a parameter if you choose.
;   NOTE!: I check IsAssigned(CAPFAMdb) as a test to see if initialization
; has already occured.  This means that BETWEEN scripts, the Variable may
; still be assigned, even when the workspace has NOT been initialized.
;   It does no harm, and is a better idea to DELIBERATELY call the initialize
; procedure on your own if you are going to use these tools.  However, the
; tools are 'forgiving' in any case.

PROC Capfam.Initialize ()
     CAPFAMdb = "capfam"    ; All code refers to this VARIABLE tablename
     If not IsOnWorkSpace(CAPFAMdb) Then
        Switch          ; Use the appropriate method to load the table
           Case SysMode() = "CoEdit" : Menu {TableAdd} Select CAPFAMdb
           Case SysMode() = "Main"   : View CAPFAMdb
           Otherwise:
               beep beep
               Quit "CAPFAM can only initialize from MAIN or COEDIT mode."
        EndSwitch
     EndIf
     MoveTo CAPFAMdb
     MoveTo Field "Name"
EndProc

WriteLib LIBNAME Capfam.Initialize
Release Procs Capfam.Initialize
?? "."





;------------------------  CLOSE THE CAPFAM TABLE  ------------------------
; The CAPFAM table is cleared from the workspace, and the variable CAPFAMdb
; is released.  Note that 'clearimage' has no effect unless you are in MAIN
; mode.

PROC Capfam.Close ()
     MoveTo CAPFAMdb
     clearimage
     Release Vars CAPFAMdb
EndProc

WriteLib LIBNAME Capfam.Close
Release Procs Capfam.Close
?? "."







;**********************************************************************
;***                                                                ***
;***             E X P O R T I N G     P R O C E D U R E S          ***
;***                                                                ***
;**********************************************************************

;-----------------------  FIND AND EXPORT  ------------------------------
;   This is a higher-level, 'clean' procedure.  The record associated with
; the TargetName is exported back to the stored [FileName].  The procedure
; quits with a message if the target is not found.  If the active image
; is not already CAPFAMdb, then  whatever the current image is will be
; returned to at the end of the procedure.
;    NOTE: If the record being exporte DOES require processing, you must
; be in MAIN mode to process a report/form, and if a script is going to be
; played, that  script MAY change image numbers around.  Depending on how
; you intend to use this, you may want to either remove the clean-up code,
; or add another parameter to turn it on/off when you call this procedure.

PROC Capfam.Find.Exp (TargetName)
private StartImage
     StartImage = ImageNo ()              ; Note where I STARTED from.
     Capfam.find (TargetName)         ; go find the target (or quit)
     Capfam.Curnt.Exp ()              ; Spit out the data
     Capfam.Curnt.Process ()            ; Process it if needed

     If StartImage > 0 Then           ; go back to where I came from.
        MoveTo StartImage
     EndIf
EndProc

WriteLib LIBNAME Capfam.Find.Exp
Release Procs Capfam.Find.Exp
?? "."






;-----------------------  FIND TARGET  -------------------------------
; This is a 'helper' procedure.  The target name is searched for, and
; you are left in that record.  You are automatically placed into the
; CAPFAM table before the search, but are not returned to your original
; ImageNo().

PROC Capfam.Find (TargetName)
     Capfam.Initialize ()
     Locate TargetName

     If RetVal=False Then    ; Target not found...
        Note = "'"+TargetName+"' was not found in " + CAPFAMdb
        Quit Note
     EndIf
EndProc

WriteLib LIBNAME Capfam.Find
Release Procs Capfam.Find
?? "."






;------------------------  EXPORT CURRENT RECORD'S DATA  ----------------
;   This is a 'helper' procedure, but you may use it directly if you like.
; By the time this procedure is called, it is already ASSUMED that the
; CAPFAM table is loaded, active, and you are at the desired record.

PROC Capfam.Curnt.Exp ()
     FileWrite BINARY [FileName] FROM [Data]
EndProc

WriteLib LIBNAME Capfam.Curnt.Exp
Release Procs Capfam.Curnt.Exp
?? "."






;------------------------  PROCESS IF NEEDED  ----------------------------
;    If the 'Process' field of the current record = "Y", then Scripts will
; be played, and Reports/Forms will be resyncronized.  Note that you must
; be in MAIN mode to resyncronize family members, and the tabel must exist.

PROC Capfam.Curnt.Process ()
private FileType,
        TableName,
        AfterDot

     If not [Process] = "Y" Then    ; If not TOLD to process, then don't
        Return 0                    ;    (procedure will end here)
     Endif

   ; Split the filename apart.  Seperate the extension from the rest.
     DotLocation = search(".", [FileName])

   ; Get the capitolized 1st char past the period
     AfterDot   = Format("CU",SubStr ([FileName], DotLocation+1,1))

   ; Grab everything BEFORE the dot (could be table, script, etc)
     BaseName   = Format("CU",SubStr ([FileName], 1, DotLocation-1))

     Switch
        Case (AfterDot="R") or (AfterDot="F"):
          ; Ensure I am in the proper mode
            If SysMode() <> "Main" Then
               Quit "System must be in MAIN mode to Restructure/JustFamily"
            EndIf

            If not IsTable(BaseName) Then
               Note =BaseName+" Must exist in order to Restructure/JustFamily"
               Quit Note
            EndIf

            ; Resyncronize the FAMILY for the TableName
              Menu {Modify} {Restructure} Select BaseName
              Menu {JustFamily} {ok}

        Case AfterDot = "S":
              play BaseName      ; play the script
     EndSwitch
EndProc

WriteLib LIBNAME Capfam.Curnt.Process
Release Procs Capfam.Curnt.Process
?? "."





;**********************************************************************
;***                                                                ***
;***             I M P O R T I N G     P R O C E D U R E S          ***
;***                                                                ***
;**********************************************************************

;-----------------------  FIND AND UPDATE  -------------------------------
;   This is higher-level, clean procedure.  The record matching TargetName
; is located, then the [data] field is updated.  If the ImageNo changes,
; it is returned to at the end of the procedure.

PROC Capfam.Find.Upd  (TargetName)
private StartImage, CloseEdit
     StartImage = ImageNo ()              ; Note where I STARTED from.

     Capfam.find (TargetName)      ; Go find the target (quits if not found)
     Capfam.AllowUpdate ()         ; sets CloseEdit and allows editing
     Capfam.Curnt.Upd ()           ; Update the [data] field

   ; Clean-up if I changed the SysMode
     If CloseEdit Then
        Do_It!
     EndIf

     If StartImage > 0 Then        ; Go back to where I came from.
        MoveTo StartImage
     EndIf
EndProc

WriteLib LIBNAME Capfam.Find.Upd
Release Procs Capfam.Find.Upd
?? "."






;------------------------  UPDATE CURRENT RECORD  ------------------------
;    This uses the current record's values and loads the [FileName] into
; the [data] field.  It is ASSUMED you have already called AllowUpdates
; in order to ensure you can make a field assignment.
; If there is already a BLOB in [Data], it is over-written.

PROC Capfam.Curnt.Upd ()
Private Temp
   ; Read the data-file and put it into the record
     FileRead BINARY [FileName] TO Temp
     [Data] = Temp
EndProc

WriteLib LIBNAME Capfam.Curnt.Upd
Release Procs Capfam.Curnt.Upd
?? "."





;------------------------  ALLOW UPDATES  --------------------------------
; This makes sure I am in Edit/CoEdit mode.  If I am in Main, then I PLACE
; the system into CoEdit, and set the variable 'CloseEdit' to true so
; that the higher level procedures know to Do_It! when they are done in
; order to return to the original SysMode.  CloseEdit is a private Variable
; to the procedures that use it, so it will not confilct with any of your
; personal variables, and it will be released when appropriate.

PROC Capfam.AllowUpdate ()
   ; Check what SysMode I am in, and ensure I CAN perform the update
     Switch
       Case (SysMode()="CoEdit") or (SysMode()="Edit") :
            CloseEdit = False       ; I can STAY in edit/coedit when done
       Case (SysMode()= "Main")  :
            CloseEdit = True        ; I will need to Do_It! when done
            CoEditKey               ; Go into CoEdit mode for update
       Otherwise:
            Quit "CAPFAM can only update from Main, Edit or CoEdit modes"
     EndSwitch
EndProc

WriteLib LIBNAME Capfam.AllowUpdate
Release Procs Capfam.AllowUpdate
?? "."






;------------------------  NEW ENTRY  -------------------------------
PROC Capfam.New (Name,Short,Long,FileName,Process)
private StartImage, CloseEdit
     StartImage = ImageNo()
     Capfam.Initialize ()
     Capfam.AllowUpdate ()              ; go into the proper mode
     Ins                                ; make a new record
     [Name]    = Name                   ; fill in the fields
     [Short]   = Short
     [Long]    = Long
     [FileName]= FileName
     [Process] = Process
     Capfam.Curnt.Upd ()                ; use fields for update
     PostRecord ForcePost               ; OVER-WRITING IS AUTOMATIC!

   ; Clean-up if I changed the SysMode
     If CloseEdit Then
        Do_It!
     EndIf
EndProc

WriteLib LIBNAME Capfam.New
Release Procs Capfam.New
?? "."


Release Vars LIBNAME
Reset
