;==============  CAPture FAMily members DEMONSTRATION  ===============
;
; The documentation and purpose of this program came in the file
; CAPFAM.DOC.  THIS script is a "quick and dirty" way to demonstrate
; how a Table's family members and other files can be placed into the
; CAPFAM.DB table.
;
; As a developer, it is expected that you will use the procedures in
; CAPFAMPR.SC instead.  That file is more versitile, commented better,
; and deals with more uncertain circumstances.
;
; --------------------------------------------------------------------
; Written by Adam Guberman, December 1993.      CIS 72310,2274
; --------------------------------------------------------------------

PROC Capfam.Interactive ()
     View "CAPFAM"
     FormKey
     Done    = False
     While not Done
           Wait Table
           Until -23, -18, -16, "CoEditKey","F2"  ; alt I,E,Q
           Switch
               Case Retval = -23 : ImportBinary()
               Case Retval = -18 : ExportBinary([Filename],[Data],[Process])
               Case Retval = -16 : Done=True
               Case Retval = "CoEditKey" : CoEditKey 
               Case Retval = "F2" : Do_It!  
           EndSwitch
     EndWhile
     do_it!
     clearall
     Return 0
EndProc


;--------------------------  IMPORT BINARY  --------------------------------
; This assumes that the table is already in Edit/CoEdit,
;     that you are positioned at the record of your choice,
;     and that the FileName field already contains the proper value.
PROC ImportBinary()
private Temp
     If not ((SysMode()="Edit") or (SysMode()="CoEdit")) Then
        Message "Switch to CoEdit mode first (Alt-F9)"
        Return
     EndIf
     FileRead BINARY [FileName] TO Temp
     [Data] = Temp
EndProc


;--------------------------  EXPORT BINARY  --------------------------------
; This writes the Data to the FileName, and Processes it if needed
PROC ExportBinary(Filename, Data, Process)
     If not (SysMode()="Main") Then
        Message "Close the CoEdit Session first (F2)"
        Return
     EndIf

     FileWrite BINARY FileName FROM Data
     ProcessIfNeeded (FileName, Process)
EndProc


;-------------------------  PROCESS IF NEEDED  ----------------------
PROC ProcessIfNeeded (FileName,  Process)
private FileType,
        TableName,
        AfterDot

     If Process = "N" Then               ; If told NOT to process, stop here
        Return 0
     Endif

     DotLocation = search(".", FileName)
     AfterDot    = SubStr (FileName, DotLocation+1,1)

     Switch
        Case (AfterDot="R") or (AfterDot="F"):
              TableName = SubStr (FileName, 1, DotLocation-1)
              Message "Resyncronizing the FAMILY for ", TableName
              Menu {Modify} {Restructure} Select TableName
              Menu {JustFamily} {ok}
        Case AfterDot = "S":
             Play FileName
     EndSwitch
EndProc


;=====================================================================

CapFam.Interactive ()
