;ARCHIVE.SC     Paradox Procedure
;--------------------------------
;Written by:            Jon C. Krueger
;			248 Adams Road
;			Greenfield, MA.  01301
;      Date:            18-Oct-91
;   Version:            1.01
;CompuServe:		76067,3242
;
;Revison History
;15-Dec-91	JCK	Added date field in archive table for audit trail
;17-Jan-93	JCK	Prepared for submission to C.I.S. (Comments)
;-----------------------------------------------------------------------------
;This routine allows you to ARCHIVE a record in ANY table so you can preserve
;a physical record of it, as it was BEFORE you made any changes.  
;
;The table used to hold the archived records is automatically created 
;with the preface "AK" + the first 6 letters of the original table name.
;An archive date field is added to this table and the archived date inserted.
;
;This function is useful to maintain a physical audit trail of the historical
;changes made to a Master record.  It acts like a ledger card from an
;old record keeping system allowing you to see the physical changes made,
;and what date they were made.
;
;NOTE:
;If your master table is keyed, then each archive record will REPLACE
;the old archive data with the same key.  To avoid this, if it is not desired,
;simply restructure the AK table without a key field.  Then each time a record
;from the master is inserted it will occupy a NEW record in the archive.
;-----------------------------------------------------------------------------

;------------------------
;SETKEY -30 PLAY "ARCHIVE"              ;Assign to (ALT-A) for ease of use
;------------------------		;Add this to your INIT.SC
					;if you so desire
PROC ARCHIVE()
echo off

;---- Check for Valid Table ----
if imagetype() <> "Display" then        ;Is there a TABLE Loaded?
        Beep
        message " No valid TABLE is present "
        sleep 2000
        QUIT                            ;If NOT then quit
endif

;---- Set Flags and Variables required ----
if isformview() = true                  ;Test to see if formview
   then fv_flag=1                       ;is active so we can return
   else fv_flag=0                       ;to it when finished.
endif

if Sysmode() = "Edit"                   ;Test to see if Edit Mode
   then Do_it!                          ;if so, then Do_it!
        ed_flag=1                       ;and set flag to return to
   else ed_flag=0                       ;the same mode as we were
endif

   cur_table=Table()                    ;Assign Current Table

   copytoarray cur_rec			;Save Current Record

   AK_table="AK"+substr(cur_table,1,6)	;Assign Archive table name

   nt_flag=0				;Clear New Table flag

;---- Check to see if an Archive Table exist ----
if istable(AK_table) then               ;Is there an ARCHIVE Table already?
        INSERT_ARCHIVE(nt_flag)         ;Call insert script
   else
        message  "Creating "+AK_table 	;If not then make New Table
        CREATE AK_TABLE LIKE CUR_TABLE
	Menu {Modify} {Restructure} 	;Modify archive table
	TYPEIN AK_table Enter		;to include archive date field
	End Down "Ak-Date" Enter "d" 	;for Audit Trail
	Do_It! 

	nt_flag = 1			;set new table flag

        INSERT_ARCHIVE(nt_flag)         ;Call insert script

endif

ENDPROC		;Archive()
;-----------------------------------------------------------------------------


PROC INSERT_ARCHIVE(nt_flag)            ;insert cur_record into AKtable

        Message  "Inserting Current Record into ",AK_Table

        view AK_Table                   ;Activate Archive Table
        editkey                         ;go to EDIT mode

        if nt_flag=0			;Move to the end of archive table
           then				;onlu if table was
                end                     ;already created
                down
        endif

        copyfromarray cur_rec           ;Insert new record

	[Ak-Date] = today()		;Add todays date (Audit Trail)

        Do_It!                          ;Save it

        clearimage                      ;Remove table image

        if fv_flag=1 then formkey endif ;Leave immage same as it was

        if ed_flag=1 then editkey endif ;Go back to EDIT if valid

	BEEP
        QUIT " This Record has been ARCHIVED "

ENDPROC		;Insert_Archive(nt_flag)
;-----------------------------------------------------------------------------


;------------------------
;---- Call Procedure ----
;------------------------
archive()
