;Ŀ
; Extended Memory Data Storage Functions for Turbo Pascal                 
; Subtitle:  Let Borland and Microsoft play with the UMBs                 
; TASM 2.5                                                                
; For Turbo Pascal:  Tested on Version 5.5                                
; AstroSoft Data Systems, Inc.                                            
; P.O. Box 12295                                                          
; Baltimore, Maryland 21281                                               
;                                                                         
; Purpose:  These are really all of the functions that should concern     
; an application programmer.                                              
;                                                                         
; Victor E. Cummings                                                      
;
;Get XMS Version Number (Function 00h):
;--------------------------------------
;
; GAZINTA:   AH = 00h
; GAZOWTA:   AX = XMS version number
;            BX = Driver internal revision number
;            DX = 0001h if the HMA exists, 0000h otherwise
; BOOBOOS:   None
DATA SEGMENT WORD PUBLIC
ASSUME DS : DATA
EXTRN  MoveRec        : DWORD
DATA ENDS
CODE SEGMENT
        ASSUME CS : CODE
XMMVER  PROC    FAR
        PUBLIC XMMVER
        LOCAL XMSControl : DWORD = LOCALSPACE
        PUSH    BP
        MOV     BP,SP
        SUB     SP, LOCALSPACE
        MOV     AX,4310h
        INT     2Fh
        MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
        MOV     WORD PTR [XMSControl+2],ES
        MOV     AH,00h
        CALL    [XMSControl]    ; Call XMS Control Function
        MOV     SP,BP
        POP     BP
        RET
XMMVER  ENDP

XMMREV  PROC    FAR
        PUBLIC XMMREV
        LOCAL XMSControl : DWORD = LOCALSPACE
        PUSH    BP
        MOV     BP,SP
        SUB     SP, LOCALSPACE
        MOV     AX,4310h
        INT     2Fh
        MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
        MOV     WORD PTR [XMSControl+2],ES
        MOV     AH,00h
        CALL    [XMSControl]    ; Call XMS Control Function
        MOV     SP,BP
        MOV     AX,BX           ; Move internal revision number to AX
        POP     BP
        RET
XMMREV  ENDP
;Query Free Extended Memory (Function 08h):
;------------------------------------------
;
; GAZINTA:   AH = 08h
; GAZOWTA:   AX = Size of the largest free extended memory block in K-bytes
;            DX = Total amount of free extended memory in K-bytes
; BOOBOOS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = A0h if all extended memory is allocated
XMMFREE PROC    FAR
        PUBLIC XMMFREE
        LOCAL XMSControl : DWORD = LOCALSPACE
        PUSH    BP
        MOV     BP,SP
        SUB     SP, LOCALSPACE
        MOV     AX,4310h
        INT     2Fh
        MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
        MOV     WORD PTR [XMSControl+2],ES
        MOV     AH,08h
        CALL    [XMSControl]    ; Call XMS Control Function
        MOV     SP,BP
        POP     BP
        RET
XMMFREE ENDP
XMMTOTAL PROC    FAR
         PUBLIC XMMTOTAL
         LOCAL XMSControl : DWORD = LOCALSPACE
         PUSH    BP
         MOV     BP,SP
         SUB     SP, LOCALSPACE
         MOV     AX,4310h
         INT     2Fh
         MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
         MOV     WORD PTR [XMSControl+2],ES
         MOV     AH,08h
         CALL    [XMSControl]    ; Call XMS Control Function
         MOV     AX, DX
         MOV     SP,BP
         POP     BP
         RET
XMMTOTAL ENDP
;Allocate Extended Memory Block (Function 09h):
;----------------------------------------------
;
;    ARGS:   AH = 09h
;            DX = Amount of extended memory being requested in K-bytes
;    RETS:   AX = 0001h if the block is allocated, 0000h otherwise
;            DX = 16-bit handle to the allocated block
;    ERRS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = A0h if all available extended memory is allocated
;            BL = A1h if all available extended memory handles are in use
;
;    This function attempts to allocate a block of the given size out of the
;pool of free extended memory.  If a block is available, it is reserved
;for the caller and a 16-bit handle to that block is returned.  The handle
;should be used in all subsequent extended memory calls.  If no memory was
;allocated, the returned handle is null.
;
;    NOTE: Extended memory handles are scarce resources.  Programs should
;          try to allocate as few as possible at any one time.  When all
;          of a driver's handles are in use, any free extended memory is
;          unavailable.
XMMALLOC PROC    FAR
          PUBLIC XMMALLOC
          ARG Requested : WORD = RETBYTES
          LOCAL XMSControl : DWORD = LOCALSPACE
          PUSH    BP
          MOV     BP,SP
          SUB     SP, LOCALSPACE
          MOV     AX,4310h
          INT     2Fh
          MOV     WORD PTR [XMSControl],BX   ; XMSControl is a DWORD
          MOV     WORD PTR [XMSControl+2],ES
          MOV     AH,09h
          MOV     DX, Requested              ; Amount requested in KB
          XOR     BX, BX                     ; Clear BX
          CALL    [XMSControl]               ; Call Control Function
          CMP     AX, 1                      ; Test for success
          JNE     MallocBad                  ; If Malloc was not OK preserve AX
          MOV     AX,DX                      ; Return Handle
          JMP     MallocOK                   ; Out of here
MallocBad:
          MOV     AX,BX                      ; Return Error
MallocOK: MOV     SP,BP
          POP     BP
          RET     RETBYTES
XMMALLOC ENDP
;Free Extended Memory Block (Function 0Ah):
;------------------------------------------
;
;    ARGS:   AH = 0Ah
;            DX = Handle to the allocated block which should be freed
;    RETS:   AX = 0001h if the block is successfully freed, 0000h otherwise
;    ERRS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = A2h if the handle is invalid
;            BL = ABh if the handle is locked
;
;    This function frees a block of extended memory which was previously
;allocated using Function 09h (Allocate Extended Memory Block).  Programs
;which allocate extended memory should free their memory blocks before
;exiting.  When an extended memory buffer is freed, its handle and all data
;stored in it become invalid and should not be accessed.
XMMDISPOSE PROC    FAR
           PUBLIC  XMMDISPOSE
           ARG HANDLE : WORD = RETBYTES
           LOCAL   XMSControl : DWORD = LOCALSPACE
           PUSH    BP
           MOV     BP,SP
           SUB     SP, LOCALSPACE
           MOV     AX,4310h
           INT     2Fh
           MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
           MOV     WORD PTR [XMSControl+2],ES
           MOV     DX,HANDLE
           MOV     AH,0Ah
           XOR     BX, BX          ; Clear BX in case of error
           CALL    [XMSControl]    ; Call the control Function
           CMP     AX,1            ; Test for error
           JE      DispOK          ; If Status is OK preserve AX
           MOV     AX, BX          ; Move Error to AX if present
DispOk:    MOV     SP,BP
           POP     BP
           RET     RETBYTES
XMMDISPOSE ENDP
;Move Extended Memory Block (Function 0Bh):
;------------------------------------------
;    ARGS:   AH = 0Bh
;            DS:SI = Pointer to an Extended Memory Move Structure (see below)
;    RETS:   AX = 0001h if the move is successful, 0000h otherwise
;    ERRS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = 82h if an A20 error occurs
;            BL = A3h if the SourceHandle is invalid
;            BL = A4h if the SourceOffset is invalid
;            BL = A5h if the DestHandle is invalid
;            BL = A6h if the DestOffset is invalid
;            BL = A7h if the Length is invalid
;            BL = A8h if the move has an invalid overlap
;            BL = A9h if a parity error occurs
;
;    Extended Memory Move Structure Definition:
;
;        ExtMemMoveStruct    struc
;            Length              dd  ?   ; 32-bit number of bytes to transfer
;            SourceHandle        dw  ?   ; Handle of source block
;            SourceOffset        dd  ?   ; 32-bit offset into source
;            DestHandle          dw  ?   ; Handle of destination block
;            DestOffset          dd  ?   ; 32-bit offset into destination block
;        ExtMemMoveStruct    ends
;
;    This function attempts to transfer a block of data from one location to
;another.  It is primarily intended for moving blocks of data between
;conventional memory and extended memory, however it can be used for moving
;blocks within conventional memory and within extended memory.
;
;    NOTE: If SourceHandle is set to 0000h, the SourceOffset is interpreted
;          as a standard segment:offset pair which refers to memory that is
;          directly accessible by the processor.  The segment:offset pair
;          is stored in Intel DWORD notation.  The same is true for DestHandle
;          and DestOffset.
;
;          SourceHandle and DestHandle do not have to refer to locked memory
;          blocks.
;
;          Length must be even.  Although not required, WORD-aligned moves
;          can be significantly faster on most machines.  DWORD aligned move
;          can be even faster on 80386 machines.
;
;          If the source and destination blocks overlap, only forward moves
;          (i.e. where the source base is less than the destination base) are
;          guaranteed to work properly.
;
;          Programs should not enable the A20 line before calling this
;          function.  The state of the A20 line is preserved.
;
;          This function is guaranteed to provide a reasonable number of
;          interrupt windows during long transfers.
XMMMOVE    PROC    FAR
           PUBLIC  XMMMOVE
           LOCAL   XMSControl  : DWORD = LOCALSPACE
           PUSH    BP
           PUSH    SI
           PUSH    DS
           MOV     BP,SP
           SUB     SP, LOCALSPACE
           XOR     BX, BX                          ; Clear Status register
           MOV     AX,4310h
           INT     2Fh
           MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
           MOV     WORD PTR [XMSControl+2],ES
           MOV     AX, SEG DATA
           MOV     DS, AX
           ASSUME  DS : DATA
           MOV     SI, OFFSET [MoveRec]
           MOV     AH,0Bh
           CALL    [XMSControl]    ; Call the XMS Control Function
           CMP     AX,1            ; Test for good move status
           JE      OutOfHere       ; If move is good get out of here
           MOV     AX,BX           ; If not good return Error
OutOfHere:
           MOV     SP,BP
           POP     DS
           POP     SI
           POP     BP
           RET
XMMMOVE    ENDP
;Lock Extended Memory Block (Function 0Ch):
;------------------------------------------
;
;    ARGS:   AH = 0Ch
;            DX = Extended memory block handle to lock
;    RETS:   AX = 0001h if the block is locked, 0000h otherwise
;            DX:BX = 32-bit linear address of the locked block
;    ERRS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = A2h if the handle is invalid
;            BL = ACh if the block's lock count overflows
;            BL = ADh if the lock fails
;
;    This function locks an extended memory block and returns its base
;address as a 32-bit linear address.  Locked memory blocks are guaranteed not
;to move.  The 32-bit pointer is only valid while the block is locked.
;Locked blocks should be unlocked as soon as possible.
;
;    NOTE: A block does not have to be locked before using Function 0Bh (Move
;          Extended Memory Block).
;
;          "Lock counts" are maintained for EMBs.
;
XMMLOCK    PROC    FAR
           PUBLIC  XMMLOCK
           ARG     LockHandle : WORD = RETBYTES
           LOCAL   XMSControl : DWORD = LOCALSPACE
           PUSH    BP
           MOV     BP,SP
           SUB     SP, LOCALSPACE
           MOV     AX,4310h
           INT     2Fh
           MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
           MOV     WORD PTR [XMSControl+2],ES
           MOV     AH,0Ch
           MOV     DX, LockHandle
           XOR     BX, BX          ; Clear BX in case of error
           CALL    [XMSControl]    ; Call the XMS Control Function
           CMP     AX, 1
           JE      LockOk          ; The lock was successful
           MOV     AX, BX          ; If unsuccessful return error
LockOK:    MOV     SP,BP
           POP     BP
           RET     RETBYTES
XMMLOCK    ENDP
;Unlock Extended Memory Block (Function 0Dh):
;--------------------------------------------
;
;    ARGS:   AH = 0Dh
;            DX = Extended memory block handle to unlock
;    RETS:   AX = 0001h if the block is unlocked, 0000h otherwise
;    ERRS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = A2h if the handle is invalid
;            BL = AAh if the block is not locked
;
;    This function unlocks a locked extended memory block.  Any 32-bit
;pointers into the block become invalid and should no longer be used.
;
XMMUNLOCK  PROC    FAR
           PUBLIC  XMMUNLOCK
           ARG     UnLockHandle : WORD = RETBYTES
           LOCAL   XMSControl : DWORD = LOCALSPACE
           PUSH    BP
           MOV     BP,SP
           SUB     SP, LOCALSPACE
           MOV     AX,4310h
           INT     2Fh
           MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
           MOV     WORD PTR [XMSControl+2],ES
           MOV     AH,0Dh
           MOV     DX, UnLockHandle
           XOR     BX, BX
           CALL    [XMSControl]    ; Get XMS Version Number
           CMP     AX, 1           ; Test for error
           JE      UnLockGood      ; Get out of here if Good Unlock
           MOV     AX, BX          ; If unsuccessful return error
UnlockGood: MOV     SP,BP
            POP     BP
            RET     RETBYTES
XMMUNLOCK   ENDP
;Get EMB Handle Information (Function 0Eh):
;------------------------------------------
;
;    ARGS:   AH = 0Eh
;            DX = Extended memory block handle
;    RETS:   AX = 0001h if the block's information is found, 0000h otherwise
;            BH = The block's lock count
;            BL = Number of free EMB handles in the system
;            DX = The block's length in K-bytes
;    ERRS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = A2h if the handle is invalid
;
;    This function returns additional information about an extended memory
;block to the caller.
;
;    NOTE: To get the block's base address, use Function 0Ch (Lock Extended
;          Memory Block).
;
XMMGETBLOCKSIZE PROC    FAR
                PUBLIC  XMMGETBLOCKSIZE

           LOCAL   XMSControl : DWORD = LOCALSPACE
           ARG     EMBHandle  : WORD = RETBYTES
           PUSH    BP
           MOV     BP,SP
           SUB     SP, LOCALSPACE
           MOV     AX,4310h
           INT     2Fh
           MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
           MOV     WORD PTR [XMSControl+2],ES
           MOV     AH,0Eh
           MOV     DX, EMBHandle
           XOR     BX, BX          ; Clear BX in case of error
           CALL    [XMSControl]    ; Call the XMS Control Function
           CMP     AX, 1           ; Test for success
           JNE     BadFunc         ; Func did booboo
           MOV     AX, DX
           JMP     FuncOK          ; If function is OK return BlockSize
BadFunc:   MOV     AX, BX
FuncOk:    MOV     SP,BP
           POP     BP
           RET     RETBYTES
XMMGETBLOCKSIZE ENDP
XMMGETHANDLES   PROC    FAR
                PUBLIC  XMMGETHANDLES

           LOCAL   XMSControl : DWORD = LOCALSPACE
           ARG     EMBHandle  : WORD = RETBYTES
           PUSH    BP
           MOV     BP,SP
           SUB     SP, LOCALSPACE
           MOV     AX,4310h
           INT     2Fh
           MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
           MOV     WORD PTR [XMSControl+2],ES
           MOV     AH,0Eh
           MOV     DX, EMBHandle
           XOR     BX, BX
           CALL    [XMSControl]    ; Call the XMS Control Function
           MOV     AX, BX
           MOV     SP,BP
           POP     BP
           RET     RETBYTES
XMMGETHANDLES ENDP
;Reallocate Extended Memory Block (Function 0Fh):
;------------------------------------------------
;
;    ARGS:   AH = 0Fh
;            BX = New size for the extended memory block in K-bytes
;            DX = Unlocked extended memory block handle to reallocate
;    RETS:   AX = 0001h if the block is reallocated, 0000h otherwise
;    ERRS:   BL = 80h if the function is not implemented
;            BL = 81h if a VDISK device is detected
;            BL = A0h if all available extended memory is allocated
;            BL = A1h if all available extended memory handles are in use
;            BL = A2h if the handle is invalid
;            BL = ABh if the block is locked
;
;    This function attempts to reallocate an unlocked extended memory block
;so that it becomes the newly specified size.  If the new size is smaller
;than the old block's size, all data at the upper end of the old block is
;lost.
;
XMMREALOC  PROC    FAR
           PUBLIC  XMMREALOC
           ARG     NewSize : WORD, Handle: WORD = RETBYTES
           LOCAL   XMSControl : DWORD = LOCALSPACE
           PUSH    BP
           MOV     BP,SP
           SUB     SP, LOCALSPACE
           MOV     AX,4310h
           INT     2Fh
           MOV     WORD PTR [XMSControl],BX        ; XMSControl is a DWORD
           MOV     WORD PTR [XMSControl+2],ES
           MOV     DX, Handle
           MOV     BX, NewSize
           MOV     AH,0Fh
           CALL    [XMSControl]    ; Call XMS Control Function
           MOV     SP,BP
           POP     BP
           RET     RETBYTES
XMMREALOC  ENDP
CODE ENDS
END
