(***********************************************************************
  Status Handler Ojbects as Enhancements to Turbo Power OOP Professional
                  New Communications Technology, Inc.
                             Version 1.0
                          by John Poindexter
                             June 23, 1990
************************************************************************)
{$I ULDEFINE.INC}

{$IFNDEF shDEBUG}
{$A-,B-,E+,F+,I+,N-,O+,R-,S-,V-}
{$ELSE}
{$A-,B-,E+,F+,I+,N-,O+,R+,S+,V-}
{$ENDIF}

Unit ULStatus;

Interface

Uses OpRoot, OpCrt, OpString, OpFrame, Filer, ULRoot, ULDial;

(************************************************************************
  Global Routines
************************************************************************)

procedure StdStatus(UnitCode:byte; var Code: word; Msg:string);

(***********************************************************************)
Implementation
(***********************************************************************)

(* Standard Status and Error Handler *)

procedure StdStatus(UnitCode:byte; var Code: word; Msg:string);
var
  ErrorType : word;
  ErrorCode : word;
  ErrorClass : word;
  Message : string;
  StatusWin : DialogBox;
  status : word;
  Redraw : boolean;

begin
  Message := '';
  if Pos('ISAM', Msg) <> 0 then
  begin
    Message := IsamErrorMessage(Code);
    case IsamErrorClass of
      0 : ErrorType := etNoError;
      1 : ErrorType := etMessage;
      2 : ErrorType := etWarning;
      3 : ErrorType := etWarning;
      4 : ErrorType := etFatal;
     99 : ErrorType := etFatal;
     else ErrorType := etFatal;
    end;
  end
  else
  begin
    ErrorType := Code div 10000;
    ErrorCode := Code mod 10000;
    ErrorClass := Code div 1000;
  end;
  if Msg = '' then Message := 'Error: '+Long2Str(ErrorCode)
  else Message := Msg+' '+Message;
  if ErrorType = etFatal then Message := 'Unit '+Long2Str(UnitCode)+': '+Message;
  if ErrorClass = 8 then Message := 'Report to developer: '+Message;
  if not StatusWin.Init(2,158,3,40) then
  begin
    WriteLn(emStatusHandlerFail);
    Halt(1);
  end;
  with StatusWin do
  begin
    AddMessageString(Message);
    case ErrorType of
      etFatal    : begin
                     AddChoiceString('Cancel');
                     AddHeader(' Error ',heTC);
                   end;
      etNonFatal : begin
                     AddChoiceString('Retry Cancel');
                     AddMessageString(emPossibleRecovery);
                     AddHeader(' Error ',heTC);
                   end;
      etWarning : begin
                    AddChoiceString('Retry Ok Cancel');
                    AddHeader(' Warning ',heTC);
                  end;
      etMessage : begin
                    AddChoiceString('Ok Cancel');
                    AddHeader(' Status ',heTC);
                  end;
      etNoError : begin
                    AddChoiceString('  Ok  ');
                    AddHeader(' Message ',heTC);
                  end;
    end;
    if dlLastError <> 0 then
    begin
      WriteLn(emStatusHandlerFail);
      Done;
      Halt(1);
    end;
    Process;
    Code := GetLastChoice;
    Done;
    case ErrorType of
      etFatal    : Code := scCancel;
      etNonFatal : case Code of
                     1: Code := scRetry;
                     2: Code := scCancel;
                   end;
      etWarning  : case Code of
                     1: Code := scRetry;
                     2: Code := scOk;
                     3: Code := scCancel;
                   end;
      etMessage  : case Code of
                     1: Code := scOk;
                     2: Code := scCancel
                   end;
      etNoError  : Code := scOk;
    end;
  end;
end;

end.
