UNIT Cmplx;

{  In the following descriptions,
   Capital letters (A, B) are real numbers or real parts of complex
   numbers.  Lowercase letters (a, b) are real factors of complex
   parts.  i is the square root of -1 (-1).

CONTENTS:  Add_Comp         (C1, C2, C_Out);
           Sub_Comp         (C1, C2, C_Out);
           Mult_Comp        (C1, C2, C_Out);
           Mult_RC          (C, R, C_Out);
           Sub_C_From_R     (R, C, C_Out);
           Div_C_By_R       (C, R, C_Out);
           Size_Of_C        (C);
           Square_Size_Of_C (C);
}


INTERFACE

TYPE
   Complex = RECORD
                R, I:  double
             END;

PROCEDURE Add_Comp (A, B:  Complex;
                    VAR C:  Complex);

PROCEDURE Sub_Comp (A, B:  Complex;
                    VAR C:  Complex);

PROCEDURE Mult_Comp (A, B:  Complex;
                     VAR C:  Complex);

PROCEDURE Div_Comp (A, B:  Complex;
                    VAR C:  Complex);

PROCEDURE Div_R_By_C (R:  double;
                      C:  Complex;
                      VAR C_Out:  Complex);

PROCEDURE Mult_RC (C:  Complex;
                   R:  double;
                   VAR C_Out:  Complex);

PROCEDURE Sub_C_From_R (R:  double;
                        C:  Complex;
                        VAR C_Out:  Complex);

PROCEDURE Div_C_By_R (C:  Complex;
                      R:  double;
                      VAR C_Out:  Complex);

FUNCTION Size_Of_C (C:  Complex):  double;
FUNCTION Square_Size_Of_C (C:  Complex):  double;

{********************************************************************}

IMPLEMENTATION

PROCEDURE Add_Comp (A, B:  Complex;
                    VAR C:  Complex);

{  RESULT == (A+ai)+(B+bi) == A+ai+B+bi == (A+B)+(a+b)i  }

BEGIN
C.R := A.R + B.R;
C.I := A.I + B.I
END {* Add_Comp *};

{********************************************************************}

PROCEDURE Sub_Comp (A, B:  Complex;
                    VAR C:  Complex);

{  RESULT == (A+ai)-(B+bi) == A+ai-B-bi == (A-B)+(a-b)i  }

BEGIN
C.R := A.R - B.R;
C.I := A.I - B.I
END {* Sub_Comp *};

{********************************************************************}

PROCEDURE Mult_Comp (A, B:  Complex;
                     VAR C:  Complex);

{  RESULT == (A+ai)(B+bi) == AB + Abi + Bai + aibi ==
             (AB-ab)+(Ab+aB)i  }

BEGIN
C.R := A.R * B.R - A.I * B.I;
C.I := A.R * B.I + A.I * B.R
END {* Mult_Comp *};

{********************************************************************}

PROCEDURE Div_Comp (A, B:  Complex;
                    VAR C:  Complex);

{  RESULT == (A+ai)/(B+bi) == (AB+ab)/(B+b)+((aB-Ab)/(B+b))i  }

VAR
   D:  double;

BEGIN
D := Sqr (B.R) + Sqr (B.I);
C.R := (A.R * B.R + A.I * B.I) / D;
C.I := (A.I * B.R - A.R * B.I) / D
END {* Div_Comp *};

{********************************************************************}

PROCEDURE Div_R_By_C (R:  double;
                      C:  Complex;
                      VAR C_Out:  Complex);
VAR
   A:  Complex;

BEGIN
A.R := R;
A.I := 0;
Div_Comp (A, C, C_Out)
END {* Div_R_By_C *};

{********************************************************************}

PROCEDURE Mult_RC (C:  Complex;
                   R:  double;
                   VAR C_Out:  Complex);

{  RESULT == (C+ci)R == CR+cRi  }

BEGIN
C_Out.R := C.R * R;
C_Out.I := C.I * R
END {* Mult_RC *};

{********************************************************************}

PROCEDURE Sub_C_From_R (R:  double;
                        C:  Complex;
                        VAR C_Out:  Complex);

{  RESULT == R-(C+ci) == R-C-ci == (R-C)-ci  }

BEGIN
C_Out.R := R - C.R;
C_Out.I := -C.I
END {* Sub_C_From_R *};

{********************************************************************}

PROCEDURE Div_C_By_R (C:  Complex;
                      R:  double;
                      VAR C_Out:  Complex);

{  RESULT == (C+ci)/R == C/B+ci/R == (C/R)+(c/R)i  }

BEGIN
C_Out.R := C.R / R;
C_Out.I := C.I / R
END {* Div_C_By_R *};

{********************************************************************}

FUNCTION Size_Of_C (C:  Complex):  double;

{  RESULT == (C+c)  }

BEGIN
Size_Of_C := Sqrt (Sqr (C.R) + Sqr (C.I))
END {* Size_Of_C *};

{********************************************************************}

FUNCTION Square_Size_Of_C (C:  Complex):  double;

{  RESULT == C + c  }

BEGIN
Square_Size_Of_C := Sqr (C.R) + Sqr (C.I)
END {* Square_Size_Of_C *};

END.