
const rempath_tag: string[90]
   = #0'@(#)CURRENT_FILE LAST_UPDATE Remove path prefix library 2.0'#0;
#log Remove path prefix library 2.0

(*
 * remove_path - remove pathname prefix from a filename
 *
 *)

function remove_path(name: anystring): anystring;
var
   n: anystring;
   i: integer;
begin
   n := '';
   for i := 1 to LEN(name) do
      if name[i] in [':','/','\'] then
         n := ''
      else
         n := n + name[i];

   remove_path := n;
end;


(*
 * path_only - return pathname prefix from a filename
 *
 *)

function path_only(name: anystring): anystring;
var
   n: anystring;
   i: integer;
begin
   n := name;
   i := LEN(n);
   while (i > 0) and (not (name[i] in [':','/','\'])) do
      i := i -1;

   n[0] := chr(i);

   if (n <> '') and not (n[LEN(n)] in ['\','/']) then
      n := n + '\';

   path_only := n;
end;


(*
 * remove_ext - remove filename .ext
 *
 *)

function remove_ext(name: anystring): anystring;
var
   n: anystring;
   i: integer;
begin
   n := name;
   i := LEN(n);
   while (i > 0) and (name[i] <> '.') do
      i := i -1;

   if name[i] = '.' then
      n[0] := chr(i-1);

   remove_ext := n;
end;


(*
 * ext_only - return only the ext portion of a filename
 *
 *)

function ext_only(name: anystring): anystring;
var
   i: integer;
begin
   i := LEN(name);
   while (i > 0) and (name[i] <> '.') do
      i := i -1;

   if name[i] = '.' then
      ext_only := copy(name,i+1,99)
   else
      ext_only := '';
end;

