
(*
 * openshar.inc - shared mode file handlers
 *
 * This library allows you to open files in the various sharing
 * modes allowed by DOS 3.x under SHARE.
 *
 * S.H.Smith, 20-may-87
 *
 * Thanks to John W. Wulff who documented these procedures!
 *
 * This routine is implemented as a macro (or an inline procedure).
 * This implementation allows you to use any combination of file types
 * without writing a special handler for each file type.
 *
 * Compile with TSHELL 1.2+ (Available from the Tool Shop BBS 602 279 2673)
 *
 *
 * Usage:
 *    assign(fd,name);
 *    OPEN_SHARE(fd, function, mode, ok);
 *    if ok then  process-file
 *    else        couldn't open
 *
 * Where:
 *    fd          is the file variable to open
 *
 *    function    is the open function, one of:
 *                   reset, rewrite, append
 *
 *    mode        is the file sharing mode, composed of:
 *                   allow_xxx+deny_yyy
 *                where xxx is:  read, write, update and
 *                      yyy is:  all, read, write, nothing
 *
 *    ok          is the result status code, on exit:
 *                   true - open was successful
 *                   false - open failed after n tries
 *
 * Revision history
 *
 *    20-may-87 s.h.smith, initial coding
 *
 *    21-may-87 s.h.smith, changed shared modes to deny nothing to other nodes
 *
 *    22-may-86 s.h.smith, changed modes again.  allow and deny fields are now
 *              specified separately.  'append' doesn't work with deny-none.
 *
 *    04-jun-87 s.h.smith, bracketed OPENSHAR body with begin..end so the
 *              macro can be used with the IF statement.
 *)

const
   retry_count        = 10;
   default_mode       = 2;

   allow_read         = 0;
   allow_write        = 1;
   allow_update       = 2;

   deny_all           = 16;
   deny_write         = 32;
   deny_read          = 48;
   deny_nothing       = 64;

var
   open_mode_byte:  byte  absolute cseg:$24fc;  {tp 3.01x only}
                                       { 24c6}  {tp 3.02x only}

   open_try_count:  integer;


#define OPEN_SHARE  {...(fd, function, mode, okstatus) }      \
begin                                                         \
   open_mode_byte := %3;                                      \
   open_try_count := 0;                                       \
   %4 := false;                                               \
                                                              \
   while (open_try_count < retry_count) and (%4 = false) do   \
   begin                                                      \
      {$i-} %2 (%1); {$i+}                                    \
                                                              \
      if ioresult = 0 then                                    \
         %4 := true                                           \
      else                                                    \
         open_try_count := open_try_count + 1;                \
   end;                                                       \
                                                              \
   open_mode_byte := default_mode;                            \
end



