
(*
 * getuser.inc - get name and level current user under GT-host
 *
 * For use with GT PowerComm 12.xx HOST-MODE.
 *
 * S.H.Smith, 6-apr-87 (rev. 26-apr-87)
 *
 * This program is provided courtesy of:
 *         The Tool Shop
 *         Phoenix, Az
 *         (602) 279-2673
 *
 * This program uses many of the building-blocks in the Tool Shop Library,
 * which is available for download from the Tool Shop.   Compile using
 * TSHELL 1.1, also avaliable from the Tool Shop.
 *
 *)

(* layout of the user control file records for gt12.10 *)

type
   user_record = record
      name:          string[30];
      level:         char;
      authorization: string[40];
      baud:          integer;
      ansi:          boolean;
   end;

var
   user:  user_record;



procedure get_user_info;
   {get name and userlevel for currently logged user}
var
   line:       anystring;
   fname:      anystring;
   fd:         text;
   i:          integer;
   spaces:     integer;

begin
   user.level := 'Z';
   user.name := 'Unknown';
   user.authorization := '';
   user.baud := 1200;
   user.ansi := false;

   fname := locate_file_env('gtuser.bbs','GTPATH=');
   if exists(fname)=false then
   begin
      writeln(con,whoami,': Missing file: ',fname);
      writeln(con,'Check setting of GTPATH environment.');
      exit;
   end;

   assign(fd,fname);
   reset(fd);
   readln(fd,line);
   close(fd);

   user.level := line[1];

   delete(line,1,2);
   i := 1;
   spaces := 0;
   while (i < LEN(line)) and (spaces < 2) do
   begin
      if line[i] = ' ' then
         INCR(spaces);
      INCR(i);
   end;

   user.name := copy(line,1,i-2);

   delete(line,1,i-1);
   i := pos(' ',line);
   user.authorization := copy(line,1,i-1);

   delete(line,1,i);
   user.baud := atoi(line);

   i := pos(' ',line);
   delete(line,1,i);
   line := copy(line,1,4);
   user.ansi := line = 'ANSI';

   with user do
   writeln(con,'Name: ',name,
               '  Level: ',user.level,
               '  Auth: ',authorization,
               '  Baud: ',baud,
               '  ANSI: ',ansi);
   writeln(con);

end;

