{$N-}   { turn off math-coprocessor }
uses rlib,crt,dos;
type
  command = ( start,stop );
const
  funcname:array [1..9] of string[10] =
  (
   'Savage    ',
   'Multiply  ',
   'Divide    ',
   'Squareroot',
   'Sin       ',
   'Cos       ',
   'Arctan    ',
   'Exp       ',
   'Log       '
  );
var
  time,time1,time2:real;
  funcno,iter,i:word;
  x,y,z:real;
  s:string;
  ch:char;

procedure timer(c:command);
var
  hour,min,sec,sec100:word;
begin
  gettime(hour,min,sec,sec100);
  if c = start then time:=0 else time:=-time;
  time:=time+3600*hour+60*min+sec+sec100/100;
  if time < 0 then time:=time+86400;
end;

procedure dispfunc;
var
  x,y:word;
begin
  x:=wherex;y:=wherey;
  window(1,1,80,25);
  gotoxy(19,25);
  write(funcname[funcno]);
  window(1,3,80,23);
  gotoxy(x,y);
end;

procedure dispiter;
var
  x,y:word;
begin
  x:=wherex;y:=wherey;
  window(1,1,80,25);
  gotoxy(63,25);
  write(iter,'    ');
  window(1,3,80,23);
  gotoxy(x,y);
end;




begin
  clrscr;
  writeln(
' 1.Savage  2.Multiply  3.Divide  4.Sqrt  5.Sin  6.Cos  7.Arctan  8.Exp  9.Log'
    );
  gotoxy(1,25);
  write(
  'Function chosen =                          No of iterations =');
  window(1,3,80,23);
  funcno:=1;iter:=1000;dispfunc;dispiter;
  while true do
  begin write(
  'To change function, enter new function number else press return : ');
  readln(s);
    if s <> '' then val(s,funcno,i);
    dispfunc;
    writeln(
'To change no of iterations, enter new value ( 0 to 65535 ) else');
write('press return : ');readln(s);
    if s <> '' then val(s,iter,i);
    dispiter;
    if funcno > 1 then
    begin
      write('x = ');readln(x);
    end;
    if (funcno = 2) or (funcno = 3) then
    begin
      write('y = ');readln(y);
    end;
    case funcno of
      1:{ savage }
      begin
        x:=1;
        timer(start);
        for i:=1 to iter do
        begin
          x:=exp(ln(sqrt(x*x)));
          y:=arctan(1+1/x);
          x:=x*sin(y);x:=x/cos(y);
        end;
        timer(stop);
        writeln(
  'Cumulative error in Turbo Pascal''s routine after ',iter,' iterations = '
               );
        writeln(abs(x-iter-1));
      end;
      2:
      begin
        timer(start);
        for i:=1 to iter do z:=x*y;
        timer(stop);
        writeln('x * y = ',z,' ( according to Turbo Pascal )');
      end;
      3:
      begin
        timer(start);
        for i:=1 to iter do z:=x/y;
        timer(stop);
        writeln('x / y = ',z,' ( according to Turbo Pascal )');
      end;
      4:
      begin
        timer(start);
        for i:=1 to iter do z:=sqrt(x);
        timer(stop);
        writeln('Sqrt(x) = ',z,' ( according to Turbo Pascal )');
      end;
      5:
      begin
        timer(start);
        for i:=1 to iter do z:=sin(x);
        timer(stop);
        writeln('Sin(x) = ',z,' ( according to Turbo Pascal )');
      end;
      6:
      begin
        timer(start);
        for i:=1 to iter do z:=cos(x);
        timer(stop);
        writeln('Cos(x) = ',z,' ( according to Turbo Pascal )');
      end;
      7:
      begin
        timer(start);
        for i:=1 to iter do z:=arctan(x);
        timer(stop);
        writeln('Arctan(x) = ',z,' ( according to Turbo Pascal )');
      end;
      8:
      begin
        timer(start);
        for i:=1 to iter do z:=exp(x);
        timer(stop);
        writeln('Exp(x) = ',z,' ( according to Turbo Pascal )');
      end;
      9:
      begin
        timer(start);
        for i:=1 to iter do z:=ln(x);
        timer(stop);
        writeln('Ln(x) = ',z,' ( according to Turbo Pascal )');
      end;
    end;
    writeln('Time taken by Turbo Pascal''s routine = ',time:3:2,' secs.');
    time1:=time;
    case funcno of
      1:{ savage }
      begin
        x:=1;
        timer(start);
        for i:=1 to iter do
        begin
          x:=_exp(_ln(_sqrt(_mul(x,x))));
          y:=_arctan(1+_div(1,x));
          x:=_mul(x,_sin(y));x:=_div(x,_cos(y));
        end;
        timer(stop);
        writeln(
	'Cumulative error in improved routine''s after ',iter,' iterations = '
               );
        writeln(abs(x-iter-1));
      end;
      2:
      begin
        timer(start);
        for i:=1 to iter do z:=_mul(x,y);
        timer(stop);
				writeln('x * y = ',z,' ( according to improved routine )');
      end;
      3:
      begin
        timer(start);
        for i:=1 to iter do z:=_div(x,y);
        timer(stop);
				writeln('x / y = ',z,' ( according to improved routine )');
      end;
      4:
      begin
        timer(start);
        for i:=1 to iter do z:=_sqrt(x);
        timer(stop);
				writeln('Sqrt(x) = ',z,' ( according to improved routine )');
      end;
      5:
      begin
        timer(start);
        for i:=1 to iter do z:=_sin(x);
        timer(stop);
				writeln('Sin(x) = ',z,' ( according to improved routine )');
      end;
      6:
      begin
        timer(start);
        for i:=1 to iter do z:=_cos(x);
        timer(stop);
				writeln('Cos(x) = ',z,' ( according to improved routine )');
      end;
      7:
      begin
        timer(start);
        for i:=1 to iter do z:=_arctan(x);
        timer(stop);
				writeln('Arctan(x) = ',z,' ( according to improved routine )');
      end;
      8:
      begin
        timer(start);
        for i:=1 to iter do z:=_exp(x);
        timer(stop);
				writeln('Exp(x) = ',z,' ( according to improved routine )');
      end;
      9:
      begin
        timer(start);
        for i:=1 to iter do z:=_ln(x);
        timer(stop);
				writeln('Ln(x) = ',z,' ( according to improved routine )');
      end;
    end;
		writeln('Time taken by improved routine = ',time:3:2,' secs.');
    time2:=time;
    writeln(
	'Speed improvement in improved routine = ',(100*(time1-time2)/time2):3:0,' %');
  writeln;
  end;
end.










