{define VGA256 to link BGI256.OBJ driver}
{NOTE: do not simultaneously link above with link in uVESA.TPU}
{A+,B-,D-,G+,I-,L-,Q-,R-,S-,Y-}
unit UBGI256;
interface

CONST
	Mode200  = 0;  {320x200x256}
  Mode400  = 1;  {640x400x256}
  Mode480  = 2;  {640x480x256}
  Mode600  = 3;  {800x600x256}
  Mode768  = 4;  {1024x768x256}
{
  if using VESA object, call any VESA mode methods with
	the Vesa_Modes[Pred( <above graphmode constant> )] array.
  The above modes are not strictly VESA, Only modes 1-4, so
  the Vesa_Modes array is not in sync with the above constants.
  ie: Vesa_Modes[0] is 640x400x256 which is this BGI's mode 1;
}
procedure InitBGI_BGI256;
{The following function is used to sync the Vesa object with
 the BGI driver, see EOF for example call}
function Equate_VESAMode(CurrentMode: integer): integer;

implementation
uses graph, Crt;

var
  OldExitProc: pointer;

{ This returns an index to the VESA_Modes array in UVESA unit
	to match VESA hex mode number to the BGI256 driver mode }
function Equate_VESAMode(CurrentMode: integer): integer;
begin	Equate_VESAMode := Pred(CurrentMode); end;

{$ifdef VGA256 }
procedure BGI256Proc; external;
{$L BGI256.OBJ }
{$endif}

function AutoDetect: integer; far;
begin AutoDetect := 127; end;

procedure BGIExitProc; far;
begin
  ExitProc := OldExitProc;
  Closegraph;
end;

procedure InitBGI_BGI256;
const
  PathtoDriver: string = '\BP\BGI';
var
  Driver, Mode, Error: integer;

  function Ok: boolean;
  begin Ok := GraphResult = grOk; end;

begin
  OldExitProc := ExitProc;
  ExitProc := @BGIExitProc;
  DirectVideo := false;
  Driver := InstallUserDriver('BGI256', @AutoDetect);
  if not Ok then Exit;
  {$ifdef VGA256}
    if RegisterBGIDriver(@BGI256Proc) < 0 then Exit;
  {$endif}
  Driver := Detect;
  InitGraph(Driver, Mode, PathToDriver);
  if not OK then
  begin
  	Writeln('ERROR: Unable to initialize graphics.');
  	Halt;
  end;
end;

end.

{ typical program call---
  Adapter := New(PVesa, Init);
  InitBGI_BGI256;
  SetGraphMode(Mode480);
  ...now set Adapter instance in sync with BGI...
  Adapter^.SetVesaMode(Vesa_Modes[Equate_VesaMode(Mode480)]);
  -or-
  Adapter^.GetStateInfo; (if in 13h)
}