{ Sample program for TPPCX-VGA256 }
{ Copyright 1993, Mark D. Rafn, MDRUtils(tm) }

program PCXPLAY;
uses graph, crt, uPcxVGA, uVesa, uVga, uPal256, uBGIVesa;
{ tabs = 2 }
{
  *** NOTE ***
  A 256 color image displayed in 16 color video mode will use gray scaling.
  A 16 color image displayed in 256 color video mode will sum colors.
  Registered users will be able to manipulate palettes to produce quality
  results.
}

var
  ePcx: PPcxEncoder_Vga; { PCX encoder object }
  VesaAdapter: PVesa;    { VESA object }
  VgaAdapter: PVga;      { VGA object  }
  Adapter: PVga;         { VGA object }
  Picx, Picy, PicW, PicH: integer;

const
  BGIRegister = 240; { Vga palette register number }
  NoRegisters = 16;  { number of registers to set  }
  TextX: integer = 10;
  TextY: integer = 10;

{ *** PCX file names to use *** }
  VGAPCX  = 'COLOR256.PCX';
  VESAPCX = 'THECOVER.PCX';

procedure Pause;
begin
  repeat until keypressed;
  MemW[$0000:$041C] := MemW[$0000:$041A]; {clear kbd buffer}
end;

procedure WriteOut(S : string);
begin
  Adapter^.SetColor(255,63,63,63);
  SetColor(BGIRegister + White);
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(LeftText,TopText);
  OutTextxy(Textx, Texty, S);
  Inc(TextY, 15);
end; { WriteOut }

procedure ShowVesa;
var
   Pcx: PPcxDecoder_VGA; { PCX decoder object }
   Size: longint;
   SaveDac: PDac_256;
begin
  Pcx := nil;
  { create VESA descendant PCX object }
  Pcx := New(PPcxDecoder_VESA, Init(VESAPCX, VesaAdapter));
  { was object created? }
  if not (Pcx = nil) then
  begin
    { decode image to RAM, will automatically decode to disk if no memory }
    Pcx^.Decode(ToRam);
    { decoded OK? }
    if PcxError = PcxError0 then
		begin
      PicW := Pcx^.GetMxX; { width of image }
      PicH := Pcx^.GetMxY; { height of image }
      PicX := (VesaAdapter^.GetMaxX div 2) - (PicW div 2); { center horiz }
      PicY := (VesaAdapter^.GetMaxY div 2) - (PicH div 2); { center vert  }
      { set Vga palette registers to PCX info }
      Pcx^.Set_Palette;
      { show image at x, y, full image - no clipping }
	    Pcx^.Show(New(PPosWin, Init(PicX, PicY, 0, 0, PicW, PicH)));

      { if you want the BGI colors, it is best to relocate them to a high   }
      { register number. Usually a 256 color image does not use the last    }
      { 8 to 16 registers (240-255). And they generally never remap color   }
      { 255. Worst case you can set register 255 to white for your text     }
      { output. Run COLOR256.PCX with the following SetColorBlock proc and  }
      { see what happens. You can play with the beginning register number   }
      { and quantity. I tried BGIRegister=128 and NoRegisters=8 which worked}
			{ fairly well. Note: that you are then limited to 8 known colors,     }
			{ black thru lightgray                                                }

      {comment out if you want all 256 colors un-modified }
      {
      Adapter^.SetColorBlock(BGIRegister, NoRegisters, @Dac16_bgi);

      graph.SetColor(BGIRegister + White);
      }
      Rectangle(Picx -1, Picy-1, Picx + PicW+1, Picy+1 + PicH);
      { destroy VESA PCX object }
      Dispose(Pcx, Done);

      WriteOut('256 GrayScale, palette loaded.');
      WriteOut('press any key ...');
      WriteOut('');
      Pause;

      { decode and display new image }

      Pcx := New(PPcxDecoder_VESA, Init(VGAPCX, VesaAdapter));
      Pcx^.Decode(ToRam);
	    Pcx^.Show(New(PPosWin,
			  Init(PicX + 50, PicY + 50, 0, 0, Pcx^.GetMxX, Pcx^.GetMxY)));
      Pcx^.Set_Palette;
      Dispose(Pcx, Done);

      WriteOut('256 color image, palette loaded.');
      WriteOut('press any key ...');
      WriteOut('');
      Pause;

      { Sum the Vga palette registers to gray }
      Adapter^.SumToGray(0, 256);
      WriteOut('256 colors summed to gray.');
      WriteOut('press any key ...');
    end;
  end;
end;

{also see ShowVESA for further palette information}
procedure ShowVGA;
var
   Pcx: PPcxDecoder_VGA; { PCX decoder object }
begin
  Pcx := nil;
  { create a VGA PCX object }
  Pcx := New(PPcxDecoder_VGA, Init(VGAPCX, Adapter));
  { was object created? }
  if not (Pcx = nil) then
  begin
    { decode image to RAM, will automatically decode to disk if no memory }
    Pcx^.Decode(ToRam);
    { decoded OK? }
    if PcxError = PcxError0 then
		begin
      PicW := Pcx^.GetMxX;
      PicH := Pcx^.GetMxY;
      Picx := (Adapter^.GetMaxX div 2) - (PicW div 2);
      Picy := (Adapter^.GetMaxY div 2) - (PicH div 2);
      Pcx^.Set_Palette;
	    Pcx^.Show(New(PPosWin, Init(Picx, Picy, 0, 0, PicW, PicH)));
      graph.SetColor(BGIRegister + White);
      Rectangle(Picx -1, Picy-1, Picx + PicW+1, Picy+1 + PicH);
      Dispose(Pcx, Done);
    end;
  end;

end;

begin
  { is system VGA? }
  if not Vga_Detect then Halt;
  { next we need a video adapter object, either VESA or VGA }
  { check first for VESA }
  Adapter := New(PVesa, Init);
  { is VESA present? }
  if Adapter <> nil then
  begin
    { VESA is present }
    VesaAdapter := PVesa(Adapter);
    { initialize graphics, no other graphics initialization is needed }
    { a video object must be passed to the initialization procedure }
    InitBGI_Vesa(VesaAdapter);
    { set VESA mode to requested resolution }
    BGI_SetVesaMode(VesaAdapter, Vesa_max);
    { four modes available, use the following constants
      VESA_Lo      =  640x 400 256 Color
      VESA_Med     =  640x 480 256 Color
      VESA_Hi      =  800x 600 256 Color
      VESA_SuperHi = 1024x 768 256 Color
      VESA_Max     = Maximum mode detected
    }
    ShowVesa;
    Pause;
    Dispose(VesaAdapter, Done);
  end
  else
  begin
    { VESA is not supported, use standard VGA 256 mode (13h) }
    Adapter := New(PVga, Init);
    { initialize graphics, no other graphics initialization is needed }
    { a video object must be passed to the initialization procedure }
    { in standard VGA mode, the requested mode must also be passed }
    InitBGI_Vga(Adapter, Vga_256);
      { use standard BGI mode calls plus additional mode 13h }
      { VGAlo, VGAmed, VGAhi, VGA_256 (13h) }
    ShowVga;
    Pause;
    Dispose(Adapter, Done);
  end;

{
  sample code for creating a PCX file, commented out
  ePcx := nil;
  (create VESA descendant PCX encoder object)
  ePcx := New(PPcxEncoder_Vesa, Init('TEST.PCX', Adapter));
  if not (ePcx = nil) then
    (save image in boundaries)
    ePcx^.Save(New(PWin, Init(Picx, Picy, Picx + PicW, Picy + PicH)));
  Dispose(ePcx, Done);
}

end.

{ sample code for intializing VESA graphics without a BGI driver }
{ any and all calls to graph unit procedures or functions will   }
{ hang the system. Remove all calls to graph unit                }
{    Adapter := New(PVesa, Init);}
{    if Adapter <> nil then VesaAdapter := Adapter;
{    VesaAdapter := PVesa(Adapter);}
{    InitBIOS_Vesa(VesaAdapter);}
{    VesaAdapter^.SetVESAMode(Vesa16_superhi);}
{      All 256 color modes Vesa_lo - Vesa_SuperHi plus }
{      2 additional modes available, planar type}
{      VESA16_Hi = 800x 600 16 Color, BIOS Vesa}
{      VESA16_SuperHi = 1024x 768 16 Color, BIOS Vesa}

