{ Sample program for TPPCX-VGA256 }
{ Copyright 1992, Mark D. Rafn, MDRUtils (tm) }

program PALPLAY;
uses uVesa, graph, crt, uVGA, uPal256, uPcxVGA;

var
  Status: word;
  Rows: integer;
  Color: integer;
  x, y: integer;
  r,g,b: integer;
  BarW, BarH, TxtX, TxtY: integer;
  VGAStatus: integer;
  Dac16: aDac_16;
  Rown, Rownx: string;
  V: PVesa;              { VESA object }
  VgaAdapter: PVga;      { VGA object  }
  Adapter: PVga;         { VGA object }

procedure Pause;
begin
  repeat until keypressed;
  MemW[ $0000:$041C ] := MemW[ $0000:$041A ];
end;

procedure EraseText;
var
  WinWidth: integer;
  bx1,bx2,by1,by2: integer;
begin
  SetFillStyle(SolidFill,Black);
  WinWidth := (V^.StateInfo.NoCharCols * 8) - 1;
  bx1 := 0;
  by1 := TxtY;
  bx2 := WinWidth;
	by2 := TxtY + TextHeight('Mg');
  Bar(bx1,by1,bx2,by2);
end;

procedure WriteOut(S : string);
begin
  EraseText;
  V^.SetColor(255,63,63,63);
  Color := 255;
  SetColor(Color);
  SetTextStyle(DefaultFont, HorizDir, 1);
  SetTextJustify(LeftText,TopText);
  OutTextXY(Txtx, Txty, S);
end; { WriteOut }

procedure DoBars;
var
  i,j: integer;
begin
  SetColor(DarkGray);
  x := 0;
  y := 0;
  for i := 0 to 15 do
  begin
    x := 0;
    for j := 0 to 15 do
    begin
      SetFillStyle(SolidFill, (i * 16)+j);
      Bar(x, y, x + BarW, y + BarH);
      Rectangle(x, y, x + BarW, y + BarH);
      x := x + BarW + 5;
    end;
    y := y + BarH + 5;
  end;
  x := 0;
  WriteOut('Default VGA palette (color #255 will be reset for text.)');
  Pause;
end;

{
procedure PCXPalette;
var  Pcx: PPcx;
begin
  WriteOut('Reading PCX file...please wait');
  Pcx := nil;
  Pcx := New(PPcxVESA, Init('COLOR256.PCX'));
  if not (Pcx = nil) then
    Pcx^.Decode(ToRam);
  if PcxError = 0 then
	  Pcx^.Set_Palette;
  Dispose(Pcx, Done);
	WriteOut('Switched to PCX palette.');
  Pause;
end;
}

procedure CycleBGI;
begin
  for Rows := 0 to 15 do
  begin
    Str(Rows * 16, Rown);
    Str((Rows * 16 + 15), Rownx);
    WriteOut('Cycling BGI 16 color palette by rows, color '+ Rown +' to color '+ Rownx);
    V^.ReadColorBlock(Rows * 16, 16, @Dac16);
    V^.SetColorBlock(Rows * 16, 16, @Dac16_BGI);
    Pause;
    V^.SetColorBlock(Rows * 16, 16, @Dac16);
  end;
end;

procedure GrayScale;
begin
  WriteOut('Summing colors to gray scale');
  V^.SumToGray(0, 256);
  pause;
end;

procedure Rows_Default;
begin
  WriteOut('Resetting each row to default setting');
  for Rows := 0 to 15 do
  begin
    V^.ResetPalette(Rows * 16, 16);
    pause;
  end;
end;

procedure UserBlocks;
begin
  WriteOut('Setting user described blocks x 16 - Red Yellow scale');
  V^.SetColorBlock(1*16, 16, @Dac16_Red);
  pause;
  WriteOut('Setting user described blocks x 16 - Green Cyan scale');
  V^.SetColorBlock(2*16, 16, @Dac16_Green);
  pause;
  WriteOut('Setting user described blocks x 16 - Blue Magenta scale');
  V^.SetColorBlock(3*16, 16, @Dac16_Blue);
  pause;
end;

procedure ResetAll;
begin
  WriteOut('Resetting complete palette to default');
  V^.ResetPalette(0, 256);
  pause;
end;

procedure Set4Color;
var
  Number: integer;
  i: integer;
begin
  Number := 0;
  for i := 0 to 63 do
  begin
    V^.SetColor(Number,i,i,i);
    Inc(Number);
  end;
  for i := 0 to 63 do
  begin
    V^.SetColor(Number,i,0,0);
    Inc(Number);
  end;
  for i := 0 to 63 do
  begin
    V^.SetColor(Number,0,i,0);
    Inc(Number);
  end;
  for i := 0 to 63 do
  begin
    V^.SetColor(Number,0,0,i);
    Inc(Number);
  end;
  WriteOut('Setting individual colors to primary gradients.');
  Pause;
end;

begin
  if not Vga_Detect then Halt;
  Adapter := New(PVesa, Init);
  { is VESA present? }
  if Adapter <> nil then
  begin
    { VESA is present }
    V := PVesa(Adapter);
    InitBGI_Vesa(V);
	  BGI_SetVESAMode(V, VESA_max)
  end
  else
  begin
    Adapter := New(PVga, Init);
    {Initialize graphics}
    InitBGI_Vga(Adapter, Vga_256);
    V := PVesa(Adapter);
    { standard BGI mode calls plus additional mode 13h }
    { VGAlo, VGAmed, VGAhi, VGA_256 (13h) }
  end;

  BarH := ((V^.StateInfo.NoCharRows *
	  V^.StateInfo.BytesperChar) div 17) - 5;
  BarW := BarH;
  TxtY := ((BarH + 5) * 16);
  TxtX := 0;

  Dobars;
{ PcxPalette;}
  CycleBGI;
  GrayScale;
  Rows_Default;
  GrayScale;
  UserBlocks;
  Set4Color;
  ResetAll;

end.
