Page 80,132
;*******************************************************
;*						       *
;* VERSION: 1.0 				       *
;*						       *
;* MODULE NAME: PASNET.ASM	Language Interface     *
;*						       *
;* DESCRIPTION:  NetWare interface drivers	       *						 *
;*						       *
;*	    Borland Turbo Pascal interface	       *
;*						       *
;* INPUTS:  Refer to individual procedures.	       *
;*						       *
;*						       *
;* RETURNS (OUTPUTS)  Refer to individual procedures.  *
;*						       *
;*						       *
;*******************************************************

title	Turbo Pascal - NetWare Interface Module

;+++++++++++++++++++++++++++++++++++++++++++++++++++++++
;+						       +
;+ For the following Turbo Pascal interface see        +
;+ the Borland Turbo Tutor manual and the	       +
;+ Reference Manual				       +
;+						       +
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++

cseg	segment byte public 'cseg'
	assume	cs:cseg

public	xtndopn, setattr, eojstat, PRLH_Log, PRLH_Rel, PRLH_Clr, PRLF_Log
public	PRLF_Rel, PRLF_Clr, PRLS_Lck, PRLS_Rel, PRLS_Clr, OpenSem, ExamSem
public	WaitSem, SigSem, ClosSem, setlck, Bakouts, btrans, etrans, exclog
public	exclcks, exculkf, exculks, excclrf, excclrs, reclog, reclck, reculk
public	reculks, recclr, recclrs, eoj, sysout, volstat
public	locdrv, wsid, errmode, bcsmode, ctlspl, splreq, pipreq, dpath, syslog
public	fattr, updfcb, cpyfile, nettod, clsmode, drvmap, retshl, asclog
public	asculkf, ascclrf, Get_PSN, Get_STA, SetServ, ModServ



;     vector table - starts at 0000, with each ensuing call
;	offset by 3 (the jmp instruction and an offset address)
	jmp	near ptr xtndopn
	jmp	near ptr setattr
	jmp	near ptr eojstat
	jmp	near ptr PRLH_Log
	jmp	near ptr PRLH_Rel
	jmp	near ptr PRLH_Clr
	jmp	near ptr PRLF_Log
	jmp	near ptr PRLF_Rel
	jmp	near ptr PRLF_Clr
	jmp	near ptr PRLS_Lck
	jmp	near ptr PRLS_Rel
	jmp	near ptr PRLS_Clr
	jmp	near ptr OpenSem
	jmp	near ptr ExamSem
	jmp	near ptr WaitSem
	jmp	near ptr SigSem
	jmp	near ptr ClosSem
	jmp	near ptr setlck
	jmp	near ptr Bakouts
	jmp	near ptr btrans
	jmp	near ptr etrans
	jmp	near ptr exclog
	jmp	near ptr exclcks
	jmp	near ptr exculkf
	jmp	near ptr exculks
	jmp	near ptr excclrf
	jmp	near ptr excclrs
	jmp	near ptr reclog
	jmp	near ptr reclck
	jmp	near ptr reculk
	jmp	near ptr reculks
	jmp	near ptr recclr
	jmp	near ptr recclrs
	jmp	near ptr eoj
	jmp	near ptr sysout
	jmp	near ptr volstat
	jmp	near ptr locdrv
	jmp	near ptr wsid
	jmp	near ptr errmode
	jmp	near ptr bcsmode
	jmp	near ptr ctlspl
	jmp	near ptr splreq
	jmp	near ptr pipreq
	jmp	near ptr dpath
	jmp	near ptr syslog
	jmp	near ptr fattr
	jmp	near ptr updfcb
	jmp	near ptr cpyfile
	jmp	near ptr nettod
	jmp	near ptr clsmode
	jmp	near ptr drvmap
	jmp	near ptr retshl
	jmp	near ptr asclog
	jmp	near ptr asculkf
	jmp	near ptr ascclrf
	jmp	near ptr Get_PSN
	jmp	near ptr Get_STA
	jmp	near ptr SetServ
	jmp	near ptr ModServ



;--------------------------------
; Extended Open a File func(61) (3DH)
;
; var
;	Mode, Handle, RetCode : Integer;
;	Filename	      : String[n];
;
; RetCode := xtndopn(Mode, Handle, Filename);
;

xtndopn proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+12]  	; put the mode in ax
	mov	ax,[si]
	mov	ah,03Dh     	; put the function in ah
	lds	dx,[bp+4]   	;ptr to ASCIIZ string
	inc	dx	    	;add 1 to get to the beginning of the string
	int	21h
	jnc	noerr
	jmp	quit
noerr:
	lds	di,[bp+8]   	;put the handle into the variable
	mov	[di],ax      	;if there is no error and
	xor	ax,ax	     	;return a 0
quit:
	pop	ds
	pop	bp
	ret	14
xtndopn endp




;--------------------------------
; Get or Set File Attributes(handle) func(67) (43H)
;
; var
;	Func, Attribute, ErrCode : Integer;
;	Filename		 : String[n];
;
;ErrCode := setattr(Func, Attribute, Filename);
;

setattr proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+12]  	; put the subfunction in ax
	mov	ax,[si]
	mov	ah,043h     	; put the function in ah
	lds	dx,[bp+4]   	;ptr to var desc block for ASCIIZ string
	inc	dx	    	;add 1 to get the address of the string
	lds	si,[bp+8]   	;put the attribute to set in cx
	mov	cx,[si]
	int	21h
	jnc	okay
	mov	ah,00h
	jmp	getout
okay:
	lds	di,[bp+8]   	;put the returned attributes in the
	mov	[di],cx     	;variable if there is no error
	xor	ax,ax	    	;and return a 0
getout:
	pop	ds
	pop	bp
	ret	14
setattr endp




;--------------------------------
; End of Job Flag Status func(187) (BBH)
;
; var
;	Flag : Integer;
;
;ErrCode := eojstat(Flag);
;

eojstat proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+4]   ; put the flag in ax
	mov	ax,[si]
	mov	ah,0BBh     ; put the function in ah
	int	21h
	mov	ah,0
	lds	di,[bp+4]
	mov	[di],ax
	pop	ds
	pop	bp
	ret	6
eojstat endp




;------------------------------------------------------------
;
; Physical Record Lock: Log Record   BCH
;
; var
;	ErrCode,FileHandle,HiByteOffset,LoByteOffset : Integer
;	HiLockLen,LoLockLen,Flags,TimeOut	     : Integer
;
;ErrCode := PRLH_Log(FileHandle,HiByteOffset,LoByteOffset,HiLockLen,
;		     LoLockLen,Flags,TimeOut);
;

PRLH_Log proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+28]		;FileHandle
	mov	bx,[si]
	lds	si,[bp+24]		;ByteOffset
	mov	cx,[si]
	lds	si,[bp+20]
	mov	dx,[si]
	lds	si,[bp+8]		;AL = Log Flags
	mov	ax,[si]
	lds	si,[bp+16]		;LockLen
	mov	si,[si]
	lds	di,[bp+12]
	mov	di,[di]
	lds	bp,[bp+4]		;time out
	mov	bp,[bp]
	mov	ah,0BCH
	int	21H
	mov	ah,0			;0 the high byte of the return
	pop	ds
	pop	bp
	ret	30

PRLH_Log endp





;-----------------------------------------
;
; Physical Record Lock: Release Rec  BDH
;
; var
;	FileHandle,HiByteOffset,LoByteOffset,ErrCode,
;       HiWordLen,LoWordLen : integer;
;
; ErrCode := PRLH_Rel(FileHandle,HiByteOffset,LoByteOffset,HiWordLen,
;                           LoWordLen:integer);


PRLH_Rel proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+20]		;FileHandle
	mov	bx,[si]
	lds	si,[bp+16]	       	;HiByteOffset
	mov	cx,[si]
	lds	si,[bp+12]        	;LoByte
	mov	dx,[si]
 	lds 	si,[bp+8]         	;HiWordLen
 	mov 	si,[si]
 	lds 	di,[bp+4]         	;LoWordLen
 	mov 	di,[di]
	mov	ah,0BDH
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	22
PRLH_Rel endp





;------------------------------------------------
;
; Physical Record Lock: Release Clr  BEH
;
; var
;    FileHandle,HiByteOffset,LoByteOffset,ErrCode,
;    HiWordLen,LoWordLen : integer;
; 
;  ErrCode := PRLH_Rel(FileHandle,HiByteOffset,LoByteOffset,HiWordLen,
;                           LoWordLen:integer);
;


PRLH_Clr proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+20]		;FileHandle
	mov	bx,[si]
	lds	si,[bp+16]	       	;ByteOffset
	mov	cx,[si]
	lds	si,[bp+12]
	mov	dx,[si]
 	lds 	si,[bp+8]         	;HiWordLen
 	mov 	si,[si]
 	lds 	di,[bp+4]         	;LoWordLen
 	mov 	di,[di]
	mov	ah,0BEH
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	22
PRLH_Clr endp





;--------------------------------------------------
;
; Physical Record Lock: Log Rec FCB BFH
;
; var
;	ErrCode,fcb,HiByteOffset,LoByteOffset : Integer;
;	HiLockLen,LoLockLen,Flags,TimeOut     : Integer;
;
; ErrCode := PRLF_Log(fcb,HiByteOffset,LoByteOffset,HiLockLen,LoLockLen,Flags,TimeOut);
;


PRLF_Log proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+28]	      	;FCB
	mov	dx,[si]
	lds	si,[bp+24]	      	;ByteOffset
	mov	bx,[si]
	lds	si,[bp+20]
	mov	cx,[si]
	lds	si,[bp+8]	     	;AL = Log Flags
	mov	ax,[si]
	lds	si,[bp+12]	      	;low lock length
	mov	di,[si]
	lds	si,[bp+16]	      	;hi lock length
	mov	si,[si]
	mov	bp,[bp+4]	     	;timeout value
	mov	bp,[bp]
	mov	ah,0BFH
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	28
PRLF_Log endp





;--------------------------------------------------
;
; Physical Record Lock: Rel Rec FCB C0H
;
; var
;	ErrCode,fcb,HiByteOffset,LoByteOffset : Integer;
;
; ErrCode := PRLF_Rel(fcb,HiByteOffset,LoByteOffset);
;


PRLF_Rel proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+12]	      	;FCB
	lds	si,[bp+8]	     	;ByteOffset
	mov	bx,[si]
	lds	si,[bp+4]
	mov	cx,[si]
	mov	ah,0C0H
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	12
PRLF_Rel endp





;-----------------------------------------------
;
; Physical Record Lock: Clr Rec FCB C1H
;
; var
;	ErrCode,fcb,HiByteOffset,LoByteOffset : Integer;
;
; ErrCode := PRLF_clr(fcb,HiByteOffset,LoByteOffset);
;


PRLF_Clr proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+12]	      	;FCB
	lds	si,[bp+8]	     	;ByteOffset
	mov	bx,[si]
	lds	si,[bp+4]
	mov	cx,[si]
	mov	ah,0C0H
	int	21H
	mov	ah,0
	pop	ds
	pop	bp
	ret	12
PRLF_Clr endp





;---------------------------------------------
;
; Lock Record Set  C2H
;
; var
;	ErrCode, Flags, TimeOut : Integer;
;
; ErrCode := PRLS_Lck(Flags,TimeOut);
;


PRLS_Lck proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+8]	       	;AL = Lock flag bits
	mov	ax,[si]
	lds	si,[bp+4]	       	;TimeOut Value
	mov	bp,[si]
	mov	ah,0C2h
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	10
PRLS_Lck endp





;----------------------------------------------
;
; Release Record Set  C3H
;
; var
;	ErrCode : Integer;
;
; ErrCode := PRLS_Rel;
;


PRLS_Rel proc	near
	mov	ah,0C3h
	int	21h
	mov	ah,0
	ret
PRLS_Rel endp





;----------------------------------------------
;
; Clear Record Set  C4H
;
; var
;	ErrCode : Integer;
;
; errcode := PRLS_Clr;
;


PRLS_Clr proc	near
	mov	ah,0C4h
	int	21h
	mov	ah,0
	ret
PRLS_Clr endp





;--------------------------------
; Semaphores func(197) (C5H) subfunction 00h
;
; var
;	RetCode,SemaValu,HiHandle,LoHandle,OpenCnt : Integer;
;	Sema4 : String[n];
;
; RetCode := OpenSem(Sema4,SemaValu,HiHandle,LoHandle,OpenCnt);
;


OpenSem proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+20]  	;ptr to Semaphore string
	lds	si,[bp+16]  	;set semaphore value
	mov	cx,[si]
	mov	ax,0C500h    	;set the function
	int	21h
	mov	bh,00h
	lds	di,[bp+4]  	;return the open count
	mov	[di],bx
	lds	di,[bp+8]  	;return low handle
	mov	[di],cx
	lds	di,[bp+12]  	;return high handle
	mov	[di],dx
	mov	ah,00h
	pop	ds
	pop	bp
	ret	22
OpenSem endp





;--------------------------------
; Semaphores func(197) (C5H) subfunction 01h
;
; var
;	RetCode,HiHandle,LoHandle,SemaValu,OpenCnt : Integer;
;
; RetCode := ExamSem(HiHandle,LoHandle,SemaValu,OpenCnt);
;


ExamSem proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+16]		;hi handle
	mov	dx,[si]
	lds	si,[bp+12]		;lo handle
	mov	cx,[si]
	mov	ax,0C501h		;set function
	int	21h
	lds	di,[bp+8]	       	;return semaphore value
	mov	[di],cx
	mov	dh,00h
	lds	di,[bp+4]
	mov	[di],dx 	     	;return open count
	mov	ah,00h
	pop	ds
	pop	bp
	ret	16
ExamSem endp





;--------------------------------
; Semaphores func(197) (C5H) subfunction 02h
;
; var
;	RetCode,HiHandle,LoHandle,TimeOut : Integer;
;
; RetCode := WaitSem(HiHandle,LoHandle,TimeOut);
;


WaitSem proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+12]		;hi handle
	mov	dx,[si]
	lds	si,[bp+8]	       	;lo handle
	mov	cx,[si]
	lds	si,[bp+4]
	mov	bp,[si] 	     	;set time out
	mov	ax,0C502h		;set function
	int     21h
	mov	ah,00h
	pop	ds
	pop	bp
	ret	12
WaitSem endp





;--------------------------------
; Semaphores func(197) (C5H) subfunction 03h
;
; var
;	RetCode,HiHandle,LoHandle : Integer;
;
; RetCode := SigSem(HiHandle,LoHandle);
;


SigSem	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+8]	       	;hi handle
	mov	dx,[si]
	lds	si,[bp+4]	       	;lo handle
	mov	cx,[si]
	mov	ax,0C503h		;set function
	int	21h
	mov	ah,00h
	pop	ds
	pop	bp
	ret	8
SigSem	endp





;--------------------------------
; Semaphores func(197) (C5H) subfunction 04h
;
; var
;	RetCode,HiHandle,LoHandle : Integer;
;
; RetCode := ClosSem(HiHandle,LoHandle);
;


ClosSem proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+8]	       	;hi handle
	mov	dx,[si]
	lds	si,[bp+4]	       	;lo handle
	mov	cx,[si]
	mov	ax,0C504h		;set function
	int	21h
	mov	ah,00h
	pop	ds
	pop	bp
	ret	8
ClosSem endp





;--------------------------------
; Get or Set Lock Mode func(198) (C6H)
;
; var
;	Mode,Func : Integer;
;
; Mode := setlck(Func);
;


setlck	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+4]
	mov	ax,[si] 	      	;set the subfunction
	mov	ah,0C6h 		;set  the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	4
setlck endp





;--------------------------------
; Transactional Backout func(199) (C7H)
;
; var
;	RetCode, Func : Integer;
;
; RetCode := BakOuts(Func);
;


BakOuts proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+4]	       	;set the subfunction
	mov	ax,[si]
	mov	ah,0C7h 		;set  the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	4
BakOuts endp





;--------------------------------
; Begin transaction  func(200) (C8H)
;
; var
;	RetCode,Mode : Integer;
;
; RetCode := btrans(Mode);
;


btrans	proc	near
	mov	ah,0C8h
	call	arg1t
	ret	4
btrans	endp





;--------------------------------
; End Transaction func(201) (C9H)
;
; var
;	RetCode : Integer;
;
; RetCode := etrans;
;


etrans	proc	near
	mov	ah,0C9H
	int	021h
	mov	ah,00h
	ret
etrans	endp





;--------------------------------
; Exc.log File (202) (CA)
;
; var
;	RetCode, FcbAddr : Integer;
;
; RetCode := exclog(FcbAddr);
;

exclog	proc	near
	mov	ah,0CAH
	call	arg1f
	ret	4
exclog	endp





;--------------------------------
; Exc Lock Set	func(203) (CBH)
;
; var
;	RetCode, Mode : Integer;
;
; RetCode := exclcks(Mode);
;


exclcks proc	near
	mov	ah,0CBH
	call	arg1
	ret	4
exclcks endp
	



;--------------------------------
; Exclusive file unlock (204) (CC)
;
; var
;	RetCode, FcbAddr : Integer;
;
; RetCode := exculkf(FcbAddr);
;


exculkf proc	near
	mov	ah,0CCH
	call	arg1f
	ret	4
exculkf endp





;--------------------------------
; Exclusive Unlock Set (205)(CD)
;
; var
;	RetCode : Integer;
;
; RetCode := exculks;
;


exculks proc	near
	mov	ah,0CDH
	int	21h
	mov	ah,00h
	ret
exculks endp



	

;--------------------------------
; Exc Clear file func(206) (CEH)
;
; var
;	RetCode, FcbAddr : Integer;
;
; RetCode := excclrf(FcbAddr);
;


excclrf proc	near
	mov	ah,0CEH
	call	arg1f
	ret	4
excclrf endp





;--------------------------------
; Exc Clear Set  func(207) (CFH)
;
; var
;	RetCode : Integer;
;
; RetCode := excclrs;
;


excclrs proc	near
	mov	ah,0CFH
	int	21h
	mov	ah,00h
	ret
excclrs endp





;--------------------------------
; Log Record(s) func(208) (D0H)
;
; var
;	RetCode, Flag, Timeout : Integer ;
;	RecStr	: String[n];
;
; RetCode := reclog(RecStr,Flag,Timeout);
;


reclog	proc	near
 	push 	bp
 	mov 	bp,sp
 	push 	ds
 	lds 	si,[bp+8]  		;load flags
 	mov 	ax,[si]
 	lds 	si,[bp+4]  		;get timeout
 	mov 	si,[si]
 	lds 	dx,[bp+12] 		;get ptr to string
 	mov 	bp,si      		;move timeout to BP
 	mov 	ah,0D0h
 	int 	21h
 	mov 	ah,0
 	pop 	ds
 	pop 	bp
 	ret 	14
reclog	endp






;--------------------------------
; Record Lock func(209) (D1H)
;
; var
;	RetCode, Mode : Integer;
;
; RetCode := reclck(Mode);
;


reclck	proc	near
 	push 	bp
 	mov 	bp,sp
 	push	 ds
 	lds 	si,[bp+4]
 	mov 	bp,[si]
 	mov 	ah,0D1h
 	int 	21h
 	mov 	ah,0
 	pop 	ds
 	pop 	bp
 	ret 	6
reclck	endp





;--------------------------------
; Record Unlock func(210) (D2H)
;
; var
;	RetCode   : Integer;
;	Semaphore : String[n];
;
; RetCode := reculk(Semaphore);
;


reculk	proc	near
	mov	ah,0D2H
	call	arg1a
	ret	4
reculk	endp





;--------------------------------
; Unlock Record Set func(211) (D3H)
;
; var
;	RetCode : Integer;
;
; RetCode := reculks;
;


reculks proc	near
	mov	ah,0D3H
	int	21h
	mov	ah,00h
	ret
reculks endp





;--------------------------------
; Record Clear func(212) (D4H)
;
; var
;	RetCode   : Integer;
;	Semaphore : String[n];
;
; RetCode := recclr(Semaphore);
;


recclr	proc	near
	mov	ah,0D4H
	call	arg1a
	ret	4
recclr	endp





;--------------------------------
; Clear record set func(213) (D5H)
;
; var
;	RetCode : Integer;
;
; RetCode := recclrs;
;


recclrs proc	near
	mov	ah,0D5H
	int	21h
	mov	ah,00h
	ret	4
recclrs endp





;--------------------------------
; End of Job  func(214) (D6H)
;
; var
;	RetCode : Integer;
;
; RetCode := eoj;
;

eoj	proc	near
	mov	ah,0D6H
	int	21h
	mov	ah,00h
	ret	4
eoj	endp





;--------------------------------
; Logout System  func(215) (D7H)
;
; var
;	RetCode : Integer;
;
; RetCode := sysout;
;


sysout	proc	near
	mov	ah,0D7H
	int	21h
	mov	ah,00h
	ret	4
sysout	endp





;--------------------------------
; Vol Statistics func(218) (DAH)
;
; var
;	RetCode,volume : Integer;
;	reply  : String[n];
;
; RetCode := volstat(volume, reply);


volstat proc	near
	mov	ah,0DAh
	push	bp
	mov	bp,sp
	push	ds
	push	es
	lds	si,[bp+8] 	;addr for the volume number
	mov	dx,[si]   	;get the volume number
	les	di,[bp+4] 	;ptr to reply buffer
	inc	di	  	;add 1 to get the address of the string
	int	21h
	mov	ah,00h
	pop	es
	pop	ds
	pop	bp
	ret	8
volstat endp





;--------------------------------
; Local Disks  func(219) (DBH)
;
; var
;	NumDisks : Integer;
;
; NumDisks := locdrv;
;


locdrv	proc	near
	mov	ah,0DBH
	int	21h
	mov	ah,00h
	ret
locdrv endp





;--------------------------------
; WorkStation ID func(220) (DCH)
;
; note: This routine returns the station number as an integer.
;	It can also be returned in ASCII with this call.
;
; var
;	StationNum : Integer;
;
; StationNum := wsid;
;


wsid   proc    near
       mov     ah,0DCH
       int     21h
       mov     ah,00h
       ret
wsid   endp





;--------------------------------
; Set Error mode func(221) (DDH)
;
; var
;	mode : Integer;
;
; errmode(mode);
;


errmode proc	near
	mov	ah,0DDH
	call	arg1
	ret	4
errmode endp





;--------------------------------
; Broadcast Mode func(222) (DEH)
;
; var
;	mode : Integer;
;
; bcsmode(mode);
;

bcsmode proc	near
	mov	ah,0DEH
	call	arg1
	ret	4
bcsmode endp





;--------------------------------
; Modify LST Device  func(223) (DFH)
;
; var
;	RetCode, Mode : Integer;
;
; RetCode := ctlspl(Mode);
;

ctlspl	proc	near
	mov	ah,0DFh
	call	arg1
	ret	4
ctlspl	endp





;--------------------------------
; Spool Request func(224) (E0H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := splreq(RequestBlock, Reply);
;

splreq	proc	near
	mov	ah,0E0h
	call	req_rep
	ret	8
splreq	endp





;--------------------------------
; Pipe Request func(225) (E1H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := pipreq(RequestBlock, Reply);
;

pipreq	proc	near
	mov	ah,0E1h
	call	req_rep
	ret	8
pipreq	endp





;--------------------------------
; Directory Path func(226) (E2H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := dpath(RequestBlock, Reply);
;

dpath	proc	near
	mov	ah,0E2h
	call	req_rep
	ret	8
dpath	endp





;--------------------------------
; Login system func(227) (E3H)
;
; var
;	ErrCode 	    : Integer;
;	RequestBlock, Reply : String[n];
;
; ErrCode := syslog(RequestBlock, Reply);
;

syslog	proc	near
	mov	ah,0E3h
	call	req_rep
	ret	8
syslog	endp





;--------------------------------
; Set File Attribute func(228) (E4H)
;
; var
;	RetCode, FcbAddr, Attribute : Integer;
;
; RetCode := fattr(FcbAddr, Attribute);
;

fattr	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+4]
	mov	cx,[si]  ;cx=attribute
	lds	dx,[bp+8];dx=address of fcb
	mov	ah,0E4h
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret
fattr	endp





;--------------------------------
; Update file size func(229) (E5H)
;
; var
;	ErrCode,FcbAddr : Integer;
;
; ErrCode := updfcb(FcbAddr);
;

updfcb	proc	near
	mov	ah,0E5H
	call	arg1f
	ret	4
updfcb	endp





;--------------------------------
; Copy File to File func(230) (E6H)
;
; var
;	RetCode,FcbSource,FcbDest : Integer;
;	CountLow, CountHigh	  : Integer;
;
; RetCode := cpyfile(FcbSource, FcbDest, CountLow, CountHigh)
;
;

cpyfile proc	near			
	mov	ah,0E6h
	push	bp
	mov	bp,sp
	push	ds
	push	es
	lds	si,[bp+4]   		;addr of the high byte cnt
	mov	dx,[si]     		;dx=high word of byte cnt
	lds	si,[bp+8]   		;addr low word of byte cnt
	mov	cx,[si]     		;cx=low 16 bits of count
	les	di,[bp+12]  		;address of dest fcb
	lds	si,[bp+16]  		;address of the source fcb
	int	21h
	mov	ah,0
	pop	es
	pop	ds
	pop	bp
	ret	16
cpyfile endp





;--------------------------------
; get time / date string func(231) (E7H)
;
; var
;	time : String[n];
;
; nettod(time);
;
; where time is a string of the form Y M D H M S
;

nettod	proc	near
	mov	ah,0E7h
	call	arg1a
	ret	4
nettod	endp





;--------------------------------
; Set Close mode func(232) (E8H)
;
; var
;	mode : Integer;
;
; clsmode(mode);
;

clsmode proc	near
	mov	ah,0E8H
	call	arg1wor
	ret	4
clsmode endp






;--------------------------------
; Shell Base Status func(233) (E9H)
;
; var
;	RetFlags, drive : Integer;
;
; RetFlags := drvmap(drive);
;

drvmap	proc	near
	mov	ax,0E900h
	call	arg1
	ret	4
drvmap	endp






;--------------------------------
; Return Shell Version func(234) (EAH)
;
; var
;	RetCode, Mode : Integer;
;	EnvirStr      : String[n];
;
; RetCode := retshl(EnvirStr, Mode);
;

retshl	proc	near
	push	bp
	mov	bp,sp
	push	ds
	push	es
	les	di,[bp+8] 	;set es:di to point at the buffer
	inc	di	  	;point di at the start of the data area
	lds	si,[bp+4] 	;put the mode into al
	mov	ax,[si]
	mov	ah,0EAh
	int	21h
	mov	ah,00h
 	pop 	es
 	pop 	ds
 	pop 	bp
	ret	8
retshl	endp





;--------------------------------
; ascii log File (235) (EB)
;
; var
;	RetCode, Flags, TimeOut : Integer;
;	Asciiz			: String[n];
;
; RetCode := asclog(Flags, TimeOut, Asciiz);
;

asclog	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+12]
	mov	ax,[si]   		;flags into al
	lds	dx,[bp+4] 		;pointer to the asciiz string
	lds	si,[bp+8]
	mov	bp,[si]   		;time out into bp
	mov	ah,0EBH
	int	21h
	mov	ah,00h
 	pop 	ds
 	pop 	bp
	ret	12
asclog	endp





;--------------------------------
; ASCIIZ file unlock (236) (EC)
;
; var
;	RetCode : Integer;
;	Asciiz	: String[n];
;
; RetCode := asculkf(Asciiz);
;

asculkf proc	near
	mov	ah,0ECH
	call	arg1a
	ret	4
asculkf endp





;--------------------------------
; ASCIIZ Clear file func(237) (EDH)
;
; var
;	RetCode : Integer;
;	Asciiz	: String[n];
;
; RetCode := ascclrf(Asciiz);
;

ascclrf proc	near
	mov	ah,0EDH
	call	arg1a
	ret	4
ascclrf endp





;--------------------------------------------
;
; Get Physical Station Number  EEH
;
; var
;	StationNo : Integer;
;
; StationNo := Get_PSN;
;

Get_PSN proc	near

	mov	ah,0EEh
	int	21h
	mov	ah,0
	ret
Get_PSN endp





;-----------------------------------------------------
;
; Get Shell Table Addresses (239) EFH
;
; var
;	Mode,Segment,Offset : Integer;
;
; Get_STA(Mode,Segment,Offset);
;

Get_STA proc	near
	push	bp
	mov	bp,sp
	push	es
	push	ds
	mov	si,[bp+12]		;get the mode
	mov	ax,[si]
	mov	ah,0EFh 		;set the function
	int	21h
	lds	di,[bp+8]		;store the segment location
	mov	[di],es
	lds	di,[bp+4]		;store the offset location
	mov	[di],si
	pop	ds
	pop	es
	pop	bp
	ret	12
Get_STA endp





;-----------------------------------------------
;
; Set Preferred File Server (240) F0H
;
; var
;	RetServer, Mode, NewServ : Integer;
;
; RetServer := SetServ(Mode,NewServ);
;

SetServ proc	near
	push	bp
	mov	bp,sp
	push	ds
	mov	si,[bp+8]		;get the mode
	mov	ax,[si]
	mov	di,[bp+4]		;set the preferred server number
	mov	dx,[di]
	mov	ah,0F0h 		;set the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	6
SetServ endp





;-----------------------------------------------------------
;
; Attach/Detach To File Server (241) F1H
;
; var
;	RetCode, Mode, NewServ : Integer;
;
; RetCode := ModServ(Mode,NewServ);
;

ModServ proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+8]		;get the mode
	mov	ax,[si]
	lds	di,[bp+4]		;set the preferred server number
	mov	dx,[di]
	mov	ah,0F1h 		;set the function
	int	21h
	mov	ah,0
	pop	ds
	pop	bp
	ret	6
ModServ endp





;-------------------------------
; Place a single integer argument into dx
; with a return code

arg1	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+6]
	mov	dx,[si]    ;dx gets the argument
	int	21h
	mov	ah,0	   ;clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1	endp





;--------------------------------
; Place a single integer argument into bp
; for use with time outs - with a return code

arg1t	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+6]
	mov	bp,[si]    ;dx gets the argument
	int	21h
	mov	ah,0	   ;clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1t	endp






;--------------------------------
; Process an fcb address in a
; function call with a return code

arg1f	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+6]  	;dx gets the argument
	int	21h
	mov	ah,0	   	;clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1f	endp





;--------------------------------
; Process a single string argument in a
; function call with a return code

arg1a	proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+6] 	;ptr to parameter string
	int	21h
	mov	ah,0	  	;clear ah for al return code
	pop	ds
	pop	bp
	ret
arg1a	endp






;----------------------------
; Perform a single integer argument
; but without a return code

arg1wor proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	si,[bp+6]
	mov	dx,[si]   	;dx gets the arg (or ptr)
	int	21h
	pop	ds
	pop	bp
	ret
arg1wor endp






;----------------------------
; Perform a single string argument
; but without a return code

arg1awor proc	near
	push	bp
	mov	bp,sp
	push	ds
	lds	dx,[bp+6]
	inc	dx	  	;add 1 to get the start of the string
	int	21h
	pop	ds
	pop	bp
	ret
arg1awor endp






;----------------------------
; Handle a request$ and reply$ function
; with error code

req_rep proc	near
	push	bp
	mov	bp,sp
	push	ds
	push	es
	lds	si,[bp+10]   	;ptr to req. string
	inc	si	    	;add 1 to get the address of the string
	les	di,[bp+6]   	;ptr to var desc block for reply buf
	inc	di	    	;add 1 to get the address of the string
	pushf		      	;save the direction flag
	int	21h
	popf
	mov	ah,0
	pop	es
	pop	ds
	pop	bp
	ret
req_rep endp



cseg	ends
	end
