{$A+,B-,D+,E-,F+,I-,L-,N-,O+,R-,S-,V-}
{$I OPDEFINE.INC}
{$DEFINE UseClipBoard} {define to support a direct clipboard between files.
                         **NOT CURRENTLY IMPLEMENTED**}

{*********************************************************}
{*                   EDITOR.PAS 1.00                     *}
{*     An example program for Object Professional 1.0    *}
{*        Copyright (c) TurboPower Software 1989.        *}
{*                 All rights reserved.                  *}
{*********************************************************}
{* Converted to unit format and modified by Steve Sneed  *}
{* 25-Feb-90 - All rights to modifications hereby re-    *}
{* leased to TurboPower Software for their release or    *}
{* use.                                                  *}
{*********************************************************}

unit TPE;
  {-basic full editor w/ TPC execution & "clipboard"}

interface

uses
  Dos,
  OpCmd,
  OpCrt,
  OpString,
  OpRoot,
  OpDos,
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  ExecAccess,
  OpEdit,
  OpFrame,
  OpWindow,
  OpMemo,
  OpEditor;

const
  OurColorSet : ColorSet = (
    TextColor       : $1B; TextMono       : $07;
    CtrlColor       : $1C; CtrlMono       : $0F;
    FrameColor      : $1B; FrameMono      : $07;
    HeaderColor     : $2F; HeaderMono     : $07; {use for status line}
    ShadowColor     : $07; ShadowMono     : $07;
    HighlightColor  : $4F; HighlightMono  : $70;
    PromptColor     : $1F; PromptMono     : $0F; {use for message line}
    SelPromptColor  : $1F; SelPromptMono  : $0F;
    ProPromptColor  : $07; ProPromptMono  : $07;
    FieldColor      : $1E; FieldMono      : $07;
    SelFieldColor   : $1E; SelFieldMono   : $07;
    ProFieldColor   : $07; ProFieldMono   : $07;
    ScrollBarColor  : $07; ScrollBarMono  : $07;
    SliderColor     : $07; SliderMono     : $07;
    HotSpotColor    : $70; HotSpotMono    : $07;
    BlockColor      : $3E; BlockMono      : $70;
    MarkerColor     : $4F; MarkerMono     : $70;
    DelimColor      : $0F; DelimMono      : $0F;
    SelDelimColor   : $70; SelDelimMono   : $70;
    ProDelimColor   : $07; ProDelimMono   : $07;
    SelItemColor    : $2F; SelItemMono    : $70;
    ProItemColor    : $17; ProItemMono    : $07;
    HighItemColor   : $1F; HighItemMono   : $0F;
    AltItemColor    : $1F; AltItemMono    : $0F;
    AltSelItemColor : $2F; AltSelItemMono : $70;
    FlexAHelpColor  : $1F; FlexAHelpMono  : $0F;
    FlexBHelpColor  : $1F; FlexBHelpMono  : $0F;
    FlexCHelpColor  : $1B; FlexCHelpMono  : $70;
    UnselXrefColor  : $1E; UnselXrefMono  : $09;
    SelXrefColor    : $5F; SelXrefMono    : $70;
    MouseColor      : $4A; MouseMono      : $70
  );

{$IFDEF UseClipBoard}
type
  BufType      = array[1..65521] of Char;
  BufPtr       = ^BufType;
  ClipBoardRec = record
                   Buff   : BufPtr;
                   ALen   : Word;
                   Active : Boolean;
                 end;

var
  ClipBoard : ClipBoardRec;
{$ENDIF}

var
  I, FSize    : LongInt;
  TE          : TextEditor;
  BufSize     : Word;
  ExitCode    : Byte;
  FName       : PathStr;
  YN          : Byte;


procedure MainEditor(FN : String);

implementation

const
  NoScrRestore : Boolean = FALSE;

var
  EdOldExit   : Pointer;
  BPP         : Pointer;
  BPX,BPL     : Word;
  SwapP       : Pointer;
  SwapX,SwapL : Word;
  ScrLines    : Array[1..3] of String[132]; {allow for wide screen modes}

  ErrorSeen   : Boolean;
  ErrorX,
  ErrorY      : Integer;
  ErrorFName  : PathStr;
  CmdList     : String;


{---}

  procedure EdExit;
  begin
    ExitProc := EdOldExit;
    if NoScrRestore then exit;
    RestoreWindow(1,1,ScreenWidth,ScreenHeight,True,BPP);
    RestoreCursorState(BPX,BPL);
  end;

{---}

  procedure CheckCompileError;
  var I : Integer;
  begin
    FillChar(ScrLines,SizeOf(ScrLines),0);
    for I := 1 to 3 do
      FastRead(ScreenWidth,(ScreenHeight - 3) + I,1,ScrLines[I]);
    ErrorX := Pos('^',ScrLines[3]);
    ErrorSeen := (ErrorX > 0);
  end;

  procedure ProcessCompileError;
  var S : String[5];
      I : Byte;
      C : PathStr;
  begin
    if NOT ErrorSeen then with OurColorSet do begin
      FastWrite(Pad(Copy(ScrLines[1],1,Pred(Pos('(',ScrLines[1])))+': '+ScrLines[2],ScreenWidth),
                ScreenHeight,1,ColorMono(TextColor,TextMono));
    end
    else with OurColorSet do begin
      FastWrite(Pad(ScrLines[1],ScreenWidth),ScreenHeight,1,ColorMono(HighlightColor,HighlightMono));
      ErrorFName := StUpCase(AddBackSlash(JustPathName(FName)) + Copy(ScrLines[1],1,Pred(Pos('(',ScrLines[1]))));
      S := '';
      I := Succ(Pos('(',ScrLines[1]));
      while ScrLines[1][I] in ['0'..'9'] do begin
        S := S + ScrLines[1][I];
        Inc(I);
      end;
      if NOT Str2Int(S,ErrorY) then ErrorY := 0;
      if (ErrorX > 0) and (ErrorY > 0) then begin
        CmdList := '';
        if ErrorFName <> FName then
          CmdList := Chr(ccNewFile) + Chr(ccChar) + ErrorFName + Chr(ccChar);
        CmdList := CmdList + Chr(ccUser1);
        EditorCommands.SetCommandList(@CmdList[1],Ord(CmdList[0]));
      end;
    end;
  end;

  procedure ExecAction(AC : ActionCodeType; Param : Word);
  begin
    case AC of
      ExecSaveScreen :
        begin
          DisableEventHandling;
          FastWrite(CharStr(' ',ScreenWidth),ScreenHeight,1,$07);
          if SaveWindow(1,1,ScreenWidth,ScreenHeight,False,SwapP) then ;
          GetCursorState(SwapX,SwapL);
          Window(1,1,ScreenWidth,ScreenHeight);
          gotoXY(1,ScreenHeight);
          ClrEol;
          Write('Swapping out...'+^M);
        end;
      ExecShowMemory :
{!! S.S. NOTE: This doesn't work, for some unknown reason}
        begin
          FastWrite('Approx. memory available: '+Long2Str(Param)+'k',WhereY,WhereX,$07);
          Delay(1000);
        end;
      ExecPauseAfterRun :
        begin
          CheckCompileError;
        end;
      ExecRestoreScreen :
        begin
          RestoreWindow(1,1,ScreenWidth,ScreenHeight,False,SwapP);
          RestoreCursorState(SwapX,SwapL);
          EnableEventHandling;
        end;
    end;
  end;

  procedure Compile(FN : String);
  var I : Integer;
  begin
    I := ExecDOSSwap('TPC '+FN,True,@ExecAction,'\$$TPED$$.SWP');
  end;

{---}

{$IFDEF UseClipBoard}
  function BlockToClipBoard(var CBP; CBLen : Word) : boolean;
  begin
    with TE, Clipboard do begin
      if Active then begin
        Active := False;           {turn off for safety}
        FreeMemCheck(Buff,ALen);   {get rid of old clipboard contents}
      end;
      if GetMemCheck(Buff,CBLen) then begin
        ALen := CBLen;
        Move(CBP,Buff^,CBLen);
        Active := True;
      end;
      BlockToClipBoard := Active;
    end;
  end;

  procedure CopyToClipBoard(Cut : Boolean);
  var Start, Stop, Total : Word;
  begin
    with TE, ClipBoard do begin
      teBlockBounds(Start,Stop,Total,false);   {this is a "private" method}
      if (Total > 0) and (BlockToClipBoard(meBufPtr^[Start],Total)) and (Cut)then begin
        CmdList := Chr(ccBlkDelete);
        EditorCommands.SetCommandList(@CmdList[1],Ord(CmdList[0]));
      end;
    end;
  end;

  procedure PasteFromClipBoard;
  begin
    with Clipboard do begin
      if NOT Active then exit;
      TE.InsertTextAtCursor(Buff^,ALen);
    end;
  end;

  procedure ClearClipBoard;
  begin
    with ClipBoard do begin
      if NOT Active then exit;
      FreeMemCheck(Buff,ALen);
      Active := False;
    end;
  end;
{$ENDIF}

{---}

  procedure MergeString(T : String; N : Byte; var S : String);
    {-Merge T into S at column N}
  begin
    Move(T[1], S[N], Length(T));
  end;

  procedure MergeNumber(N : LongInt; Col : Byte; var S : String);
    {-Merge the number N into S at Col}
  var
    St : String[15];
    StLen : Byte absolute St;
  begin
    St := Long2Str(N);
    Move(St[1], S[Col], StLen);
  end;

  procedure MergeNumberRight(N : LongInt; Col : Byte; var S : String);
    {-Merge the number N into S, right-aligned at Col}
  var
    St : String[15];
    StLen : Byte absolute St;
  begin
    St := Long2Str(N);
    Move(St[1], S[Col-Pred(StLen)], StLen);
  end;

  procedure UserHook(CPP : CommandProcessorPtr; MT : MatchType; Key : Word);
    {-Called each time CommandProcessor evaluates a keystroke}
  var
    S : string[2];
    {$IFDEF UseMouse}
    SaveMouse : Boolean;
    {$ENDIF}
  begin
    S := '  ';
    if MT = PartMatch then
      if Lo(Key) < Ord(' ') then begin
        S[1] := '^';
        S[2] := Char(Lo(Key)+$40);
      end
      else
        S[1] := '+';

    {$IFDEF UseMouse}
    HideMousePrim(SaveMouse);
    {$ENDIF}

    with OurColorSet do
      FastWrite(S, ErrorRow, 1, ColorMono(PromptColor, PromptMono));

    {$IFDEF UseMouse}
    ShowMousePrim(SaveMouse);
    {$ENDIF}
  end;

  procedure OurStatusProc(MP : MemoPtr);
    {-Display status line}
  const
    OnOff : array[Boolean] of string[3] = ('Off', 'On ');
    Save : array[Boolean] of string[1] = (' ', '*');

    RawStatusLine : string[80] =
      {         1         2         3         4         5         6         7         8}
      {12345678901234567890123456789012345678901234567890123456789012345678901234567890}
      '               Line:       Col:          /       Insert Fixed Indent Wrap * ';
      { FILENAME.EXT  Line: 12345 Col: 123  12345/12345  Insert Fixed Indent Wrap Save }
  var
    S : string[5];
    Status : string[80];
    {$IFDEF UseMouse}
    SaveMouse : Boolean;
    {$ENDIF}
  begin
    with TextEditorPtr(MP)^ do begin
      {get filename if it changed}
      if teOptionsAreOn(teNewFile) then begin
        FName := JustFileName(mfFileName);
        FName := StUpcase(FName);
        teOptionsOff(teNewFile);
      end;

      {get a copy of the raw status line}
      Status := RawStatusLine;

      {insert filename}
      MergeString(FName, 3, Status);

      {insert line number}
      MergeNumber(meCurLine, 23, Status);

      {insert column number}
      MergeNumber(meCurCol, 34, Status);

      {insert bytes used/maximum}
      MergeNumberRight(meTotalBytes, 42, Status);
      MergeNumber(meBufSize-2, 44, Status);
      {Note: OPMEMO/OPEDITOR maintains a safety margin of 2 bytes}

      {insert remaining fields}
      if not teOptionsAreOn(teInsert) then
        MergeString(' Over ', 51, Status);
      if teOptionsAreOn(teSmartTabs) then
        MergeString('Smart ', 58, Status);
      if not teOptionsAreOn(teIndent) then
        FillChar(Status[64], 6, ' ');
      if not teOptionsAreOn(teWordWrap) then
        FillChar(Status[71], 4, ' ');
      if not teOptionsAreOn(teModified) then
        FillChar(Status[76], 1, ' ');

      {$IFDEF UseMouse}
      HideMousePrim(SaveMouse);
      {$ENDIF}

      {display status line}
      FastWrite(Status, 2, 2, ColorMono(StatusColor, StatusMono));

      {$IFDEF UseMouse}
      ShowMousePrim(SaveMouse);
      {$ENDIF}
    end;
  end;

  procedure Abort(Msg : string);
    {-Display an error message and halt}
  begin
    {$IFDEF UseMouse}
    {hide the mouse cursor}
    HideMouse;
    {$ENDIF}

    NoScrRestore := True;
    Window(1, 1, ScreenWidth, ScreenHeight);
    ClrScr;
    WriteLn(Msg);
    Halt(1);
  end;

  procedure ClearPromptLine;
    {-Clear the status line}
  {$IFDEF UseMouse}
  var
    SaveMouse : Boolean;
  {$ENDIF}
  begin
    {$IFDEF UseMouse}
    HideMousePrim(SaveMouse);
    {$ENDIF}

    with OurColorSet do
      FastWrite(CharStr(' ', 76), 2, 3, ColorMono(PromptColor, PromptMono));

    {$IFDEF UseMouse}
    ShowMousePrim(SaveMouse);
    {$ENDIF}
  end;

  procedure DisplayMessage(Msg : string);
    {-Display a message at the top of the screen}
  {$IFDEF UseMouse}
  var
    SaveMouse : Boolean;
  {$ENDIF}
  begin
    {$IFDEF UseMouse}
    HideMousePrim(SaveMouse);
    {$ENDIF}

    ClearPromptLine;
    with OurColorSet do
      FastWrite(Msg, 2, 3, ColorMono(PromptColor, PromptMono));

    {$IFDEF UseMouse}
    ShowMousePrim(SaveMouse);
    {$ENDIF}

    GotoXYabs(Length(Msg)+2, 2);
  end;

  procedure ErrorProc(UnitCode : Byte; var ErrCode : Word; Msg : string);
    {-Error handler}
  var
    I : Word;
    CursorSL, CursorXY : Word;

  begin
    {save the cursor position and shape}
    GetCursorState(CursorXY, CursorSL);

    {clear the status line}
    ClearPromptLine;

    {display the error message}
    NormalCursor;
    DisplayMessage(' '+Msg+'. Press any key...');

    {wait for a keypress}
    I := ReadKeyWord;

    {clear the prompt line}
    ClearPromptLine;

    {Restore cursor position and shape}
    RestoreCursorState(CursorXY, CursorSL);
  end;

  function EditProc(MsgCode : Word;
                    Prompt : string;
                    ForceUp : Boolean;
                    TrimBlanks : Boolean;
                    MaxLen : Byte;
                    var S : string) : Boolean;
   {-Line editing routine}
  var
    LE : LineEditor;
    Width : Byte;
  begin
    with LE do begin
      ClearPromptLine;
      Init(OurColorSet);
      if ForceUp then
        leEditOptionsOn(leForceUpper)
      else
        leEditOptionsOff(leForceUpper);
      if TrimBlanks then
        leEditOptionsOn(leTrimBlanks)
      else
        leEditOptionsOff(leTrimBlanks);
      Prompt := ' '+Prompt;
      if Length(Prompt)+MaxLen > 80 then
        Width := 76-Length(Prompt)
      else
        Width := MaxLen;
      ReadString(Prompt, 2, 3, MaxLen, Width, S);
      EditProc := (GetLastCommand <> ccQuit);
      ClearPromptLine;
    end;
  end;

  function YesNoFunc(MsgCode : Word; Prompt : string;
                     Default : Byte; QuitAndAll : Boolean) : Byte;
    {-Get a response to a yes-no question}
  var
    LE : LineEditor;
    Ch : Char;
    CharsToTake : CharSet;
  begin
    with LE do begin
      ClearPromptLine;
      Init(OurColorSet);
      leEditOptionsOn(leAllowEscape+leDefaultAccepted+leForceUpper);
      if Default = teYes then
        Ch := 'Y'
      else
        Ch := 'N';
      if QuitAndAll then begin
        CharsToTake := ['Y', 'N', 'A', 'Q'];
        Prompt := Prompt+' (Y/N/A/Q)'
      end
      else
        CharsToTake := ['Y', 'N'];
      ReadChar(Prompt, 2, 3, CharsToTake, Ch);
      if GetLastCommand = ccQuit then
        YesNoFunc := teQuit
      else case Ch of
        'Y' : YesNoFunc := teYes;
        'N' : YesNoFunc := teNo;
        'A' : YesNoFunc := teAll;
        'Q' : YesNoFunc := teQuit;
      end;
      ClearPromptLine;
    end;
  end;

  function GetFile(MsgCode : Word; Prompt : string;
                   ForceUp, TrimBlanks, Writing, MustExist : Boolean;
                   MaxLen : Byte; DefExt : ExtStr;
                   var S : string) : Boolean;
    {-Get a filename}
  var
    I : Word;
  begin
    if not EditProc(0, Prompt, ForceUp, TrimBlanks, MaxLen, S) then
      GetFile := False
    else if Writing then
      if ExistFile(S) then
        GetFile := YesNoFunc(0, 'File exists. Overwrite it?', teNo, False) = teYes
      else
        GetFile := True
    else if ExistFile(S) or not MustExist then
      GetFile := True
    else begin
      I := 0;
      ErrorProc(ucNone, I, 'File not found');
      GetFile := False;
    end;
  end;

  procedure InstallUserCommands;
    {-Install user-defined exit commands}
  begin
    {AltX = Abandon file}
    EditorCommands.AddCommand(ccAbandonFile, 1, $2D00, 0);
    EditorCommands.AddCommand(ccUser0, 1, $4300, 0); {compile}
    EditorCommands.AddCommand(ccUser1, 1, $E100, 0); {gotolinecol on error,
                                                      assigned to unused key}
    EditorCommands.AddCommand(ccUser2, 2, Ord(^J), Ord(^C)); {copy to clipboard}
    EditorCommands.AddCommand(ccUser3, 2, Ord(^J), Ord(^K)); {cut to clipboard}
    EditorCommands.AddCommand(ccUser4, 2, Ord(^J), Ord(^P)); {paste from clipboard}
    EditorCommands.AddCommand(ccUser5, 2, Ord(^J), Ord(^Y)); {clear the clipboard}
  end;

  procedure MainEditor(FN : String);
  begin
    {calculate size of edit buffer}
    I := MaxAvail-10000;
    if I > $FFF1 then
      BufSize := $FFF1
    else
      BufSize := I;
    if I <= 0 then
      Halt;

    {get name of file to edit}
    FName := FN;
    if Length(FName) = 0 then FName := 'NONAME';
    FName := StUpcase(FName);
    if (Pos('.',FName) = 0) and (FName <> 'NONAME') then
      FName := ForceExtension(FName,'PAS');

    {$IFDEF UseMouse}
    if MouseInstalled then begin
      {use a red diamond for our mouse cursor}
      with OurColorSet do
        SoftMouseCursor($0000, (ColorMono(MouseColor, MouseMono) shl 8)+$04);

      {enable mouse support in OPEDITOR}
      EditorCommands.cpOptionsOn(cpEnableMouse);
    end;
    {$ENDIF}

    {install user-defined exit commands}
    InstallUserCommands;

    {initialize the editor window}
    DefaultColorSet := OurColorSet;
    with TE, OurColorSet do begin
      if not InitCustom(2, 3, ScreenWidth-1, ScreenHeight-2,
                        DefaultColorSet,
                        DefWindowOptions or wBordered or wClear or
                          wResizeable or wAllMouseEvents,
                        BufSize) then
        Abort(emInsufficientMemory);

      SetDefaultExtension('PAS');
      SetPrinter(1);

      wFrame.AddCustomScrollBar(frRR, 0, MaxLongInt, 1, 1, '', '', OurColorSet);
      wFrame.AddCustomScrollBar(frBB, 0, MaxLongInt, 1, 1, '', '', OurColorSet);

      {use our special status display routine}
      SetStatusProc(OurStatusProc);
      StatusColor := HeaderColor;
      StatusMono := HeaderMono;

      {don't allow reading of partial files, no wordwrap in programming editor}
      teOptionsOff(meAllowTrunc + teWordWrap);


      {try to open the file before installing error handler}
      ReadFile(FName, FSize);
      if GetLastError <> 0 then
        Abort('Error reading '+FName);

      {set procedure pointers}
      SetEditProc(EditProc);
      SetErrorProc(ErrorProc);
      SetGetFileProc(GetFile);
      SetYesNoProc(YesNoFunc);
      EditorCommands.SetUserHookProc(UserHook);

      {draw the interior of the editor window}
      Draw;

      {clear the status line}
      ClearPromptLine;

      {$IFDEF UseMouse}
      {show the mouse}
      ShowMouse;
      {$ENDIF}

      repeat
        {start editing}
        Process;

        {process exit command}
        ExitCode := GetLastCommand;
        case ExitCode of
          ccUser0 :
            begin
              Compile(FName);
              ProcessCompileError;
            end;
          ccUser1 :
            GotoLineCol(ErrorY,ErrorX);
          ccUser2 :
            CopyToClipBoard(False);
          ccUser3 :
            CopyToClipBoard(True);
          ccUser4 :
            PasteFromClipBoard;
          ccUser5 :
            ClearClipBoard;
          ccQuit,                {quit}
          ccAbandonFile :        {abandon file}
            if not teOptionsAreOn(teModified) then
              ExitCode := ccQuit
            {file was modified--verify that user wants to quit}
            else begin
              YN := YesNoFunc(0, emFileModified, teYes, False);
              case YN of
                teYes :
                  begin
                    SaveFile;
                    ExitCode := ccQuit
                  end;
                teNo :
                  ExitCode := ccQuit;
                else
                  ExitCode := ccNone;
              end;
            end;
        end;
      until (ExitCode = ccQuit) or (ExitCode = ccSaveExit);

      {$IFDEF UseMouse}
      {hide the mouse cursor}
      HideMouse;
      {$ENDIF}

      {erase the memo window}
      Erase;
    end;
  end;

begin
{$IFDEF UseClipBoard}
  FillChar(ClipBoard,SizeOf(ClipBoard),0);
{$ENDIF}

  if NOT GetMemCheck(SwapP,ScreenWidth * ScreenHeight * 2) then begin
    WriteLn('Insufficient memory');
    halt(1);
  end;

  if SaveWindow(1,1,ScreenWidth,ScreenHeight,True,BPP) then begin
    {if we could save the screen, install our handler to restore it on exit}
    GetCursorState(BPX,BPL);
    EdOldExit := ExitProc;
    ExitProc := @EdExit;
  end;
  ClrScr;
end.
