{$M 2048, 0, 0}
{$R-,V-,S-,I-,F-,O-,N-,E-}

Program direc;
{find and change to a directory looking across drives}
Uses DOS, TPDOS;

const
  CompileDate = '91.01.10';
var
  Requested:string;

procedure WriteHeader;
begin
  Writeln;
  Writeln('DIREC  '+ CompileDate + '  USDA ERS');
  Writeln('');
  Writeln('DIREC finds a directory across multiple drives.');
end;

function GetDirecName : string;
var Temp:string;
begin
  Temp:='';
  Write('Enter name of directory: ');
  Readln(Temp);
  If (Temp[1] = '\') and (Length(Temp) > 1) then Delete(Temp,1,1);
  GetDirecName:=Temp;
end;

procedure LocateDirectory(Name:string);
const
  Found : boolean = False;
  Count : byte = 3;

var
  DriveLtr:char;
  TotDriveNum, DrivesCounted:byte;
  IOError:integer;
  OrigDirec, ThisTry : string[80];

begin
  TotDriveNum := TPDOS.NumberOfDrives;
  If TotDriveNum < 3 then
  begin
    WriteHeader;
    Writeln('No drives greater than B.  This utility is for a many-drive system.');
    Halt(1);
  end;

  GetDir(0,OrigDirec);

  If Name ='\' then Name:='';
  While (not Found) and (Count <= TotDriveNum) do
  begin
    If Name[2] = ':' then
      ThisTry:=Name
    Else
      ThisTry := Chr(Count+Ord('A')-1) + ':\'+Name;
    ChDir(ThisTry);
    IOError:=IOResult;
    If IOError <> 0 then
      Inc(Count) {can't get to this drive}
    Else
      Found:=True;
  end;

  If not Found then
  begin
    ChDir(OrigDirec);
    Writeln('Not found.');
  end
  Else
  begin
    GetDir(0,ThisTry);
    Writeln('Directory is now ',ThisTry);
  end;
end;

{***********************}
begin
  If ParamCount > 0 then
    Requested:=ParamStr(1)
  Else
  begin
    WriteHeader;
    Requested:=GetDirecName;
  end;

  If Requested <> '' then
    LocateDirectory(Requested);
end.

