program TPDBDemo;

                           (***********************************)
                           (*               TPDB              *)
                           (***********************************)
                           (*         Object -Oriented        *)
                           (*    Borland/Turbo Pascal Units   *)
                           (*    for Accessing dBASE III      *)
                           (*             files.              *)
                           (*      Copyright 1988 - 1993      *)
                           (*          Brian Corll            *)
                           (*       All Rights Reserved       *)
                           (***********************************)
                           (*            FREEWARE             *)
                           (***********************************)
                           (*     dBASE is a registered       *)
                           (* trademark of Borland Int. Inc.  *)
                           (*   Version 3.35  November, 1993  *)
                           (***********************************)
                           (*   Portions Copyright 1984,1991  *)
                           (*    Borland International Corp.  *)
                           (***********************************)


{Field  Field Name  Type       Width    Dec
     1  CUSTNO      Character      5
     2  FIRSTNAME   Character     20
     3  MI          Character      1
     4  LASTNAME    Character     25
     5  ADDRESS     Character     35
     6  CITY        Character     35
     7  STATE       Character      2
     8  ZIP         Character      5
     9  ORDERNO     Character      9
    10  ITEM        Character     20
    11  COST        Numeric        8      2
    12  SALEPRICE   Numeric        8      2
    13  PROFIT      Numeric        8      2
    14  SALEDATE    Date           8
    15  COMPLETED   Logical        1
 ** Total **                     191}

{Demonstration of the capabilities of TPDB  Version 3.34}

uses
    Crt, Dos, TPDB, TPDBDate, TPDBScrn, TPDBStr;

const
    NameNdx: byte = 1;
    CustNoNdx: byte = 2;


var
    J: longint;
    SPos: byte;
    Message: string [80];
    RecNo: string;
    Continue: byte;
    Demo:^DBF;
    Test: ScrPtr;
    Ch: char;


begin
    SetDateFormat(Italian);
    New(Demo, Init('tpdbdemo.dbf'));
    Demo^.Zap;
    Demo^.MakeDBIndex(NameNdx, 'name.ndx', 25, Duplicates);
    Demo^.MakeDBIndex(CustNoNdx, 'custno.ndx', 5, NoDuplicates);
    Demo^.OpenDBIndex(NameNdx, 'name.ndx', 25, Duplicates);
    Demo^.OpenDBIndex(CustNoNdx, 'custno.ndx', 5, NoDuplicates);


    repeat
        Continue := 0;
        Demo^.NewDBRec;
        Demo^.Repl(14, Today);
        Normal := White + BlueBG;
        Reverse := Black + LightGrayBG;
        SetDBColor(Black, LightGray);
        FlashFill(1, 1, 25, 80, Blue + BlackBG, #176);
        Flash(2, 5, Black + LightGrayBG, 'Customer');
        Flash(3, 5, Black + LightGrayBG, 'Database');
        FlashC(2, White + RedBG, 'TPDB Version 3.34');
        Flash(24, 50, Black + LightGrayBG, 'Press Esc Key When Finished.');
        FlashC(4, White + GreenBG, 'Demonstration');
        Str(Demo^.DBRecNum: 10, RecNo);
        Message := 'Record Number: ' + RecNo;
        Flash(2, 50, White + RedBG, Message);
        Prompt(6, 10, 'Enter Customer Number: ');
        Demo^.Say(1, 6, 33);
        Prompt(8, 10, 'First Name: ');
        Demo^.Say(2, 8, 22);
        Prompt(10, 10, 'MI: ');
        Demo^.Say(3, 10, 14);
        Prompt(12, 10, 'Last Name: ');
        Demo^.Say(4, 12, 21);
        Prompt(14, 10, 'Address: ');
        Demo^.Say(5, 14, 19);
        Prompt(16, 10, 'City: ');
        Demo^.Say(6, 16, 16);
        Prompt(16, 52, 'State: ');
        Demo^.Say(7, 16, 59);
        Prompt(16, 63, 'ZIP Code: ');
        Demo^.Say(8, 16, 73);
        Prompt(18, 10, 'Order No.: ');
        Demo^.Say(9, 18, 21);
        Prompt(18, 35, 'Item: ');
        Demo^.Say(10, 18, 41);
        Prompt(20, 10, 'Cost: $');
        Demo^.Say(11, 20, 17);
        Prompt(20, 30, 'Sale Price: $');
        Demo^.Say(12, 20, 43);
        Prompt(20, 55, 'Profit: $');
        Demo^.Say(13, 20, 64);
        Prompt(22, 30, 'Sale Date: ');
        Demo^.Say(14, 22, 41);
        Prompt(24, 10, 'Transaction Completed ?: ');
        Demo^.Say(15, 24, 35);

        BlockCursor;
        SPos := 1;

        repeat
            case SPos of
                1: Demo^.Get(1, 6, 33);
                2: Demo^.Get(2, 8, 22);
                3: Demo^.Get(3, 10, 14);
                4: Demo^.Get(4, 12, 21);
                5: Demo^.Get(5, 14, 19);
                6: Demo^.Get(6, 16, 16);
                7: Demo^.Get(7, 16, 59);
                8: Demo^.Get(8, 16, 73);
                9: Demo^.Get(9, 18, 21);
                10: Demo^.Get(10, 18, 41);
                11: Demo^.Get(11, 20, 17);
                12: Demo^.Get(12, 20, 43);
                13: begin
                    Demo^.Repl(13, Demo^.Sub(12, 11));
                    Demo^.Say(13, 20, 65);
                end;
                14: Demo^.Get(14, 22, 41);
                15: Demo^.Get(15, 24, 35);
            end;
            CheckScreen(SPos, BC, Up, Down, 1, 15);
        until BC in Next;
        Demo^.AddDBRec;
        Demo^.AddDBKey(NameNdx, Demo^.Field(4));
        Demo^.AddDBKey(CustNoNdx, Demo^.Field(1));
        Flash(24, 50, Blue + BlackBG, Replicate(#176, 30));
        Flash(24, 50, White + RedBG, 'Add another record ? ');
        BC := GetBoolean(Continue, 'Y', 'N', 72, 24);
    until BoolToStr(Continue, 'Y', 'N') = 'N';
    Dispose(Demo, Done);
    SetDBColor(White, Black);
    CursorOn;
    ClrScr;
end.
