{$A+,B+,D+,E-,F-,I-,L+,N-,O-,R-,S-,V-}
{$M 16384,0,655360}

program PackTest;
                           (***********************************)
                           (*               TPDB              *)
                           (***********************************)
                           (*         Object -Oriented        *)
                           (*    Borland/Turbo Pascal Units   *)
                           (*    for Accessing dBASE III      *)
                           (*             files.              *)
                           (*      Copyright 1988 - 1993      *)
                           (*          Brian Corll            *)
                           (*       All Rights Reserved       *)
                           (***********************************)
                           (*            FREEWARE             *)
                           (***********************************)
                           (*     dBASE is a registered       *)
                           (* trademark of Borland Int. Inc.  *)
                           (*   Version 3.35  November, 1993  *)
                           (***********************************)
                           (*   Portions Copyright 1984,1991  *)
                           (*    Borland International Corp.  *)
                           (***********************************)

uses
    Crt, TPDB;

var
    H: integer;
    Test:^DBF;


begin
    New(Test, Init('packtest.dbf'));
    if Test^.TotalRecs >= 500 then
        Test^.Zap;
    ClrScr;
    Writeln('Appending 1000 records.....');
    Test^.FillRecs(1000);
    Writeln('Deleting 500 records....');
    for H := 1 to 1000 do begin
        Test^.GetDBRec(H);
        if H mod 2 = 0 then begin
            Test^.Repl(1, 'Deleted.');
            Test^.Mark;
        end else
            Test^.Repl(1, 'Undeleted.');
        Test^.PutDBRec(H);
    end;
    Test^.DBReset;
    Writeln('Packing....');
    Test^.Pack;
    Writeln('500 undeleted records remain.');
    Writeln;
    Writeln('TPDB Version 3.35');
    Test^.Done;
end.
