Unit BARCODE;
Interface
uses printer;
CONST
      High      :integer    = 6;
      LeftSpace :integer    = 2;
      Space     :integer    = 17;
      Width     :integer    = 1;
      CopyNum   :integer    = 1;
      Prtr      :string[3]  = 'IBM';
      Bold      :string[3]  = 'ON';
Procedure Printbar(MSG : String; VAR Valid : Boolean);
implementation
Procedure printbar;


TYPE
  Bar      = string[84];


VAR
  Len,N1,N2,
  Pass,Incr,Cols              : integer;
  Test,Ch                     : char;
  BarMsg                      : string[25];
  Lbar                        : Bar;
  NNs                         : string[2];
  NWs                         : string[4];
  NNb                         : string[1];
  NWb                         : string[3];
  Ns                          : string[8];
  Ws                          : string[16];
  Nb                          : string[4];
  Wb                          : string[12];
  Prnt                        : array[ 1..25] of Bar;
  Enough        : boolean;



procedure SetWidth;
VAR Z : integer;
   begin
     NS := '';
     WS := '';
     NB := '';
     WB := '';
     NNS := chr(0)+chr(0);                 { set Barcode characters   }
     NWS := chr(0)+chr(0)+chr(0)+chr(0);
     NNB := chr(255);
     NWB := chr(255)+chr(255)+chr(255);
     for Z := 1 to Width do
        begin
           NS := NS + NNS;
           WS := WS + NWS;
           NB := NB + NNB;
           WB := WB + NWB
        end;
  end;

procedure Numb_To_Bars;
VAR x : integer;
  begin
    Valid := true;
    SetWidth;
    for X := 1 to Len do
      begin
        Test := (BarMsg[X]);
        case Test of
        '1': Lbar := WB+NS+NB+WS+NB+NS+NB+NS+WB;
        '2': Lbar := NB+NS+WB+WS+NB+NS+NB+NS+WB;
        '3': Lbar := WB+NS+WB+WS+NB+NS+NB+NS+NB;
        '4': Lbar := NB+NS+NB+WS+WB+NS+NB+NS+WB;
        '5': Lbar := WB+NS+NB+WS+WB+NS+NB+NS+NB;
        '6': Lbar := NB+NS+WB+WS+WB+NS+NB+NS+NB;
        '7': Lbar := NB+NS+NB+WS+NB+NS+WB+NS+WB;
        '8': Lbar := WB+NS+NB+WS+NB+NS+WB+NS+NB;
        '9': Lbar := NB+NS+WB+WS+NB+NS+WB+NS+NB;
        '0': Lbar := NB+NS+NB+WS+WB+NS+WB+NS+NB;
        'A': Lbar := WB+NS+NB+NS+NB+WS+NB+NS+WB;
        'B': Lbar := NB+NS+WB+NS+NB+WS+NB+NS+WB;
        'C': Lbar := WB+NS+WB+NS+NB+WS+NB+NS+NB;
        'D': Lbar := NB+NS+NB+NS+WB+WS+NB+NS+WB;
        'E': Lbar := WB+NS+NB+NS+WB+WS+NB+NS+NB;
        'F': Lbar := NB+NS+WB+NS+WB+WS+NB+NS+NB;
        'G': Lbar := NB+NS+NB+NS+NB+WS+WB+NS+WB;
        'H': Lbar := WB+NS+NB+NS+NB+WS+WB+NS+NB;
        'I': Lbar := NB+NS+WB+NS+NB+WS+WB+NS+NB;
        'J': Lbar := NB+NS+NB+NS+WB+WS+WB+NS+NB;
        'K': Lbar := WB+NS+NB+NS+NB+NS+NB+WS+WB;
        'L': Lbar := NB+NS+WB+NS+NB+NS+NB+WS+WB;
        'M': Lbar := WB+NS+WB+NS+NB+NS+NB+WS+NB;
        'N': Lbar := NB+NS+NB+NS+WB+NS+NB+WS+WB;
        'O': Lbar := WB+NS+NB+NS+WB+NS+NB+WS+NB;
        'P': Lbar := NB+NS+WB+NS+WB+NS+NB+WS+NB;
        'Q': Lbar := NB+NS+NB+NS+NB+NS+WB+WS+WB;
        'R': Lbar := WB+NS+NB+NS+NB+NS+WB+WS+NB;
        'S': Lbar := NB+NS+WB+NS+NB+NS+WB+WS+NB;
        'T': Lbar := NB+NS+NB+NS+WB+NS+WB+WS+NB;
        'U': Lbar := WB+WS+NB+NS+NB+NS+NB+NS+WB;
        'V': Lbar := NB+WS+WB+NS+NB+NS+NB+NS+WB;
        'W': Lbar := WB+WS+WB+NS+NB+NS+NB+NS+NB;
        'X': Lbar := NB+WS+NB+NS+WB+NS+NB+NS+WB;
        'Y': Lbar := WB+WS+NB+NS+WB+NS+NB+NS+NB;
        'Z': Lbar := NB+WS+WB+NS+WB+NS+NB+NS+NB;
        '-': Lbar := NB+WS+NB+NS+NB+NS+WB+NS+WB;
        '.': Lbar := WB+WS+NB+NS+NB+NS+WB+NS+NB;
        ' ': Lbar := NB+WS+WB+NS+NB+NS+WB+NS+NB;
        '*': Lbar := NB+WS+NB+NS+WB+NS+WB+NS+NB;
        '$': Lbar := NB+WS+NB+WS+NB+WS+NB+NS+NB;
        '/': Lbar := NB+WS+NB+WS+NB+NS+NB+WS+NB;
        '+': Lbar := NB+WS+NB+NS+NB+WS+NB+WS+NB;
        '%': Lbar := NB+NS+NB+WS+NB+WS+NB+WS+NB;
        else
            Valid := false
        end;                  {Case}
        Prnt[X] := Lbar;
      end;                     {for}
  end;                       {Numb_To_Bars}

procedure Do_Bar;
var x : integer;
   begin
      for X := 1 to Len do
        Msg[X] := upcase(Msg[X]);
      Len :=Len + 2;
      BarMsg := concat('*', Msg, '*');
      Numb_To_Bars
   end;



procedure Printnumber;

  VAR
    I,X,Y,z,Pass,Counter : Integer;

  procedure SmallSpace( Feeds : Integer);
  Var counter :integer;
     begin
        for Counter := 1 to Feeds do
        writeln(lst, chr(27), chr(51), chr((Incr + 2) div 4));
     end;

  begin
    if Prtr = 'IBM' then Incr := 22
    else Incr := 14;
    Cols := 21 * Width * Len;
    N1 := Cols mod 256; N2 := Cols div 256;
    for I := 1 to CopyNum do                   { control number of copies }
    begin
       SmallSpace(4);
       for Y := 1 to High do                    {print each line of barcode}
       begin
          for Pass := 1 to 2 do                 { two passes overlapped }
          begin
               for Z := 1 to Leftspace do
               write(lst, ' ');                 { produce left margin   }
               if Bold = 'ON' then
                  write(lst, chr(27), chr(76), chr(N1), chr(N2))
                                                { set      DD graphics  }
               else write(lst, chr(27), chr(75), chr(N1), chr(N2));
                                                { set      SD graphics  }
               for X := 1 to Len do
                  write(lst, Prnt[X], Ns);      { Print the bars and spaces }
               if (Pass mod 2) = 0 then
                  writeln(lst, chr(27), chr(51), chr(Incr))
                                              { 8/72 inch line feed           }
                                              { Incr = 22 for IBM; 14 for EPS }
               else writeln(lst, chr(27), chr(51), chr(2))
                                             { tiny LF to fill in dots        }
          end;          { of Pass  }
       end;             { of bar printing }
       SmallSpace(3);       { 2/72 linefeed   }
       for Z := 1 to (Leftspace + 1 + (Len*(Width-1) div 2)) do
        write(lst, ' ');
       if Bold = 'ON' then                         { enhanced print on       }
          write(lst, chr(27), 'G')
       else write(lst, chr(27), 'H');              { enhanced print off      }
       for Z := 1 to length(Msg) do
         begin
           write(lst, Msg[Z]);
           for X := 1 to Width do write(lst, ' '); {spaces between digits   }
         end;
      for X := 1 to Space do
      Smallspace(1);
    end;
    writeln(lst, chr(27), chr(64));              { restore line spacing }
  end;

begin
      begin
        Valid :=false;
        Len := length(Msg);
        if Len > 0 then Do_Bar;
        if Valid then Printnumber
        else Enough := true
      end;
end;
end.

