{
********************************************************************
*                                                                  *
*  DESQview Demo                                                   *
*  for Turbo Pascal 6.0                                            *
*  Copyright (C) 1992 Jonathan L. Zarate.                          *
*  All Rights Reserved                                             *
*                                                                  *
********************************************************************
}
{ NOTE: Adjust the SYSTEM MEMORY of the program to a NON-ZERO value }
{       SYSTEM MEMORY is found under DESQview's "change a program" menu }

Uses dos, dv;

var
 Win1 : pointer;
 Win2 : pointer;
 Tim1 : pointer;
 Tim2 : pointer;
 w    : word;
 f    : text;
 s    : string;
 x, y : shortint;
 L1,L2: longint;

procedure pause; assembler;
asm
 xor ah,ah
 int $16
end;

procedure Delay( w : word );
var
 Timer : pointer;
begin
 Timer:=DVTimer_New;
 DVTimer_Start(Timer,w);
 repeat
 until DVTimer_Len(Timer)=0;
 DVFree(Timer);
end;

function strW( w : word ) : string;
var
 s : string;
begin
 str(w,s);
 strW:=s;
end;

begin
 Win1:=DVInit;
 if not InDV then
  begin
   writeln('This program requires DESQview.');
   halt(1);
  end;
 DVTitle(Win1, 'DESQview DEMO');
 DVFrameAttr(Win1, 19);
 DVSetAttr(Win1, 31);
 DVMove(Win1, 1, 1);
 DVResize(Win1, 40, 11);
 DVClear(Win1);
 DVRedraw(Win1);

 DVDisAllow(Win1, MStream_QuitMenu);
 DVWriteln(Win1,' DESQview version: '+strW(hi(DV_Version))+'.'+
                strW(lo(DV_Version)));
 DVWriteln(Win1, ' Quit Option Disabled');
 DVWriteln(Win1, ' Press any key to continue...');
 pause;

 DVWriteln(Win1, ' Moving...');
 for w:=1 to 20 do
  begin
   DVMove2(Win1, 1, 0);
   DVRedraw(Win1);
   delay(10);
  end;
 for w:=1 to 5 do
  begin
   DVMove2(Win1, 0, 1);
   DVRedraw(Win1);
   delay(10);
  end;

 DVWriteln(Win1, ' Press any key to create a new window');
 pause;
 Win2:=DVNewWin( 40, 11 );
 DVTitle(Win2, '  DV DEMO 2');
 DVFrameAttr(Win2, 127);
 DVSetAttr(Win2, 112);
 DVMove(Win2,1,1);
 DVClear(Win2);
 DVRedraw(Win2);
 DVTopProcess(Win2);
 DVWriteln(Win2,' Hello World!');

 DVError( Win1, 30, 5, ^J^J'          ERROR TEST', DVErrorMouEither+DVErrorBeep);

 DVWriteln(Win2,' Press any key to continue...');
 pause;
 DVBottomProcess(Win2);

 assign(f,'C:\TP6\DV\DV.PAS'); { !!- change directory -!! }
 {$I-}reset(f);{$I+}
 if ioresult=0 then
  begin
   while not eof(f) do
    begin
     readln(f,s);
     s:=copy(s,1,38);
     DVWriteln(Win1, s);
     DVWriteln(Win2, s);
    end;
   close(f);
  end else DVWriteln(Win2,' Cannot find DV.PAS');

 DVTitle(Win2,'  Countdown');
 DVTopProcess(Win2);

 Tim1:=DVTimer_New;
 Tim2:=DVTimer_New;
 DVTimer_Start(Tim1, 10*100);
 DVTimer_Start(Tim2, 09*100);
 repeat
  L1:=DVTimer_Len(Tim1);
  L2:=DVTimer_Len(Tim2);
  str(L1,s);
  DVWrite(Win1,' Countdown: '+s+'     '+#13);
  if L2 > 0 then
   begin
    str(L2,s);
    DVWrite(Win2,' Countdown: '+s+'     '+#13);
   end else if Win2<>nil then DVFree(Win2);
 until L1=0;
 DVWriteln(Win1,^J^M'Bye!');

 delay(22);
 for w:=1 to 30 do
  begin
   DVMove2(Win1, -1, 0);
   DVRedraw(Win1);
   delay(4);
  end;
 DVFree(Win1);
end.