program TP5Patch;
{ Program to patch TURBO.EXE version 5.0 for the problem with }
{ the vector for interrupt $60 getting changed in the IDE.    }
uses
  Dos;
const
  PatchFileName : string = 'TURBO.EXE';  { Name of file to be patched }
  PatchByte     : byte   = $02;          { Value to be patched in }
  PatchOffset   : word   = $1476;        { Offset of patch location }
var
  PatchFile : file of byte;
  OrgByte   : byte;
begin
  if FSearch(PatchFileName, '') = '' then
    Writeln(PatchFileName, ' not found.')  { Can't find the file }
  else
    begin
      Assign(PatchFile, PatchFileName);
      {$I-} Reset(PatchFile); {$I+}
      if IOResult <> 0 then
      begin
        Writeln('I/O error on Reset.');
        Halt;
      end;
      Seek(PatchFile, PatchOffset);
      Read(PatchFile, OrgByte);            { Read byte at patch location }
      case OrgByte of
        4 : begin
              Seek(PatchFile, PatchOffset);
              Write(PatchFile, PatchByte);
              Writeln('Patch successfully applied.');
            end;
        2 : Writeln('Patch already applied.');
      else
        Writeln('No patch applied.');
      end;
      Close(PatchFile);
    end;
end.
