Title: PATCH FOR INCLUDE FILE NOT FOUND BY TURBO DEBUGGER

This handout describes the patches needed in order for Turbo
Pascal version 5.0 to generate the correct debug information so
that an $Include file in a user defined unit can be found by 
Turbo Debugger.  Two patches are supplied, one for TURBO.EXE, one
for TPC.EXE.  Both patches should be made using the DOS utility,
DEBUG on copies of the original .EXE files.

Notes:BEGIN NUMBERED
DEBUG is not case sensitive to upper and lower case.  All
addresses are listed in upper case for ease of readability.  All
addresses are in hexidecimal.

While in DEBUG, the prompt will appear as a dash (-).

If you do not receive the appropriate response, press "q"
followed by <Return>, to quit.  
END NUMBERED


TURBO.EXE Patch

BEGIN NUMBERED
Rename TURBO.EXE to TURBO.BIN (DEBUG will not allow modifications
to be made to an .EXE file.)

		Prompt>ren turbo.exe turbo.bin <Return>

Load TURBO.BIN into DEBUG with the command:

		Prompt>debug turbo.bin <Return>

Display the registers by entering "r" at DEBUG's hyphen prompt.

		-r <Return>

	The system will resond with a display of the CPU register
values.  The following is an example

	AX=0000  BX=0000  CX=0000  DX=0000  SP=FFEE  BP=0000 ...
	DS=3C23  ES=3C23  SS=3C23  CS=3C23  IP=0100  NV UP   ...

	Note the value of the CS register.  Add 1000h to this value
mentally.  e.g. in the above example CS=3C23, then CS + 1000h is
4C23.  This value will be referenced by ????.

At DEBUG's hyphen prompt type:

		-a ????:A41E <Return>

Enter the following Assembler code when the address is displayed.

		????:A41E cmp si,dx <Return>

Press <Return> a second time.

Write the modified code to disk by entering the following at the
prompt.

		-w <Return>

Quit DEBUG by entering the following -

		-q <Return>

At the DOS prompt, rename the .BIN file back to the .EXE file
with the following command.

		Prompt>ren turbo.bin turbo.exe <Return>
END NUMBERED



TPC.EXE Patch

BEGIN NUMBERED
Rename TPC.EXE to TPC.BIN (DEBUG will not allow modifications to
be made to an .EXE file.)

		Prompt>ren tpc.exe tpc.bin <Return>

Load TPC.BIN into DEBUG with the command:

		Prompt>debug tpc.bin <Return>

At DEBUG's hyphen prompt type:

		-a a5d3 <Return>

Enter the following Assembler code when the address is displayed

		XXXX:A5D3 cmp si,dx <Return>

Press <Return> a second time.

Write the modified code to disk by entering the following at the
prompt.

		-w <Return>

Quit DEBUG by entering the following -

		-q <Return>

At the DOS prompt, rename the .BIN file back to the .EXE file
with the following command.

		Prompt>ren tpc.bin tpc.exe <Return>
END NUMBERED
 