{
Turbo Vision CyberTools 1.1
(C) 1994 Steve Goldsmith
All Rights Reserved

CyberBase application using PX Browse unit to edit multiple Paradox tables
on single user or network systems.  Table passwords, encryption, decryption,
create, append, copy, empty and delete are supported.  Status bar on status
line reports what the app is doing during table operations.

Borland Pascal 7.x or Turbo Pascal 7.x, Turbo Vision 2.x and Paradox
Engine 3.x Database Framework are required to compile.

Set IDE directories to

\BP\UNITS;
\BP\EXAMPLES\DOS\TVDEMO;
\BP\EXAMPLES\DOS\TVFM;
\BP\PXENGINE\PASCAL\SOURCE;
\BP\PXENGINE\PASCAL;

I used \BP\PXENGINE when I installed Paradox Engine 3.0.  The rest of the
path names use BP 7.x defaults.  If you changed any of these then use the
correct paths in Options|Directories...  See APP.INC for global compiler
switches.

IMPORTANT:

Remember to add TCursor.getTableHandle method to the Data Base Framework in
\BP\PXENGINE\PASCAL\SOURCE\OOPXENG.PAS.  This allows PX Browse access to
TCursor's private table handle tabH.  PX Browse can then search on the primary
index regardless of what index the table is opened on.

Search OOPXENG.PAS for 'searchIndex'. Right after:

  function searchIndex(keyRec: PRecord; mode: PXSearchMode;
    fldCnt: Integer): Retcode; virtual;

Add:

  function getTableHandle : TableHandle;


Search OOPXENG.PAS for 'TRecord methods'.  Right before:

*************************************************************************
                          TRecord methods
**************************************************************************

Add:

function TCursor.getTableHandle : TableHandle;

begin
  getTableHandle := tabH
end;
}

{$I APP.INC}
{$X+}

program CyberBase;

uses

  Dos,                               {system units}
  OOPXEng, PXEngine,                 {paradox engine 3.0 and framework units}
  Memory, Drivers, Objects,          {tv units}
  Views, Menus, Dialogs,
  App, MsgBox, StdDlg, ColorSel,
  Gadgets, Calendar, Calc, HelpFile, {tv demo units}
  ViewText,                          {tvfm units}
  CBHelp, CBCmds, TVStr, PXBrowse;   {cybertools units}

const

  appRecords = 4;             {use 4 record browser}
  appIndex = 0;               {open tables on primary index}
  appViewDocBuf = 8192;       {buffer size for viewing doc file}
  appHelpInUse  = $8000;      {used by help system}
  appHelpName = 'CBHELP.HLP'; {help file name}
  appExeName  = 'CYBASE.EXE'; {name used to locate .exe for older dos}
  appDocName  = 'CYBER.DOC';  {doc file name}
  appCfgName = 'CYBASE.CFG';  {config file name}
  appCfgHeaderLen = 10;       {header used by config stream}
  appCfgHeader : string[appCfgHeaderLen] = 'CYBERBASE'#26;
  appReadyMsg = 'READY';      {ready status}

  CSysColor = #$00#$00#$00;   {app palette additions for tv system stuff}
  CSysPal   = #136#137#138;

type

  TCyberBase = object(TApplication)
    AppOptions : word;
    CreateData : TpxbCreateDlgRec;
    appEnv : TEnv;
    appEngine : TEngine;
    appDatabase : TDatabase;
    appStatus : PInputLine;
    Clock : PClockView;
    Heap : PHeapView;
    constructor Init;
    destructor Done; virtual;
    procedure UpdateStatus (S : string);
    function ErrorBox (ErrCode : integer) : boolean;
    procedure AboutBox;
    procedure Idle; virtual;
    procedure ClearDeskTop;
    function SelectFile (Title : string; WildCard : PathStr; ReadFlag : boolean) : PathStr;
    procedure AddPassword;
    procedure NewBrowser;
    procedure RestoreDesktop (F : PathStr);
    procedure SaveDeskTop (F : PathStr);
    procedure GetEvent (var Event : TEvent); virtual;
    function GetPalette : PPalette; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure InitDeskTop; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure OutOfMemory; virtual;
    procedure LoadDesktop (var S : TStream);
    procedure StoreDesktop (var S : TStream);
  end;

{
Init app, engine and database.
}

constructor TCyberBase.Init;

var

  R : TRect;

begin
  LowMemSize := 4095;   {65520 byte safety pool}
  inherited Init;
  RegisterObjects;      {register stuff for stream access}
  RegisterViews;
  RegisterMenus;
  RegisterDialogs;
  RegisterApp;
  RegisterHelpFile;

  R.Assign (64,0,70,1);
  Heap := New (PHeapView,Init(R));
  Insert (Heap);

  R.Assign (71,0,79,1); {gadgets included with tvdemo}
  Clock := New (PClockView,Init (R));
  Insert (Clock);

  R.Assign (70,24,80,25);
  appStatus := New (PInputLine,Init (R,10));
  appStatus^.Options := appStatus^.Options and not ofSelectable;
  appStatus^.GrowMode := gfGrowAll;
  Insert (appStatus);

  UpdateStatus ('STARTING');
  RestoreDesktop (appCfgName);        {load config stream}
  appEngine.Init (@appEnv);           {init engine}
  ErrorBox (appEngine.lastError);
  appDatabase.Init (@appEngine);      {init database}
  ErrorBox (appDataBase.lastError);
  UpdateStatus (appReadyMsg);
  AboutBox
end;

{
Close database and engine if open before calling inherited done.
}

destructor TCyberBase.Done;

begin
  UpdateStatus ('ENDING');
  if appDataBase.isOpen then
    appDatabase.Done;
  if appEngine.isOpen then
    appEngine.Done;
  inherited Done
end;

{
Update dialog status line.
}

procedure TCyberBase.UpdateStatus (S : string);

begin
  appStatus^.SetData (S)
end;

{
Display error and return true if error <> PXSUCCESS.  If error = PXSUCCESS
then no error is diaplayed and false is returned.
}

function TCyberBase.ErrorBox (ErrCode : integer) : boolean;

begin
  if ErrCode <> PxSuccess then
  begin
    MessageBox (appEngine.getErrorMessage (ErrCode),nil, mfError or mfOKButton);
    ErrorBox := true
  end
  else
    ErrorBox := false
end;

{
Tells what the app is about and what mode it is running in.
}

procedure TCyberBase.AboutBox;

begin
  HelpCtx := hcAbout;
  MessageBox(
    #3'Turbo Vision CyberTools 1.1'#13+
    #3'(C) 1994 Steve Goldsmith'#13+
{$IFDEF DPMI}
    #3'CyberBase PROTECTED',
{$ELSE}
    #3'CyberBase REAL',
{$ENDIF}
    nil, mfInformation or mfOKButton);
  HelpCtx := hcNoContext
end;

{
Update status line and gadgets during idle processing.
}

procedure TCyberBase.Idle;

function IsTileable (P : PView) : Boolean; far;

begin
  IsTileable := (P^.Options and ofTileable <> 0) and
  (P^.State and sfVisible <> 0)
end;

function IsThere (P : PView) : Boolean; far;

begin
  IsThere := (P^.State and sfActive = sfActive)
end;

function IsModal (P : PView) : Boolean; far;

begin
  IsModal := (P^.State and sfModal = sfModal)
end;

begin
  inherited Idle;
  Clock^.Update;                               {update tvdemo gadgets}
  Heap^.Update;
  if Desktop^.FirstThat (@IsThere) <> nil then {see if anything is}
  begin                                        {on the desk top}
    EnableCommands ([cmCloseAll]);
    if Desktop^.FirstThat (@IsTileable) <> nil then {see if any tileable}
      EnableCommands ([cmTile,cmCascade])           {windows are on the}
    else                                            {desk top}
      DisableCommands ([cmTile,cmCascade]);
  end
  else
    DisableCommands ([cmCloseAll,cmTile,cmCascade]);
  if (Desktop^.FirstThat (@IsModal) <> nil)            
  or (AppOptions and appHelpInUse = appHelpInUse) then {see if modal dialog}
    DisableCommands ([cmQuit,cmOpenTable])             {is on the desk top}
  else
  begin                                             {no modal views}
    if appStatus^.Data^ <> appReadyMsg then
      UpdateStatus (appReadyMsg);
    EnableCommands ([cmQuit,cmOpenTable])
  end
end;

{
Close all windows on desk top.
}

procedure TCyberBase.ClearDeskTop;

procedure CloseDlg (P : PView); far;

begin
  Message (P,evCommand,cmClose,nil)
end;

begin
  UpdateStatus ('CLOSE');
  Desktop^.ForEach (@CloseDlg)
end;

{
Select file from wild card with overwrite warning.
}

function TCyberBase.SelectFile (Title : string; WildCard : PathStr; ReadFlag : boolean) : PathStr;

var

  F : file;

begin
  HelpCtx := hcFileDialog;
  if ExecuteDialog (New (PFileDialog,Init (WildCard,Title,
    '~N~ame',fdOkButton,100)),@WildCard) <> cmCancel then
  begin
    if ReadFlag then
      SelectFile := WildCard
    else
    begin
      Assign (F,WildCard);
      {$I-} Reset (F); {$I+}
      if IoResult = 0 then {see if file exists before writes}
      begin
        {$I-} Close (F); {$I+}
        if MessageBox (WildCard+' already exists.  Erase and continue?',
        nil,mfConfirmation or mfYesNoCancel) = cmYes then
          SelectFile := WildCard
        else
          SelectFile := ''
      end
      else
        SelectFile := WildCard
    end
  end
  else
    SelectFile := '';
  HelpCtx := hcNoContext
end;

{
Add master password to engine.
}

procedure TCyberBase.AddPassword;

var

  Password : string;

begin
  Password := '';
  if InputBox ('','Password',Password,15) <> cmCancel then
    ErrorBox (appEngine.addPassword (Password))
end;

{
Open new table browser on primary index.  Any existing index can be used
though.  Handles encrypted tables too.
}

procedure TCyberBase.NewBrowser;

var

  FileName : PathStr;
  BrowseCur : PCursor;
  W : PpxbDialog;

begin
  FileName := SelectFile ('Open Table','*.DB',true);
  if FileName <> '' then
  begin
    UpdateStatus ('OPEN');
    BrowseCur := New (PCursor,InitAndOpen (@appDataBase,FileName,appIndex,true));
    if BrowseCur^.lastError = PXERR_INSUFRIGHTS then
    begin
      AddPassword;
      BrowseCur^.Open (@appDataBase,FileName,appIndex,true)
    end;
    if not ErrorBox (BrowseCur^.lastError) then
    begin
      W := New (PpxbDialog,Init (appRecords,
      FileName,@appEngine,@appDataBase,BrowseCur,appIndex));
      W^.HelpCtx := hcTableEditor;
      InsertWindow (W)
    end
    else
      Dispose (BrowseCur,Done)
  end
end;

{
Restore desk top stream.
}

procedure TCyberBase.RestoreDesktop (F : PathStr);

var

  S : PStream;
  Signature : string[appCfgHeaderLen];

begin
  S := New (PBufStream,Init (F,stOpenRead,1024));
  if LowMemory then OutOfMemory
  else
    if S^.Status <> stOk then
    begin
      MessageBox (#3'Unable to open file.',nil,mfOkButton+mfError)
    end
    else
    begin
      Signature[0] := Char (appCfgHeaderLen);
      S^.Read (Signature[1],appCfgHeaderLen);
      if Signature = appCfgHeader then {see if signature is right}
      begin
        S^.Read (appEnv,SizeOf (appEnv)); {read data from stream}
        LoadDesktop (S^);
        LoadIndexes (S^);
        ShadowAttr := GetColor (136);   {tv shadow color}
        SysColorAttr := (GetColor (137) shl 8) or GetColor (137); {tv system error color}
        ErrorAttr := GetColor (138);    {tv palette index error color}
        Application^.ReDraw; {draw app with new config}
        if S^.Status <> stOk then
          MessageBox (#3'Stream error.',nil,mfOkButton+mfError);
      end
      else
        MessageBox (#3'Invalid configuration format.',nil,mfOkButton+mfError)
    end;
  Dispose (S,Done)
end;

{
Save desk top stream.
}

procedure TCyberBase.SaveDesktop (F : PathStr);

var

  CfgFile : File;
  S : PStream;

begin
  S := New(PBufStream,Init (F,stCreate,1024));
  if not LowMemory and (S^.Status = stOk) then
  begin
    S^.Write (appCfgHeader[1],appCfgHeaderLen);
    S^.Write (appEnv,SizeOf (appEnv));
    StoreDesktop (S^);
    StoreIndexes (S^);
    if S^.Status <> stOk then
    begin {if stream error then delete file}
      MessageBox (#3'Could not create stream.',nil,mfOkButton+mfError);
      Dispose (S,Done);
      Assign (CfgFile,F);
      {$I-} Erase (CfgFile) {$I+};
      Exit
    end
  end;
  Dispose (S,Done)
end;

{
Intercept cmHelp to display help even when views are in modal state.
}

procedure TCyberBase.GetEvent (var Event : TEvent);

function CalcHelpName : PathStr;

var

  EXEName : PathStr;
  Dir : DirStr;
  Name : NameStr;
  Ext : ExtStr;

begin
  if Lo (DosVersion) >= 3 then
    EXEName := ParamStr (0)
  else
    EXEName := FSearch (appExeName, GetEnv ('PATH'));
  FSplit (EXEName, Dir, Name, Ext);
  if Dir[Length (Dir)] = '\' then
    Dec (Dir[0]);
  CalcHelpName := FSearch (appHelpName, Dir);
end;

var

  W : PWindow;
  HFile : PHelpFile;
  HelpStrm : PDosStream;

begin
  inherited GetEvent (Event);
  case Event.What of
    evCommand:
      if (Event.Command = cmHelp) and (AppOptions and appHelpInUse = 0) then
      begin {process help command if not in use}
        AppOptions := AppOptions or appHelpInUse; {help's in use}
        HelpStrm := New (PDosStream, Init (CalcHelpName, stOpenRead));
        HFile := New (PHelpFile, Init (HelpStrm));
        if HelpStrm^.Status <> stOk then
        begin
          MessageBox (#3'Could not open help file.', nil, mfError + mfOkButton);
          Dispose (HFile, Done);
        end
        else
        begin
          W := New (PHelpWindow,Init (HFile, GetHelpCtx));
          if ValidView (W) <> nil then
          begin
            DisableCommands ([cmHelp]);
            ExecView (W);
            Dispose (W, Done);
            EnableCommands ([cmHelp])
          end;
          ClearEvent (Event)
        end;
        AppOptions := AppOptions and not appHelpInUse
      end;
    evMouseDown:
      if Event.Buttons <> 1 then
        Event.What := evNothing
  end
end;

{
Get custom app palette.
}

function TCyberBase.GetPalette: PPalette;

const

  CNewColor = CAppColor+CHelpColor+CSysColor;
  CNewBlackWhite = CAppBlackWhite+CHelpBlackWhite+CSysColor;
  CNewMonochrome = CAppMonochrome+CHelpMonochrome+CSysColor;
  P: array[apColor..apMonochrome] of string[Length (CNewColor)] =
  (CNewColor, CNewBlackWhite, CNewMonochrome);

begin {add additional entries to the normal application palettes}
  GetPalette := @P[AppPalette];
end;

{
Handle app events.
}

procedure TCyberBase.HandleEvent(var Event: TEvent);

{
Configure and save engine setup.  Be careful when modifing engine values,
since incorrect values can crash the engine with a internal error!
}

procedure EngineConfig;

var

  D : PpxbEngineCfg;
  CfgRec : TpxbEngineCfgRec;

begin
  EngCfgToDlgCfg (appEnv,CfgRec);
  D := New (PpxbEngineCfg,Init);
  D^.HelpCtx := hcEngineDialog;
  if ExecuteDialog (D,@CfgRec) <> cmCancel then
  begin
    DlgCfgToEngCfg (CfgRec,appEnv);
    MessageBox(
    'Engine changes will not take effect until you save configuration as CYBASE.CFG and reload program.',
    nil, mfInformation or mfOKButton)
  end
end;

{
Load .CGF file.
}

procedure LoadConfigFile;

var

  F : PathStr;

begin
  F := SelectFile ('Load Config Stream','*.CFG',true);
  if F <> '' then
    RestoreDeskTop (F)
end;

{
Save .CFG file.
}

procedure SaveConfigFile;

var

  F : PathStr;

begin
  F := SelectFile ('Save Config Stream','*.CFG',false);
  if F <> '' then
    SaveDeskTop (F)
end;

{
Create table with password and error retry.  If appDataBase.createTable
returns an error you can retry with another table name, edit fields again or
abort.
}

procedure CreateTable;

var

  ExitCreate : boolean;
  PriFields : integer;
  FileName : PathStr;
  D : PpxbCreateDialog;

begin
  FillChar (CreateData,SizeOf (CreateData),0); {zero dialog rec}
  repeat
    UpdateStatus (appReadyMsg);
    ExitCreate := true;
    FileName := SelectFile ('Create Table','*.DB',true);
    if FileName <> '' then
    begin
      D := New (PpxbCreateDialog,Init (FileName));
      if CreateData.Fields.List = nil then {create new list}
        CreateData.Fields.List := New (PCollection,Init (255,0));
      D^.FieldPtr := CreateData.Fields.List;
      D^.HelpCtx := hcCreateDialog;
      UpdateStatus ('STRUCT');
      if ExecuteDialog (D,@CreateData) <> cmCancel then
      begin
        UpdateStatus ('CREATE');
        PriFields := StrToInt (CreateData.PriKey);
        if appDataBase.createTable (FileName,
        CreateData.Fields.List) = PXERR_INSUFRIGHTS then
        begin
          AddPassword;
          ErrorBox (appDataBase.createTable (FileName,
          CreateData.Fields.List))
        end
        else
          ErrorBox (appDataBase.lastError);
        if (appDataBase.lastError = PXSUCCESS) and (PriFields > 0) then
          ErrorBox (appDataBase.createPIndex (FileName,PriFields));
        if appDataBase.lastError <> PXSUCCESS then
          if MessageBox ('Try again?',
          nil,mfConfirmation or mfYesNoCancel) = cmYes then
            ExitCreate := false
      end;
      if ExitCreate then
        Dispose (CreateData.Fields.List,Done)
    end
  until ExitCreate
end;

{
Append table with password retry.
}

procedure AppendTable;

var

  SFileName,
  DFileName : PathStr;

begin
  SFileName := SelectFile ('Append From Table','*.DB',true);
  if SFileName <> '' then
  begin
    DFileName := SelectFile ('Append To Table','*.DB',true);
    if DFileName <> '' then
    begin
      UpdateStatus ('APPEND');
      if appDataBase.appendTable (SFileName,DFileName) = PXERR_INSUFRIGHTS then
      begin
        AddPassword;
        ErrorBox (appDataBase.appendTable (SFileName,DFileName))
      end
      else
        ErrorBox (appDataBase.lastError)
    end
  end
end;

{
Copy table with password retry.
}

procedure CopyTable;

var

  SFileName,
  DFileName : PathStr;

begin
  SFileName := SelectFile ('Copy From Table','*.DB',true);
  if SFileName <> '' then
  begin
    DFileName := SelectFile ('Copy To Table','*.DB',true);
    if DFileName <> '' then
    begin
      UpdateStatus ('COPY');
      if appDataBase.copyTable (SFileName,DFileName) = PXERR_INSUFRIGHTS then
      begin
        AddPassword;
        ErrorBox (appDataBase.copyTable (SFileName,DFileName))
      end
      else
        ErrorBox (appDataBase.lastError)
    end
  end
end;

{
Delete table with password retry.
}

procedure DeleteTable;

var

  FileName : PathStr;

begin
  FileName := SelectFile ('Delete Table','*.DB',true);
  if FileName <> '' then
  begin
    UpdateStatus ('DELETE');
    if appDataBase.deleteTable (FileName) = PXERR_INSUFRIGHTS then
    begin
      AddPassword;
      ErrorBox (appDataBase.deleteTable (FileName))
    end
    else
      ErrorBox (appDataBase.lastError)
  end
end;

{
Empty table with password retry.
}

procedure EmptyTable;

var

  FileName : PathStr;

begin
  FileName := SelectFile ('Empty Table','*.DB',true);
  if FileName <> '' then
  begin
    UpdateStatus ('EMPTY');
    if appDataBase.emptyTable (FileName) = PXERR_INSUFRIGHTS then
    begin
      AddPassword;
      ErrorBox (appDataBase.emptyTable (FileName))
    end
    else
      ErrorBox (appDataBase.lastError)
  end
end;

{
Encrypt table with password retry.
}

procedure EncryptTable;

var

  FileName : PathStr;
  Password : string;

begin
  FileName := SelectFile ('Encrypt Table','*.DB',true);
  if FileName <> '' then
  begin
    Password := '';
    if InputBox ('Encrypt','Password',Password,15) <> cmCancel then
    begin
      UpdateStatus ('ENCRYPT');
      if appDataBase.encryptTable (FileName,Password) = PXERR_INSUFRIGHTS then
      begin
        AddPassword;
        ErrorBox (appDataBase.encryptTable (FileName,Password))
      end
      else
        ErrorBox (appDataBase.lastError)
    end
  end
end;

{
Decrypt table with password retry.  Password must be in effect for decrypt to
work.
}

procedure DecryptTable;

var

  FileName : PathStr;

begin
  FileName := SelectFile ('Decrypt Table','*.DB',true);
  if FileName <> '' then
  begin
    UpdateStatus ('DECRYPT');
    if appDataBase.decryptTable (FileName) = PXERR_INSUFRIGHTS then
    begin
      AddPassword;
      ErrorBox (appDataBase.decryptTable (FileName))
    end
    else
      ErrorBox (appDataBase.lastError)
  end
end;

{
Switch between 25 and 43/50 line mode.
}

procedure ToggleVideo;

var

  NewMode : word;
  R : TRect;

begin
  NewMode := ScreenMode xor smFont8x8;
  if NewMode and smFont8x8 <> 0 then
    ShadowSize.X := 1
  else
    ShadowSize.X := 2;
  SetScreenMode (NewMode);
  Desktop^.GetExtent (R)
end;

{
TV Demo calendar.
}

procedure Calendar;

var

  P : PCalendarWindow;

begin
  P := New(PCalendarWindow, Init);
  P^.HelpCtx := hcCalendar;
  InsertWindow(P)
end;

{
TV Demo calculator.
}

procedure Calculator;

var

  P : PCalculator;
begin
  P := New(PCalculator, Init);
  P^.HelpCtx := hcCalculator;
  InsertWindow(P)
end;

{
View doc file.
}

procedure ViewTextFile (FileName : PathStr);

var

  T : PTextWindow;
  R : TRect;

begin
  GetExtent (R);
  R.Grow (-5,-4);
  T := New(PTextWindow, Init(R, FileName));
  T^.Options := T^.Options or ofCentered;
  T^.HelpCtx := hcViewDoc;
  InsertWindow (T)
end;

{
Set custom TV color palette.
}

procedure Colors;

{custom color items}
function DlgColorItems (Palette: Word; const Next: PColorItem) : PColorItem;

const

  COffset : array[dpBlueDialog..dpGrayDialog] of Byte = (64, 96, 32);

var

  Offset : Byte;

begin
  Offset := COffset[Palette];
  DlgColorItems :=
    ColorItem ('Frame passive',     Offset,
    ColorItem ('Frame active',      Offset + 1,
    ColorItem ('Frame icons',       Offset + 2,
    ColorItem ('Scroll bar page',   Offset + 3,
    ColorItem ('Scroll bar icons',  Offset + 4,
    ColorItem ('Static text',       Offset + 5,

    ColorItem ('Label normal',      Offset + 6,
    ColorItem ('Label selected',    Offset + 7,
    ColorItem ('Label shortcut',    Offset + 8,

    ColorItem ('Button normal',     Offset + 9,
    ColorItem ('Button default',    Offset + 10,
    ColorItem ('Button selected',   Offset + 11,
    ColorItem ('Button disabled',   Offset + 12,
    ColorItem ('Button shortcut',   Offset + 13,
    ColorItem ('Button shadow',     Offset + 14,

    ColorItem ('Cluster normal',    Offset + 15,
    ColorItem ('Cluster selected',  Offset + 16,
    ColorItem ('Cluster shortcut',  Offset + 17,

    ColorItem ('Input normal',      Offset + 18,
    ColorItem ('Input selected',    Offset + 19,
    ColorItem ('Input arrow',       Offset + 20,

    ColorItem ('History button',    Offset + 21,
    ColorItem ('History sides',     Offset + 22,
    ColorItem ('History bar page',  Offset + 23,
    ColorItem ('History bar icons', Offset + 24,

    ColorItem ('List normal',       Offset + 25,
    ColorItem ('List focused',      Offset + 26,
    ColorItem ('List selected',     Offset + 27,
    ColorItem ('List divider',      Offset + 28,

    ColorItem('Information pane',  Offset + 29,
    Next))))))))))))))))))))))))))))));
end;

function HelpColorItems(const Next: PColorItem): PColorItem;

begin
  HelpColorItems :=
    ColorItem ('Frame passive',     128,
    ColorItem ('Frame active',      129,
    ColorItem ('Frame icons',       130,
    ColorItem ('Scroll bar page',   131,
    ColorItem ('Scroll bar icons',  132,
    ColorItem ('Normal text',       133,
    ColorItem ('Key word',          134,
    ColorItem ('Select key word',   135,
    Next))))))))
end;

function SysColorItems (const Next: PColorItem) : PColorItem;

begin
  SysColorItems :=
    ColorItem ('Shadow',       136,
    ColorItem ('System error', 137,
    ColorItem ('Index error',  138,
    Next)))
end;

var

  D : PColorDialog;

begin
  D := New (PColorDialog,Init ('',
  ColorGroup ('Desktop',     DesktopColorItems(nil),
  ColorGroup ('Menus',       MenuColorItems(nil),
  ColorGroup ('Gray Windows',WindowColorItems(wpGrayWindow,nil),
  ColorGroup ('Blue Windows',WindowColorItems(wpBlueWindow,nil),
  ColorGroup ('Cyan Windows',WindowColorItems(wpCyanWindow,nil),
  ColorGroup ('Gray Dialogs',DlgColorItems(dpGrayDialog,nil),
  ColorGroup ('Blue Dialogs',DlgColorItems(dpBlueDialog,nil),
  ColorGroup ('Cyan Dialogs',DlgColorItems(dpCyanDialog,nil),
  ColorGroup ('Help',        HelpColorItems(nil),
  ColorGroup ('System',      SysColorItems(nil),
  nil))))))))))));
  D^.HelpCtx := hcColorDialog;
  if ExecuteDialog (D,Application^.GetPalette) <> cmCancel then
  begin
    DoneMemory; {dispose all group buffers}
    ReDraw;     {redraw application with new palette}
    ShadowAttr := GetColor (136);   {tv shadow color}
    SysColorAttr := (GetColor (137) shl 8) or GetColor (137); {tv system error color}
    ErrorAttr := GetColor (138);    {tv palette index error color}
  end
end;

begin
  if (Event.What = evCommand) and
  (Event.Command = cmQuit) then
    ClearDeskTop;
  inherited HandleEvent (Event);
  case Event.What of
    evCommand:
    case Event.Command of             {process commands}
      cmOpenTable    : NewBrowser;
      cmCreateTable  : CreateTable;
      cmAppendTable  : AppendTable;
      cmCopyTable    : CopyTable;
      cmEmptyTable   : EmptyTable;
      cmDeleteTable  : DeleteTable;
      cmEncryptTable : EncryptTable;
      cmDecryptTable : DecryptTable;
      cmAddPassword  : AddPassword;
      cmEngineConfig : EngineConfig;
      cmToggleVideo  : ToggleVideo;
      cmViewDoc      : ViewTextFile (appDocName);
      cmCalendar     : Calendar;
      cmCalculator   : Calculator;
      cmAbout        : AboutBox;
      cmCloseAll     : ClearDeskTop;
      cmColors       : Colors;
      cmSaveConfig   : SaveConfigFile;
      cmLoadConfig   : LoadConfigFile
    end
    else
      Exit;
    ClearEvent (Event)
  end
end;

{
Assign desk top pattern char.
}

procedure TCyberBase.InitDeskTop;

begin
  inherited InitDeskTop;
  DeskTop^.Background^.Pattern := '' {new wall paper}
end;

procedure TCyberBase.InitMenuBar;

var

  R : TRect;

begin
  GetExtent (R);
  R.B.Y := R.A.Y+1;
  MenuBar := New (PMenuBar,Init (R,NewMenu (
    NewSubMenu ('~F~ile',hcFile,NewMenu (
    NewSubMenu ('~T~able',hcTable,NewMenu (
      NewItem ('~O~pen','F3',kbF3,cmOpenTable,hcOpen,
      NewItem ('~N~ew','F4',kbF4,cmCreateTable,hcNew,
      NewItem ('~A~ppend','',kbNoKey,cmAppendTable,hcAppend,
      NewItem ('~C~opy','',kbNoKey,cmCopyTable,hcCopy,
      NewItem ('~E~mpty','',kbNoKey,cmEmptyTable,hcEmpty,
      NewItem ('~D~elete','',kbNoKey,cmDeleteTable,hcDelete,
      nil))))))),
    NewSubMenu ('~S~ecurity',hcSecurity,NewMenu (
      NewItem ('~A~dd password','',kbNoKey,cmAddPassword,hcAddPassword,
      NewItem ('~E~ncrypt','',kbNoKey,cmEncryptTable,hcEncrypt,
      NewItem ('~D~ecrypt','',kbNoKey,cmDecryptTable,hcDecrypt,
      nil)))),
      NewItem ('~L~oad config...','Ctrl+F3',kbCtrlF3,cmLoadConfig,hcLoadFile,
      NewItem ('Save con~f~ig...','Ctrl+F2',kbCtrlF2,cmSaveConfig,hcSaveFile,
      NewLine (
      NewItem ('~C~alendar','',kbNoKey,cmCalendar,hcSCalendar,
      NewItem ('Ca~l~culator','',kbNoKey,cmCalculator,hcSCalculator,
      NewItem ('~V~iew doc','',kbNoKey,cmViewDoc,hcViewDoc,
      NewItem ('~A~bout','',kbNoKey,cmAbout,hcAbout,
      NewLine (
      NewItem ('E~x~it','Alt-X',kbAltX,cmQuit,hcExit,
      nil)))))))))))),
    NewSubMenu ('~O~ptions',hcOptions,NewMenu (
      NewItem ('~E~ngine...','',kbNoKey,cmEngineConfig,hcEngine,
      NewItem ('~C~olors...','',kbNoKey,cmColors,hcOColors,
      NewItem ('~T~oggle video','',kbNoKey,cmToggleVideo,hcToggleVideo,
      nil)))),
    NewSubMenu ('~W~indow',hcWindows,NewMenu(
      StdWindowMenuItems (
      nil)),nil))))))
end;

procedure TCyberBase.InitStatusLine;

var

  R : TRect;

begin
  GetExtent (R);
  R.A.Y := R.B.Y-1;
  StatusLine := New (PStatusLine,Init(R,
    NewStatusDef (0,$FFFF,
      NewStatusKey ('~F1~ Help', kbF1, cmHelp,
      NewStatusKey ('~F3~ Open',kbF3,cmOpenTable,
      NewStatusKey ('~Alt-F3~ Close',kbAltF3,cmClose,
      NewStatusKey ('~Alt-X~ Exit',kbAltX,cmQuit,
      NewStatusKey ('',kbF4,cmCreateTable,
      NewStatusKey ('',kbCtrlF5,cmResize,
      NewStatusKey ('',kbF10,cmMenu,
      nil))))))),nil)))
end;

{
Let user know if heap allocation cuts into the safety pool.
}

procedure TCyberBase.OutOfMemory;

begin
  MessageBox ('Not enough memory available to complete operation.  Try closing some windows!',
  nil,mfError+mfOkButton);
end;

{
Load desk top from stream.
}

procedure TCyberBase.LoadDesktop (var S : TStream);

var

  Pal : PString;

begin
  Pal := S.ReadStr;
  if Pal <> nil then
  begin
    Application^.GetPalette^ := Pal^;
    DoneMemory;
    DisposeStr (Pal)
  end
end;

{
Store desk top on stream.
}

procedure TCyberBase.StoreDesktop(var S: TStream);

var

  Pal: PString;

begin
  Pal := @Application^.GetPalette^;
  S.WriteStr (Pal)
end;

var

  CBApp : TCyberBase;

begin
  CBApp.Init;
  CBApp.Run;
  CBApp.Done
end.
