(*
 *    PROGRAM : WindTest installation example
 *    SYSTEM  : Turbo Pascal 4.0, 5.0, and 5.5
 *    AUTHOR  : (C) 1988, 1989 by Tom Swan
 *)

PROGRAM WindInst;


USES  Crt, TCUnit, WindGlob;

CONST FileName = 'WINDTEST.EXE';    { File to modify }

VAR   userQuits : Boolean;          { True to end program }


FUNCTION MenuChar : Char;

{ Display menu and return selection }

BEGIN
   ClrScr;
   Writeln( 'WindTest Installation Program' );
   Writeln( '--------------------------------------------' );
   Writeln( 'A - Border foreground ...... ', WBForeColor:2 );
   Writeln( 'B - Border background ...... ', WBBackColor:2 );
   Writeln( 'C - Text foreground ........ ', WTForeColor:2 );
   Writeln( 'D - Text background ........ ', WTBackColor:2 );
   Writeln( 'E - Window title ........... ', WTitle );
   Writeln;
   Writeln( 'Q - Quit and save changes' );
   Writeln( 'X - Quit and do NOT save changes' );
   Writeln;
   Write(   'Pick a letter, any letter: ' );
   MenuChar := UpCase( ReadKey )
END; { MenuChar }


{$V-}    { Turn off string-parameter length checking }

BEGIN
   userQuits := False;
   REPEAT
      CASE MenuChar OF
         'A' : GetWord( 'Border foreground', WBForeColor, 0, 15 );
         'B' : GetWord( 'Border background', WBBackColor, 0, 15 );
         'C' : GetWord( 'Text foreground', WTForeColor, 0, 15 );
         'D' : GetWord( 'Text background', WTBackColor, 0, 15 );
         'E' : GetStr( 'Window title', WTitle, 40 );
         'Q' : userQuits := ChangesSaved( fileName, CBase, 
                              Ofs( CBase ), Ofs( EBase ) );
         'X' : userQuits := True
      END { case }
   UNTIL userQuits;
   GotoXY( 1, 25 )
END.

