program SL_Test1; {demonstrate use of single row status line}
uses
  OpCrt,
  StatLine,
  OpMacro,
  OpString,
  OpKey,
  OpMouse;

   var
     SL : StatusLine;
     W  : word;
     S  : String;
     Special : boolean;

   const
     FA : FlexAttrs = ($17,$1f,$1e,$70);

  function SampleReadKey    : Word;
  { return value of key pressed }
  var
    Count : Word;
    LastX,
    LastY : byte;
  begin
    While not KeyOrButtonPressed do;
    if MouseButtonPressed(LeftButton,Count,LastX,LastY) then
      SampleReadKey := SL.GetKey(LastY,LastX,ReadkeyOrButton)
    else
      SampleReadKey := ReadKeyOrButton;
  end; {SampleReadKey}

begin
    if not MouseInstalled then exit;
    TextAttr := $20;
    clrscr;
    if not SL.Init(ScreenHeight,ScreenHeight,FA) then exit;

    with SL do
     if AddTopic(^A'Alt'^A' ',0) and
       AddTopic(^A'F2'^A'-File ',AltF2) and
       AddTopic(^A'F3'^A'-Browse ',AltF3) and
       AddTopic(^A'F4'^A'-DOS ',AltF4) and
       AddTopic(^A'A'^A'-Ascii ',AltA) and
       AddTopic(^A'L'^A'-caLendar ',AltL) and
       AddTopic(^A'0'^A'-Calc ',Alt0) and
       AddTopic(^A'X'^A'-ESC  ',ESC ) and
       AddTopic(^A#18^A,Home) and
       AddTopic(^A#23^A,EndKey) and
       AddTopic(^A#30^A,PgUp) and
       AddTopic(^A#31^A' ',PgDn) and
       AddTopic(^A#24^A,Up) and
       AddTopic(^A#25^A,Down) and
       AddTopic(^A'<'^A,Left) and
       AddTopic(^A''^A,CtrlLeft) and
       AddTopic(^A''^A' ',ShTab) and
       AddTopic(^A''^A,Tab) and
       AddTopic(^A''^A,CtrlRight) and
       AddTopic(^A'>'^A' ',Right) and
       AddTopic(^A^Q''^A,Enter) then begin

     Draw;
     EnableEventHandling;
     ShowMouse;
     FastCenter('Click on Status line to test - ESC to quit',10,$71);
     repeat
       W := SampleReadKey;
       KeyToString(W,S,Special);
       FastCenter(center(s,20),1,$02);
     until W = ESC;
     HideMouse;
     Hide;
     Done;
  end;
  TextAttr := $17;
  clrscr;
end.
