program SSEntryExample;

{$I OPDEFINE.INC}

{**********************************************************************}
{*      This program demonstrates the use of the SSEntry object.      *}
{* It is remarkably similar to the example on p. 4-186 of the manual. *}
{* The SSEntry object is a two-dimensional pick-list with row and     *}
{* column headers.  It also has hooks for calling a line-editor to    *}
{* edit cell values.                                                  *}
{*                        by Dallan Quass                             *}
{*                         [72010.3037]                               *}
{**********************************************************************}

uses
  Dos,
  OpInline,
  OpString,
  OpRoot,
  OpCrt,
  OpMouse,
  OpDrag,
  OpCmd,
  OpFrame,
  OpWindow,
  OpEdit,
  USSEntry;
const
  NumRows = 50;
  NumCols = 30;
  ColWid  = 6;
type
  DataType = integer;
var
  PizzaTop : SSEntry;
  LE : LineEditor;
  Data : array[1..NumCols,1..NumRows] of DataType;
  SSWindowOptions : LongInt;
  SSOptions : Word;
  x,y : Word;

  {$F+}
  procedure PizzaTopping(ItemX, ItemY : Word;
                         var IType : ssItemType; var IString : String;
                         SSPtr : SSEntryPtr);
    {-Sets item string and item options (if any)}
  begin
    IString := LeftPad(Long2Str(Data[ItemX,ItemY]), ColWid);
  end;

  procedure ColHeader(ItemX, LineNum : Word;
                         var IType : ssItemType; var IString : String;
                         SSPtr : SSEntryPtr);
    {-Sets item string and item options (if any)}
  begin
    IString := Long2Str(ItemX)+'('+Long2Str(LineNum)+')';
  end;

  procedure RowHeader(ItemY : Word;
                         var IType : ssItemType; var IString : String;
                         SSPtr : SSEntryPtr);
    {-Sets item string and item options (if any)}
  begin
    IString := Long2Str(ItemY);
  end;

  procedure PreMove(ItemX, ItemY: Word; SSPtr : SSEntryPtr);
  begin
    FastWrite('PreMove '+Long2Str(ItemX)+':'+
              Long2Str(ItemY),23,1,TextAttr);
  end;

  procedure Action(ItemX, ItemY : Word; SSPtr : SSEntryPtr);
  var
    cmd : Word;
  begin
    LE.EditNumericInteger('', WhereYabs, WhereXabs+SSPtr^.GetLeftOfs,
                          CharStr('#', ColWid), 0, MaxInt,
                          data[itemX, ItemY]);
    cmd := LE.GetLastCommand;
    if cmd = ccSelect then
      SSPtr^.SetLastCommand(ccDown)
    else if cmd = ccUser0 then
      SSPtr^.SetLastCommand(ccMouseAuto)
    else if cmd = ccUser1 then
      SSPtr^.SetLastCommand(ccHome)
    else if cmd = ccUser2 then
      SSPtr^.SetLastCommand(ccEnd)
    else if cmd = ccUser3 then
      SSPtr^.SetLastCommand(ccHome)
    else if cmd = ccUser4 then
      SSPtr^.SetLastCommand(ccEnd)
    else if cmd = ccUser5 then
      SSPtr^.SetLastCommand(ccTopOfFile)
    else if cmd = ccUser6 then
      SSPtr^.SetLastCommand(ccEndOfFile)
    else
      SSPtr^.SetLastCommand(cmd);
  end;

  procedure PostMove(ItemX, ItemY : Word; SSPtr : SSEntryPtr);
  begin
    FastWrite('PostMove '+Long2Str(ItemX)+':'+
              Long2Str(ItemY),25,1,TextAttr);
  end;
  {$F-}

begin
  for x := 1 to NumCols do
    for y := 1 to NumRows do
      Data[x,y] := x+y;

  with SSCommands do begin
    AddCommand(ccDel, 1, $5300, 0);
    AddCommand(ccBack, 1, $0008, 0);
    {$IFDEF UseDrag}
    {Re-map ccMouseAuto to ccUser0 so it will be returned from
     LE.EditNumericInteger; otherwise, efOKtoAdvance causes it to be
     ignored.}
    AddCommand(ccUser0, 1, $E700, 0);
    {$ENDIF}
    {Force LE.EditNumericInteger to return Home,End,^PgUp,^PgDn,^Left,^Right}
    AddCommand(ccUser1, 1, $4700, 0); {Home}
    AddCommand(ccUser2, 1, $4F00, 0); {End}
    AddCommand(ccUser3, 1, $7300, 0); {^Left}
    AddCommand(ccUser4, 1, $7400, 0); {^Right}
    AddCommand(ccUser5, 1, $8400, 0); {^PgUp}
    AddCommand(ccUser6, 1, $7600, 0); {^PgDn}
  end;

  {Initialize LE}
  with LE do begin
    Init(DefaultColorSet);
    LE.SetCommandProcessor(SSCommands);
    leEditOptionsOff(leHouseCursorAtEnd);
    leEditOptionsOn(leAutoAdvanceCursor or leBeepOnError);
    leSecEditOptionsOff(sleNoFieldMovement);
  end;

  {Make a PickList with custom window options}
  SSWindowOptions := DefWindowOptions or wBordered;
  SSOptions := DefSSOptions or ssSelectOnClick or ssAutoSelect;
  if not PizzaTop.InitDeluxe(10, 5, 70, 12,     {Initial window coordinates}
                             DefaultColorSet,   {ColorSet to use}
                             SSWindowOptions,   {Window options}
                             ColWid+1,          {Column width per item}
                             NumCols, NumRows,  {Number of picklist items}
                             2, 10,             {ColHdr Height, RowHdr Width}
                             PizzaTopping,
                             ColHeader,
                             RowHeader,         {Item string function}
                             SSOptions)
  then begin
    WriteLn('Failed to Init SSEntry,  Status = ', InitStatus);
    Halt;
  end;

  AutoRepeatTicks := 2;

  {Set some PickList and Frame features}
  PizzaTop.SetActionProc(Action);
  with PizzaTop do begin
    EnableExplosions(20);
    SetSelectMarker('',#017);
    SetSelectRowHdr(#016,'');
    with wFrame do begin
      AdjustFrameCoords(frXL, frYL, frXH, frYH);
      AddShadow(shBR, shOverWrite);
      AddHeader(' SS_ENTRY ', heTC);
      AddScrollBar(frRR, 0, 65536, DefaultColorSet);
      AddScrollBar(frBB, 0, 65536, DefaultColorSet);
    end;
  end;

  ClrScr;

  {Process Spreadsheet Entry}
  PizzaTop.Process;
  PizzaTop.Erase;
  PizzaTop.Done;
end.
