{$R-,S-,I-,V-,B-,F+,O+,A-}

{Conditional defines that may affect this unit}
{$I OPDEFINE.INC}

{********************************************************************}
{*                        SSENTRY.PAS 1.00                          *}
{*                        by Dallan Quass                           *}
{*                          [72010.3037]                            *}
{*  (major) portions Copyright (c) TurboPower Software, 1987, 1989. *}
{*  Most of this code was obtained from the PickList object, some   *}
{*  from the Selector object.  I've left out some of the "expected" *}
{*  OPRO features, such as stream support, a 'more' header, string  *}
{*  searching, and flex-writing (because I didn't need them).  If   *}
{*  you want them, it shouldn't be too difficult to match this code *}
{*  with the OPPICK code and add them, using OPPICK as a template.  *}
{*                                                                  *}
{*  This code is provided "as is."  I've tested it and feel         *}
{*  comfortable with it, but I'm not saying it's bullit-proof.      *}
{*  Have fun extending it--maybe someday we'll have a real          *}
{*  spreadsheet object here!                                        *}
{********************************************************************}

unit USSEntry;
  {-Spreadsheet Entry Screen}

interface

uses
  OpInline,
  OpString,
  OpRoot,
  OpCrt,
  {$IFDEF UseMouse}
  OpMouse,
  {$ENDIF}
  OpCmd,
  OpFrame,
  OpWindow
  {$IFDEF UseDrag}
  , OpDrag
  {$ENDIF}
  ;

  {$I USSENTRY.ICD}  {configuration data}

const

  ucSS              = 100;        {unit code}
                                  {!! you may need to change this in case of
                                   conflicts}
  {---- Option codes ----}
  ssExitAtEdges     = $0002;      {Exit picklist for cursor at top or left}
  ssMousePage       = $0008;      {Clicking on scroll bar scrolls by page}
  ssDrawActive      = $0010;      {Draw and Process leave selected item visible
                                   and frame status headers showing}
  ssHighlightHdr    = $0200;      {Highlight Current Row and Col headings}
  ssAutoSelect      = $0400;      {auto-select current field}
  ssSelectOnClick   = $0800;      {Implicit Enter on first mouse click}
  ssProcessZero     = $1000;      {Allow Process of zero rows or cols}
  ssNoHighlightPad  = $4000;      {Don't pad item highlights}
  ssAltCurrent      = $8000;      {Draw current item in alt attribute}

  DefSSOptions      : Word = ssDrawActive+ssHighlightHdr+ssProcessZero;
  BadSSOptions      : Word = 0;

  {---- Secondary (internal) option flags ----}
  {These flags are not stored in streams}
  {!!This object does not have stream support, although it could be added}
  ssItemStrActive   = $0001;      {CompleteItemString method active}
  ssPickActive      = $0002;      {Set when Pick method active}
  ssRedrawPage      = $0004;      {Set when page must be redrawn}
  ssRedrawOne       = $0008;      {Set when one item must be redrawn}
  ssChangedItems    = $0020;      {Set when mouse moves to new item}
  ssFakingOneRow    = $0040;      {Set when Process has 0 rows}
  ssSelStrings      = $0080;      {Set when select strings not empty}
  ssPadStrings      = $0100;      {Set when pad strings not empty}
  ssFakingOneCol    = $0010;      {Set when Process has 0 cols}
  ssSelColHdr       = $0200;      {Set when col select strings not empty}
  ssSelRowHdr       = $0400;      {Set when row select strings not empty}

  DefSecSSOptions   : Word = 0;   {Default secondary options}

  {---- Cell item categories ----}
  ssNormal         = 0;
  ssAlternate      = 1;

type
  SSEntryPtr      = ^SSEntry;   {Pointer to a SpreadSheet Entry Screen}

  ssItemType       = ssNormal..ssAlternate;

  {....                    0..1,       Selected      0..3}
  ssBaseColorArray = array[ssItemType, Boolean] of FlexAttrs;
  {....                   mono/color ------> all the colors = 64 bytes}
  ssColorArray     = array[Boolean] of ssBaseColorArray;

  ssStringProc     = procedure (ItemCol, ItemRow : Word;
                                var IType : ssItemType;
                                var IString : String;
                                SSPtr : SSEntryPtr);

  ssColHdrProc     = procedure (ItemCol, LineNum : Word;
                                var IType : ssItemType;
                                var IString : String;
                                SSPtr : SSEntryPtr);

  ssRowHdrProc     = procedure (ItemRow : Word;
                                var IType : ssItemType;
                                var IString : String;
                                SSPtr : SSEntryPtr);

  ssGenlProc       = procedure (ItemCol, ItemRow : Word;
                                SSPtr : SSEntryPtr);

  SSEntry         =
    object(CommandWindow)
      {... Following are modified when pick list is initialized}
      ssXL         : Byte;        {Initially requested size for window}
      ssYL         : Byte;
      ssXH         : Byte;
      ssYH         : Byte;
      ssFlags      : Word;        {Bit-mapped flags}
      ssColWidth   : Byte;        {Character positions per cell}
      ssColHdrHeight : Byte;      {Number of rows in column header}
      ssRowHdrWidth  : Byte;      {length of row header}
      ssLeftPad    : Byte;        {Number of chars to left-pad names}
      ssRightPad   : Byte;        {Number of chars to right-pad names}
      ssColsWin    : Byte;        {Maximum visible columns of items}
      ssRowsWin    : Byte;        {Maximum visible rows of items}
      ssWidth      : Byte;        {Maximum width of cell area}
      ssHeight     : Byte;        {Maximum height of cell area}
        {!!ssWidth and ssHeight have different meanings here than they do
         in PickList.  In PickList, they monitor only the *active* portion
         of the window; here, they monitor the *maximum* portion of the window.
         The active portion is computed as needed.  The reason for this
         approach is to allow setting ssFirstRow and ssFirstCol to values
         greater than ssMaxFirstRow and ssMaxFirstCol using SetChoice.}
      ssColsCnt    : Word;        {Total number of columns}
      ssRowsCnt    : Word;        {Total number of rows}
      ssMaxFirstCol  : Word;      {Largest allowed value for ssFirstCol}
      ssMaxFirstRow  : Word;      {Largest allows value for ssFirstRow}
      ssColorPtr   : ^ssBaseColorArray; {Pointer to active attrs: color or mono}
      ssColors     : ssColorArray;  {All the colors, so many colors}
      ssLeftSel    : String[5];     {left cell selection string}
      ssRightSel   : String[5];     {right cell selection string}
      ssSelColHdrLeft : String[5];  {left column header selection string}
      ssSelColHdrRight : String[5]; {right column header selection string}
      ssSelColHdrLine : Byte;       {column header line number on which
                                     selection string is to appear
                                     (0 for all lines)}
      ssSelRowHdrLeft : String[5];  {left row header selection string}
      ssSelRowHdrRight : String[5]; {right row header selection string}

      {... Following are modified when browsing around the pick list}
      ssChoiceCol     : Word;        {Current item}
      ssChoiceRow     : Word;
      ssFirstCol      : Word;        {Choice in upper left corner of window}
      ssFirstRow      : Word;
      ssRow        : Byte;        {Window-relative row of current item,
                                   0-based}
      ssCol        : Byte;        {Window-relative logical column
                                   of current item, 0-based}

      {... Following user-defined procedures are also available
           via virtual methods}
      ssString     : ssStringProc; {User-supplied string procedures}
      ssColHdr     : ssColHdrProc;   {for cell, column header, and row header,}
      ssRowHdr     : ssRowHdrProc;   {respectively}
      ssPreMove    : ssGenlProc;   {User-supplied pre-move procedure}
      ssAction     : ssGenlProc;   {User-supplied action procedure}
      ssPostMove   : ssGenlProc;   {User-supplied post-move procedure}

      {... Miscellaneous data not stored in a stream}
      ssSecFlags   : Word;        {Secondary (internal) flags}

      constructor InitDeluxe(X1, Y1, X2, Y2 : Byte;
                             var Colors : ColorSet;
                             Options : LongInt;
                             ItemWidth : Byte;
                             NumCols, NumRows : Word;
                             ColHdrHeight, RowHdrWidth : Byte;
                             StringProc : ssStringProc;
                             ColHdrProc : ssColHdrProc;
                             RowHdrProc : ssRowHdrProc;
                             SSOptions : Word);
        {-Initialize a pick window with custom window and pick options}
      constructor InitAbstractDeluxe(X1, Y1, X2, Y2 : Byte;
                                     var Colors : ColorSet;
                                     Options : LongInt;
                                     ItemWidth : Byte;
                                     NumCols, NumRows : Word;
                                     ColHdrHeight, RowHdrWidth : Byte;
                                     SSOptions : Word);
         {-Constructor to be called by derived types that override the
           ItemString method, with custom pick options}

      destructor Done; virtual;
        {-Dispose of PickList}

      procedure UpdateContents; virtual;
        {-Redraw the complete pick window}
      procedure ProcessSelf; virtual;
        {-Process pick commands leading to a choice}

      procedure ItemString(ItemCol, ItemRow : Word; var IType : ssItemType;
                           var IString : String); virtual;
        {-Supplies each item string when the list is displayed}
      procedure ColHdrString(ItemCol, HdrLine : Word; var IType : ssItemType;
                             var IString : String); virtual;
        {-Supplies each column header string when the list is displayed}
      procedure RowHdrString(ItemRow : Word; var IType : ssItemType;
                             var IString : String); virtual;
        {-Supplies each row header string when the list is displayed}

      procedure CompleteItemString(ItemCol, ItemRow : Word;
                                   var IType : ssItemType;
                                   var IString : String); virtual;
        {-Supplies, marks, and pads item string}
      procedure CompleteColHdrString(ItemCol, LineNum : Word;
                                   var IType : ssItemType;
                                   var IString : String); virtual;
        {-Supplies, marks, and pads column header string}
      procedure CompleteRowHdrString(ItemRow : Word;
                                   var IType : ssItemType;
                                   var IString : String); virtual;
        {-Supplies, marks, and pads row header string}

      procedure PreMove(ItemCol, ItemRow : Word); virtual;
        {-Called just prior to moving the cursor to a new field}
      procedure Action(ItemCol, ItemRow : Word); virtual;
        {-Called when a field is selected}
      procedure PostMove(ItemCol, ItemRow : Word); virtual;
        {-Called when about to exit or move cursor to another field}

      procedure SetInitialChoice(ChoiceCol, ChoiceRow : Word);
        {-Set initial choice without scrolling if possible}
      procedure SetChoice(ChoiceCol, ChoiceRow,
                          FirstCol, FirstRow : Word);
        {-Set initial choice with scrolling control}

      function GetLastChoiceRow : Word;
        {-Return last selected row number}
      function GetLastChoiceCol : Word;
        {-Return last selected cell number}
      procedure WhereSelect(var X, Y : Byte);
        {-Return window-relative coordinates of selected item}
      procedure WhereSelectAbs(var X, Y : Byte);
        {-Return absolute coordinates of selected item}
      function GetItemCols : Byte;
        {-Return maximum number of columns visible in the window}
      procedure GetNumItems(var NumCols, NumRows : Word);
        {-Return number of cells}

      procedure ssOptionsOn(OptionFlags : Word);
        {-Activate multiple options}
      procedure ssOptionsOff(OptionFlags : Word);
        {-Deactivate multiple options}
      function ssOptionsAreOn(OptionFlags : Word) : Boolean;
        {-Return True if all specified options are on}

      procedure SetPadSize(LeftPad, RightPad : Byte);
        {-Set number of characters for padding of cells}
      procedure SetPreMoveProc(MP : ssGenlProc);
        {-Set pre-move procedure}
      procedure SetActionProc(MP : ssGenlProc);
        {-Set action procedure}
      procedure SetPostMoveProc(MP : ssGenlProc);
        {-Set post-move procedure}
      procedure ChangeNumItems(NumCols, NumRows : Word);
        {-Change the number of cells to display}
      procedure ChangeStringProc(StringProc : ssStringProc);
        {-Change the string function}
      procedure ChangeRowHdrWidth(W : Byte);
        {-Change row header width}
      procedure ChangeColHdrHeight(H : Byte);
        {-Change column header height}

      procedure SetPickAttr(ItemType : ssItemType; Selected : Boolean;
                            Color, Mono : Byte);
        {-Set one group of colors -- disables flexwriting}
        {!!FlexWriting has not been included in this object,
         though it could be added}
      procedure SetSelectMarker(Left, Right : String);
        {-Define strings to mark selected items}
      procedure SetSelectColHdr(Left, Right : String; LineNum : Byte);
              {-Define strings to mark selected column headers}
      procedure SetSelectRowHdr(Left, Right : String);
              {-Define strings to mark selected row headers}
      function GetLeftOfs : Byte;
              {-get left hand side offset of item inside cell}
      function GetRightOfs : Byte;
              {-get right hand side offset of item inside cell}
      function GetColWidth : Byte;
              {-get width of columns}

      {...Internal procedures...}
      function ssProcessCursorCommand(var Cmd: Word) : Boolean;
       {process keyboard event}
      function ssProcessMouseCommand(var Cmd: Word) : Boolean;
       {process mouse event}
      function ssCommand(var Cmd: Word) : Boolean;
       {process keyboard or mouse event}

      procedure ssSetCurrent(ChoiceCol, ChoiceRow,
                             FirstCol, FirstRow : Word);
        {set valid First, Row, and Col, given Choice and First}

      {$IFDEF UseScrollBars}
      procedure ssUpdScrollBars;
        {-Update scroll bars}
      procedure ssSetScroll(FramePos : FramePosType;
                                    MPos : Byte;
                                    UserVal : LongInt;
                                    var First : Word;
                                    Last, MaxFirst : Word;
                                    var Offset : Byte;
                                    var Choice : Word);
        {-Set pick position based on slider position}
      {$ENDIF}

      function ssScrolled(pChoiceCol, pChoiceRow,
                                pFirstCol, pFirstRow : Word;
                                pCol, pRow : Byte) : Boolean;
        {-Perform a one-element optimized scroll if possible}
      procedure ssInitPickSize1;
        {-Initialize pick parameters based on window size, part 1}
      procedure ssInitPickSize2;
        {-Initialize pick parameters based on window size and video mode, part 2}
      procedure ssSetItemCount(NumCols, NumRows : Word);
        {-Set flags if needed to fake an item}
      procedure ssInitPick;
        {-Initialize instance for current width, height, video mode}
      procedure ssDrawItem(ItemCol, ItemRow : Word; Col, Row : Byte;
                                    Selected : Boolean);
        {-Draw the specified item}
      procedure ssDrawRowHdr(ItemRow : Word; Row : Byte;
                                    Selected : Boolean);
        {-Draw the specified row header}
      procedure ssDrawColHdr(ItemCol : Word; Col : Byte;
                                    Selected : Boolean);
        {-Draw the specified col header}
      procedure ssDrawPage(ShowSelected : Boolean);
        {-Draw the complete visible page}
      procedure ssScrollUp(pChoiceCol, pChoiceRow : Word;
                                   pCol, pRow : Byte);
        {-Redraw page for special case of one-row scroll up}
      procedure ssScrollDown(pChoiceCol, pChoiceRow : Word;
                                   pCol, pRow : Byte);
        {-Redraw page for special case of one-row scroll down}
      procedure ssScrollLeft(pChoiceCol, pChoiceRow : Word;
                                     pCol, pRow : Byte);
        {-Redraw page for special case of one-col scroll left}
      procedure ssScrollRight(pChoiceCol, pChoiceRow : Word;
                                     pCol, pRow : Byte);
        {-Redraw page for special case of one-col scroll right}

      {$IFDEF UseMouse}
      procedure ssMoveToNewRowCol(nRow, nCol : Byte);
        {-Move to new row and column if possible}
      {$ENDIF}

      procedure ssUpdatePick(pFirstCol, pFirstRow,
                                     pChoiceCol, pChoiceRow : Word;
                                     pCol, pRow : Byte);
        {-Update pick list display while ProcessSelf is active}
      procedure ssSetPickAttr(ItemType : ssItemType; Selected : Boolean;
                                       Color, Mono : Byte);
        {-Set one group of colors without color mapping}
    end;

var
  {$IFDEF UseDrag}
  SSCommands : DragProcessor;
  {$ELSE}
  SSCommands : CommandProcessor;
  {$ENDIF}

  {--- Premove routines ----}
  procedure NoMoveAction(ItemCol, ItemRow : Word; P : SSEntryPtr);
    {-Default user hook routine for PreMove, Action, and PostMove}

  {====================================================================}

implementation

  {$I USSENTRY.IN1}

begin
  {Initialize command processor}
  SSCommands.Init(@SSKeySet, SSKeyMax);
end.
